/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.service.impl.SalaryExpenseTransferTransactionAgeServiceImpl;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.kfs.sys.service.impl.UniversityDateServiceImpl;

@ConfigureContext
public class SalaryExpenseTransferTransactionAgeServiceTest
extends KualiTestBase {
    private static final Integer DEFAULT_PARM_FISCAL_PERIODS = new Integer("3");
    private static final Integer SUBFUND_PARM_FISCAL_PERIODS = new Integer("2");
    private static final String DEFAULT_PARM_SUBFUND = "FEDERA=2";
    private static final String YOUNGER_FISCAL_PER = "11";
    private static final String OLDER_FISCAL_PER = "7";
    private static final String NON_PARM_SUBFUND = "AG";
    private static final String PARM_SUBFUND = "FEDERA";
    private static final String TEST_FISCAL_PERIOD = "13";
    private SalaryExpenseTransferTransactionAgeServiceImpl salaryExpenseTransferTransactionAgeService;
    private MyUniversityDateService universityDateService;
    private UniversityDateService oldDateService;
    private SalaryExpenseTransferDocument stDoc;

    public void setUp() throws Exception {
        super.setUp();
        this.salaryExpenseTransferTransactionAgeService = new SalaryExpenseTransferTransactionAgeServiceImpl();
        this.universityDateService = new MyUniversityDateService();
        this.oldDateService = this.salaryExpenseTransferTransactionAgeService.getUniversityDateService();
        this.salaryExpenseTransferTransactionAgeService.setUniversityDateService((UniversityDateService)this.universityDateService);
        this.salaryExpenseTransferTransactionAgeService.setParameterService((ParameterService)SpringContext.getBean(ParameterService.class));
        TestUtils.setSystemParameter(KfsParameterConstants.LABOR_DOCUMENT.class, (String)"DEFAULT_NUMBER_OF_FISCAL_PERIODS_LATE_ADJUSTMENT_TAB_REQUIRED", (String)DEFAULT_PARM_FISCAL_PERIODS.toString());
        TestUtils.setSystemParameter(KfsParameterConstants.LABOR_DOCUMENT.class, (String)"LATE_ADJUSTMENT_DEFAULT_OVERRIDE_BY_SUB_FUND", (String)DEFAULT_PARM_SUBFUND);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.salaryExpenseTransferTransactionAgeService.setUniversityDateService(this.oldDateService);
    }

    public void testYoungerAccountingLine() {
        List accountingLines = this.createAccountingLinesList(YOUNGER_FISCAL_PER, NON_PARM_SUBFUND);
        boolean isYounger = this.salaryExpenseTransferTransactionAgeService.defaultNumberOfFiscalPeriodsCheck(accountingLines, DEFAULT_PARM_FISCAL_PERIODS);
        SalaryExpenseTransferTransactionAgeServiceTest.assertTrue((String)"The transaction is older, but should be younger.", (boolean)isYounger);
    }

    public void testOlderAccountingLine() {
        List accountingLines = this.createAccountingLinesList(OLDER_FISCAL_PER, NON_PARM_SUBFUND);
        boolean isYounger = this.salaryExpenseTransferTransactionAgeService.defaultNumberOfFiscalPeriodsCheck(accountingLines, DEFAULT_PARM_FISCAL_PERIODS);
        SalaryExpenseTransferTransactionAgeServiceTest.assertFalse((String)"The transaction is younger, but should be older.", (boolean)isYounger);
    }

    public void testSubFundParameterTrigger() {
        List accountingLines = this.createAccountingLinesList(OLDER_FISCAL_PER, PARM_SUBFUND);
        boolean isYounger = this.salaryExpenseTransferTransactionAgeService.defaultNumberOfFiscalPeriodsCheck(accountingLines, SUBFUND_PARM_FISCAL_PERIODS);
        SalaryExpenseTransferTransactionAgeServiceTest.assertFalse((String)"The transaction should have been considered older and had a subfund that is in the LATE_ADJUSTMENT_DEFAULT_OVERRIDE_BY_SUB_FUND parameter.", (boolean)isYounger);
    }

    public List createAccountingLinesList(String fiscalPeriod, String subFund) {
        ArrayList<ExpenseTransferTargetAccountingLine> accountingLines = new ArrayList<ExpenseTransferTargetAccountingLine>();
        Account account = new Account();
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(subFund);
        account.setSubFundGroup(subFundGroup);
        ExpenseTransferTargetAccountingLine targetAccountingLine = new ExpenseTransferTargetAccountingLine();
        targetAccountingLine.setPayrollEndDateFiscalYear(this.salaryExpenseTransferTransactionAgeService.getUniversityDateService().getCurrentUniversityDate().getUniversityFiscalYear());
        targetAccountingLine.setPayrollEndDateFiscalPeriodCode(fiscalPeriod);
        targetAccountingLine.setAccount(account);
        accountingLines.add(targetAccountingLine);
        return accountingLines;
    }

    static class MyUniversityDateService
    extends UniversityDateServiceImpl {
        MyUniversityDateService() {
        }

        public UniversityDate getCurrentUniversityDate() {
            UniversityDate universityDate = ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentUniversityDate();
            universityDate.setUniversityFiscalAccountingPeriod(SalaryExpenseTransferTransactionAgeServiceTest.TEST_FISCAL_PERIOD);
            return universityDate;
        }
    }
}

