/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.util;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.gl.businessobject.OriginEntryGroup;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.businessobject.LaborGeneralLedgerEntry;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.service.LaborOriginEntryService;
import org.kuali.kfs.module.ld.testdata.LaborTestDataPropertyConstants;
import org.kuali.kfs.module.ld.util.PendingLedgerEntryForTesting;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.context.Log4jConfigurer;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.SpringContextForBatchRunner;

public class TestDataLoader {
    private Properties properties;
    private String fieldNames;
    private String fieldLength;
    private String deliminator;
    private List<String> keyFieldList;
    private List<String> fieldLengthList;
    private BusinessObjectService businessObjectService;
    private LaborOriginEntryService laborOriginEntryService;

    public TestDataLoader() {
        String messageFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/message.properties";
        String propertiesFileName = LaborTestDataPropertyConstants.TEST_DATA_PACKAGE_NAME + "/laborTransaction.properties";
        this.properties = TestDataPreparator.loadPropertiesFromClassPath((String)propertiesFileName);
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.fieldLength = this.properties.getProperty("fieldLength");
        this.deliminator = this.properties.getProperty("deliminator");
        Log4jConfigurer.configureLogging();
        SpringContextForBatchRunner.initializeKfs();
        this.keyFieldList = Arrays.asList(StringUtils.split((String)this.fieldNames, (String)this.deliminator));
        this.fieldLengthList = Arrays.asList(StringUtils.split((String)this.fieldLength, (String)this.deliminator));
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.laborOriginEntryService = (LaborOriginEntryService)SpringContext.getBean(LaborOriginEntryService.class);
    }

    public int loadTransactionIntoPendingEntryTable() {
        int numberOfInputData = Integer.valueOf(this.properties.getProperty("numOfData"));
        int[] fieldLength = this.getFieldLength(this.fieldLengthList);
        return this.loadInputData("data", numberOfInputData, this.keyFieldList, fieldLength);
    }

    public int loadTransactionIntoOriginEntryTable(OriginEntryGroup group) {
        int numberOfInputData = Integer.valueOf(this.properties.getProperty("numOfData"));
        this.businessObjectService.save((PersistableBusinessObject)group);
        int[] fieldLength = this.getFieldLength(this.fieldLengthList);
        List originEntries = this.loadInputData(LaborOriginEntry.class, "data", numberOfInputData, this.keyFieldList, fieldLength);
        for (LaborOriginEntry entry : originEntries) {
            entry.setEntryGroupId(group.getId());
        }
        this.businessObjectService.save(originEntries);
        return originEntries.size();
    }

    public int loadTransactionIntoGLEntryTable() {
        int numberOfInputData = Integer.valueOf(this.properties.getProperty("numOfData"));
        int[] fieldLength = this.getFieldLength(this.fieldLengthList);
        List laborGLEntries = this.loadInputData(LaborGeneralLedgerEntry.class, "data", numberOfInputData, this.keyFieldList, fieldLength);
        this.businessObjectService.save(laborGLEntries);
        return laborGLEntries.size();
    }

    private int loadInputData(String propertyKeyPrefix, int numberOfInputData, List<String> keyFieldList, int[] fieldLength) {
        int count = 0;
        for (int i = 1; i <= numberOfInputData; ++i) {
            String propertyKey = propertyKeyPrefix + i;
            PendingLedgerEntryForTesting inputData = new PendingLedgerEntryForTesting();
            ObjectUtil.populateBusinessObject((Object)((Object)inputData), (Properties)this.properties, (String)propertyKey, (int[])fieldLength, keyFieldList);
            if (this.businessObjectService.countMatching(LaborLedgerPendingEntry.class, inputData.getPrimaryKeyMap()) > 0) continue;
            inputData.setFinancialDocumentApprovedCode("A");
            this.businessObjectService.save((PersistableBusinessObject)inputData);
            ++count;
        }
        return count;
    }

    private List loadInputData(Class clazz, String propertyKeyPrefix, int numberOfInputData, List<String> keyFieldList, int[] fieldLength) {
        ArrayList inputDataList = new ArrayList();
        for (int i = 1; i <= numberOfInputData; ++i) {
            String propertyKey = propertyKeyPrefix + i;
            try {
                Object inputData = clazz.newInstance();
                ObjectUtil.populateBusinessObject(inputData, (Properties)this.properties, (String)propertyKey, (int[])fieldLength, keyFieldList);
                inputDataList.add(inputData);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return inputDataList;
    }

    private int[] getFieldLength(List<String> fieldLengthList) {
        int[] fieldLengthArray = new int[fieldLengthList.size()];
        for (int i = 0; i < fieldLengthArray.length; ++i) {
            fieldLengthArray[i] = Integer.valueOf(fieldLengthList.get(i).trim());
        }
        return fieldLengthArray;
    }

    public static void main(String[] args) {
        TestDataLoader testDataLoader = new TestDataLoader();
        Date groupCreationDate = new Date(0L);
        if (ArrayUtils.isEmpty((Object[])args) || args.length < 2) {
            System.out.println("The program requires at least two arguments.");
            return;
        }
        if (!StringUtils.isAlphanumeric((CharSequence)args[0])) {
            System.out.println("The first argument should be a number.");
            return;
        }
        for (int numOfRound = Integer.parseInt(args[0]); numOfRound > 0; --numOfRound) {
            int numOfData;
            OriginEntryGroup group;
            if (ArrayUtils.contains((Object[])args, (Object)"poster")) {
                group = new OriginEntryGroup();
                group.setSourceCode("LSCV");
                group.setValid(Boolean.valueOf(true));
                group.setScrub(Boolean.valueOf(false));
                group.setProcess(Boolean.valueOf(true));
                group.setDate(groupCreationDate);
                numOfData = testDataLoader.loadTransactionIntoOriginEntryTable(group);
                System.out.println("Number of Origin Entries for Poster = " + numOfData);
            }
            if (ArrayUtils.contains((Object[])args, (Object)"scrubber")) {
                group = new OriginEntryGroup();
                group.setSourceCode("LBAK");
                group.setValid(Boolean.valueOf(true));
                group.setScrub(Boolean.valueOf(true));
                group.setProcess(Boolean.valueOf(true));
                group.setDate(groupCreationDate);
                numOfData = testDataLoader.loadTransactionIntoOriginEntryTable(group);
                System.out.println("Number of Origin Entries for Scrubber = " + numOfData);
            }
            if (ArrayUtils.contains((Object[])args, (Object)"pending")) {
                int numOfData2 = testDataLoader.loadTransactionIntoPendingEntryTable();
                System.out.println("Number of Pending Entries = " + numOfData2);
            }
            if (!ArrayUtils.contains((Object[])args, (Object)"glentry")) continue;
            int numOfData3 = testDataLoader.loadTransactionIntoGLEntryTable();
            System.out.println("Number of Labor GL Entries = " + numOfData3);
        }
        System.exit(0);
    }
}

