/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.batch.service.BalancingService;
import org.kuali.kfs.gl.batch.service.impl.BalancingServiceBaseImpl;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.gl.businessobject.LedgerBalanceHistory;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.batch.LaborBalancingStep;
import org.kuali.kfs.module.ld.businessobject.LaborBalanceHistory;
import org.kuali.kfs.module.ld.businessobject.LaborEntryHistory;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.sys.FileUtil;
import org.kuali.kfs.sys.Message;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborBalancingServiceImpl
extends BalancingServiceBaseImpl<LaborEntryHistory, LaborBalanceHistory>
implements BalancingService {
    private static final Logger LOG = LogManager.getLogger(LaborBalancingServiceImpl.class);

    public boolean runBalancing() {
        LOG.debug("runBalancing() started");
        return super.runBalancing();
    }

    public File getPosterInputFile() {
        FilenameFilter filenameFilter = (dir, name) -> name.startsWith("ld_sortpost") && name.endsWith(".data");
        return FileUtil.getNewestFile((File)new File(this.batchFileDirectoryName), (FilenameFilter)filenameFilter);
    }

    public File getPosterErrorOutputFile() {
        FilenameFilter filenameFilter = (dir, name) -> name.startsWith("ld_posterrs") && name.endsWith(".data");
        return FileUtil.getNewestFile((File)new File(this.batchFileDirectoryName), (FilenameFilter)filenameFilter);
    }

    public int getPastFiscalYearsToConsider() {
        return Integer.parseInt(this.parameterService.getParameterValueAsString(LaborBalancingStep.class, "NUMBER_OF_PAST_FISCAL_YEARS_TO_INCLUDE"));
    }

    public int getComparisonFailuresToPrintPerReport() {
        return Integer.parseInt(this.parameterService.getParameterValueAsString(LaborBalancingStep.class, "NUMBER_OF_COMPARISON_FAILURES_TO_PRINT_PER_REPORT"));
    }

    public String getShortTableLabel(String businessObjectName) {
        HashMap<String, String> names = new HashMap<String, String>();
        names.put(Entry.class.getSimpleName(), this.kualiConfigurationService.getPropertyValueAsString("message.ld.balancing.report.entry.label"));
        names.put(LaborEntryHistory.class.getSimpleName(), this.kualiConfigurationService.getPropertyValueAsString("message.ld.balancing.report.entry.label"));
        names.put(Balance.class.getSimpleName(), this.kualiConfigurationService.getPropertyValueAsString("message.ld.balancing.report.balance.label"));
        names.put(LaborBalanceHistory.class.getSimpleName(), this.kualiConfigurationService.getPropertyValueAsString("message.ld.balancing.report.balance.label"));
        return names.get(businessObjectName) == null ? this.kualiConfigurationService.getPropertyValueAsString("message.batch.balancing.report.unknown.label") : (String)names.get(businessObjectName);
    }

    public OriginEntryInformation getOriginEntry(String inputLine, int lineNumber) {
        LaborOriginEntry originEntry = new LaborOriginEntry();
        originEntry.setFromTextFileForBatch(inputLine, lineNumber);
        return originEntry;
    }

    protected int updateHistoriesHelper(Integer postMode, Integer startUniversityFiscalYear, File inputFile, File errorFile) {
        if (postMode == 1) {
            return super.updateHistoriesHelper(postMode, startUniversityFiscalYear, inputFile, errorFile);
        }
        return 0;
    }

    public void updateEntryHistory(Integer postMode, OriginEntryInformation originEntry) {
        if (postMode == 1) {
            LaborOriginEntry laborOriginEntry = (LaborOriginEntry)originEntry;
            LaborEntryHistory ledgerEntryHistory = new LaborEntryHistory(laborOriginEntry);
            LaborEntryHistory retrievedLedgerEntryHistory = (LaborEntryHistory)this.businessObjectService.retrieve((PersistableBusinessObject)ledgerEntryHistory);
            if (ObjectUtils.isNotNull((Object)((Object)retrievedLedgerEntryHistory))) {
                ledgerEntryHistory = retrievedLedgerEntryHistory;
            }
            ledgerEntryHistory.addAmount(laborOriginEntry.getTransactionLedgerEntryAmount());
            this.businessObjectService.save((PersistableBusinessObject)ledgerEntryHistory);
        }
    }

    public void updateBalanceHistory(Integer postMode, OriginEntryInformation originEntry) {
        if (postMode == 1) {
            LaborOriginEntry laborOriginEntry = (LaborOriginEntry)originEntry;
            LaborBalanceHistory ledgerBalanceHistory = new LaborBalanceHistory(laborOriginEntry);
            LaborBalanceHistory retrievedLedgerBalanceHistory = (LaborBalanceHistory)this.businessObjectService.retrieve((PersistableBusinessObject)ledgerBalanceHistory);
            if (ObjectUtils.isNotNull((Object)((Object)retrievedLedgerBalanceHistory))) {
                ledgerBalanceHistory = retrievedLedgerBalanceHistory;
            }
            KualiDecimal amount = laborOriginEntry.getTransactionLedgerEntryAmount();
            laborOriginEntry.refreshReferenceObject("balanceType");
            laborOriginEntry.refreshReferenceObject("objectType");
            if (laborOriginEntry.getBalanceType().isFinancialOffsetGenerationIndicator() && !laborOriginEntry.getTransactionDebitCreditCode().equals(laborOriginEntry.getObjectType().getFinObjectTypeDebitcreditCd())) {
                amount = (KualiDecimal)amount.negated();
            }
            ledgerBalanceHistory.addAmount(laborOriginEntry.getUniversityFiscalPeriodCode(), amount);
            this.businessObjectService.save((PersistableBusinessObject)ledgerBalanceHistory);
        }
    }

    protected int compareBalanceHistory() {
        String historyTable;
        int countComparisionFailures = 0;
        String balanceTable = this.persistenceStructureService.getTableName(LedgerBalance.class);
        List data = this.ledgerEntryBalanceCachingDao.compareBalanceHistory(balanceTable, historyTable = this.persistenceStructureService.getTableName(this.balanceHistoryPersistentClass), this.getFiscalYear());
        if (!data.isEmpty()) {
            Iterator itr = data.iterator();
            while (itr.hasNext()) {
                LaborBalanceHistory balance = this.createBalanceFromMap((Map)itr.next());
                if (++countComparisionFailures > this.getComparisonFailuresToPrintPerReport()) continue;
                this.reportWriterService.writeError((BusinessObject)balance, new Message(this.kualiConfigurationService.getPropertyValueAsString("message.batch.balancing.record.failed.balancing"), 0, new Object[]{((Object)((Object)balance)).getClass().getSimpleName()}));
            }
        }
        return countComparisionFailures;
    }

    protected int compareEntryHistory() {
        String historyTable;
        int countComparisionFailures = 0;
        String entryTable = this.persistenceStructureService.getTableName(LedgerEntry.class);
        List data = this.ledgerEntryBalanceCachingDao.compareEntryHistory(entryTable, historyTable = this.persistenceStructureService.getTableName(this.entryHistoryPersistentClass), this.getFiscalYear());
        if (!data.isEmpty()) {
            Iterator itr = data.iterator();
            while (itr.hasNext()) {
                LaborEntryHistory entry = this.createEntryHistoryFromMap((Map)itr.next());
                if (++countComparisionFailures > this.getComparisonFailuresToPrintPerReport()) continue;
                this.reportWriterService.writeError((BusinessObject)entry, new Message(this.kualiConfigurationService.getPropertyValueAsString("message.batch.balancing.record.failed.balancing"), 0, new Object[]{((Object)((Object)entry)).getClass().getSimpleName()}));
            }
        }
        return countComparisionFailures;
    }

    public void clearHistories() {
        HashMap fieldValues = new HashMap();
        this.businessObjectService.deleteMatching(LaborEntryHistory.class, fieldValues);
        this.businessObjectService.deleteMatching(LaborBalanceHistory.class, fieldValues);
        this.reportWriterService.writeFormattedMessageLine(this.kualiConfigurationService.getPropertyValueAsString("message.batch.balancing.history.purged"), new Object[0]);
    }

    public String getFilenames() {
        return this.getName(this.getPosterInputFile()) + this.getName(this.getPosterErrorOutputFile());
    }

    public Balance getBalance(LedgerBalanceHistory ledgerBalanceHistory) {
        LedgerBalance ledgerBalance = new LedgerBalance((LaborBalanceHistory)ledgerBalanceHistory);
        return (LedgerBalance)this.businessObjectService.retrieve((PersistableBusinessObject)ledgerBalance);
    }

    protected LaborBalanceHistory createBalanceFromMap(Map<String, Object> map) {
        LaborBalanceHistory balance = new LaborBalanceHistory();
        balance.setUniversityFiscalYear(((BigDecimal)map.get("UNIV_FISCAL_YR")).intValue());
        balance.setChartOfAccountsCode((String)map.get("FIN_COA_CD"));
        balance.setAccountNumber((String)map.get("ACCOUNT_NBR"));
        balance.setSubAccountNumber((String)map.get("SUB_ACCT_NBR"));
        balance.setObjectCode((String)map.get("FIN_OBJECT_CD"));
        balance.setSubObjectCode((String)map.get("FIN_SUB_OBJ_CD"));
        balance.setBalanceTypeCode((String)map.get("FIN_BALANCE_TYP_CD"));
        balance.setObjectTypeCode((String)map.get("FIN_OBJ_TYP_CD"));
        balance.setEmplid((String)map.get("EMPLID"));
        balance.setPositionNumber((String)map.get("POSITION_NBR"));
        balance.setAccountLineAnnualBalanceAmount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("ACLN_ACTLS_BAL_AMT")));
        balance.setContractsGrantsBeginningBalanceAmount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("CONTR_GR_BB_AC_AMT")));
        balance.setBeginningBalanceLineAmount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("FIN_BEG_BAL_LN_AMT")));
        balance.setMonth1Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO1_ACCT_LN_AMT")));
        balance.setMonth2Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO2_ACCT_LN_AMT")));
        balance.setMonth3Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO3_ACCT_LN_AMT")));
        balance.setMonth4Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO4_ACCT_LN_AMT")));
        balance.setMonth5Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO5_ACCT_LN_AMT")));
        balance.setMonth6Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO6_ACCT_LN_AMT")));
        balance.setMonth7Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO7_ACCT_LN_AMT")));
        balance.setMonth8Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO8_ACCT_LN_AMT")));
        balance.setMonth9Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO9_ACCT_LN_AMT")));
        balance.setMonth10Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO10_ACCT_LN_AMT")));
        balance.setMonth11Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO11_ACCT_LN_AMT")));
        balance.setMonth12Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO12_ACCT_LN_AMT")));
        balance.setMonth13Amount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("MO13_ACCT_LN_AMT")));
        return balance;
    }

    protected LaborEntryHistory createEntryHistoryFromMap(Map<String, Object> map) {
        LaborEntryHistory entry = new LaborEntryHistory();
        entry.setUniversityFiscalYear(((BigDecimal)map.get("UNIV_FISCAL_YR")).intValue());
        entry.setChartOfAccountsCode((String)map.get("FIN_COA_CD"));
        entry.setFinancialObjectCode((String)map.get("FIN_OBJECT_CD"));
        entry.setFinancialBalanceTypeCode((String)map.get("FIN_BALANCE_TYP_CD"));
        entry.setUniversityFiscalPeriodCode((String)map.get("UNIV_FISCAL_PRD_CD"));
        entry.setTransactionDebitCreditCode((String)map.get("TRN_DEBIT_CRDT_CD"));
        entry.setTransactionLedgerEntryAmount(this.convertBigDecimalToKualiDecimal((BigDecimal)map.get("TRN_LDGR_ENTR_AMT")));
        return entry;
    }

    protected KualiDecimal convertBigDecimalToKualiDecimal(BigDecimal biggy) {
        if (ObjectUtils.isNull((Object)biggy)) {
            return new KualiDecimal(0);
        }
        return new KualiDecimal(biggy);
    }

    public File getReversalInputFile() {
        return null;
    }

    public File getReversalErrorOutputFile() {
        return null;
    }

    public File getICRInputFile() {
        return null;
    }

    public File getICRErrorOutputFile() {
        return null;
    }

    public File getICREncumbranceInputFile() {
        return null;
    }

    public File getICREncumbranceErrorOutputFile() {
        return null;
    }
}

