/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.module.ld.businessobject.AccountStatusBaseFunds;
import org.kuali.kfs.module.ld.businessobject.inquiry.BaseFundsInquirableImpl;
import org.kuali.kfs.module.ld.service.LaborBaseFundsService;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.rice.krad.bo.BusinessObject;

public class BaseFundsLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    private LaborBaseFundsService laborBaseFundsService;
    private LaborInquiryOptionsService laborInquiryOptionsService;

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        return new BaseFundsInquirableImpl().getInquiryUrl(bo, propertyName);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        boolean isConsolidated = this.laborInquiryOptionsService.isConsolidationSelected(fieldValues, this.getRows());
        List<AccountStatusBaseFunds> searchResultsCollection = this.laborBaseFundsService.findAccountStatusBaseFundsWithCSFTracker(fieldValues, isConsolidated);
        Long actualSize = searchResultsCollection.size();
        return this.buildSearchResultList(searchResultsCollection, actualSize);
    }

    protected List buildSearchResultList(Collection searchResultsCollection, Long actualSize) {
        CollectionIncomplete results;
        CollectionIncomplete searchResults = results = new CollectionIncomplete(searchResultsCollection, actualSize);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            results.sort((Comparator)new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    public void setLaborInquiryOptionsService(LaborInquiryOptionsService laborInquiryOptionsService) {
        this.laborInquiryOptionsService = laborInquiryOptionsService;
    }

    public void setLaborBaseFundsService(LaborBaseFundsService laborBaseFundsService) {
        this.laborBaseFundsService = laborBaseFundsService;
    }
}

