/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.ld.SegmentedBusinessObject;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.inquiry.LedgerBalanceForExpenseTransferInquirableImpl;
import org.kuali.kfs.module.ld.businessobject.inquiry.PositionDataDetailsInquirableImpl;
import org.kuali.kfs.module.ld.businessobject.lookup.LedgerBalanceLookupableHelperServiceImpl;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public abstract class LedgerBalanceForExpenseTransferLookupableHelperServiceImpl
extends LedgerBalanceLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger();

    @Override
    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        if ("positionNumber".equals(propertyName)) {
            LedgerBalance balance = (LedgerBalance)bo;
            PositionDataDetailsInquirableImpl positionDataDetailsInquirable = new PositionDataDetailsInquirableImpl();
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, balance.getPositionNumber());
            BusinessObject positionData = positionDataDetailsInquirable.getBusinessObject(fieldValues);
            return positionData == null ? new HtmlData.AnchorHtmlData() : positionDataDetailsInquirable.getInquiryUrl(positionData, propertyName);
        }
        return new LedgerBalanceForExpenseTransferInquirableImpl().getInquiryUrl(bo, propertyName);
    }

    @Override
    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        return null;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        List displayList = bounded ? this.getSearchResults(lookupForm.getFieldsForLookup()) : this.getSearchResultsUnbounded(lookupForm.getFieldsForLookup());
        List pkNames = this.getBusinessObjectMetaDataService().listPrimaryKeyFieldNames(this.getBusinessObjectClass());
        List returnKeys = this.getReturnKeys();
        Person user = GlobalVariables.getUserSession().getPerson();
        for (BusinessObject element : displayList) {
            ResultRow row;
            Collection<Column> columns;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Doing lookup for " + element.getClass());
            }
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            String returnUrl = this.getReturnUrl(element, lookupForm, returnKeys, businessObjectRestrictions).constructCompleteHtmlTag();
            if (!(element instanceof PersistableBusinessObject)) continue;
            if (element instanceof SegmentedBusinessObject) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("segmented property names " + ((SegmentedBusinessObject)element).getSegmentedPropertyNames());
                }
                columns = this.getColumns(element, businessObjectRestrictions);
                row = new ResultRow((List)columns, returnUrl, this.getActionUrls(element, pkNames, businessObjectRestrictions));
                for (String propertyName : ((SegmentedBusinessObject)element).getSegmentedPropertyNames()) {
                    columns.add(this.setupResultsColumn(element, propertyName, businessObjectRestrictions));
                }
                row.setObjectId(((PersistableBusinessObject)element).getObjectId());
                resultTable.add(row);
                continue;
            }
            columns = this.getColumns(element, businessObjectRestrictions);
            row = new ResultRow((List)columns, returnUrl, this.getActionUrls(element, pkNames, businessObjectRestrictions));
            row.setObjectId(((PersistableBusinessObject)element).getObjectId());
            resultTable.add(row);
        }
        return displayList;
    }

    protected Column setupResultsColumn(BusinessObject element, String attributeName, BusinessObjectRestrictions businessObjectRestrictions) {
        Column col = new Column();
        col.setPropertyName(attributeName);
        String columnTitle = this.getDataDictionaryService().getAttributeLabel(this.getBusinessObjectClass(), attributeName);
        if (StringUtils.isBlank((CharSequence)columnTitle)) {
            columnTitle = this.getDataDictionaryService().getCollectionLabel(this.getBusinessObjectClass(), attributeName);
        }
        col.setColumnTitle(columnTitle);
        col.setMaxLength(this.getDataDictionaryService().getAttributeMaxLength(this.getBusinessObjectClass(), attributeName).intValue());
        Class formatterClass = this.getDataDictionaryService().getAttributeFormatter(this.getBusinessObjectClass(), attributeName);
        Formatter formatter = null;
        if (formatterClass != null) {
            try {
                formatter = (Formatter)formatterClass.newInstance();
                col.setFormatter(formatter);
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error("Unable to get new instance of formatter class: " + formatterClass.getName());
                throw new RuntimeException("Unable to get new instance of formatter class: " + formatterClass.getName());
            }
        }
        String propValue = "";
        Object prop = ObjectUtils.getPropertyValue((Object)element, (String)attributeName);
        Class<?> propClass = null;
        try {
            PropertyDescriptor propDescriptor = PropertyUtils.getPropertyDescriptor((Object)element, (String)col.getPropertyName());
            if (propDescriptor != null) {
                propClass = propDescriptor.getPropertyType();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot access PropertyType for property '" + col.getPropertyName() + "'  on an instance of '" + element.getClass().getName() + "'.", e);
        }
        if (prop != null) {
            if (prop instanceof Boolean) {
                formatter = new BooleanFormatter();
            }
            propValue = formatter != null ? (String)formatter.format(prop) : prop.toString();
        }
        col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass(propClass));
        col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass(propClass));
        propValue = super.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
        col.setPropertyValue(propValue);
        if (StringUtils.isNotBlank((CharSequence)propValue)) {
            col.setColumnAnchor(this.getInquiryUrl(element, col.getPropertyName()));
        }
        return col;
    }

    protected Collection<Column> getColumns(BusinessObject bo, BusinessObjectRestrictions businessObjectRestrictions) {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String attributeName : this.getBusinessObjectDictionaryService().getLookupResultFieldNames(this.getBusinessObjectClass())) {
            columns.add(this.setupResultsColumn(bo, attributeName, businessObjectRestrictions));
        }
        return columns;
    }
}

