/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.service.BalanceTypeService;
import org.kuali.kfs.gl.OJBUtility;
import org.kuali.kfs.gl.businessobject.lookup.BalanceLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.CollectionIncomplete;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.inquiry.LedgerBalanceInquirableImpl;
import org.kuali.kfs.module.ld.businessobject.inquiry.PositionDataDetailsInquirableImpl;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class LedgerBalanceLookupableHelperServiceImpl
extends BalanceLookupableHelperServiceImpl {
    private static final Logger LOG = LogManager.getLogger();
    LaborLedgerBalanceService balanceService;
    private LaborInquiryOptionsService laborInquiryOptionsService;
    protected BalanceTypeService balanceTypService;

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        if ("positionNumber".equals(propertyName)) {
            LedgerBalance balance = (LedgerBalance)bo;
            PositionDataDetailsInquirableImpl positionDataDetailsInquirable = new PositionDataDetailsInquirableImpl();
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, balance.getPositionNumber());
            BusinessObject positionData = positionDataDetailsInquirable.getBusinessObject(fieldValues);
            return positionData == null ? new HtmlData.AnchorHtmlData("", "") : positionDataDetailsInquirable.getInquiryUrl(positionData, propertyName);
        }
        return new LedgerBalanceInquirableImpl().getInquiryUrl(bo, propertyName);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        boolean isA21Balance;
        String wildCards = "";
        for (SearchOperator op : SearchOperator.QUERY_CHARACTERS) {
            wildCards = wildCards + op.op();
        }
        if (wildCards.contains(fieldValues.get("emplid").trim())) {
            ArrayList emptySearchResults = new ArrayList();
            Long actualCountIfTruncated = 0L;
            GlobalVariables.getMessageMap().putError("emplid", "error.fieldDoNotAllowWildcard", new String[]{"Employee ID field "});
            return new CollectionIncomplete(emptySearchResults, actualCountIfTruncated);
        }
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String pendingEntryOption = this.laborInquiryOptionsService.getSelectedPendingEntryOption(fieldValues);
        boolean isCgBeginningBalanceExcluded = this.laborInquiryOptionsService.isCgBeginningBalanceOnlyExcluded(fieldValues);
        boolean isConsolidated = this.laborInquiryOptionsService.isConsolidationSelected(fieldValues);
        String amountViewOption = this.getSelectedAmountViewOption(fieldValues);
        boolean isAccumulated = amountViewOption.equals("Accumulate");
        String balanceTypeCode = fieldValues.get("financialBalanceTypeCode");
        boolean bl = isA21Balance = StringUtils.isNotEmpty((CharSequence)balanceTypeCode) && "AC&A2".equals(balanceTypeCode.trim());
        if (isA21Balance) {
            fieldValues.put("financialBalanceTypeCode", "AC");
        }
        Integer recordCountForActualBalance = this.balanceService.getBalanceRecordCount(fieldValues, isConsolidated, this.getEncumbranceBalanceTypes(fieldValues), false);
        Iterator actualBalanceIterator = this.balanceService.findBalance(fieldValues, isConsolidated, this.getEncumbranceBalanceTypes(fieldValues), false);
        Collection<LedgerBalance> searchResultsCollection = this.buildBalanceCollection(actualBalanceIterator, isConsolidated, pendingEntryOption);
        this.laborInquiryOptionsService.updateLedgerBalanceByPendingLedgerEntry(searchResultsCollection, fieldValues, pendingEntryOption, isConsolidated);
        Integer recordCountForEffortBalance = 0;
        if (isA21Balance) {
            fieldValues.put("financialBalanceTypeCode", "A2");
            recordCountForEffortBalance = this.balanceService.getBalanceRecordCount(fieldValues, isConsolidated, this.getEncumbranceBalanceTypes(fieldValues), false);
            Iterator effortBalanceIterator = this.balanceService.findBalance(fieldValues, isConsolidated, this.getEncumbranceBalanceTypes(fieldValues), false);
            Collection effortBalances = this.buildBalanceCollection(effortBalanceIterator, isConsolidated, pendingEntryOption);
            this.laborInquiryOptionsService.updateLedgerBalanceByPendingLedgerEntry(effortBalances, fieldValues, pendingEntryOption, isConsolidated);
            List<String> consolidationKeyList = LedgerBalance.getPrimaryKeyList();
            searchResultsCollection = ConsolidationUtil.consolidateA2Balances(searchResultsCollection, effortBalances, "AC&A2", consolidationKeyList);
        }
        if (isCgBeginningBalanceExcluded) {
            searchResultsCollection = this.filterOutCGBeginningBalanceOnlyRows(searchResultsCollection);
        }
        this.accumulate(searchResultsCollection, isAccumulated);
        Integer recordCount = recordCountForActualBalance + recordCountForEffortBalance;
        Long actualSize = OJBUtility.getResultActualSize(searchResultsCollection, (Integer)recordCount, fieldValues, (Object)((Object)new LedgerBalance()));
        return this.buildSearchResultList(searchResultsCollection, actualSize);
    }

    protected Collection<LedgerBalance> filterOutCGBeginningBalanceOnlyRows(Collection<LedgerBalance> searchResultsCollection) {
        ArrayList<LedgerBalance> filteredSearchResults = new ArrayList<LedgerBalance>();
        for (LedgerBalance balance : searchResultsCollection) {
            if (balance.isCGBeginningBalanceOnly()) continue;
            filteredSearchResults.add(balance);
        }
        return filteredSearchResults;
    }

    protected Collection buildBalanceCollection(Iterator iterator, boolean isConsolidated, String pendingEntryOption) {
        Collection balanceCollection = isConsolidated ? this.buildConsolidatedBalanceCollection(iterator, pendingEntryOption) : this.buildDetailedBalanceCollection(iterator, pendingEntryOption);
        return balanceCollection;
    }

    protected Collection buildConsolidatedBalanceCollection(Iterator iterator, String pendingEntryOption) {
        ArrayList<LedgerBalance> balanceCollection = new ArrayList<LedgerBalance>();
        while (iterator.hasNext()) {
            Object collectionEntry = iterator.next();
            if (!collectionEntry.getClass().isArray()) continue;
            int i = 0;
            Object[] array = (Object[])collectionEntry;
            LedgerBalance balance = new LedgerBalance();
            if (LedgerBalance.class.isAssignableFrom(this.getBusinessObjectClass())) {
                try {
                    balance = (LedgerBalance)((Object)this.getBusinessObjectClass().newInstance());
                }
                catch (Exception e) {
                    LOG.warn("Using " + LedgerBalance.class + " for results because I couldn't instantiate the " + this.getBusinessObjectClass());
                }
            } else {
                LOG.warn("Using " + LedgerBalance.class + " for results because I couldn't instantiate the " + this.getBusinessObjectClass());
            }
            balance.setUniversityFiscalYear(Integer.valueOf(array[i++].toString()));
            balance.setChartOfAccountsCode(array[i++].toString());
            balance.setAccountNumber(array[i++].toString());
            String subAccountNumber = "*ALL*";
            balance.setSubAccountNumber(subAccountNumber);
            balance.setBalanceTypeCode(array[i++].toString());
            balance.setFinancialObjectCode(array[i++].toString());
            balance.setEmplid(array[i++].toString());
            balance.setPositionNumber(array[i++].toString());
            balance.setFinancialSubObjectCode("*ALL*");
            balance.setFinancialObjectTypeCode("*ALL*");
            balance.setAccountLineAnnualBalanceAmount(new KualiDecimal(array[i++].toString()));
            balance.setBeginningBalanceLineAmount(new KualiDecimal(array[i++].toString()));
            balance.setContractsGrantsBeginningBalanceAmount(new KualiDecimal(array[i++].toString()));
            balance.setMonth1Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth2Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth3Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth4Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth5Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth6Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth7Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth8Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth9Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth10Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth11Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth12Amount(new KualiDecimal(array[i++].toString()));
            balance.setMonth13Amount(new KualiDecimal(array[i].toString()));
            balance.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            balance.getDummyBusinessObject().setConsolidationOption("Consolidation");
            balanceCollection.add(balance);
        }
        return balanceCollection;
    }

    protected Collection buildDetailedBalanceCollection(Iterator iterator, String pendingEntryOption) {
        ArrayList<LedgerBalance> balanceCollection = new ArrayList<LedgerBalance>();
        while (iterator.hasNext()) {
            LedgerBalance copyBalance = (LedgerBalance)((Object)iterator.next());
            LedgerBalance balance = new LedgerBalance();
            if (LedgerBalance.class.isAssignableFrom(this.getBusinessObjectClass())) {
                try {
                    balance = (LedgerBalance)((Object)this.getBusinessObjectClass().newInstance());
                }
                catch (Exception e) {
                    LOG.warn("Using " + LedgerBalance.class + " for results because I couldn't instantiate the " + this.getBusinessObjectClass());
                }
            } else {
                LOG.warn("Using " + LedgerBalance.class + " for results because I couldn't instantiate the " + this.getBusinessObjectClass());
            }
            balance.setUniversityFiscalYear(copyBalance.getUniversityFiscalYear());
            balance.setChartOfAccountsCode(copyBalance.getChartOfAccountsCode());
            balance.setAccountNumber(copyBalance.getAccountNumber());
            balance.setSubAccountNumber(copyBalance.getSubAccountNumber());
            balance.setBalanceTypeCode(copyBalance.getBalanceTypeCode());
            balance.setFinancialObjectCode(copyBalance.getFinancialObjectCode());
            balance.setEmplid(copyBalance.getEmplid());
            balance.setObjectId(copyBalance.getObjectId());
            balance.setPositionNumber(copyBalance.getPositionNumber());
            balance.setFinancialSubObjectCode(copyBalance.getFinancialSubObjectCode());
            balance.setFinancialObjectTypeCode(copyBalance.getFinancialObjectTypeCode());
            balance.setAccountLineAnnualBalanceAmount(copyBalance.getAccountLineAnnualBalanceAmount());
            balance.setBeginningBalanceLineAmount(copyBalance.getBeginningBalanceLineAmount());
            balance.setContractsGrantsBeginningBalanceAmount(copyBalance.getContractsGrantsBeginningBalanceAmount());
            balance.setMonth1Amount(copyBalance.getMonth1Amount());
            balance.setMonth2Amount(copyBalance.getMonth2Amount());
            balance.setMonth3Amount(copyBalance.getMonth3Amount());
            balance.setMonth4Amount(copyBalance.getMonth4Amount());
            balance.setMonth5Amount(copyBalance.getMonth5Amount());
            balance.setMonth6Amount(copyBalance.getMonth6Amount());
            balance.setMonth7Amount(copyBalance.getMonth7Amount());
            balance.setMonth8Amount(copyBalance.getMonth8Amount());
            balance.setMonth9Amount(copyBalance.getMonth9Amount());
            balance.setMonth10Amount(copyBalance.getMonth10Amount());
            balance.setMonth11Amount(copyBalance.getMonth11Amount());
            balance.setMonth12Amount(copyBalance.getMonth12Amount());
            balance.setMonth13Amount(copyBalance.getMonth13Amount());
            balance.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            balance.getDummyBusinessObject().setConsolidationOption("Detail");
            balanceCollection.add(balance);
        }
        return balanceCollection;
    }

    protected List buildSearchResultList(Collection searchResultsCollection, Long actualSize) {
        CollectionIncomplete results;
        CollectionIncomplete searchResults = results = new CollectionIncomplete(searchResultsCollection, actualSize);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            results.sort((Comparator)new BeanPropertyComparator(defaultSortColumns, true));
        }
        return searchResults;
    }

    protected List<String> getEncumbranceBalanceTypes(Map<String, String> fieldValues) {
        List<String> encumbranceBalanceTypes = new ArrayList<String>();
        if (fieldValues.containsKey("universityFiscalYear")) {
            String universityFiscalYearStr = fieldValues.get("universityFiscalYear");
            Integer universityFiscalYear = Integer.valueOf(universityFiscalYearStr);
            encumbranceBalanceTypes = this.balanceTypService.getEncumbranceBalanceTypes(universityFiscalYear);
        }
        return encumbranceBalanceTypes;
    }

    public void setLaborInquiryOptionsService(LaborInquiryOptionsService laborInquiryOptionsService) {
        this.laborInquiryOptionsService = laborInquiryOptionsService;
    }

    public void setBalanceService(LaborLedgerBalanceService balanceService) {
        this.balanceService = balanceService;
    }

    public void setBalanceTypService(BalanceTypeService balanceTypService) {
        this.balanceTypService = balanceTypService;
    }
}

