/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.List;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class LaborExpenseTransferAccountLineTotalsMatchValidation
extends GenericValidation {
    private Document documentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        List targetLines;
        Document documentForValidation = this.getDocumentForValidation();
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)documentForValidation;
        List sourceLines = expenseTransferDocument.getSourceAccountingLines();
        if (!this.isAccountingLineTotalsMatch(sourceLines, targetLines = expenseTransferDocument.getTargetAccountingLines())) {
            GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.labor.accountingLineTotalsMismatch", new String[0]);
            return false;
        }
        return true;
    }

    public boolean isAccountingLineTotalsMatch(List sourceLines, List targetLines) {
        ExpenseTransferAccountingLine line;
        boolean isValid = true;
        KualiDecimal sourceLinesAmount = KualiDecimal.ZERO;
        KualiDecimal targetLinesAmount = KualiDecimal.ZERO;
        for (Object sourceLine : sourceLines) {
            line = (ExpenseTransferAccountingLine)sourceLine;
            sourceLinesAmount = (KualiDecimal)sourceLinesAmount.add((AbstractKualiDecimal)line.getAmount());
        }
        for (Object targetLine : targetLines) {
            line = (ExpenseTransferAccountingLine)targetLine;
            targetLinesAmount = (KualiDecimal)targetLinesAmount.add((AbstractKualiDecimal)line.getAmount());
        }
        if (sourceLinesAmount.compareTo((AbstractKualiDecimal)targetLinesAmount) != 0) {
            isValid = false;
        }
        return isValid;
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }
}

