/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.document.BenefitExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.module.ld.util.ConsolidationUtil;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class LaborExpenseTransferValidTransferAmountValidation
extends GenericValidation {
    private static final Logger LOG = LogManager.getLogger();
    private Document documentForValidation;
    private BusinessObjectService businessObjectService;
    private OptionsService optionsService;

    public boolean validate(AttributedDocumentEvent event) {
        Document documentForValidation = this.getDocumentForValidation();
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)documentForValidation;
        List sourceLines = expenseTransferDocument.getSourceAccountingLines();
        Map<String, ExpenseTransferAccountingLine> accountingLineGroupMap = this.getAccountingLineGroupMap(sourceLines, ExpenseTransferSourceAccountingLine.class);
        boolean isValidTransferAmount = this.isValidTransferAmount(accountingLineGroupMap);
        if (!isValidTransferAmount) {
            GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.labor.transferAmountExceedMaximum", new String[0]);
            return false;
        }
        return true;
    }

    protected boolean isValidTransferAmount(Map<String, ExpenseTransferAccountingLine> accountingLineGroupMap) {
        Set<Map.Entry<String, ExpenseTransferAccountingLine>> entrySet = accountingLineGroupMap.entrySet();
        for (Map.Entry<String, ExpenseTransferAccountingLine> entry : entrySet) {
            ExpenseTransferAccountingLine accountingLine = entry.getValue();
            Map<String, Object> fieldValues = this.buildFieldValueMap(accountingLine);
            KualiDecimal balanceAmount = this.getBalanceAmount(fieldValues, accountingLine.getPayrollEndDateFiscalPeriodCode());
            KualiDecimal transferAmount = accountingLine.getAmount();
            if (((KualiDecimal)balanceAmount.abs()).isLessThan(transferAmount.abs())) {
                return false;
            }
            if (!balanceAmount.isNegative() || !transferAmount.isPositive()) continue;
            return false;
        }
        return true;
    }

    protected Map<String, Object> buildFieldValueMap(ExpenseTransferAccountingLine accountingLine) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", accountingLine.getPayrollEndDateFiscalYear());
        fieldValues.put("chartOfAccountsCode", accountingLine.getChartOfAccountsCode());
        fieldValues.put("accountNumber", accountingLine.getAccountNumber());
        String subAccountNumber = accountingLine.getSubAccountNumber();
        subAccountNumber = StringUtils.isBlank((CharSequence)subAccountNumber) ? KFSConstants.getDashSubAccountNumber() : subAccountNumber;
        fieldValues.put("subAccountNumber", subAccountNumber);
        fieldValues.put("financialBalanceTypeCode", accountingLine.getBalanceTypeCode());
        fieldValues.put("financialObjectCode", accountingLine.getFinancialObjectCode());
        SystemOptions options = this.optionsService.getOptions(accountingLine.getPayrollEndDateFiscalYear());
        fieldValues.put("financialObjectTypeCode", options.getFinObjTypeExpenditureexpCd());
        String subObjectCode = accountingLine.getFinancialSubObjectCode();
        subObjectCode = StringUtils.isBlank((CharSequence)subObjectCode) ? KFSConstants.getDashFinancialSubObjectCode() : subObjectCode;
        fieldValues.put("financialSubObjectCode", subObjectCode);
        fieldValues.put("emplid", accountingLine.getEmplid());
        fieldValues.put("positionNumber", accountingLine.getPositionNumber());
        Document documentForValidation = this.getDocumentForValidation();
        if (documentForValidation instanceof BenefitExpenseTransferDocument) {
            fieldValues.remove("emplid");
            fieldValues.remove("positionNumber");
        }
        return fieldValues;
    }

    protected Map<String, ExpenseTransferAccountingLine> getAccountingLineGroupMap(List<ExpenseTransferAccountingLine> accountingLines, Class clazz) {
        HashMap<String, ExpenseTransferAccountingLine> accountingLineGroupMap = new HashMap<String, ExpenseTransferAccountingLine>();
        for (ExpenseTransferAccountingLine accountingLine : accountingLines) {
            ExpenseTransferAccountingLine line;
            String stringKey = ObjectUtil.buildPropertyMap((Object)accountingLine, this.defaultKeyOfExpenseTransferAccountingLine()).toString();
            if (accountingLineGroupMap.containsKey(stringKey)) {
                line = (ExpenseTransferAccountingLine)accountingLineGroupMap.get(stringKey);
                KualiDecimal amount = line.getAmount();
                line.setAmount((KualiDecimal)amount.add((AbstractKualiDecimal)accountingLine.getAmount()));
                continue;
            }
            try {
                line = (ExpenseTransferAccountingLine)clazz.newInstance();
                ObjectUtil.buildObject((Object)line, (Object)accountingLine);
                accountingLineGroupMap.put(stringKey, line);
            }
            catch (Exception e) {
                LOG.error("Cannot create a new instance of ExpenseTransferAccountingLine" + e);
            }
        }
        return accountingLineGroupMap;
    }

    protected List<String> defaultKeyOfExpenseTransferAccountingLine() {
        ArrayList<String> defaultKey = new ArrayList<String>();
        defaultKey.add("postingYear");
        defaultKey.add("chartOfAccountsCode");
        defaultKey.add("accountNumber");
        defaultKey.add("subAccountNumber");
        defaultKey.add("balanceTypeCode");
        defaultKey.add("financialObjectCode");
        defaultKey.add("financialSubObjectCode");
        defaultKey.add("emplid");
        defaultKey.add("positionNumber");
        defaultKey.add("payrollEndDateFiscalYear");
        defaultKey.add("payrollEndDateFiscalPeriodCode");
        return defaultKey;
    }

    protected KualiDecimal getBalanceAmount(Map<String, Object> fieldValues, String periodCode) {
        if (periodCode == null) {
            return KualiDecimal.ZERO;
        }
        fieldValues.put("financialBalanceTypeCode", "AC");
        KualiDecimal actualBalanceAmount = this.getBalanceAmountOfGivenPeriod(fieldValues, periodCode);
        fieldValues.put("financialBalanceTypeCode", "A2");
        KualiDecimal effortBalanceAmount = this.getBalanceAmountOfGivenPeriod(fieldValues, periodCode);
        return (KualiDecimal)actualBalanceAmount.add((AbstractKualiDecimal)effortBalanceAmount);
    }

    protected KualiDecimal getBalanceAmountOfGivenPeriod(Map<String, Object> fieldValues, String periodCode) {
        List ledgerBalances = (List)this.businessObjectService.findMatching(LedgerBalance.class, fieldValues);
        LedgerBalance summaryBalance = new LedgerBalance();
        for (LedgerBalance balance : ledgerBalances) {
            ConsolidationUtil.sumLedgerBalances(summaryBalance, balance);
        }
        return summaryBalance.getAmount(periodCode);
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }
}

