/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.service.ReconciliationParserService;
import org.kuali.kfs.gl.batch.service.impl.EnterpriseFeederStatus;
import org.kuali.kfs.gl.batch.service.impl.ExceptionCaughtStatus;
import org.kuali.kfs.gl.batch.service.impl.FileReconBadLoadAbortedStatus;
import org.kuali.kfs.gl.batch.service.impl.FileReconOkLoadOkStatus;
import org.kuali.kfs.gl.batch.service.impl.ReconciliationBlock;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.gl.report.LedgerSummaryReport;
import org.kuali.kfs.gl.service.OriginEntryService;
import org.kuali.kfs.gl.service.impl.EnterpriseFeederStatusAndErrorMessagesWrapper;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.batch.LaborEnterpriseFeedStep;
import org.kuali.kfs.module.ld.batch.service.FileEnterpriseFeederHelperService;
import org.kuali.kfs.module.ld.batch.service.ReconciliationService;
import org.kuali.kfs.module.ld.businessobject.BenefitsCalculation;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.PositionObjectBenefit;
import org.kuali.kfs.module.ld.report.EnterpriseFeederReportData;
import org.kuali.kfs.module.ld.service.LaborBenefitsCalculationService;
import org.kuali.kfs.module.ld.service.LaborPositionObjectBenefitService;
import org.kuali.kfs.module.ld.util.LaborOriginEntryFileIterator;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiPercent;
import org.kuali.rice.krad.bo.BusinessObject;

public class FileEnterpriseFeederHelperServiceImpl
implements FileEnterpriseFeederHelperService {
    private static final Logger LOG = LogManager.getLogger();
    protected ReconciliationParserService reconciliationParserService;
    protected ReconciliationService reconciliationService;
    protected OriginEntryService originEntryService;
    protected ParameterService parameterService;
    protected LaborPositionObjectBenefitService laborPositionObjectBenefitService;
    protected LaborBenefitsCalculationService laborBenefitsCalculationService;
    protected BusinessObjectService businessObjectService;
    protected ConfigurationService configurationService;
    protected DateTimeService dateTimeService;
    private UniversityDateService universityDateService;

    @Override
    public void feedOnFile(File doneFile, File dataFile, File reconFile, PrintStream enterpriseFeedPs, String feederProcessName, String reconciliationTableId, EnterpriseFeederStatusAndErrorMessagesWrapper statusAndErrors, LedgerSummaryReport ledgerSummaryReport, ReportWriterService errorStatisticsReport, EnterpriseFeederReportData feederReportData) {
        block43: {
            ReconciliationBlock reconciliationBlock;
            if (LOG.isInfoEnabled()) {
                LOG.info("Processing done file: " + doneFile.getAbsolutePath());
            }
            List errorMessages = statusAndErrors.getErrorMessages();
            BufferedReader dataFileReader = null;
            FileReader reconReader = null;
            try {
                reconReader = new FileReader(reconFile, StandardCharsets.UTF_8);
                reconciliationBlock = this.reconciliationParserService.parseReconciliationBlock((Reader)reconReader, reconciliationTableId);
            }
            catch (IOException e) {
                LOG.error("IO Error occurred trying to read the recon file.", (Throwable)e);
                errorMessages.add(new Message("IO Error occurred trying to read the recon file.", 1));
                statusAndErrors.setStatus((EnterpriseFeederStatus)new FileReconBadLoadAbortedStatus());
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                LOG.error("Error occurred trying to parse the recon file.", (Throwable)e);
                errorMessages.add(new Message("Error occurred trying to parse the recon file.", 1));
                statusAndErrors.setStatus((EnterpriseFeederStatus)new FileReconBadLoadAbortedStatus());
                throw e;
            }
            finally {
                if (reconReader != null) {
                    try {
                        ((Reader)reconReader).close();
                    }
                    catch (IOException e) {
                        LOG.error("Error occurred trying to close recon file: " + reconFile.getAbsolutePath(), (Throwable)e);
                    }
                }
            }
            try {
                if (reconciliationBlock == null) {
                    errorMessages.add(new Message("Unable to parse reconciliation file.", 1));
                } else {
                    dataFileReader = new BufferedReader(new FileReader(dataFile, StandardCharsets.UTF_8));
                    LaborOriginEntryFileIterator fileIterator = new LaborOriginEntryFileIterator(dataFileReader, false);
                    this.reconciliationService.reconcile(fileIterator, reconciliationBlock, errorMessages);
                    dataFileReader.close();
                    dataFileReader = null;
                }
                if (this.reconciliationProcessSucceeded(errorMessages)) {
                    String line;
                    dataFileReader = new BufferedReader(new FileReader(dataFile, StandardCharsets.UTF_8));
                    int count = 0;
                    HashMap salaryBenefitOffsets = new HashMap();
                    boolean calculateOffsets = this.parameterService.getParameterValueAsBoolean(LaborEnterpriseFeedStep.class, "LABOR_BENEFIT_CALCULATION_OFFSET_IND");
                    Collection offsetDocTypes = this.parameterService.getParameterValuesAsString(LaborEnterpriseFeedStep.class, "LABOR_BENEFIT_OFFSET_DOCTYPE");
                    offsetDocTypes = offsetDocTypes.stream().map(s -> s.toUpperCase(Locale.US)).collect(Collectors.toList());
                    while ((line = dataFileReader.readLine()) != null) {
                        try {
                            LaborOriginEntry tempEntry = new LaborOriginEntry();
                            tempEntry.setFromTextFileForBatch(line, count);
                            this.applyDefaultIfNecessary(tempEntry);
                            feederReportData.incrementNumberOfRecordsRead();
                            feederReportData.addToTotalAmountRead(tempEntry.getTransactionLedgerEntryAmount());
                            enterpriseFeedPs.printf("%s\n", line);
                            ledgerSummaryReport.summarizeEntry((OriginEntryInformation)tempEntry);
                            feederReportData.incrementNumberOfRecordsWritten();
                            feederReportData.addToTotalAmountWritten(tempEntry.getTransactionLedgerEntryAmount());
                            List<LaborOriginEntry> benefitEntries = this.generateBenefits(tempEntry, errorStatisticsReport, feederReportData);
                            for (LaborOriginEntry benefitEntry : benefitEntries) {
                                List<LaborOriginEntry> entries;
                                enterpriseFeedPs.printf("%s\n", benefitEntry.getLine());
                                feederReportData.incrementNumberOfRecordsWritten();
                                feederReportData.addToTotalAmountWritten(benefitEntry.getTransactionLedgerEntryAmount());
                                if (!calculateOffsets || offsetDocTypes == null || !offsetDocTypes.contains(tempEntry.getFinancialDocumentTypeCode().toUpperCase(Locale.US))) continue;
                                String key = tempEntry.getUniversityFiscalYear() + "_" + tempEntry.getChartOfAccountsCode() + "_" + tempEntry.getAccountNumber() + "_" + tempEntry.getFinancialObjectCode();
                                if (!salaryBenefitOffsets.containsKey(key)) {
                                    entries = new ArrayList();
                                    salaryBenefitOffsets.put((CallSite)((Object)key), entries);
                                } else {
                                    entries = (List)salaryBenefitOffsets.get(key);
                                }
                                benefitEntry.setFinancialObjectCode(tempEntry.getFinancialObjectCode());
                                benefitEntry.setAccountNumber(tempEntry.getAccountNumber());
                                benefitEntry.setChartOfAccountsCode(tempEntry.getChartOfAccountsCode());
                                benefitEntry.setUniversityFiscalYear(tempEntry.getUniversityFiscalYear());
                                benefitEntry.setUniversityFiscalPeriodCode(tempEntry.getUniversityFiscalPeriodCode());
                                entries.add(benefitEntry);
                            }
                        }
                        catch (Exception e) {
                            throw new IOException(e);
                        }
                        ++count;
                    }
                    if (calculateOffsets && offsetDocTypes != null) {
                        String originCode = this.parameterService.getParameterValueAsString("KFS-LD", "LaborEnterpriseFeedStep", "LABOR_BENEFIT_OFFSET_ORIGIN_CODE");
                        for (List entryList : salaryBenefitOffsets.values()) {
                            LaborOriginEntry entry2;
                            if (entryList == null || entryList.size() <= 0) continue;
                            LaborOriginEntry offsetEntry = new LaborOriginEntry();
                            KualiDecimal total = KualiDecimal.ZERO;
                            for (LaborOriginEntry entry2 : entryList) {
                                if (entry2.getTransactionDebitCreditCode().equalsIgnoreCase("D")) {
                                    total = (KualiDecimal)total.add((AbstractKualiDecimal)entry2.getTransactionLedgerEntryAmount());
                                    continue;
                                }
                                total = (KualiDecimal)total.subtract((AbstractKualiDecimal)entry2.getTransactionLedgerEntryAmount());
                            }
                            if (!total.isNonZero()) continue;
                            Collection<PositionObjectBenefit> positionObjectBenefits = this.laborPositionObjectBenefitService.getActivePositionObjectBenefits(((LaborOriginEntry)entryList.get(0)).getUniversityFiscalYear(), ((LaborOriginEntry)entryList.get(0)).getChartOfAccountsCode(), ((LaborOriginEntry)entryList.get(0)).getFinancialObjectCode());
                            entry2 = (LaborOriginEntry)entryList.get(0);
                            if (positionObjectBenefits == null || positionObjectBenefits.isEmpty()) {
                                this.writeMissingBenefitsTypeError(entry2, errorStatisticsReport, feederReportData);
                            } else {
                                for (PositionObjectBenefit positionObjectBenefit : positionObjectBenefits) {
                                    HashMap<String, Object> fieldValues = new HashMap<String, Object>(3);
                                    fieldValues.put("universityFiscalYear", entry2.getUniversityFiscalYear());
                                    fieldValues.put("chartOfAccountsCode", entry2.getChartOfAccountsCode());
                                    fieldValues.put("positionBenefitTypeCode", positionObjectBenefit.getFinancialObjectBenefitsTypeCode());
                                    BenefitsCalculation benefitsCalculation = (BenefitsCalculation)this.businessObjectService.findByPrimaryKey(BenefitsCalculation.class, fieldValues);
                                    offsetEntry.setAccountNumber(benefitsCalculation.getAccountCodeOffset());
                                    offsetEntry.setFinancialObjectCode(benefitsCalculation.getObjectCodeOffset());
                                }
                            }
                            offsetEntry.setUniversityFiscalPeriodCode(entry2.getUniversityFiscalPeriodCode());
                            offsetEntry.setChartOfAccountsCode(entry2.getChartOfAccountsCode());
                            offsetEntry.setUniversityFiscalYear(entry2.getUniversityFiscalYear());
                            offsetEntry.setTransactionLedgerEntryDescription("GENERATED BENEFIT OFFSET");
                            offsetEntry.setFinancialSystemOriginationCode(originCode);
                            offsetEntry.setDocumentNumber(this.dateTimeService.toString(this.dateTimeService.getCurrentDate(), "yyyyMMddhhmmssSSS"));
                            offsetEntry.setTransactionLedgerEntryAmount((KualiDecimal)total.abs());
                            if (total.isGreaterThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                                offsetEntry.setTransactionDebitCreditCode("C");
                            } else if (total.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
                                offsetEntry.setTransactionDebitCreditCode("D");
                            }
                            offsetEntry.setFinancialDocumentTypeCode(offsetDocTypes.stream().findFirst().orElse(null));
                            enterpriseFeedPs.printf("%s\n", offsetEntry.getLine());
                        }
                    }
                    dataFileReader.close();
                    dataFileReader = null;
                    statusAndErrors.setStatus((EnterpriseFeederStatus)new FileReconOkLoadOkStatus());
                    break block43;
                }
                statusAndErrors.setStatus((EnterpriseFeederStatus)new FileReconBadLoadAbortedStatus());
            }
            catch (Exception e) {
                LOG.error("Caught exception when reconciling/loading done file: " + doneFile, (Throwable)e);
                statusAndErrors.setStatus((EnterpriseFeederStatus)new ExceptionCaughtStatus());
                errorMessages.add(new Message("Caught exception attempting to reconcile/load done file: " + doneFile + ".  File contents are NOT loaded", 1));
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                if (dataFileReader != null) {
                    try {
                        dataFileReader.close();
                    }
                    catch (IOException e) {
                        LOG.error("IO Exception occurred trying to close connection to the data file", (Throwable)e);
                        errorMessages.add(new Message("IO Exception occurred trying to close connection to the data file", 1));
                    }
                }
            }
        }
    }

    protected List<LaborOriginEntry> generateBenefits(LaborOriginEntry wageEntry, ReportWriterService errorStatisticsReport, EnterpriseFeederReportData feederReportData) {
        boolean isEncumbrance;
        ArrayList<LaborOriginEntry> benefits = new ArrayList<LaborOriginEntry>();
        String balanceTypeCode = wageEntry.getFinancialBalanceTypeCode();
        boolean isActual = "AC".equals(balanceTypeCode) || "A2".equals(balanceTypeCode);
        boolean bl = isEncumbrance = "D".equals(wageEntry.getTransactionEncumbranceUpdateCode()) || "R".equals(wageEntry.getTransactionEncumbranceUpdateCode());
        if (isActual) {
            feederReportData.incrementNumberOfBalanceTypeActualsRead();
            boolean generateActualBenefits = this.parameterService.getParameterValueAsBoolean(LaborEnterpriseFeedStep.class, "GENERATE_FRINGE_BENEFIT_IND");
            if (!generateActualBenefits) {
                LOG.info("Skipping benefit generation due to parameter disabling benefit generation for actual balance type");
                return benefits;
            }
        }
        if (isEncumbrance) {
            feederReportData.incrementNumberOfBalanceTypeEncumbranceRead();
            boolean generateEncumbranceBenefits = this.parameterService.getParameterValueAsBoolean(LaborEnterpriseFeedStep.class, "GENERATE_FRINGE_BENEFIT_ENCUMBRANCE_IND");
            if (!generateEncumbranceBenefits) {
                LOG.info("Skipping benefit generation due to parameter disabling benefit generation for encumbrance balance type");
                return benefits;
            }
        }
        String benefitRateCategoryCode = this.laborBenefitsCalculationService.getBenefitRateCategoryCode(wageEntry.getChartOfAccountsCode(), wageEntry.getAccountNumber(), wageEntry.getSubAccountNumber());
        String defaultLaborBenefitsRateCategoryCode = StringUtils.trimToEmpty((String)this.parameterService.getParameterValueAsString(Account.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND"));
        boolean useBenefitRateCategoryCode = this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "ENABLE_FRINGE_BENEFIT_CALC_BY_BENEFIT_RATE_CATEGORY_IND");
        Collection<PositionObjectBenefit> positionObjectBenefits = this.laborPositionObjectBenefitService.getActivePositionObjectBenefits(wageEntry.getUniversityFiscalYear(), wageEntry.getChartOfAccountsCode(), wageEntry.getFinancialObjectCode());
        if (positionObjectBenefits == null || positionObjectBenefits.isEmpty()) {
            this.writeMissingBenefitsTypeError(wageEntry, errorStatisticsReport, feederReportData);
        }
        for (PositionObjectBenefit positionObjectBenefit : positionObjectBenefits) {
            BenefitsCalculation benefitsCalculation = useBenefitRateCategoryCode ? this.laborBenefitsCalculationService.getBenefitsCalculation(wageEntry.getUniversityFiscalYear(), wageEntry.getChartOfAccountsCode(), positionObjectBenefit.getFinancialObjectBenefitsTypeCode(), benefitRateCategoryCode) : this.laborBenefitsCalculationService.getBenefitsCalculation(wageEntry.getUniversityFiscalYear(), wageEntry.getChartOfAccountsCode(), positionObjectBenefit.getFinancialObjectBenefitsTypeCode(), defaultLaborBenefitsRateCategoryCode);
            if (ObjectUtils.isNull((Object)((Object)benefitsCalculation)) || !benefitsCalculation.isActive()) continue;
            LaborOriginEntry benefitEntry = new LaborOriginEntry(wageEntry);
            benefitEntry.setFinancialObjectCode(benefitsCalculation.getPositionFringeBenefitObjectCode());
            KualiPercent fringeBenefitPercent = benefitsCalculation.getPositionFringeBenefitPercent();
            KualiDecimal fringeBenefitAmount = (KualiDecimal)((KualiDecimal)fringeBenefitPercent.multiply((AbstractKualiDecimal)wageEntry.getTransactionLedgerEntryAmount())).divide((AbstractKualiDecimal)KFSConstants.ONE_HUNDRED.kualiDecimalValue());
            benefitEntry.setTransactionLedgerEntryAmount(fringeBenefitAmount);
            benefits.add(benefitEntry);
            if (isActual) {
                feederReportData.incrementNumberOfFringeActualsGenerated();
                continue;
            }
            feederReportData.incrementNumberOfFringeEncumbrancesGenerated();
        }
        return benefits;
    }

    protected void writeMissingBenefitsTypeError(LaborOriginEntry wageEntry, ReportWriterService errorStatisticsReport, EnterpriseFeederReportData feederReportData) {
        String benefitKey = wageEntry.getUniversityFiscalYear() + "-" + wageEntry.getChartOfAccountsCode() + "-" + wageEntry.getFinancialObjectCode();
        String message = this.configurationService.getPropertyValueAsString("error.ld.enterpriseFeed.report.benefitTypeNotFound");
        message = MessageFormat.format(message, benefitKey);
        feederReportData.incrementNumberOfErrorEncountered();
        LOG.error(message);
        errorStatisticsReport.writeError((BusinessObject)wageEntry, new Message(message, 1));
    }

    protected boolean reconciliationProcessSucceeded(List<Message> errorMessages) {
        for (Message message : errorMessages) {
            if (message.getType() != 1) continue;
            return false;
        }
        return true;
    }

    protected void applyDefaultIfNecessary(LaborOriginEntry laborOriginEntry) {
        if (ObjectUtils.isNull((Object)laborOriginEntry.getUniversityFiscalYear())) {
            laborOriginEntry.setUniversityFiscalYear(this.universityDateService.getCurrentFiscalYear());
        }
    }

    public void setReconciliationParserService(ReconciliationParserService reconciliationParserService) {
        this.reconciliationParserService = reconciliationParserService;
    }

    public void setReconciliationService(ReconciliationService reconciliationService) {
        this.reconciliationService = reconciliationService;
    }

    public void setOriginEntryService(OriginEntryService originEntryService) {
        this.originEntryService = originEntryService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setLaborPositionObjectBenefitService(LaborPositionObjectBenefitService laborPositionObjectBenefitService) {
        this.laborPositionObjectBenefitService = laborPositionObjectBenefitService;
    }

    public void setLaborBenefitsCalculationService(LaborBenefitsCalculationService laborBenefitsCalculationService) {
        this.laborBenefitsCalculationService = laborBenefitsCalculationService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }
}

