/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.gl.businessobject.OriginEntryGroup;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.gl.report.LedgerSummaryReport;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ld.batch.service.LaborNightlyOutService;
import org.kuali.kfs.module.ld.businessobject.LaborGeneralLedgerEntry;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.dataaccess.LaborClearGeneralLedgerEntryDao;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.batch.service.WrappingBatchService;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborNightlyOutServiceImpl
implements LaborNightlyOutService {
    private static final Logger LOG = LogManager.getLogger();
    protected LaborLedgerPendingEntryService laborLedgerPendingEntryService;
    protected OriginEntryGroupService originEntryGroupService;
    protected BusinessObjectService businessObjectService;
    protected DateTimeService dateTimeService;
    protected String batchFileDirectoryName;
    protected String batchGlFileDirectoryName;
    protected LaborClearGeneralLedgerEntryDao laborClearGeneralLedgerEntryDao;
    protected ReportWriterService laborPendingEntryLedgerReportWriterService;
    protected ReportWriterService laborGLEntryReportWriterService;

    @Override
    public void deleteCopiedPendingLedgerEntries() {
        this.laborLedgerPendingEntryService.deleteByFinancialDocumentApprovedCode("X");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyApprovedPendingLedgerEntries() {
        PrintStream outputFilePs;
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        String outputFile = this.batchFileDirectoryName + File.separator + "ld_labentry_kfs.data";
        try {
            outputFilePs = new PrintStream(outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Iterator<LaborLedgerPendingEntry> pendingEntries = this.laborLedgerPendingEntryService.findApprovedPendingLedgerEntries();
        LedgerSummaryReport nightlyOutLedgerSummaryReport = new LedgerSummaryReport();
        while (pendingEntries != null && pendingEntries.hasNext()) {
            LaborLedgerPendingEntry pendingEntry = pendingEntries.next();
            LaborOriginEntry entry = new LaborOriginEntry(pendingEntry);
            try {
                outputFilePs.printf("%s\n", entry.getLine());
                nightlyOutLedgerSummaryReport.summarizeEntry((OriginEntryInformation)entry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            pendingEntry.setFinancialDocumentApprovedCode("X");
            pendingEntry.setTransactionDate(runDate);
            this.businessObjectService.save((PersistableBusinessObject)pendingEntry);
        }
        outputFilePs.close();
        String doneFileName = outputFile.replace(".data", ".done");
        File doneFile = new File(doneFileName);
        if (!doneFile.exists()) {
            try {
                doneFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
        try {
            ((WrappingBatchService)this.laborPendingEntryLedgerReportWriterService).initialize();
            nightlyOutLedgerSummaryReport.writeReport(this.laborPendingEntryLedgerReportWriterService);
        }
        finally {
            ((WrappingBatchService)this.laborPendingEntryLedgerReportWriterService).destroy();
        }
    }

    @Override
    public void deleteCopiedLaborGenerealLedgerEntries() {
        this.laborClearGeneralLedgerEntryDao.deleteCopiedLaborGenerealLedgerEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyLaborGenerealLedgerEntries() {
        PrintStream outputFilePs;
        String outputFile = this.batchGlFileDirectoryName + File.separator + "gl_glentry_lab.data";
        try {
            outputFilePs = new PrintStream(outputFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collection generalLedgerEntries = this.businessObjectService.findAll(LaborGeneralLedgerEntry.class);
        LedgerSummaryReport laborGLSummaryReport = new LedgerSummaryReport();
        for (LaborGeneralLedgerEntry entry : generalLedgerEntries) {
            OriginEntryFull originEntry = new OriginEntryFull();
            ObjectUtil.buildObject((Object)originEntry, (Object)((Object)entry));
            try {
                outputFilePs.printf("%s\n", originEntry.getLine());
                laborGLSummaryReport.summarizeEntry((OriginEntryInformation)originEntry);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        outputFilePs.close();
        String doneFileName = outputFile.replace(".data", ".done");
        File doneFile = new File(doneFileName);
        if (!doneFile.exists()) {
            try {
                doneFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
        try {
            ((WrappingBatchService)this.laborGLEntryReportWriterService).initialize();
            laborGLSummaryReport.writeReport(this.laborGLEntryReportWriterService);
        }
        finally {
            ((WrappingBatchService)this.laborGLEntryReportWriterService).destroy();
        }
    }

    protected boolean saveAsLaborOriginEntry(LaborLedgerPendingEntry pendingEntry, OriginEntryGroup group) {
        try {
            LaborOriginEntry originEntry = new LaborOriginEntry();
            ObjectUtil.buildObject((Object)originEntry, (Object)pendingEntry);
            originEntry.setTransactionPostingDate(group.getDate());
            originEntry.setEntryGroupId(group.getId());
            this.businessObjectService.save((PersistableBusinessObject)originEntry);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fail to copy the pending entry as origin entry" + e);
            }
            return false;
        }
        return true;
    }

    protected boolean saveAsLaborOriginEntry(LaborLedgerPendingEntry pendingEntry) {
        try {
            LaborOriginEntry originEntry = new LaborOriginEntry();
            ObjectUtil.buildObject((Object)originEntry, (Object)pendingEntry);
            this.businessObjectService.save((PersistableBusinessObject)originEntry);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fail to copy the pending entry as origin entry" + e);
            }
            return false;
        }
        return true;
    }

    protected boolean saveAsGLOriginEntry(LaborGeneralLedgerEntry entry, OriginEntryGroup group) {
        try {
            OriginEntryFull originEntry = new OriginEntryFull();
            ObjectUtil.buildObject((Object)originEntry, (Object)((Object)entry));
            originEntry.setEntryGroupId(group.getId());
            this.businessObjectService.save((PersistableBusinessObject)originEntry);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Fail to copy the labor GL entry as an origin entry" + e);
            }
            return false;
        }
        return true;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setLaborLedgerPendingEntryService(LaborLedgerPendingEntryService laborLedgerPendingEntryService) {
        this.laborLedgerPendingEntryService = laborLedgerPendingEntryService;
    }

    public void setOriginEntryGroupService(OriginEntryGroupService originEntryGroupService) {
        this.originEntryGroupService = originEntryGroupService;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }

    public void setBatchGlFileDirectoryName(String batchGlFileDirectoryName) {
        this.batchGlFileDirectoryName = batchGlFileDirectoryName;
    }

    public void setLaborPendingEntryLedgerReportWriterService(ReportWriterService laborPendingEntryLedgerReportWriterService) {
        this.laborPendingEntryLedgerReportWriterService = laborPendingEntryLedgerReportWriterService;
    }

    public void setLaborGLEntryReportWriterService(ReportWriterService laborGLEntryReportWriterService) {
        this.laborGLEntryReportWriterService = laborGLEntryReportWriterService;
    }

    protected LaborClearGeneralLedgerEntryDao getLaborClearGeneralLedgerEntryDao() {
        return this.laborClearGeneralLedgerEntryDao;
    }

    public void setLaborClearGeneralLedgerEntryDao(LaborClearGeneralLedgerEntryDao laborClearGeneralLedgerEntryDao) {
        this.laborClearGeneralLedgerEntryDao = laborClearGeneralLedgerEntryDao;
    }
}

