/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.BalanceType;
import org.kuali.kfs.coa.service.ObjectCodeService;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.batch.BatchSortUtil;
import org.kuali.kfs.gl.batch.ScrubberStep;
import org.kuali.kfs.gl.batch.service.AccountingCycleCachingService;
import org.kuali.kfs.gl.businessobject.DemergerReportData;
import org.kuali.kfs.gl.businessobject.OriginEntryGroup;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.gl.businessobject.OriginEntryStatistics;
import org.kuali.kfs.gl.businessobject.ScrubberProcessUnitOfWork;
import org.kuali.kfs.gl.report.LedgerSummaryReport;
import org.kuali.kfs.gl.report.PreScrubberReport;
import org.kuali.kfs.gl.report.PreScrubberReportData;
import org.kuali.kfs.gl.report.TransactionListingReport;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.gl.service.PreScrubberService;
import org.kuali.kfs.gl.service.ScrubberReportData;
import org.kuali.kfs.gl.service.ScrubberValidator;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.batch.LaborScrubberSortComparator;
import org.kuali.kfs.module.ld.batch.LaborScrubberStep;
import org.kuali.kfs.module.ld.batch.service.LaborAccountingCycleCachingService;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntryFieldUtil;
import org.kuali.kfs.module.ld.service.LaborOriginEntryService;
import org.kuali.kfs.module.ld.util.FilteringLaborOriginEntryFileIterator;
import org.kuali.kfs.module.ld.util.LaborOriginEntryFileIterator;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.batch.service.WrappingBatchService;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.dataaccess.UniversityDateDao;
import org.kuali.kfs.sys.service.DocumentNumberAwareReportWriterService;
import org.kuali.kfs.sys.service.FlexibleOffsetAccountService;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.parameter.ParameterEvaluator;
import org.kuali.rice.core.api.parameter.ParameterEvaluatorService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class LaborScrubberProcess {
    private static final Logger LOG = LogManager.getLogger();
    protected static String SPACES = "                                        ";
    protected FlexibleOffsetAccountService flexibleOffsetAccountService;
    protected LaborOriginEntryService laborOriginEntryService;
    protected OriginEntryGroupService originEntryGroupService;
    protected DateTimeService dateTimeService;
    protected OffsetDefinitionService offsetDefinitionService;
    protected ObjectCodeService objectCodeService;
    protected ConfigurationService kualiConfigurationService;
    protected UniversityDateDao universityDateDao;
    protected PersistenceService persistenceService;
    protected ScrubberValidator scrubberValidator;
    protected LaborAccountingCycleCachingService laborAccountingCycleCachingService;
    protected PreScrubberService laborPreScrubberService;
    protected DocumentNumberAwareReportWriterService laborMainReportWriterService;
    protected DocumentNumberAwareReportWriterService laborLedgerReportWriterService;
    protected ReportWriterService laborBadBalanceTypeReportWriterService;
    protected ReportWriterService laborErrorListingReportWriterService;
    protected DocumentNumberAwareReportWriterService laborGeneratedTransactionsReportWriterService;
    protected ReportWriterService laborDemergerReportWriterService;
    protected DocumentNumberAwareReportWriterService laborPreScrubberReportWriterService;
    protected ParameterService parameterService;
    private ParameterEvaluatorService parameterEvaluatorService;
    protected String batchFileDirectoryName;
    protected Date runDate;
    protected Calendar runCal;
    protected UniversityDate universityRunDate;
    protected String offsetString;
    protected Integer cutoffHour;
    protected Integer cutoffMinute;
    protected Integer cutoffSecond;
    protected OriginEntryGroup validGroup;
    protected OriginEntryGroup errorGroup;
    protected OriginEntryGroup expiredGroup;
    protected ScrubberProcessUnitOfWork scrubberProcessUnitOfWork;
    protected KualiDecimal scrubCostShareAmount;
    protected ScrubberReportData scrubberReport;
    protected String offsetDescription;
    protected String capitalizationDescription;
    protected String liabilityDescription;
    protected String transferDescription;
    protected String costShareDescription;
    protected String inputFile;
    protected String validFile;
    protected String errorFile;
    protected String expiredFile;

    public LaborScrubberProcess(FlexibleOffsetAccountService flexibleOffsetAccountService, LaborAccountingCycleCachingService laborAccountingCycleCachingService, LaborOriginEntryService laborOriginEntryService, OriginEntryGroupService originEntryGroupService, DateTimeService dateTimeService, OffsetDefinitionService offsetDefinitionService, ObjectCodeService objectCodeService, ConfigurationService kualiConfigurationService, UniversityDateDao universityDateDao, PersistenceService persistenceService, ScrubberValidator scrubberValidator, String batchFileDirectoryName, DocumentNumberAwareReportWriterService laborMainReportWriterService, DocumentNumberAwareReportWriterService laborLedgerReportWriterService, ReportWriterService laborBadBalanceTypeReportWriterService, ReportWriterService laborErrorListingReportWriterService, DocumentNumberAwareReportWriterService laborGeneratedTransactionsReportWriterService, ReportWriterService laborDemergerReportWriterService, PreScrubberService laborPreScrubberService, DocumentNumberAwareReportWriterService laborPreScrubberReportWriterService, ParameterService parameterService, ParameterEvaluatorService parameterEvaluatorService) {
        this.flexibleOffsetAccountService = flexibleOffsetAccountService;
        this.laborAccountingCycleCachingService = laborAccountingCycleCachingService;
        this.laborOriginEntryService = laborOriginEntryService;
        this.originEntryGroupService = originEntryGroupService;
        this.dateTimeService = dateTimeService;
        this.offsetDefinitionService = offsetDefinitionService;
        this.objectCodeService = objectCodeService;
        this.kualiConfigurationService = kualiConfigurationService;
        this.universityDateDao = universityDateDao;
        this.persistenceService = persistenceService;
        this.scrubberValidator = scrubberValidator;
        this.batchFileDirectoryName = batchFileDirectoryName;
        this.laborMainReportWriterService = laborMainReportWriterService;
        this.laborLedgerReportWriterService = laborLedgerReportWriterService;
        this.laborBadBalanceTypeReportWriterService = laborBadBalanceTypeReportWriterService;
        this.laborErrorListingReportWriterService = laborErrorListingReportWriterService;
        this.laborGeneratedTransactionsReportWriterService = laborGeneratedTransactionsReportWriterService;
        this.laborDemergerReportWriterService = laborDemergerReportWriterService;
        this.laborPreScrubberService = laborPreScrubberService;
        this.laborPreScrubberReportWriterService = laborPreScrubberReportWriterService;
        this.parameterService = parameterService;
        this.parameterEvaluatorService = parameterEvaluatorService;
        this.cutoffHour = null;
        this.cutoffMinute = null;
        this.cutoffSecond = null;
        this.initCutoffTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrubGroupReportOnly(String fileName, String documentNumber) {
        PreScrubberReportData preScrubberReportData;
        this.inputFile = fileName + ".sort";
        this.validFile = this.batchFileDirectoryName + File.separator + "ld_scrbout1.data";
        this.errorFile = this.batchFileDirectoryName + File.separator + "ld_scrberr1.data";
        this.expiredFile = this.batchFileDirectoryName + File.separator + "ld_expaccts.data";
        String prescrubOutput = this.batchFileDirectoryName + File.separator + "ld_prescrub.data";
        LineIterator inputEntries = null;
        try {
            inputEntries = FileUtils.lineIterator((File)new File(fileName));
            preScrubberReportData = this.laborPreScrubberService.preprocessOriginEntries((Iterator)inputEntries, prescrubOutput);
        }
        catch (IOException e1) {
            try {
                LOG.error("Error encountered trying to prescrub GLCP/LLCP document", (Throwable)e1);
                throw new RuntimeException("Error encountered trying to prescrub GLCP/LLCP document", e1);
            }
            catch (Throwable throwable) {
                LineIterator.closeQuietly(inputEntries);
                throw throwable;
            }
        }
        LineIterator.closeQuietly((LineIterator)inputEntries);
        if (preScrubberReportData != null) {
            this.laborPreScrubberReportWriterService.setDocumentNumber(documentNumber);
            ((WrappingBatchService)this.laborPreScrubberReportWriterService).initialize();
            try {
                new PreScrubberReport().generateReport(preScrubberReportData, (ReportWriterService)this.laborPreScrubberReportWriterService);
            }
            finally {
                ((WrappingBatchService)this.laborPreScrubberReportWriterService).destroy();
            }
        }
        BatchSortUtil.sortTextFileWithFields((String)prescrubOutput, (String)this.inputFile, (Comparator)new LaborScrubberSortComparator());
        this.scrubEntries(true, documentNumber);
        File deleteSortFile = new File(this.inputFile);
        File deleteValidFile = new File(this.validFile);
        File deleteErrorFile = new File(this.errorFile);
        File deleteExpiredFile = new File(this.expiredFile);
        try {
            deleteSortFile.delete();
            deleteValidFile.delete();
            deleteErrorFile.delete();
            deleteExpiredFile.delete();
        }
        catch (Exception e) {
            LOG.error("scrubGroupReportOnly delete output files process Stopped: " + e.getMessage());
            throw new RuntimeException("scrubGroupReportOnly delete output files process Stopped: " + e.getMessage(), e);
        }
    }

    public void scrubEntries() {
        this.inputFile = this.batchFileDirectoryName + File.separator + "ld_sortscrb.data";
        this.validFile = this.batchFileDirectoryName + File.separator + "ld_scrbout1.data";
        this.errorFile = this.batchFileDirectoryName + File.separator + "ld_scrberr1.data";
        this.expiredFile = this.batchFileDirectoryName + File.separator + "ld_expaccts.data";
        this.scrubEntries(false, null);
    }

    public void scrubEntries(boolean reportOnlyMode, String documentNumber) {
        LOG.debug("scrubEntries() started");
        if (reportOnlyMode) {
            this.laborMainReportWriterService.setDocumentNumber(documentNumber);
            this.laborLedgerReportWriterService.setDocumentNumber(documentNumber);
            this.laborGeneratedTransactionsReportWriterService.setDocumentNumber(documentNumber);
        }
        this.runDate = this.calculateRunDate(this.dateTimeService.getCurrentDate());
        this.runCal = Calendar.getInstance();
        this.runCal.setTime(this.runDate);
        this.universityRunDate = this.laborAccountingCycleCachingService.getUniversityDate(this.runDate);
        if (this.universityRunDate == null) {
            throw new IllegalStateException(this.kualiConfigurationService.getPropertyValueAsString("error.gl.UniversityDateNotFound"));
        }
        this.setOffsetString();
        this.setDescriptions();
        try {
            ((WrappingBatchService)this.laborMainReportWriterService).initialize();
            ((WrappingBatchService)this.laborLedgerReportWriterService).initialize();
            if (reportOnlyMode) {
                ((WrappingBatchService)this.laborGeneratedTransactionsReportWriterService).initialize();
            }
            this.scrubberReport = new ScrubberReportData();
            this.processGroup();
            if (reportOnlyMode) {
                this.generateScrubberTransactionsOnline();
            } else {
                this.generateScrubberBadBalanceTypeListingReport();
            }
        }
        finally {
            ((WrappingBatchService)this.laborMainReportWriterService).destroy();
            ((WrappingBatchService)this.laborLedgerReportWriterService).destroy();
            if (reportOnlyMode) {
                ((WrappingBatchService)this.laborGeneratedTransactionsReportWriterService).destroy();
            }
        }
    }

    protected String getTransactionType(LaborOriginEntry transaction) {
        if ("CE".equals(transaction.getFinancialBalanceTypeCode())) {
            return "CE";
        }
        String desc = transaction.getTransactionLedgerEntryDescription();
        if (desc == null) {
            return "X";
        }
        if (desc.startsWith(this.offsetDescription) && desc.contains("***")) {
            return "CS";
        }
        if (desc.startsWith(this.costShareDescription) && desc.contains("***")) {
            return "CS";
        }
        if (desc.startsWith(this.offsetDescription)) {
            return "O";
        }
        if (desc.startsWith(this.capitalizationDescription)) {
            return "C";
        }
        if (desc.startsWith(this.liabilityDescription)) {
            return "L";
        }
        if (desc.startsWith(this.transferDescription)) {
            return "T";
        }
        return "X";
    }

    protected void processGroup() {
        PrintStream OUTPUT_EXP_FILE_ps;
        PrintStream OUTPUT_ERR_FILE_ps;
        PrintStream OUTPUT_GLE_FILE_ps;
        FileReader INPUT_GLE_FILE;
        this.scrubCostShareAmount = KualiDecimal.ZERO;
        this.scrubberProcessUnitOfWork = new ScrubberProcessUnitOfWork();
        try {
            INPUT_GLE_FILE = new FileReader(this.inputFile, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find input file: " + this.inputFile, e);
        }
        try {
            OUTPUT_GLE_FILE_ps = new PrintStream(this.validFile);
            OUTPUT_ERR_FILE_ps = new PrintStream(this.errorFile);
            OUTPUT_EXP_FILE_ps = new PrintStream(this.expiredFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Problem opening output files", e);
        }
        BufferedReader INPUT_GLE_FILE_br = new BufferedReader(INPUT_GLE_FILE);
        LOG.debug("Starting Scrubber Process process group...");
        int lineNumber = 0;
        int loadedCount = 0;
        LedgerSummaryReport laborLedgerSummaryReport = new LedgerSummaryReport();
        LaborOriginEntry unscrubbedEntry = new LaborOriginEntry();
        try {
            String currentLine = INPUT_GLE_FILE_br.readLine();
            while (currentLine != null) {
                LaborOriginEntry scrubbedEntry = new LaborOriginEntry();
                try {
                    ++lineNumber;
                    if (!StringUtils.isEmpty((CharSequence)currentLine) && !StringUtils.isBlank((CharSequence)currentLine.trim())) {
                        unscrubbedEntry = new LaborOriginEntry();
                        List<Message> tmperrors = unscrubbedEntry.setFromTextFileForBatch(currentLine, lineNumber);
                        ++loadedCount;
                        this.scrubberReport.incrementUnscrubbedRecordsRead();
                        ArrayList<Message> transactionErrors = new ArrayList<Message>();
                        unscrubbedEntry.setGroup(null);
                        unscrubbedEntry.setVersionNumber(null);
                        unscrubbedEntry.setEntryId(null);
                        boolean saveErrorTransaction = false;
                        boolean saveValidTransaction = false;
                        this.buildScrubbedEntry(unscrubbedEntry, scrubbedEntry);
                        laborLedgerSummaryReport.summarizeEntry((OriginEntryInformation)unscrubbedEntry);
                        try {
                            tmperrors.addAll(this.scrubberValidator.validateTransaction((OriginEntryInformation)unscrubbedEntry, (OriginEntryInformation)scrubbedEntry, this.universityRunDate, true, (AccountingCycleCachingService)this.laborAccountingCycleCachingService));
                        }
                        catch (Exception e) {
                            transactionErrors.add(new Message(e.toString() + " occurred for this record.", 1));
                            saveValidTransaction = false;
                        }
                        transactionErrors.addAll(tmperrors);
                        Account unscrubbedEntryAccount = this.laborAccountingCycleCachingService.getAccount(unscrubbedEntry.getChartOfAccountsCode(), unscrubbedEntry.getAccountNumber());
                        if (ObjectUtils.isNotNull((Object)unscrubbedEntry.getAccount()) && (this.scrubberValidator.isAccountExpired(unscrubbedEntryAccount, this.universityRunDate) || unscrubbedEntryAccount.isClosed())) {
                            LaborOriginEntry expiredEntry = new LaborOriginEntry(scrubbedEntry);
                            this.createOutputEntry(expiredEntry, OUTPUT_EXP_FILE_ps);
                            this.scrubberReport.incrementExpiredAccountFound();
                        }
                        if (!this.isFatal(transactionErrors)) {
                            saveValidTransaction = true;
                            if (!this.scrubberProcessUnitOfWork.isSameUnitOfWork((OriginEntryInformation)scrubbedEntry)) {
                                this.scrubberProcessUnitOfWork = new ScrubberProcessUnitOfWork((OriginEntryInformation)scrubbedEntry);
                            }
                            KualiDecimal transactionAmount = scrubbedEntry.getTransactionLedgerEntryAmount();
                            ParameterEvaluator offsetFiscalPeriods = this.parameterEvaluatorService.getParameterEvaluator(ScrubberStep.class, "OFFSET_GENERATION_FISCAL_PERIODS", scrubbedEntry.getUniversityFiscalPeriodCode());
                            BalanceType scrubbedEntryBalanceType = this.laborAccountingCycleCachingService.getBalanceType(scrubbedEntry.getFinancialBalanceTypeCode());
                            if (scrubbedEntryBalanceType.isFinancialOffsetGenerationIndicator() && offsetFiscalPeriods.evaluationSucceeds()) {
                                if (scrubbedEntry.isDebit()) {
                                    this.scrubberProcessUnitOfWork.setOffsetAmount((KualiDecimal)this.scrubberProcessUnitOfWork.getOffsetAmount().add((AbstractKualiDecimal)transactionAmount));
                                } else {
                                    this.scrubberProcessUnitOfWork.setOffsetAmount((KualiDecimal)this.scrubberProcessUnitOfWork.getOffsetAmount().subtract((AbstractKualiDecimal)transactionAmount));
                                }
                            }
                            String subAccountTypeCode = "  ";
                            A21SubAccount scrubbedEntryA21SubAccount = this.laborAccountingCycleCachingService.getA21SubAccount(scrubbedEntry.getChartOfAccountsCode(), scrubbedEntry.getAccountNumber(), scrubbedEntry.getSubAccountNumber());
                            if (ObjectUtils.isNotNull((Object)scrubbedEntryA21SubAccount)) {
                                subAccountTypeCode = scrubbedEntryA21SubAccount.getSubAccountTypeCode();
                            }
                            if (transactionErrors.size() > 0) {
                                this.laborMainReportWriterService.writeError((BusinessObject)unscrubbedEntry, transactionErrors);
                            }
                        } else {
                            saveErrorTransaction = true;
                            this.laborMainReportWriterService.writeError((BusinessObject)unscrubbedEntry, transactionErrors);
                        }
                        if (saveValidTransaction) {
                            scrubbedEntry.setTransactionScrubberOffsetGenerationIndicator(false);
                            this.createOutputEntry(scrubbedEntry, OUTPUT_GLE_FILE_ps);
                            this.scrubberReport.incrementScrubbedRecordWritten();
                        }
                        if (saveErrorTransaction) {
                            LaborOriginEntry errorEntry = new LaborOriginEntry(unscrubbedEntry);
                            errorEntry.setTransactionScrubberOffsetGenerationIndicator(false);
                            this.createOutputEntry(currentLine, OUTPUT_ERR_FILE_ps);
                            this.scrubberReport.incrementErrorRecordWritten();
                        }
                    }
                    currentLine = INPUT_GLE_FILE_br.readLine();
                }
                catch (IOException ioe) {
                    LOG.error("processGroup() stopped due to: " + ioe.getMessage() + " on line number : " + loadedCount, (Throwable)ioe);
                    throw new RuntimeException("processGroup() stopped due to: " + ioe.getMessage() + " on line number : " + loadedCount, ioe);
                }
            }
            INPUT_GLE_FILE_br.close();
            INPUT_GLE_FILE.close();
            OUTPUT_GLE_FILE_ps.close();
            OUTPUT_ERR_FILE_ps.close();
            OUTPUT_EXP_FILE_ps.close();
            this.laborMainReportWriterService.writeStatisticLine("UNSCRUBBED RECORDS READ              %,9d", new Object[]{this.scrubberReport.getNumberOfUnscrubbedRecordsRead()});
            this.laborMainReportWriterService.writeStatisticLine("SCRUBBED RECORDS WRITTEN             %,9d", new Object[]{this.scrubberReport.getNumberOfScrubbedRecordsWritten()});
            this.laborMainReportWriterService.writeStatisticLine("ERROR RECORDS WRITTEN                %,9d", new Object[]{this.scrubberReport.getNumberOfErrorRecordsWritten()});
            this.laborMainReportWriterService.writeStatisticLine("TOTAL OUTPUT RECORDS WRITTEN         %,9d", new Object[]{this.scrubberReport.getTotalNumberOfRecordsWritten()});
            this.laborMainReportWriterService.writeStatisticLine("EXPIRED ACCOUNTS FOUND               %,9d", new Object[]{this.scrubberReport.getNumberOfExpiredAccountsFound()});
            laborLedgerSummaryReport.writeReport((ReportWriterService)this.laborLedgerReportWriterService);
        }
        catch (IOException ioe) {
            LOG.error("processGroup() stopped due to: " + ioe.getMessage(), (Throwable)ioe);
            throw new RuntimeException("processGroup() stopped due to: " + ioe.getMessage(), ioe);
        }
    }

    protected boolean isFatal(List<Message> errors) {
        for (Message element : errors) {
            if (element.getType() != 1) continue;
            return true;
        }
        return false;
    }

    protected void setDescriptions() {
        this.offsetDescription = this.kualiConfigurationService.getPropertyValueAsString("message.gl.GeneratedOffset");
        this.capitalizationDescription = this.kualiConfigurationService.getPropertyValueAsString("message.gl.GeneratedCapitalization");
        this.liabilityDescription = this.kualiConfigurationService.getPropertyValueAsString("message.gl.GeneratedLiability");
        this.costShareDescription = this.kualiConfigurationService.getPropertyValueAsString("message.gl.GeneratedCostShareDescription");
        this.transferDescription = this.kualiConfigurationService.getPropertyValueAsString("message.gl.GeneratedTransfer");
    }

    protected void setOffsetString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(0);
        nf.setMaximumIntegerDigits(2);
        nf.setMinimumFractionDigits(0);
        nf.setMinimumIntegerDigits(2);
        this.offsetString = "***" + nf.format(this.runCal.get(2) + 1) + nf.format(this.runCal.get(5));
    }

    protected String getOffsetMessage() {
        String msg = this.offsetDescription + SPACES;
        return msg.substring(0, 33) + this.offsetString;
    }

    protected void setCutoffTimeForPreviousDay(int hourOfDay, int minuteOfDay, int secondOfDay) {
        this.cutoffHour = hourOfDay;
        this.cutoffMinute = minuteOfDay;
        this.cutoffSecond = secondOfDay;
        LOG.info("Setting cutoff time to hour: " + hourOfDay + ", minute: " + minuteOfDay + ", second: " + secondOfDay);
    }

    protected void setCutoffTime(String cutoffTime) {
        if (StringUtils.isBlank((CharSequence)cutoffTime)) {
            LOG.debug("Cutoff time is blank");
            this.unsetCutoffTimeForPreviousDay();
        } else {
            cutoffTime = cutoffTime.trim();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cutoff time value found: " + cutoffTime);
            }
            StringTokenizer st = new StringTokenizer(cutoffTime, ":", false);
            try {
                String hourStr = st.nextToken();
                String minuteStr = st.nextToken();
                String secondStr = st.nextToken();
                int hourInt = Integer.parseInt(hourStr, 10);
                int minuteInt = Integer.parseInt(minuteStr, 10);
                int secondInt = Integer.parseInt(secondStr, 10);
                if (hourInt < 0 || hourInt > 23 || minuteInt < 0 || minuteInt > 59 || secondInt < 0 || secondInt > 59) {
                    throw new IllegalArgumentException("Cutoff time must be in the format \"HH:mm:ss\", where HH, mm, ss are defined in the java.text.SimpleDateFormat class.  In particular, 0 <= hour <= 23, 0 <= minute <= 59, and 0 <= second <= 59");
                }
                this.setCutoffTimeForPreviousDay(hourInt, minuteInt, secondInt);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cutoff time should either be null, or in the format \"HH:mm:ss\", where HH, mm, ss are defined in the java.text.SimpleDateFormat class.", e);
            }
        }
    }

    public void unsetCutoffTimeForPreviousDay() {
        this.cutoffHour = null;
        this.cutoffMinute = null;
        this.cutoffSecond = null;
    }

    public Date calculateRunDate(java.util.Date currentDate) {
        Calendar currentCal = Calendar.getInstance();
        currentCal.setTime(currentDate);
        if (this.isCurrentDateBeforeCutoff(currentCal)) {
            currentCal.add(5, -1);
            currentCal.set(11, 23);
            currentCal.set(12, 59);
            currentCal.set(13, 59);
            currentCal.set(14, 0);
            return new Date(currentCal.getTimeInMillis());
        }
        return new Date(currentDate.getTime());
    }

    protected boolean isCurrentDateBeforeCutoff(Calendar currentCal) {
        if (this.cutoffHour != null && this.cutoffMinute != null && this.cutoffSecond != null) {
            Calendar cutoffTime = (Calendar)currentCal.clone();
            cutoffTime.setLenient(false);
            cutoffTime.set(11, this.cutoffHour);
            cutoffTime.set(12, this.cutoffMinute);
            cutoffTime.set(13, this.cutoffSecond);
            cutoffTime.set(14, 0);
            return currentCal.before(cutoffTime);
        }
        return false;
    }

    protected void initCutoffTime() {
        String cutoffTime = this.parameterService.getParameterValueAsString(ScrubberStep.class, "CUTOFF_TIME");
        if (StringUtils.isBlank((CharSequence)cutoffTime)) {
            LOG.debug("Cutoff time system parameter not found");
            this.unsetCutoffTimeForPreviousDay();
            return;
        }
        this.setCutoffTime(cutoffTime);
    }

    protected void buildScrubbedEntry(LaborOriginEntry unscrubbedEntry, LaborOriginEntry scrubbedEntry) {
        scrubbedEntry.setDocumentNumber(unscrubbedEntry.getDocumentNumber());
        scrubbedEntry.setOrganizationDocumentNumber(unscrubbedEntry.getOrganizationDocumentNumber());
        scrubbedEntry.setOrganizationReferenceId(unscrubbedEntry.getOrganizationReferenceId());
        scrubbedEntry.setReferenceFinancialDocumentNumber(unscrubbedEntry.getReferenceFinancialDocumentNumber());
        Integer transactionNumber = unscrubbedEntry.getTransactionLedgerEntrySequenceNumber();
        scrubbedEntry.setTransactionLedgerEntrySequenceNumber(null == transactionNumber ? Integer.valueOf(0) : transactionNumber);
        scrubbedEntry.setTransactionLedgerEntryDescription(unscrubbedEntry.getTransactionLedgerEntryDescription());
        scrubbedEntry.setTransactionLedgerEntryAmount(unscrubbedEntry.getTransactionLedgerEntryAmount());
        scrubbedEntry.setTransactionDebitCreditCode(unscrubbedEntry.getTransactionDebitCreditCode());
        scrubbedEntry.setPositionNumber(unscrubbedEntry.getPositionNumber());
        scrubbedEntry.setTransactionPostingDate(unscrubbedEntry.getTransactionPostingDate());
        scrubbedEntry.setPayPeriodEndDate(unscrubbedEntry.getPayPeriodEndDate());
        scrubbedEntry.setTransactionTotalHours(unscrubbedEntry.getTransactionTotalHours());
        scrubbedEntry.setPayrollEndDateFiscalYear(unscrubbedEntry.getPayrollEndDateFiscalYear());
        scrubbedEntry.setPayrollEndDateFiscalPeriodCode(unscrubbedEntry.getPayrollEndDateFiscalPeriodCode());
        scrubbedEntry.setFinancialDocumentApprovedCode(unscrubbedEntry.getFinancialDocumentApprovedCode());
        scrubbedEntry.setTransactionEntryOffsetCode(unscrubbedEntry.getTransactionEntryOffsetCode());
        scrubbedEntry.setTransactionEntryProcessedTimestamp(unscrubbedEntry.getTransactionEntryProcessedTimestamp());
        scrubbedEntry.setEmplid(unscrubbedEntry.getEmplid());
        scrubbedEntry.setEmployeeRecord(unscrubbedEntry.getEmployeeRecord());
        scrubbedEntry.setEarnCode(unscrubbedEntry.getEarnCode());
        scrubbedEntry.setPayGroup(unscrubbedEntry.getPayGroup());
        scrubbedEntry.setSalaryAdministrationPlan(unscrubbedEntry.getSalaryAdministrationPlan());
        scrubbedEntry.setGrade(unscrubbedEntry.getGrade());
        scrubbedEntry.setRunIdentifier(unscrubbedEntry.getRunIdentifier());
        scrubbedEntry.setLaborLedgerOriginalChartOfAccountsCode(unscrubbedEntry.getLaborLedgerOriginalChartOfAccountsCode());
        scrubbedEntry.setLaborLedgerOriginalAccountNumber(unscrubbedEntry.getLaborLedgerOriginalAccountNumber());
        scrubbedEntry.setLaborLedgerOriginalSubAccountNumber(unscrubbedEntry.getLaborLedgerOriginalSubAccountNumber());
        scrubbedEntry.setLaborLedgerOriginalFinancialObjectCode(unscrubbedEntry.getLaborLedgerOriginalFinancialObjectCode());
        scrubbedEntry.setLaborLedgerOriginalFinancialSubObjectCode(unscrubbedEntry.getLaborLedgerOriginalFinancialSubObjectCode());
        scrubbedEntry.setHrmsCompany(unscrubbedEntry.getHrmsCompany());
        scrubbedEntry.setSetid(unscrubbedEntry.getSetid());
        scrubbedEntry.setTransactionDateTimeStamp(unscrubbedEntry.getTransactionDateTimeStamp());
        scrubbedEntry.setReferenceFinancialDocumentTypeCode(unscrubbedEntry.getReferenceFinancialDocumentTypeCode());
        scrubbedEntry.setReferenceFinancialSystemOrigination(unscrubbedEntry.getReferenceFinancialSystemOrigination());
        scrubbedEntry.setPayrollEndDateFiscalPeriod(unscrubbedEntry.getPayrollEndDateFiscalPeriod());
    }

    public void performDemerger() {
        PrintStream OUTPUT_DEMERGER_ERR_FILE_ps;
        PrintStream OUTPUT_DEMERGER_GLE_FILE_ps;
        FileReader INPUT_ERR_FILE;
        FileReader INPUT_GLE_FILE;
        LOG.debug("performDemerger() started");
        LaborOriginEntryFieldUtil loefu = new LaborOriginEntryFieldUtil();
        Map pMap = loefu.getFieldBeginningPositionMap();
        String validOutputFilename = this.batchFileDirectoryName + File.separator + "ld_scrbout1.data";
        String errorOutputFilename = this.batchFileDirectoryName + File.separator + "ld_sorterr1.data";
        this.runDate = this.calculateRunDate(this.dateTimeService.getCurrentDate());
        DemergerReportData demergerReport = new DemergerReportData();
        OriginEntryStatistics eOes = this.laborOriginEntryService.getStatistics(errorOutputFilename);
        demergerReport.setErrorTransactionsRead(eOes.getRowCount().intValue());
        Collection demergeDocumentTypes = this.parameterService.getParameterValuesAsString(LaborScrubberStep.class, "DEMERGE_DOCUMENT_TYPES");
        String demergerValidOutputFilename = this.batchFileDirectoryName + File.separator + "ld_scrbout2.data";
        String demergerErrorOutputFilename = this.batchFileDirectoryName + File.separator + "ld_scrberr2.data";
        try {
            INPUT_GLE_FILE = new FileReader(validOutputFilename, StandardCharsets.UTF_8);
            INPUT_ERR_FILE = new FileReader(errorOutputFilename, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open input files", e);
        }
        try {
            OUTPUT_DEMERGER_GLE_FILE_ps = new PrintStream(demergerValidOutputFilename);
            OUTPUT_DEMERGER_ERR_FILE_ps = new PrintStream(demergerErrorOutputFilename);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to open output files", e);
        }
        int validRead = 0;
        int errorRead = 0;
        int validSaved = 0;
        int errorSaved = 0;
        BufferedReader INPUT_GLE_FILE_br = new BufferedReader(INPUT_GLE_FILE);
        BufferedReader INPUT_ERR_FILE_br = new BufferedReader(INPUT_ERR_FILE);
        try {
            String currentValidLine = INPUT_GLE_FILE_br.readLine();
            String currentErrorLine = INPUT_ERR_FILE_br.readLine();
            while (currentValidLine != null || currentErrorLine != null) {
                if (StringUtils.isEmpty((CharSequence)currentValidLine)) {
                    this.createOutputEntry(currentErrorLine, OUTPUT_DEMERGER_ERR_FILE_ps);
                    currentErrorLine = INPUT_ERR_FILE_br.readLine();
                    ++errorRead;
                    ++errorSaved;
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)currentErrorLine)) {
                    this.createOutputEntry(currentValidLine, OUTPUT_DEMERGER_GLE_FILE_ps);
                    currentValidLine = INPUT_GLE_FILE_br.readLine();
                    ++validRead;
                    ++validSaved;
                    continue;
                }
                String documentTypeCode = currentErrorLine.substring((Integer)pMap.get("financialDocumentTypeCode"), (Integer)pMap.get("financialSystemOriginationCode"));
                if (documentTypeCode != null) {
                    documentTypeCode = documentTypeCode.trim();
                }
                if (demergeDocumentTypes.contains(documentTypeCode)) {
                    String compareStringFromErrorEntry;
                    String compareStringFromValidEntry = currentValidLine.substring((Integer)pMap.get("financialDocumentTypeCode"), (Integer)pMap.get("transactionLedgerEntrySequenceNumber"));
                    if (compareStringFromValidEntry.compareTo(compareStringFromErrorEntry = currentErrorLine.substring((Integer)pMap.get("financialDocumentTypeCode"), (Integer)pMap.get("transactionLedgerEntrySequenceNumber"))) < 0) {
                        this.createOutputEntry(currentValidLine, OUTPUT_DEMERGER_GLE_FILE_ps);
                        currentValidLine = INPUT_GLE_FILE_br.readLine();
                        ++validRead;
                        ++validSaved;
                        continue;
                    }
                    if (compareStringFromValidEntry.compareTo(compareStringFromErrorEntry) > 0) {
                        this.createOutputEntry(currentErrorLine, OUTPUT_DEMERGER_ERR_FILE_ps);
                        currentErrorLine = INPUT_ERR_FILE_br.readLine();
                        ++errorRead;
                        ++errorSaved;
                        continue;
                    }
                    this.createOutputEntry(currentValidLine, OUTPUT_DEMERGER_ERR_FILE_ps);
                    currentValidLine = INPUT_GLE_FILE_br.readLine();
                    ++validRead;
                    ++errorSaved;
                    continue;
                }
                this.createOutputEntry(currentErrorLine, OUTPUT_DEMERGER_ERR_FILE_ps);
                currentErrorLine = INPUT_ERR_FILE_br.readLine();
                ++errorRead;
                ++errorSaved;
            }
        }
        catch (Exception e) {
            LOG.error("performDemerger() stopped due to: " + e.getMessage(), (Throwable)e);
            throw new RuntimeException("performDemerger() stopped due to: " + e.getMessage(), e);
        }
        finally {
            try {
                if (INPUT_GLE_FILE_br != null) {
                    INPUT_GLE_FILE_br.close();
                }
            }
            catch (IOException e) {
                LOG.error("performDemerger() sFailed to close resources due to: " + e.getMessage(), (Throwable)e);
            }
            try {
                if (INPUT_ERR_FILE_br != null) {
                    INPUT_ERR_FILE_br.close();
                }
            }
            catch (IOException e) {
                LOG.error("performDemerger() sFailed to close resources due to: " + e.getMessage(), (Throwable)e);
            }
            OUTPUT_DEMERGER_GLE_FILE_ps.close();
            OUTPUT_DEMERGER_ERR_FILE_ps.close();
        }
        demergerReport.setValidTransactionsRead(validRead);
        demergerReport.setValidTransactionsSaved(validSaved);
        demergerReport.setErrorTransactionsRead(errorRead);
        demergerReport.setErrorTransactionWritten(errorSaved);
        this.laborDemergerReportWriterService.writeStatisticLine("SCRUBBER ERROR TRANSACTIONS READ       %,9d", new Object[]{demergerReport.getErrorTransactionsRead()});
        this.laborDemergerReportWriterService.writeStatisticLine("SCRUBBER VALID TRANSACTIONS READ       %,9d", new Object[]{demergerReport.getValidTransactionsRead()});
        this.laborDemergerReportWriterService.writeStatisticLine("DEMERGER ERRORS SAVED                  %,9d", new Object[]{demergerReport.getErrorTransactionsSaved()});
        this.laborDemergerReportWriterService.writeStatisticLine("DEMERGER VALID TRANSACTIONS SAVED      %,9d", new Object[]{demergerReport.getValidTransactionsSaved()});
        this.generateScrubberErrorListingReport(demergerErrorOutputFilename);
    }

    protected void createOutputEntry(LaborOriginEntry entry, PrintStream ps) throws IOException {
        try {
            ps.printf("%s\n", entry.getLine());
        }
        catch (Exception e) {
            throw new IOException(e.toString(), e);
        }
    }

    protected void createOutputEntry(String line, PrintStream ps) throws IOException {
        try {
            ps.printf("%s\n", line);
        }
        catch (Exception e) {
            throw new IOException(e.toString(), e);
        }
    }

    protected boolean checkEntry(LaborOriginEntry validEntry, LaborOriginEntry errorEntry, String documentTypeCode) {
        String documentNumber = errorEntry.getDocumentNumber();
        String originationCode = errorEntry.getFinancialSystemOriginationCode();
        return validEntry.getDocumentNumber().equals(documentNumber) && validEntry.getFinancialDocumentTypeCode().equals(documentTypeCode) && validEntry.getFinancialSystemOriginationCode().equals(originationCode);
    }

    protected void generateScrubberTransactionsOnline() {
        try {
            LaborOriginEntryFileIterator generatedTransactions = new LaborOriginEntryFileIterator(new File(this.inputFile));
            ((WrappingBatchService)this.laborGeneratedTransactionsReportWriterService).initialize();
            new TransactionListingReport().generateReport((ReportWriterService)this.laborGeneratedTransactionsReportWriterService, (Iterator)generatedTransactions);
        }
        finally {
            ((WrappingBatchService)this.laborGeneratedTransactionsReportWriterService).destroy();
        }
    }

    protected void generateScrubberBadBalanceTypeListingReport() {
        FilteringLaborOriginEntryFileIterator.LaborOriginEntryFilter blankBalanceTypeFilter = originEntry -> {
            BalanceType originEntryBalanceType = this.laborAccountingCycleCachingService.getBalanceType(originEntry.getFinancialBalanceTypeCode());
            return ObjectUtils.isNull((Object)originEntryBalanceType);
        };
        try {
            ((WrappingBatchService)this.laborBadBalanceTypeReportWriterService).initialize();
            FilteringLaborOriginEntryFileIterator blankBalanceOriginEntries = new FilteringLaborOriginEntryFileIterator(new File(this.inputFile), blankBalanceTypeFilter);
            new TransactionListingReport().generateReport(this.laborBadBalanceTypeReportWriterService, (Iterator)blankBalanceOriginEntries);
        }
        finally {
            ((WrappingBatchService)this.laborBadBalanceTypeReportWriterService).destroy();
        }
    }

    protected void generateScrubberErrorListingReport(String errorFileName) {
        try {
            ((WrappingBatchService)this.laborErrorListingReportWriterService).initialize();
            LaborOriginEntryFileIterator removedTransactions = new LaborOriginEntryFileIterator(new File(errorFileName));
            new TransactionListingReport().generateReport(this.laborErrorListingReportWriterService, (Iterator)removedTransactions);
        }
        finally {
            ((WrappingBatchService)this.laborErrorListingReportWriterService).destroy();
        }
    }

    static enum GROUP_TYPE {
        VALID,
        ERROR,
        EXPIRED;

    }
}

