/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.OriginEntryInformation;
import org.kuali.kfs.gl.report.PosterOutputSummaryReport;
import org.kuali.kfs.module.ld.batch.LaborYearEndBalanceForwardStep;
import org.kuali.kfs.module.ld.batch.service.LaborYearEndBalanceForwardService;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.businessobject.LedgerBalanceForYearEndBalanceForward;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.util.DebitCreditUtil;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.ReportWriterService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborYearEndBalanceForwardServiceImpl
implements LaborYearEndBalanceForwardService {
    private static final Logger LOG = LogManager.getLogger();
    private LaborLedgerBalanceService laborLedgerBalanceService;
    private OptionsService optionsService;
    private DateTimeService dateTimeService;
    private ParameterService parameterService;
    private String batchFileDirectoryName;
    private ReportWriterService laborBalanceForwardReportWriterService;
    private ConfigurationService configurationService;
    protected static String PROCESSED_BALANCE_TYPES_LABEL = "PROCESSED BALANCE TYPES";
    protected static String PROCESSED_OBJECT_TYPES_LABEL = "PROCESSED OBJECT TYPES";

    @Override
    public void forwardBalance() {
        Integer fiscalYear = Integer.valueOf(this.parameterService.getParameterValueAsString(LaborYearEndBalanceForwardStep.class, "FISCAL_YEAR_SELECTION"));
        this.forwardBalance(fiscalYear);
    }

    @Override
    public void forwardBalance(Integer fiscalYear) {
        this.forwardBalance(fiscalYear, fiscalYear + 1);
    }

    @Override
    public void forwardBalance(Integer fiscalYear, Integer newFiscalYear) {
        PrintStream balanceForwardsPs;
        SystemOptions options = this.optionsService.getOptions(fiscalYear);
        Date runDate = this.dateTimeService.getCurrentSqlDate();
        Map<String, Integer> reportSummary = this.constructReportSummary();
        PosterOutputSummaryReport posterOutputSummaryReport = new PosterOutputSummaryReport();
        List<String> processableBalanceTypeCodes = this.getProcessableBalanceTypeCode(options);
        List<String> processableObjectTypeCodes = this.getProcessableObjectTypeCodes(options);
        Collection<String> subFundGroupCodes = this.getSubFundGroupProcessed();
        Collection<String> fundGroupCodes = this.getFundGroupProcessed();
        String balanceForwardsFileName = this.batchFileDirectoryName + File.separator + "ld_balance_forwards.data";
        File balanceForwardsFile = new File(balanceForwardsFileName);
        try {
            balanceForwardsPs = new PrintStream(balanceForwardsFile, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("balanceForwardsFile Files doesn't exist " + balanceForwardsFileName);
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        for (String balanceTypeCode : processableBalanceTypeCodes) {
            fieldValues.put("financialBalanceTypeCode", balanceTypeCode);
            for (String objectTypeCode : processableObjectTypeCodes) {
                fieldValues.put("financialObjectTypeCode", objectTypeCode);
                fieldValues.remove("chartOfAccountsCode");
                fieldValues.remove("accountNumber");
                Iterator<LedgerBalanceForYearEndBalanceForward> balanceIterator = this.laborLedgerBalanceService.findBalancesForFiscalYear(fiscalYear, fieldValues, subFundGroupCodes, fundGroupCodes);
                this.postSelectedBalancesAsOriginEntries(balanceIterator, newFiscalYear, balanceForwardsPs, runDate, posterOutputSummaryReport, reportSummary);
            }
        }
        this.fillStatisticsReportWriter(reportSummary);
        this.fillParametersReportWriter(runDate, fiscalYear, fundGroupCodes, subFundGroupCodes, this.getOriginationCode(), processableBalanceTypeCodes, processableObjectTypeCodes, this.getDocumentTypeCode());
        posterOutputSummaryReport.writeReport(this.laborBalanceForwardReportWriterService);
        balanceForwardsPs.close();
        this.createDoneFile(balanceForwardsFileName);
    }

    protected void createDoneFile(String originEntryFileName) {
        String doneFileName = originEntryFileName.replace(".data", ".done");
        File doneFile = new File(doneFileName);
        if (!doneFile.exists()) {
            try {
                doneFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
    }

    protected int postSelectedBalancesAsOriginEntries(Iterator<LedgerBalanceForYearEndBalanceForward> balanceIterator, Integer newFiscalYear, PrintStream balanceForwardsPs, Date runDate, PosterOutputSummaryReport posterOutputSummaryReport, Map<String, Integer> reportSummary) {
        int numberOfSelectedBalance = 0;
        String description = this.getDescription();
        String originationCode = this.getOriginationCode();
        String documentTypeCode = this.getDocumentTypeCode();
        while (balanceIterator != null && balanceIterator.hasNext()) {
            LedgerBalanceForYearEndBalanceForward balance = balanceIterator.next();
            this.updateReportSummary(reportSummary, "LD_LDGR_BAL_T", "read");
            List errors = null;
            boolean isValidBalance = this.validateBalance(balance, errors);
            LaborOriginEntry laborOriginEntry = new LaborOriginEntry();
            if (isValidBalance) {
                laborOriginEntry.setUniversityFiscalYear(newFiscalYear);
                laborOriginEntry.setFinancialDocumentTypeCode(documentTypeCode);
                laborOriginEntry.setFinancialSystemOriginationCode(originationCode);
                laborOriginEntry.setTransactionLedgerEntryDescription(description);
                this.postAsOriginEntry(balance, laborOriginEntry, balanceForwardsPs, runDate);
                ++numberOfSelectedBalance;
                posterOutputSummaryReport.summarize((OriginEntryInformation)laborOriginEntry);
                this.updateReportSummary(reportSummary, "LD_LDGR_BAL_T", "select");
                this.updateReportSummary(reportSummary, "LD_LDGR_BAL_T", "insert");
                continue;
            }
            if (errors == null || errors.isEmpty()) continue;
            ObjectUtil.buildObject((Object)laborOriginEntry, (Object)((Object)balance));
            this.laborBalanceForwardReportWriterService.writeError((BusinessObject)laborOriginEntry, errors);
            this.updateReportSummary(reportSummary, "LD_LDGR_BAL_T", "with error");
        }
        return numberOfSelectedBalance;
    }

    protected boolean validateBalance(LedgerBalanceForYearEndBalanceForward balance, List<Message> errors) {
        return true;
    }

    protected void postAsOriginEntry(LedgerBalanceForYearEndBalanceForward balance, LaborOriginEntry originEntry, PrintStream balanceForwardsPs, Date postingDate) {
        try {
            originEntry.setAccountNumber(balance.getAccountNumber());
            originEntry.setChartOfAccountsCode(balance.getChartOfAccountsCode());
            originEntry.setSubAccountNumber(balance.getSubAccountNumber());
            originEntry.setFinancialObjectCode(balance.getFinancialObjectCode());
            originEntry.setFinancialSubObjectCode(balance.getFinancialSubObjectCode());
            originEntry.setFinancialBalanceTypeCode(balance.getFinancialBalanceTypeCode());
            originEntry.setFinancialObjectTypeCode(balance.getFinancialObjectTypeCode());
            originEntry.setPositionNumber(balance.getPositionNumber());
            originEntry.setEmplid(balance.getEmplid());
            originEntry.setDocumentNumber(balance.getFinancialBalanceTypeCode() + balance.getAccountNumber());
            originEntry.setProjectCode(KFSConstants.getDashProjectCode());
            originEntry.setUniversityFiscalPeriodCode("CB");
            KualiDecimal transactionAmount = balance.getAccountLineAnnualBalanceAmount();
            transactionAmount = (KualiDecimal)transactionAmount.add((AbstractKualiDecimal)balance.getContractsGrantsBeginningBalanceAmount());
            originEntry.setTransactionLedgerEntryAmount((KualiDecimal)transactionAmount.abs());
            originEntry.setTransactionDebitCreditCode(DebitCreditUtil.getDebitCreditCode(transactionAmount, false));
            originEntry.setTransactionLedgerEntrySequenceNumber(null);
            originEntry.setTransactionTotalHours(BigDecimal.ZERO);
            originEntry.setTransactionDate(postingDate);
            try {
                balanceForwardsPs.printf("%s\n", originEntry.getLine());
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    protected Collection<String> getFundGroupProcessed() {
        return this.parameterService.getParameterValuesAsString(LaborYearEndBalanceForwardStep.class, "FUND_GROUPS");
    }

    protected Collection<String> getSubFundGroupProcessed() {
        return this.parameterService.getParameterValuesAsString(LaborYearEndBalanceForwardStep.class, "SUB_FUND_GROUPS");
    }

    protected List<String> getProcessableBalanceTypeCode(SystemOptions options) {
        ArrayList<String> processableBalanceTypeCodes = new ArrayList<String>();
        processableBalanceTypeCodes.add(options.getActualFinancialBalanceTypeCd());
        return processableBalanceTypeCodes;
    }

    protected List<String> getProcessableObjectTypeCodes(SystemOptions options) {
        ArrayList<String> processableObjectTypeCodes = new ArrayList<String>();
        processableObjectTypeCodes.add(options.getFinObjTypeExpenditureexpCd());
        processableObjectTypeCodes.add(options.getFinObjTypeExpNotExpendCode());
        return processableObjectTypeCodes;
    }

    protected Map<String, Integer> constructReportSummary() {
        HashMap<String, Integer> reportSummary = new HashMap<String, Integer>();
        reportSummary.put("LD_LDGR_BAL_T,read", 0);
        reportSummary.put("LD_LDGR_BAL_T,select", 0);
        reportSummary.put("LD_LDGR_BAL_T,with error", 0);
        reportSummary.put("LD_LBR_ORIGIN_ENTRY_T,insert", 0);
        return reportSummary;
    }

    protected void fillStatisticsReportWriter(Map<String, Integer> glEntryReportSummary) {
        this.laborBalanceForwardReportWriterService.writeStatisticLine("NUMBER OF RECORDS READ              %,9d", new Object[]{glEntryReportSummary.get("LD_LDGR_BAL_T,read")});
        this.laborBalanceForwardReportWriterService.writeStatisticLine("NUMBER OF RECORDS SELECTED          %,9d", new Object[]{glEntryReportSummary.get("LD_LDGR_BAL_T,select")});
        this.laborBalanceForwardReportWriterService.writeStatisticLine("NUMBER OF RECORDS IN ERROR          %,9d", new Object[]{glEntryReportSummary.get("LD_LDGR_BAL_T,with error")});
        this.laborBalanceForwardReportWriterService.writeStatisticLine("NUMBER OF RECORDS INSERTED          %,9d", new Object[]{glEntryReportSummary.get("LD_LBR_ORIGIN_ENTRY_T,insert")});
    }

    protected void fillParametersReportWriter(Date runDate, Integer closingYear, Collection<String> processedFundGroups, Collection<String> processedSubFundGroups, String originationCode, Collection<String> processedBalanceTypeCodes, Collection<String> processedObjectTypeCodes, String documentTypeCode) {
        this.laborBalanceForwardReportWriterService.writeParameterLine("%32s %10s", new Object[]{"ANNUAL_CLOSING_TRANSACTION_DATE", runDate.toString()});
        this.laborBalanceForwardReportWriterService.writeParameterLine("%32s %10s", new Object[]{"FISCAL_YEAR_SELECTION", closingYear});
        this.laborBalanceForwardReportWriterService.writeParameterLine("%32s %10s", new Object[]{"FUND_GROUPS", StringUtils.join(processedFundGroups, (String)", ")});
        this.laborBalanceForwardReportWriterService.writeParameterLine("%32s %10s", new Object[]{"SUB_FUND_GROUPS", StringUtils.join(processedSubFundGroups, (String)", ")});
        this.laborBalanceForwardReportWriterService.writeParameterLine("%32s %10s", new Object[]{"ORIGINATION", originationCode});
        this.laborBalanceForwardReportWriterService.writeParameterLine("%32s %10s", new Object[]{PROCESSED_BALANCE_TYPES_LABEL, StringUtils.join(processedBalanceTypeCodes, (String)", ")});
        this.laborBalanceForwardReportWriterService.writeParameterLine("%32s %10s", new Object[]{PROCESSED_OBJECT_TYPES_LABEL, StringUtils.join(processedObjectTypeCodes, (String)", ")});
        this.laborBalanceForwardReportWriterService.writeParameterLine("%32s %10s", new Object[]{"ANNUAL_CLOSING_DOCUMENT_TYPE", documentTypeCode});
        this.laborBalanceForwardReportWriterService.pageBreak();
    }

    protected void updateReportSummary(Map<String, Integer> reportSummary, String destination, String operation) {
        String key = destination + "," + operation;
        if (reportSummary.containsKey(key)) {
            Integer count = reportSummary.get(key);
            reportSummary.put(key, count + 1);
        } else {
            reportSummary.put(key, 1);
        }
    }

    protected String getDocumentTypeCode() {
        return this.parameterService.getParameterValueAsString(KfsParameterConstants.GENERAL_LEDGER_BATCH.class, "ANNUAL_CLOSING_DOCUMENT_TYPE");
    }

    protected String getOriginationCode() {
        return this.parameterService.getParameterValueAsString(LaborYearEndBalanceForwardStep.class, "ORIGINATION");
    }

    protected String getDescription() {
        return this.configurationService.getPropertyValueAsString("message.labor.yearEndTransactionDescription");
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setLaborLedgerBalanceService(LaborLedgerBalanceService laborLedgerBalanceService) {
        this.laborLedgerBalanceService = laborLedgerBalanceService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }

    public void setLaborBalanceForwardReportWriterService(ReportWriterService laborBalanceForwardReportWriterService) {
        this.laborBalanceForwardReportWriterService = laborBalanceForwardReportWriterService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }
}

