/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.inquiry;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.kuali.kfs.integration.ld.businessobject.inquiry.AbstractPositionDataDetailsInquirableImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.PositionData;
import org.kuali.rice.krad.bo.BusinessObject;

public class PositionDataDetailsInquirableImpl
extends AbstractPositionDataDetailsInquirableImpl {
    protected String getPositionNumberKeyValue() {
        return LaborConstants.getDashPositionNumber();
    }

    protected String getFinancialBalanceTypeCodeKeyValue() {
        return "AC&A2";
    }

    protected String getEffectiveDateKey() {
        return "effectiveDate";
    }

    protected Class getInquiryBusinessObjectClass(String attributeName) {
        return PositionData.class;
    }

    public BusinessObject getBusinessObject(Map fieldValues) {
        ArrayList positionList = new ArrayList(this.getLookupService().findCollectionBySearch(PositionData.class, fieldValues));
        Date today = Calendar.getInstance().getTime();
        java.sql.Date maxEffectiveDate = null;
        PositionData lookupValue = null;
        for (PositionData position : positionList) {
            java.sql.Date effectiveDate = position.getEffectiveDate();
            if (effectiveDate.compareTo(today) > 0 || maxEffectiveDate != null && effectiveDate.compareTo(maxEffectiveDate) <= 0) continue;
            maxEffectiveDate = effectiveDate;
            lookupValue = position;
        }
        return lookupValue;
    }

    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
        HtmlData.AnchorHtmlData htmlData = (HtmlData.AnchorHtmlData)super.getInquiryUrl(businessObject, attributeName);
        htmlData.setHref(htmlData.getHref().replaceAll("kr/", ""));
        return htmlData;
    }
}

