/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.fp.document.JournalVoucherDocument;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.module.ld.LaborConstants;
import org.kuali.kfs.module.ld.businessobject.LaborJournalVoucherAccountingLineParser;
import org.kuali.kfs.module.ld.businessobject.LaborJournalVoucherDetail;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.document.LaborLedgerPostingDocument;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.AccountingLineParser;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.AmountTotaling;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.HomeOriginationService;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeContract;
import org.kuali.rice.kew.doctype.bo.DocumentTypeEBO;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class LaborJournalVoucherDocument
extends JournalVoucherDocument
implements LaborLedgerPostingDocument,
AmountTotaling {
    private static final Logger LOG = LogManager.getLogger();
    protected String offsetTypeCode;
    protected List<LaborLedgerPendingEntry> laborLedgerPendingEntries;
    protected DocumentTypeEBO financialSystemDocumentTypeCode;

    public LaborJournalVoucherDocument() {
        this.offsetTypeCode = LaborConstants.JournalVoucherOffsetType.NO_OFFSET.typeCode;
        this.setLaborLedgerPendingEntries(new ArrayList<LaborLedgerPendingEntry>());
    }

    public Class getSourceAccountingLineClass() {
        return LaborJournalVoucherDetail.class;
    }

    @Override
    public LaborLedgerPendingEntry getLaborLedgerPendingEntry(int index) {
        while (this.laborLedgerPendingEntries.size() <= index) {
            this.laborLedgerPendingEntries.add(new LaborLedgerPendingEntry());
        }
        return this.laborLedgerPendingEntries.get(index);
    }

    public String getOffsetTypeCode() {
        return this.offsetTypeCode;
    }

    public void setOffsetTypeCode(String offsetTypeCode) {
        this.offsetTypeCode = offsetTypeCode;
    }

    @Override
    public List<LaborLedgerPendingEntry> getLaborLedgerPendingEntries() {
        return this.laborLedgerPendingEntries;
    }

    @Override
    public void setLaborLedgerPendingEntries(List<LaborLedgerPendingEntry> laborLedgerPendingEntries) {
        this.laborLedgerPendingEntries = laborLedgerPendingEntries;
    }

    public DocumentTypeEBO getFinancialSystemDocumentTypeCode() {
        if (this.financialSystemDocumentTypeCode == null || !StringUtils.equals((CharSequence)this.financialSystemDocumentTypeCode.getName(), (CharSequence)this.documentHeader.getWorkflowDocument().getDocumentTypeName())) {
            DocumentType docType;
            this.financialSystemDocumentTypeCode = null;
            if (StringUtils.isNotBlank((CharSequence)this.documentHeader.getWorkflowDocument().getDocumentTypeName()) && (docType = KewApiServiceLocator.getDocumentTypeService().getDocumentTypeByName(this.documentHeader.getWorkflowDocument().getDocumentTypeName())) != null) {
                this.financialSystemDocumentTypeCode = org.kuali.rice.kew.doctype.bo.DocumentType.from((DocumentTypeContract)docType);
            }
        }
        return this.financialSystemDocumentTypeCode;
    }

    public AccountingLineParser getAccountingLineParser() {
        return new LaborJournalVoucherAccountingLineParser(this.getBalanceTypeCode());
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.getDocumentHeader().getWorkflowDocument().isProcessed()) {
            this.changeLedgerPendingEntriesApprovedStatusCode();
        } else if (this.getDocumentHeader().getWorkflowDocument().isCanceled() || this.getDocumentHeader().getWorkflowDocument().isDisapproved()) {
            this.removeLedgerPendingEntries();
        }
    }

    protected void changeLedgerPendingEntriesApprovedStatusCode() {
        for (LaborLedgerPendingEntry pendingEntry : this.laborLedgerPendingEntries) {
            pendingEntry.setFinancialDocumentApprovedCode("A");
        }
    }

    protected void removeLedgerPendingEntries() {
        LaborLedgerPendingEntryService laborLedgerPendingEntryService = (LaborLedgerPendingEntryService)SpringContext.getBean(LaborLedgerPendingEntryService.class);
        laborLedgerPendingEntryService.delete(this.getDocumentHeader().getDocumentNumber());
    }

    @Override
    public boolean generateLaborLedgerBenefitClearingPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    @Override
    public boolean generateLaborLedgerPendingEntries(AccountingLine accountingLine, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LOG.debug("processGenerateLaborLedgerPendingEntries() started");
        try {
            LaborLedgerPendingEntry pendingLedgerEntry = new LaborLedgerPendingEntry();
            ObjectUtil.buildObject((Object)pendingLedgerEntry, (Object)accountingLine);
            GeneralLedgerPendingEntryService pendingEntryService = (GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class);
            pendingEntryService.populateExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySource)this, (GeneralLedgerPendingEntrySourceDetail)accountingLine, sequenceHelper, (GeneralLedgerPendingEntry)pendingLedgerEntry);
            this.customizeExplicitGeneralLedgerPendingEntry((GeneralLedgerPendingEntrySourceDetail)accountingLine, pendingLedgerEntry);
            pendingLedgerEntry.setFinancialDocumentTypeCode(this.getOffsetTypeCode());
            if (StringUtils.isBlank((CharSequence)((LaborJournalVoucherDetail)accountingLine).getEmplid())) {
                pendingLedgerEntry.setEmplid(LaborConstants.getDashEmplId());
            }
            if (StringUtils.isBlank((CharSequence)((LaborJournalVoucherDetail)accountingLine).getPositionNumber())) {
                pendingLedgerEntry.setPositionNumber(LaborConstants.getDashPositionNumber());
            }
            String originationCode = ((HomeOriginationService)SpringContext.getBean(HomeOriginationService.class)).getHomeOrigination().getFinSystemHomeOriginationCode();
            pendingLedgerEntry.setFinancialSystemOriginationCode(originationCode);
            pendingLedgerEntry.setTransactionLedgerEntrySequenceNumber(sequenceHelper.getSequenceCounter());
            pendingLedgerEntry.refreshReferenceObject("financialObject");
            this.getLaborLedgerPendingEntries().add(pendingLedgerEntry);
            sequenceHelper.increment();
        }
        catch (Exception e) {
            LOG.error("Cannot add a Labor Ledger Pending Entry into the list");
            return false;
        }
        return true;
    }

    public void prepareForSave() {
        if (!((LaborLedgerPendingEntryService)SpringContext.getBean(LaborLedgerPendingEntryService.class)).generateLaborLedgerPendingEntries(this)) {
            this.logErrors();
            throw new ValidationException("labor ledger LLPE generation failed");
        }
        super.prepareForSave();
    }

    public void prepareForSave(KualiDocumentEvent event) {
        this.prepareForSave();
        super.prepareForSave(event);
    }

    public boolean generateGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySourceDetail glpeSourceDetail, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        return true;
    }

    public boolean isDebit(GeneralLedgerPendingEntrySourceDetail postable) {
        return true;
    }

    @Override
    public List getLaborLedgerPendingEntriesForSearching() {
        return this.getLaborLedgerPendingEntries();
    }
}

