/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.HashMap;
import java.util.List;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.search.SearchOperator;

public class SalaryExpenseTransferPendingLegerEntryValidation
extends GenericValidation {
    private Document documentForValidation;
    private LaborLedgerPendingEntryService laborLedgerPendingEntryService;

    public boolean validate(AttributedDocumentEvent event) {
        Document documentForValidation = this.getDocumentForValidation();
        AccountingDocument accountingDocument = (AccountingDocument)documentForValidation;
        return !this.hasPendingLedgerEntry(accountingDocument);
    }

    protected boolean hasPendingLedgerEntry(AccountingDocument accountingDocument) {
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)accountingDocument;
        List sourceAccountingLines = expenseTransferDocument.getSourceAccountingLines();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        for (ExpenseTransferAccountingLine sourceAccountingLine : sourceAccountingLines) {
            String payPeriodCode = sourceAccountingLine.getPayrollEndDateFiscalPeriodCode();
            String accountNumber = sourceAccountingLine.getAccountNumber();
            String objectCode = sourceAccountingLine.getFinancialObjectCode();
            String emplId = sourceAccountingLine.getEmplid();
            String documentNumber = accountingDocument.getDocumentNumber();
            fieldValues.put("payrollEndDateFiscalPeriodCode", payPeriodCode);
            fieldValues.put("accountNumber", accountNumber);
            fieldValues.put("financialObjectCode", objectCode);
            fieldValues.put("emplid", emplId);
            fieldValues.put("documentNumber", SearchOperator.NOT.op() + documentNumber);
            if (!this.laborLedgerPendingEntryService.hasPendingLaborLedgerEntry(fieldValues)) continue;
            GlobalVariables.getMessageMap().putError("document.employeeLookups", "error.labor.alreadyPendingSalaryTransferError", new String[]{emplId, payPeriodCode, accountNumber, objectCode});
            return true;
        }
        return false;
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }

    public void setLaborLedgerPendingEntryService(LaborLedgerPendingEntryService laborLedgerPendingEntryService) {
        this.laborLedgerPendingEntryService = laborLedgerPendingEntryService;
    }
}

