/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.Entry;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborLedgerExpenseTransferAccountingLine;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.integration.ld.LaborLedgerPositionObjectBenefit;
import org.kuali.kfs.integration.ld.LaborLedgerPositionObjectGroup;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.SessionDocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.LedgerEntry;
import org.kuali.kfs.module.ld.businessobject.LedgerEntryGLSummary;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.service.LaborBenefitsCalculationService;
import org.kuali.kfs.module.ld.service.LaborLedgerBalanceService;
import org.kuali.kfs.module.ld.service.LaborLedgerEntryService;
import org.kuali.kfs.module.ld.service.LaborLedgerPendingEntryService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.AccountingLineOverride;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborModuleServiceImpl
implements LaborModuleService {
    private static final Logger LOG = LogManager.getLogger();
    private static final String GL_LABOR_ENTRY_SUMMARIZATION_INQUIRY_BASE_URL = "laborGLLaborEntrySummarizationInquiry.do";
    private static final String GL_LABOR_ENTRY_SUMMARIZATION_INQUIRY_METHOD = "viewResults";
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private KualiModuleService kualiModuleService;
    private LaborBenefitsCalculationService laborBenefitsCalculationService;
    private LaborLedgerBalanceService laborLedgerBalanceService;
    private LaborLedgerEntryService laborLedgerEntryService;
    private LaborLedgerPendingEntryService laborLedgerPendingEntryService;
    private ParameterService parameterService;
    private SessionDocumentService sessionDocumentService;
    private WorkflowDocumentService workflowDocumentService;

    public KualiDecimal calculateFringeBenefit(Integer fiscalYear, String chartCode, String objectCode, KualiDecimal salaryAmount, String accountNumber, String subAccountNumber) {
        return this.laborBenefitsCalculationService.calculateFringeBenefit(fiscalYear, chartCode, objectCode, salaryAmount, accountNumber, subAccountNumber);
    }

    public void createAndBlankApproveSalaryExpenseTransferDocument(String documentDescription, String explanation, String annotation, List<String> adHocRecipients, List<LaborLedgerExpenseTransferAccountingLine> sourceAccountingLines, List<LaborLedgerExpenseTransferAccountingLine> targetAccountingLines) throws WorkflowException {
        String organizationDocumentNumber;
        LOG.debug("createSalaryExpenseTransferDocument() start");
        if (sourceAccountingLines == null || sourceAccountingLines.isEmpty()) {
            LOG.info("Cannot create a salary expense document when the given source accounting line is empty.");
            return;
        }
        if (targetAccountingLines == null || targetAccountingLines.isEmpty()) {
            LOG.info("Cannot create a salary expense document when the given target accounting line is empty.");
            return;
        }
        SalaryExpenseTransferDocument document = (SalaryExpenseTransferDocument)this.documentService.getNewDocument(SalaryExpenseTransferDocument.class);
        document.setEmplid(sourceAccountingLines.get(0).getEmplid());
        document.setSourceAccountingLines(sourceAccountingLines);
        document.setTargetAccountingLines(targetAccountingLines);
        DocumentHeader documentHeader = document.getDocumentHeader();
        documentHeader.setDocumentDescription(documentDescription);
        documentHeader.setExplanation(explanation);
        document.prepareForSave((KualiDocumentEvent)new SaveDocumentEvent((Document)document));
        document.populateDocumentForRouting();
        String documentTitle = document.getDocumentTitle();
        if (StringUtils.isNotBlank((CharSequence)documentTitle)) {
            document.getDocumentHeader().getWorkflowDocument().setTitle(documentTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)(organizationDocumentNumber = document.getDocumentHeader().getOrganizationDocumentNumber()))) {
            document.getDocumentHeader().getWorkflowDocument().setApplicationDocumentId(organizationDocumentNumber);
        }
        this.businessObjectService.save((PersistableBusinessObject)document);
        ArrayList<AdHocRouteRecipient> adHocRecipientList = new ArrayList<AdHocRouteRecipient>();
        for (String adHocRouteRecipient : adHocRecipients) {
            adHocRecipientList.add(this.buildApprovePersonRecipient(adHocRouteRecipient));
        }
        this.workflowDocumentService.blanketApprove(document.getDocumentHeader().getWorkflowDocument(), annotation, adHocRecipientList);
        this.sessionDocumentService.addDocumentToUserSession(GlobalVariables.getUserSession(), document.getDocumentHeader().getWorkflowDocument());
    }

    protected AdHocRouteRecipient buildApprovePersonRecipient(String userId) {
        AdHocRoutePerson adHocRouteRecipient = new AdHocRoutePerson();
        adHocRouteRecipient.setActionRequested("A");
        adHocRouteRecipient.setId(userId);
        return adHocRouteRecipient;
    }

    public int countPendingSalaryExpenseTransfer(String emplid) {
        HashMap<String, String> positiveFieldValues = new HashMap<String, String>();
        positiveFieldValues.put("emplid", emplid);
        positiveFieldValues.put("financialDocumentTypeCode", "ST");
        List<String> approvedCodes = Arrays.asList("A", "X");
        HashMap<String, List<String>> negativeFieldValues = new HashMap<String, List<String>>();
        negativeFieldValues.put("financialDocumentApprovedCode", approvedCodes);
        return this.businessObjectService.countMatching(LaborLedgerPendingEntry.class, positiveFieldValues, negativeFieldValues);
    }

    public List<String> findEmployeesWithPayType(Map<Integer, Set<String>> payPeriods, List<String> balanceTypes, Map<String, Set<String>> earnCodePayGroupMap) {
        return this.laborLedgerEntryService.findEmployeesWithPayType(payPeriods, balanceTypes, earnCodePayGroupMap);
    }

    public boolean isEmployeeWithPayType(String emplid, Map<Integer, Set<String>> payPeriods, List<String> balanceTypes, Map<String, Set<String>> earnCodePayGroupMap) {
        return this.laborLedgerEntryService.isEmployeeWithPayType(emplid, payPeriods, balanceTypes, earnCodePayGroupMap);
    }

    public Collection<LaborLedgerBalance> findLedgerBalances(Map<String, Collection<String>> fieldValues, Map<String, Collection<String>> excludedFieldValues, Set<Integer> fiscalYears, List<String> balanceTypes, List<String> positionObjectGroupCodes) {
        HashMap<String, List<String>> excludedFieldValueList = new HashMap<String, List<String>>();
        for (Map.Entry<String, Collection<String>> entry : excludedFieldValues.entrySet()) {
            ArrayList<String> arrayList = new ArrayList<String>(entry.getValue());
            Collections.sort(arrayList);
            excludedFieldValueList.put(entry.getKey(), arrayList);
        }
        HashMap<String, List<String>> fieldValueList = new HashMap<String, List<String>>();
        for (Map.Entry<String, Collection<String>> entry : fieldValues.entrySet()) {
            ArrayList<String> list = new ArrayList<String>(entry.getValue());
            Collections.sort(list);
            fieldValueList.put(entry.getKey(), list);
        }
        Collection<LedgerBalance> collection = this.laborLedgerBalanceService.findLedgerBalances(fieldValueList, excludedFieldValueList, fiscalYears, balanceTypes, positionObjectGroupCodes);
        return new ArrayList<LaborLedgerBalance>(collection);
    }

    public LaborLedgerPositionObjectGroup getLaborLedgerPositionObjectGroup(String positionObjectGroupCode) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("positionObjectGroupCode", positionObjectGroupCode);
        return (LaborLedgerPositionObjectGroup)this.kualiModuleService.getResponsibleModuleService(LaborLedgerPositionObjectGroup.class).getExternalizableBusinessObject(LaborLedgerPositionObjectGroup.class, primaryKeys);
    }

    public LaborLedgerObject retrieveLaborLedgerObject(Integer fiscalYear, String chartOfAccountsCode, String objectCode) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", fiscalYear);
        searchCriteria.put("chartOfAccountsCode", chartOfAccountsCode);
        searchCriteria.put("financialObjectCode", objectCode);
        return (LaborLedgerObject)this.kualiModuleService.getResponsibleModuleService(LaborLedgerObject.class).getExternalizableBusinessObject(LaborLedgerObject.class, searchCriteria);
    }

    public LaborLedgerObject retrieveLaborLedgerObject(ObjectCode financialObject) {
        if (financialObject == null) {
            throw new IllegalArgumentException("The given financial object cannot be null.");
        }
        Integer fiscalYear = financialObject.getUniversityFiscalYear();
        String chartOfAccountsCode = financialObject.getChartOfAccountsCode();
        String financialObjectCode = financialObject.getFinancialObjectCode();
        return this.retrieveLaborLedgerObject(fiscalYear, chartOfAccountsCode, financialObjectCode);
    }

    public boolean hasPendingLaborLedgerEntry(String chartOfAccountsCode, String accountNumber) {
        return this.laborLedgerPendingEntryService.hasPendingLaborLedgerEntry(chartOfAccountsCode, accountNumber);
    }

    public List<LaborLedgerPositionObjectBenefit> retrieveActiveLaborPositionObjectBenefits(Integer fiscalYear, String chartOfAccountsCode, String objectCode) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", fiscalYear);
        searchCriteria.put("chartOfAccountsCode", chartOfAccountsCode);
        searchCriteria.put("financialObjectCode", objectCode);
        searchCriteria.put("active", "Y");
        return this.kualiModuleService.getResponsibleModuleService(LaborLedgerPositionObjectBenefit.class).getExternalizableBusinessObjectsList(LaborLedgerPositionObjectBenefit.class, searchCriteria);
    }

    public boolean hasFringeBenefitProducingObjectCodes(Integer fiscalYear, String chartOfAccountsCode, String financialObjectCode) {
        List<LaborLedgerPositionObjectBenefit> objectBenefits = this.retrieveActiveLaborPositionObjectBenefits(fiscalYear, chartOfAccountsCode, financialObjectCode);
        return objectBenefits != null && !objectBenefits.isEmpty();
    }

    public List<LaborLedgerPositionObjectBenefit> retrieveLaborPositionObjectBenefits(Integer fiscalYear, String chartOfAccountsCode, String objectCode) {
        HashMap<String, Object> searchCriteria = new HashMap<String, Object>();
        searchCriteria.put("universityFiscalYear", fiscalYear);
        searchCriteria.put("chartOfAccountsCode", chartOfAccountsCode);
        searchCriteria.put("financialObjectCode", objectCode);
        return this.kualiModuleService.getResponsibleModuleService(LaborLedgerPositionObjectBenefit.class).getExternalizableBusinessObjectsList(LaborLedgerPositionObjectBenefit.class, searchCriteria);
    }

    public Collection<String> getLaborLedgerGLOriginCodes() {
        return this.parameterService.getParameterValuesAsString(LedgerEntry.class, "LINK_DOCUMENT_NUMBER_TO_LABOR_ORIGIN_CODES");
    }

    public HtmlData getInquiryUrlForGeneralLedgerEntryDocumentNumber(Entry entry) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("methodToCall", GL_LABOR_ENTRY_SUMMARIZATION_INQUIRY_METHOD);
        params.put("universityFiscalYear", entry.getUniversityFiscalYear().toString());
        params.put("universityFiscalPeriodCode", entry.getUniversityFiscalPeriodCode());
        params.put("chartOfAccountsCode", entry.getChartOfAccountsCode());
        params.put("accountNumber", entry.getAccountNumber());
        params.put("subAccountNumber", entry.getSubAccountNumber());
        params.put("financialObjectCode", entry.getFinancialObjectCode());
        params.put("financialSubObjectCode", entry.getFinancialSubObjectCode());
        params.put("financialBalanceTypeCode", entry.getFinancialBalanceTypeCode());
        params.put("financialObjectTypeCode", entry.getFinancialObjectTypeCode());
        params.put("financialDocumentTypeCode", entry.getFinancialDocumentTypeCode());
        params.put("financialSystemOriginationCode", entry.getFinancialSystemOriginationCode());
        params.put("documentNumber", entry.getDocumentNumber());
        params.put("businessObjectClassName", LedgerEntryGLSummary.class.getName());
        return new HtmlData.AnchorHtmlData(UrlFactory.parameterizeUrl((String)GL_LABOR_ENTRY_SUMMARIZATION_INQUIRY_BASE_URL, params), entry.getDocumentNumber());
    }

    public String getBenefitRateCategoryCode(String chartOfAccountsCode, String accountNumber, String subAccountNumber) {
        return this.laborBenefitsCalculationService.getBenefitRateCategoryCode(chartOfAccountsCode, accountNumber, subAccountNumber);
    }

    public String getCostSharingSourceAccountNumber() {
        return this.laborBenefitsCalculationService.getCostSharingSourceAccountNumber();
    }

    public String getCostSharingSourceSubAccountNumber() {
        return this.laborBenefitsCalculationService.getCostSharingSourceSubAccountNumber();
    }

    public String getCostSharingSourceChartOfAccountsCode() {
        return this.laborBenefitsCalculationService.getCostSharingSourceAccountChartOfAccountsCode();
    }

    public AccountingLineOverride determineNeededOverrides(AccountingDocument document, AccountingLine line) {
        boolean isDocumentFinalOrProcessed = false;
        if (ObjectUtils.isNotNull((Object)document)) {
            AccountingDocument accountingDocument = document;
            isDocumentFinalOrProcessed = accountingDocument.isDocumentFinalOrProcessed();
        }
        HashSet<Integer> neededOverrideComponents = new HashSet<Integer>();
        if (AccountingLineOverride.needsExpiredAccountOverride((AccountingLine)line, (boolean)isDocumentFinalOrProcessed)) {
            neededOverrideComponents.add(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT);
        }
        if (AccountingLineOverride.needsObjectBudgetOverride((Account)line.getAccount(), (ObjectCode)line.getObjectCode())) {
            neededOverrideComponents.add(AccountingLineOverride.COMPONENT.NON_BUDGETED_OBJECT);
        }
        if (AccountingLineOverride.needsNonFringAccountOverride((Account)line.getAccount())) {
            neededOverrideComponents.add(AccountingLineOverride.COMPONENT.NON_FRINGE_ACCOUNT_USED);
        }
        Integer[] inputComponentArray = neededOverrideComponents.toArray(new Integer[neededOverrideComponents.size()]);
        return AccountingLineOverride.valueOf((Integer[])inputComponentArray);
    }

    @Deprecated
    public AccountingLineOverride determineNeededOverrides(AccountingLine line) {
        HashSet<Integer> neededOverrideComponents = new HashSet<Integer>();
        if (AccountingLineOverride.needsExpiredAccountOverride((Account)line.getAccount())) {
            neededOverrideComponents.add(AccountingLineOverride.COMPONENT.EXPIRED_ACCOUNT);
        }
        if (AccountingLineOverride.needsObjectBudgetOverride((Account)line.getAccount(), (ObjectCode)line.getObjectCode())) {
            neededOverrideComponents.add(AccountingLineOverride.COMPONENT.NON_BUDGETED_OBJECT);
        }
        if (AccountingLineOverride.needsNonFringAccountOverride((Account)line.getAccount())) {
            neededOverrideComponents.add(AccountingLineOverride.COMPONENT.NON_FRINGE_ACCOUNT_USED);
        }
        Integer[] inputComponentArray = neededOverrideComponents.toArray(new Integer[neededOverrideComponents.size()]);
        return AccountingLineOverride.valueOf((Integer[])inputComponentArray);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setLaborBenefitsCalculationService(LaborBenefitsCalculationService laborBenefitsCalculationService) {
        this.laborBenefitsCalculationService = laborBenefitsCalculationService;
    }

    public void setLaborLedgerBalanceService(LaborLedgerBalanceService laborLedgerBalanceService) {
        this.laborLedgerBalanceService = laborLedgerBalanceService;
    }

    public void setLaborLedgerEntryService(LaborLedgerEntryService laborLedgerEntryService) {
        this.laborLedgerEntryService = laborLedgerEntryService;
    }

    public void setLaborLedgerPendingEntryService(LaborLedgerPendingEntryService laborLedgerPendingEntryService) {
        this.laborLedgerPendingEntryService = laborLedgerPendingEntryService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setSessionDocumentService(SessionDocumentService sessionDocumentService) {
        this.sessionDocumentService = sessionDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }
}

