/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld;

public final class LaborParameterConstants {

    public static final String ACCOUNT_FRINGE_EXCLUSION = "ACCOUNTS_NOT_ACCEPTING_FRINGES_IND";
    public static final String BALANCE_TYPES_NOT_PROCESSED = "SENT_TO_GL_BALANCE_TYPES";
    public static final String BENEFIT_CLEARING_ACCOUNT = "BENEFIT_CLEARING_ACCOUNT_NUMBER";
    public static final String BENEFIT_CLEARING_CHART = "BENEFIT_CLEARING_CHART_OF_ACCOUNTS";
    public static final String CONTINUATION_ACCOUNT_BYPASS_DOCUMENT_TYPE_CODES =
            "CONTINUATION_ACCOUNT_BYPASS_DOCUMENT_TYPES";
    public static final String CONTINUATION_ACCOUNT_BYPASS_ORIGINATION_CODES =
            "CONTINUATION_ACCOUNT_BYPASS_ORIGINATIONS";
    public static final String CONTINUATION_ACCOUNT_LOGIC = "CONTINUATION_ACCOUNT_LOGIC_IND";
    public static final String COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES =
            "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND";
    public static final String DEFAULT_NUMBER_OF_FISCAL_PERIODS_LATE_ADJUSTMENT_TAB_REQUIRED =
            "DEFAULT_NUMBER_OF_FISCAL_PERIODS_LATE_ADJUSTMENT_TAB_REQUIRED";
    public static final String DEMERGE_DOCUMENT_TYPES = "DEMERGE_DOCUMENT_TYPES";
    public static final String FUND_GROUP_PROCESSED = "FUND_GROUPS";
    public static final String GENERATE_FRINGE_BENEFIT_ENCUMBRANCE =
            "GENERATE_FRINGE_BENEFIT_ENCUMBRANCE_IND";
    public static final String GENERATE_FRINGE_BENEFIT = "GENERATE_FRINGE_BENEFIT_IND";
    public static final String LABOR_BENEFIT_CALCULATION_OFFSET_IND = "LABOR_BENEFIT_CALCULATION_OFFSET_IND";
    public static final String LABOR_BENEFIT_OFFSET_DOCTYPE = "LABOR_BENEFIT_OFFSET_DOCTYPE";
    public static final String LABOR_BENEFIT_OFFSET_ORIGIN_CODE = "LABOR_BENEFIT_OFFSET_ORIGIN_CODE";
    public static final String LINK_DOCUMENT_NUMBER_TO_LABOR_ORIGIN_CODES =
            "LINK_DOCUMENT_NUMBER_TO_LABOR_ORIGIN_CODES";
    public static final String MAX_NUMBER_OF_ERRORS_ALLOWED = "MAX_NUMBER_OF_ERRORS_ALLOWED";
    public static final String NON_FRINGE_ACCOUNT_BYPASS_ORIGINATIONS = "NON_FRINGE_ACCOUNT_BYPASS_ORIGINATIONS";
    public static final String NON_WAGE_SUB_FUND_BYPASS_ORIGINATIONS = "NON_WAGE_SUB_FUND_BYPASS_ORIGINATIONS";
    public static final String NUMBER_OF_COMPARISON_FAILURES_TO_PRINT_PER_REPORT =
            "NUMBER_OF_COMPARISON_FAILURES_TO_PRINT_PER_REPORT";
    public static final String NUMBER_OF_PAST_FISCAL_YEARS_TO_INCLUDE = "NUMBER_OF_PAST_FISCAL_YEARS_TO_INCLUDE";
    public static final String OLD_FISCAL_YEAR = "FISCAL_YEAR_SELECTION";
    public static final String ORIGINATION_CODE = "ORIGINATION";
    public static final String PERIOD_CODES_NOT_PROCESSED = "SENT_TO_GL_PERIOD_CODES";
    public static final String PURGE_LEDGER_BALANCE_YEAR = "PRIOR_TO_YEAR";
    public static final String PURGE_LEDGER_ENTRY_YEAR = "PRIOR_TO_YEAR";
    public static final String SUB_FUND_GROUP_PROCESSED = "SUB_FUND_GROUPS";
    public static final String SUBFUND_WAGE_EXCLUSION = "SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND";
    public static final String SUSPENSE_ACCOUNT = "SUSPENSE_ACCOUNT";
    public static final String SUSPENSE_ACCOUNT_LOGIC = "SUSPENSE_ACCOUNT_LOGIC_IND";
    public static final String SUSPENSE_CHART = "SUSPENSE_CHART";
    public static final String SUSPENSE_SUB_ACCOUNT = "SUSPENSE_SUB_ACCOUNT";
    public static final String VALIDATE_AGAINST_EFFORT = "VALIDATE_AGAINST_EFFORT_CERTIFICATION_IND";

    /**
     * Private Constructor since this is a constants class that should never be instantiated.
     */
    private LaborParameterConstants() {
    }
}
