/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.document.authorization;

import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemTransactionalDocument;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentPresentationControllerBase;
import org.kuali.kfs.kew.api.WorkflowDocument;

import java.util.Set;

/**
 * Document Presentation Controller for the Effort Certification document. allowsErrorCorrection property has been
 * set to false in data dictionary entry setHasAmountTotal property has been set to true in data dictionary entry
 */
public class LaborExpensesDocumentPresentationController extends
        FinancialSystemTransactionalDocumentPresentationControllerBase {

    public static final String LEDGER_BALANCE_IMPORTING = "ledgerBalanceImporting";
    public static final String ACCOUNTS_CAN_CROSS_CHART = "AccountsCanCrossChart";

    @Override
    public boolean canCopy(Document document) {
        return false;
    }

    @Override
    public boolean canErrorCorrect(FinancialSystemTransactionalDocument document) {
        return false;
    }

    @Override
    public Set<String> getEditModes(Document document) {
        Set<String> editModes = super.getEditModes(document);

        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isInitiated() || workflowDocument.isSaved() || workflowDocument.isCompletionRequested()) {
            editModes.add(LEDGER_BALANCE_IMPORTING);
        }
        AccountService accountService = SpringContext.getBean(AccountService.class);
        if (accountService.accountsCanCrossCharts()) {
            editModes.add(ACCOUNTS_CAN_CROSS_CHART);
        }
        return editModes;
    }
}
