/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.integration.ld.LaborLedgerExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.validation.impl.SalaryExpenseTransferDuplicateAccountingLineValidation;
import org.kuali.kfs.sys.document.AccountingDocument;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class SalaryExpenseTransferDuplicateAccountingLineValidationTest {
    private SalaryExpenseTransferDuplicateAccountingLineValidation cut;
    @Mock
    private SalaryExpenseTransferDocument salaryExpenseTransferDocMock;
    @Mock
    private ExpenseTransferSourceAccountingLine sourceAccountingLine;
    @Mock
    private ExpenseTransferTargetAccountingLine targetAccountingLine;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.setupAccountingLine((LaborLedgerExpenseTransferAccountingLine)this.sourceAccountingLine);
        List<ExpenseTransferSourceAccountingLine> sourceAccountingLines = Collections.singletonList(this.sourceAccountingLine);
        this.setupAccountingLine((LaborLedgerExpenseTransferAccountingLine)this.targetAccountingLine);
        List<ExpenseTransferTargetAccountingLine> targetAccountingLines = Collections.singletonList(this.targetAccountingLine);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getSourceAccountingLines()).thenReturn(sourceAccountingLines);
        Mockito.when((Object)this.salaryExpenseTransferDocMock.getTargetAccountingLines()).thenReturn(targetAccountingLines);
        this.cut = new SalaryExpenseTransferDuplicateAccountingLineValidation();
        this.cut.setAccountingDocumentForValidation((AccountingDocument)this.salaryExpenseTransferDocMock);
    }

    private void setupAccountingLine(LaborLedgerExpenseTransferAccountingLine accountingLine) {
        Mockito.when((Object)accountingLine.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountingLine.getAccountNumber()).thenReturn((Object)"1031400");
        Mockito.when((Object)accountingLine.getSubAccountNumber()).thenReturn((Object)"ADV");
        Mockito.when((Object)accountingLine.getFinancialObjectCode()).thenReturn((Object)"2383");
        Mockito.when((Object)accountingLine.getFinancialSubObjectCode()).thenReturn((Object)"POS");
        Mockito.when((Object)accountingLine.getProjectCode()).thenReturn((Object)"BOB");
        Mockito.when((Object)accountingLine.getOrganizationReferenceId()).thenReturn((Object)"123");
        Mockito.when((Object)accountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)accountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)"09");
        Mockito.when((Object)accountingLine.getAmount()).thenReturn((Object)new KualiDecimal(100.0));
    }

    @Test
    public void validate_accountingLinesMatch_invalid() {
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentChart_valid() {
        Mockito.when((Object)this.targetAccountingLine.getChartOfAccountsCode()).thenReturn((Object)"EA");
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentAccount_valid() {
        Mockito.when((Object)this.targetAccountingLine.getAccountNumber()).thenReturn((Object)"1031420");
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentSubAccount_valid() {
        Mockito.when((Object)this.targetAccountingLine.getSubAccountNumber()).thenReturn((Object)"BLT");
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentObjectCode_valid() {
        Mockito.when((Object)this.targetAccountingLine.getFinancialObjectCode()).thenReturn((Object)"5000");
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentSubObjectCode_valid() {
        Mockito.when((Object)this.targetAccountingLine.getFinancialSubObjectCode()).thenReturn((Object)"ABC");
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentProjectCode_valid() {
        Mockito.when((Object)this.targetAccountingLine.getProjectCode()).thenReturn((Object)"PRJ");
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentOrgRefId_valid() {
        Mockito.when((Object)this.targetAccountingLine.getOrganizationReferenceId()).thenReturn((Object)"456");
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentFiscalYear_valid() {
        Mockito.when((Object)this.targetAccountingLine.getPayrollEndDateFiscalYear()).thenReturn((Object)2010);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentFiscalPeriod_valid() {
        Mockito.when((Object)this.targetAccountingLine.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)"10");
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_targetAccountingLineHasDifferentAmount_valid() {
        Mockito.when((Object)this.targetAccountingLine.getAmount()).thenReturn((Object)new KualiDecimal(500.0));
        Assert.assertTrue((boolean)this.cut.validate(null));
    }
}

