/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.kuali.kfs.module.ld.LaborPropertyConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.businessobject.AccountingLineParserBase;

/**
 * Labor Extended class for parsing serialized <code>AccountingLine</code>s for <code>TransactionalDocument</code>s
 */
public class LaborLedgerAccountingLineParser extends AccountingLineParserBase {

    protected static final String[] LABOR_LEDGER_FORMAT = {
        KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE,
        KFSPropertyConstants.ACCOUNT_NUMBER,
        KFSPropertyConstants.SUB_ACCOUNT_NUMBER,
        KFSPropertyConstants.FINANCIAL_OBJECT_CODE,
        KFSPropertyConstants.FINANCIAL_SUB_OBJECT_CODE,
        KFSPropertyConstants.PROJECT_CODE,
        KFSPropertyConstants.ORGANIZATION_REFERENCE_ID,
        KFSPropertyConstants.POSITION_NUMBER,
        LaborPropertyConstants.PAYROLL_END_DATE_FISCAL_YEAR,
        LaborPropertyConstants.PAYROLL_END_DATE_FISCAL_PERIOD_CODE,
        LaborPropertyConstants.PAYROLL_TOTAL_HOURS,
        KFSPropertyConstants.AMOUNT};

    public LaborLedgerAccountingLineParser() {
    }

    /**
     * @return the LABOR_LEDGER_FORMAT of the SourceAccountingLineFormat
     */
    @Override
    public String[] getSourceAccountingLineFormat() {
        return removeChartFromFormatIfNeeded(LABOR_LEDGER_FORMAT);
    }

    /**
     * @return the LABOR_LEDGER_FORMAT of the TargetAccountingLineFormat
     */
    @Override
    public String[] getTargetAccountingLineFormat() {
        return removeChartFromFormatIfNeeded(LABOR_LEDGER_FORMAT);
    }

}
