/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ld.businessobject;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.Chart;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.integration.ld.LaborLedgerBalance;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.kim.impl.identity.Person;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.KFSPropertyConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.core.api.util.type.KualiDecimal;
import org.kuali.kfs.kim.api.identity.PersonService;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

/**
 * Labor business object for LedgerBalance.
 */
public class LedgerBalance extends Balance implements LaborLedgerBalance {

    private String financialObjectCode;
    private String financialSubObjectCode;
    private String financialBalanceTypeCode;
    private String financialObjectTypeCode;
    private String positionNumber;
    private String emplid;
    private KualiDecimal financialBeginningBalanceLineAmount;
    private Timestamp transactionDateTimeStamp;
    private String financialObjectFringeOrSalaryCode;
    private Chart chartOfAccounts;
    private ObjectType financialObjectType;
    private Person ledgerPerson;
    private LaborObject laborObject;

    public LedgerBalance() {
        super();
        this.setAccountLineAnnualBalanceAmount(KualiDecimal.ZERO);
        this.setFinancialBeginningBalanceLineAmount(KualiDecimal.ZERO);
        super.setBeginningBalanceLineAmount(KualiDecimal.ZERO);
        this.setContractsGrantsBeginningBalanceAmount(KualiDecimal.ZERO);
    }

    /**
     * @param transaction
     */
    public LedgerBalance(LaborTransaction transaction) {
        this();
        this.setChartOfAccountsCode(transaction.getChartOfAccountsCode());
        this.setAccountNumber(transaction.getAccountNumber());
        this.setFinancialBalanceTypeCode(transaction.getFinancialBalanceTypeCode());
        this.setEmplid(transaction.getEmplid());
        this.setFinancialObjectCode(transaction.getFinancialObjectCode());
        this.setFinancialObjectTypeCode(transaction.getFinancialObjectTypeCode());
        this.setFinancialSubObjectCode(transaction.getFinancialSubObjectCode());
        this.setPositionNumber(transaction.getPositionNumber());
        this.setUniversityFiscalYear(transaction.getUniversityFiscalYear());
        this.setSubAccountNumber(transaction.getSubAccountNumber());
    }

    /**
     * @param ledgerBalanceHistory
     */
    public LedgerBalance(LaborBalanceHistory ledgerBalanceHistory) {
        this();
        this.setChartOfAccountsCode(ledgerBalanceHistory.getChartOfAccountsCode());
        this.setAccountNumber(ledgerBalanceHistory.getAccountNumber());
        this.setFinancialBalanceTypeCode(ledgerBalanceHistory.getFinancialBalanceTypeCode());
        this.setEmplid(ledgerBalanceHistory.getEmplid());
        this.setFinancialObjectCode(ledgerBalanceHistory.getFinancialObjectCode());
        this.setFinancialObjectTypeCode(ledgerBalanceHistory.getFinancialObjectTypeCode());
        this.setFinancialSubObjectCode(ledgerBalanceHistory.getFinancialSubObjectCode());
        this.setPositionNumber(ledgerBalanceHistory.getPositionNumber());
        this.setUniversityFiscalYear(ledgerBalanceHistory.getUniversityFiscalYear());
        this.setSubAccountNumber(ledgerBalanceHistory.getSubAccountNumber());
    }

    @Override
    public String getEmplid() {
        return emplid;
    }

    @Override
    public void setEmplid(String emplid) {
        this.emplid = emplid;
    }

    @Override
    public String getFinancialBalanceTypeCode() {
        return financialBalanceTypeCode;
    }

    @Override
    public void setFinancialBalanceTypeCode(String financialBalanceTypeCode) {
        this.financialBalanceTypeCode = financialBalanceTypeCode;
    }

    @Override
    public KualiDecimal getFinancialBeginningBalanceLineAmount() {
        return financialBeginningBalanceLineAmount;
    }

    @Override
    public void setFinancialBeginningBalanceLineAmount(KualiDecimal financialBeginningBalanceLineAmount) {
        this.financialBeginningBalanceLineAmount = financialBeginningBalanceLineAmount;
        super.setBeginningBalanceLineAmount(financialBeginningBalanceLineAmount);
    }

    @Override
    public String getFinancialObjectCode() {
        return financialObjectCode;
    }

    @Override
    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    @Override
    public String getFinancialObjectTypeCode() {
        return financialObjectTypeCode;
    }

    @Override
    public void setFinancialObjectTypeCode(String financialObjectTypeCode) {
        this.financialObjectTypeCode = financialObjectTypeCode;
    }

    @Override
    public String getFinancialSubObjectCode() {
        return financialSubObjectCode;
    }

    @Override
    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    @Override
    public String getPositionNumber() {
        return positionNumber;
    }

    @Override
    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    @Override
    public Timestamp getTransactionDateTimeStamp() {
        return transactionDateTimeStamp;
    }

    @Override
    public void setTransactionDateTimeStamp(Timestamp transactionDateTimeStamp) {
        this.transactionDateTimeStamp = transactionDateTimeStamp;
    }

    @Override
    public String getBalanceTypeCode() {
        return this.getFinancialBalanceTypeCode();
    }

    @Override
    public void setBalanceTypeCode(String balanceTypeCode) {
        this.setFinancialBalanceTypeCode(balanceTypeCode);
    }

    @Override
    public Chart getChart() {
        return this.getChartOfAccounts();
    }

    @Override
    public void setChart(Chart chart) {
        this.setChartOfAccounts(chart);
    }

    @Override
    public Chart getChartOfAccounts() {
        return chartOfAccounts;
    }

    @Override
    public void setChartOfAccounts(Chart chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }

    @Override
    public ObjectType getFinancialObjectType() {
        return financialObjectType;
    }

    @Override
    public void setFinancialObjectType(ObjectType financialObjectType) {
        this.financialObjectType = financialObjectType;
    }

    @Override
    public void addAmount(String period, KualiDecimal amount) {
        if (KFSConstants.PERIOD_CODE_ANNUAL_BALANCE.equals(period)) {
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.PERIOD_CODE_BEGINNING_BALANCE.equals(period)) {
            this.setFinancialBeginningBalanceLineAmount(this.getFinancialBeginningBalanceLineAmount().add(amount));
            super.getBeginningBalanceLineAmount().add(amount);
        } else if (KFSConstants.PERIOD_CODE_CG_BEGINNING_BALANCE.equals(period)) {
            this.setContractsGrantsBeginningBalanceAmount(this.getContractsGrantsBeginningBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH1.equals(period)) {
            setMonth1Amount(getMonth1Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH2.equals(period)) {
            setMonth2Amount(getMonth2Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH3.equals(period)) {
            setMonth3Amount(getMonth3Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH4.equals(period)) {
            setMonth4Amount(getMonth4Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH5.equals(period)) {
            setMonth5Amount(getMonth5Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH6.equals(period)) {
            setMonth6Amount(getMonth6Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH7.equals(period)) {
            setMonth7Amount(getMonth7Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH8.equals(period)) {
            setMonth8Amount(getMonth8Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH9.equals(period)) {
            setMonth9Amount(getMonth9Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH10.equals(period)) {
            setMonth10Amount(getMonth10Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH11.equals(period)) {
            setMonth11Amount(getMonth11Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH12.equals(period)) {
            setMonth12Amount(getMonth12Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        } else if (KFSConstants.MONTH13.equals(period)) {
            setMonth13Amount(getMonth13Amount().add(amount));
            this.setAccountLineAnnualBalanceAmount(this.getAccountLineAnnualBalanceAmount().add(amount));
        }
    }

    @Override
    public KualiDecimal getAmountByPeriod(String periodCode) {
        if (KFSConstants.PERIOD_CODE_ANNUAL_BALANCE.equals(periodCode)) {
            return this.getAccountLineAnnualBalanceAmount();
        } else if (KFSConstants.PERIOD_CODE_BEGINNING_BALANCE.equals(periodCode)) {
            return this.getFinancialBeginningBalanceLineAmount();
        } else if (KFSConstants.PERIOD_CODE_CG_BEGINNING_BALANCE.equals(periodCode)) {
            return this.getContractsGrantsBeginningBalanceAmount();
        } else if (KFSConstants.MONTH1.equals(periodCode)) {
            return this.getMonth1Amount();
        } else if (KFSConstants.MONTH2.equals(periodCode)) {
            return this.getMonth2Amount();
        } else if (KFSConstants.MONTH3.equals(periodCode)) {
            return this.getMonth3Amount();
        } else if (KFSConstants.MONTH4.equals(periodCode)) {
            return this.getMonth4Amount();
        } else if (KFSConstants.MONTH5.equals(periodCode)) {
            return this.getMonth5Amount();
        } else if (KFSConstants.MONTH6.equals(periodCode)) {
            return this.getMonth6Amount();
        } else if (KFSConstants.MONTH7.equals(periodCode)) {
            return this.getMonth7Amount();
        } else if (KFSConstants.MONTH8.equals(periodCode)) {
            return this.getMonth8Amount();
        } else if (KFSConstants.MONTH9.equals(periodCode)) {
            return this.getMonth9Amount();
        } else if (KFSConstants.MONTH10.equals(periodCode)) {
            return this.getMonth10Amount();
        } else if (KFSConstants.MONTH11.equals(periodCode)) {
            return this.getMonth11Amount();
        } else if (KFSConstants.MONTH12.equals(periodCode)) {
            return this.getMonth12Amount();
        } else if (KFSConstants.MONTH13.equals(periodCode)) {
            return this.getMonth13Amount();
        } else {
            throw new IllegalArgumentException("Unsupported Period Code: " + periodCode);
        }
    }

    @Override
    public LaborLedgerObject getLaborLedgerObject() {
        return this.laborObject;
    }

    @Override
    @Deprecated
    public void setLaborLedgerObject(LaborLedgerObject laborLedgerObject) {
        this.laborObject = (LaborObject) laborLedgerObject;
    }

    public LaborObject getLaborObject() {
        return laborObject;
    }

    @Deprecated
    public void setLaborObject(LaborObject laborObject) {
        this.laborObject = laborObject;
    }

    @Override
    public Person getLedgerPerson() {
        if ((ledgerPerson == null || !StringUtils.equals(ledgerPerson.getEmployeeId(), emplid))
                && StringUtils.isNotBlank(emplid)) {
            ledgerPerson = (Person) SpringContext.getBean(PersonService.class).getPersonByEmployeeId(emplid);
        }

        return ledgerPerson;
    }

    @Override
    public void setLedgerPerson(Person ledgerPerson) {
        this.ledgerPerson = ledgerPerson;
    }

    public static List<String> getPrimaryKeyList() {
        List<String> primaryKeyList = new ArrayList<>();
        primaryKeyList.add(KFSPropertyConstants.UNIVERSITY_FISCAL_YEAR);
        primaryKeyList.add(KFSPropertyConstants.CHART_OF_ACCOUNTS_CODE);
        primaryKeyList.add(KFSPropertyConstants.ACCOUNT_NUMBER);
        primaryKeyList.add(KFSPropertyConstants.SUB_ACCOUNT_NUMBER);
        primaryKeyList.add(KFSPropertyConstants.FINANCIAL_OBJECT_CODE);
        primaryKeyList.add(KFSPropertyConstants.FINANCIAL_SUB_OBJECT_CODE);
        primaryKeyList.add(KFSPropertyConstants.FINANCIAL_BALANCE_TYPE_CODE);
        primaryKeyList.add(KFSPropertyConstants.FINANCIAL_OBJECT_TYPE_CODE);
        primaryKeyList.add(KFSPropertyConstants.POSITION_NUMBER);
        primaryKeyList.add(KFSPropertyConstants.EMPLID);

        return primaryKeyList;
    }

    /**
     * @return true if all amounts except C/G beginning balance are zero; false otherwise.
     */
    public boolean isCGBeginningBalanceOnly() {
        return getAccountLineAnnualBalanceAmount().isZero()
                && getBeginningBalanceLineAmount().isZero()
                && getFinancialBeginningBalanceLineAmount().isZero()
                && getMonth1Amount().isZero()
                && getMonth2Amount().isZero()
                && getMonth3Amount().isZero()
                && getMonth4Amount().isZero()
                && getMonth5Amount().isZero()
                && getMonth6Amount().isZero()
                && getMonth7Amount().isZero()
                && getMonth8Amount().isZero()
                && getMonth9Amount().isZero()
                && getMonth10Amount().isZero()
                && getMonth11Amount().isZero()
                && getMonth12Amount().isZero()
                && getMonth13Amount().isZero();
    }

}
