/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.junit.Test;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.validation.event.AddActualExpenseLineEvent;
import org.kuali.kfs.module.tem.document.validation.impl.TravelDocumentActualExpenseLineValidation;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class TravelDocumentActualExpenseLineValidationTest
extends KualiTestBase {
    private static final int EXPENSE_AMOUNT = 100;
    private TravelDocumentActualExpenseLineValidation validation;
    private DateTimeService dateTimeService;
    private DocumentService docService;
    private DictionaryValidationService dictionaryValidationService;
    private static final String AIRFARE_EXPENSE_TYPE_CODE = "A";
    private static final String MILEAGE_EXPENSE_TYPE_CODE = "M";
    private static final String HOSTEDMEAL_BREAKFAST_EXPENSE_TYPE_CODE = "HB";
    private static final String LODGING_EXPENSE_TYPE_CODE = "L";
    private static final String LODGING_ALLOWANCE_EXPENSE_TYPE_CODE = "LA";
    private static final String RENTALCAR_EXPENSE_TYPE_CODE = "R";

    protected void setUp() throws Exception {
        super.setUp();
        this.validation = new TravelDocumentActualExpenseLineValidation();
        this.dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        this.docService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.dictionaryValidationService = (DictionaryValidationService)SpringContext.getBean(DictionaryValidationService.class);
        this.validation.setDictionaryValidationService(this.dictionaryValidationService);
    }

    protected void tearDown() throws Exception {
        this.validation = null;
        super.tearDown();
    }

    @Test
    public void testValidation() {
        TravelReimbursementDocument tr = null;
        try {
            tr = (TravelReimbursementDocument)this.docService.getNewDocument(TravelReimbursementDocument.class);
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        ActualExpense ote2 = new ActualExpense();
        ote2.setExpenseAmount(new KualiDecimal(100));
        ote2.setExpenseDate(this.dateTimeService.getCurrentSqlDate());
        ote2.setExpenseTypeCode(AIRFARE_EXPENSE_TYPE_CODE);
        AddActualExpenseLineEvent event2 = new AddActualExpenseLineEvent("errorPathPrefix", (Document)tr, ote2);
        this.validation.setActualExpenseForValidation(ote2);
        TravelDocumentActualExpenseLineValidationTest.assertTrue((boolean)this.validation.validate((AttributedDocumentEvent)event2));
    }

    @Test
    public void testValidateGeneralRules() {
        TravelReimbursementDocument document = new TravelReimbursementDocument();
        ArrayList<ActualExpense> actualExpenses = new ArrayList<ActualExpense>();
        ActualExpense airFareEntry = new ActualExpense();
        ActualExpense mileageEntry = new ActualExpense();
        ExpenseTypeObjectCode aTravelExpenseTypeCode = new ExpenseTypeObjectCode();
        document.setActualExpenses(actualExpenses);
        aTravelExpenseTypeCode.setExpenseTypeCode(AIRFARE_EXPENSE_TYPE_CODE);
        airFareEntry.setTravelExpenseTypeCode(aTravelExpenseTypeCode);
        airFareEntry.setExpenseDate(this.dateTimeService.getCurrentSqlDate());
        airFareEntry.setExpenseTypeCode(AIRFARE_EXPENSE_TYPE_CODE);
        TravelDocumentActualExpenseLineValidationTest.assertTrue((boolean)this.validation.validateGeneralRules(airFareEntry, (TravelDocument)document));
        airFareEntry.setExpenseAmount(new KualiDecimal(-100));
        TravelDocumentActualExpenseLineValidationTest.assertFalse((boolean)this.validation.validateGeneralRules(airFareEntry, (TravelDocument)document));
        airFareEntry.setExpenseAmount(new KualiDecimal(100));
        airFareEntry.setCurrencyRate(BigDecimal.ZERO);
        TravelDocumentActualExpenseLineValidationTest.assertTrue((boolean)this.validation.validateGeneralRules(airFareEntry, (TravelDocument)document));
        ActualExpense duplicateAirfareEntry = new ActualExpense();
        duplicateAirfareEntry.setTravelExpenseTypeCode(aTravelExpenseTypeCode);
        duplicateAirfareEntry.setExpenseTypeCode(AIRFARE_EXPENSE_TYPE_CODE);
        duplicateAirfareEntry.setExpenseAmount(new KualiDecimal(100.0));
        duplicateAirfareEntry.setExpenseDate(this.dateTimeService.getCurrentSqlDate());
        actualExpenses.add(airFareEntry);
        TravelDocumentActualExpenseLineValidationTest.assertFalse((boolean)this.validation.validateGeneralRules(duplicateAirfareEntry, (TravelDocument)document));
        ExpenseTypeObjectCode mTravelExpenseTypeCode = new ExpenseTypeObjectCode();
        mTravelExpenseTypeCode.setExpenseTypeCode(MILEAGE_EXPENSE_TYPE_CODE);
        mileageEntry.setExpenseAmount(KualiDecimal.ZERO);
        mileageEntry.setTravelExpenseTypeCode(mTravelExpenseTypeCode);
        TravelDocumentActualExpenseLineValidationTest.assertTrue((boolean)this.validation.validateGeneralRules(mileageEntry, (TravelDocument)document));
    }

    @Test
    public void testValidateAirfareRules() {
    }

    @Test
    public void testValidateRentalCarRules() {
    }

    @Test
    public void testValidateMileageRules() {
    }

    @Test
    public void testValidateLodgingRules() {
    }

    @Test
    public void testValidateLodgingAllowanceRules() {
    }

    @Test
    public void testValidateMealsRuels() {
    }

    @Test
    public void testMaximumAmountRules() {
    }

    @Test
    public void testValidatePerDiemRules() {
    }
}

