/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.dataaccess.ExpenseTypeObjectCodeDao;
import org.kuali.kfs.module.tem.dataaccess.impl.ExpenseTypeObjectCodeDaoOjb;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.module.tem.service.impl.TravelExpenseServiceImpl;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;

@ConfigureContext
public class TravelExpenseServiceTest
extends KualiTestBase {
    protected static final String MONKEY_EXPENSE_TYPE_CODE = "M";
    protected static final String GIRAFFE_EXPENSE_TYPE_CODE = "G";
    protected TravelExpenseService travelExpenseService;

    public void setUp() {
        this.travelExpenseService = new TravelExpenseServiceImpl(){

            public ExpenseTypeObjectCodeDao getExpenseTypeObjectCodeDao() {
                ExpenseTypeObjectCodeDaoOjb expenseTypeObjectCodeDao = new ExpenseTypeObjectCodeDaoOjb(){

                    public List<ExpenseTypeObjectCode> findMatchingExpenseTypeObjectCodes(String expenseTypeCode, Set<String> documentTypes, String tripType, String travelerType) {
                        ArrayList<ExpenseTypeObjectCode> results = new ArrayList<ExpenseTypeObjectCode>();
                        if (TravelExpenseServiceTest.MONKEY_EXPENSE_TYPE_CODE.equals(expenseTypeCode)) {
                            results.add(MockExpenseTypeObjectCode.MONKEY.buildExpenseTypeObjectCode());
                        } else if (TravelExpenseServiceTest.GIRAFFE_EXPENSE_TYPE_CODE.equals(expenseTypeCode)) {
                            if ("IN".equals(tripType) && documentTypes.contains("TA")) {
                                results.add(MockExpenseTypeObjectCode.GIRAFFE_TRAVELER_ALL.buildExpenseTypeObjectCode());
                            }
                            if (documentTypes.contains("TA")) {
                                results.add(MockExpenseTypeObjectCode.GIRAFFE_TA.buildExpenseTypeObjectCode());
                            }
                            results.add(MockExpenseTypeObjectCode.GIRAFFE_TT.buildExpenseTypeObjectCode());
                            if ("IN".equals(tripType) && "EMP".equals(travelerType) && documentTypes.contains("TA")) {
                                results.add(MockExpenseTypeObjectCode.GIRAFFE_EMP_IN.buildExpenseTypeObjectCode());
                            }
                            if ("EMP".equals(travelerType) && documentTypes.contains("TA")) {
                                results.add(MockExpenseTypeObjectCode.GIRAFFE_TRIP_ALL.buildExpenseTypeObjectCode());
                            }
                        } else {
                            throw new UnsupportedOperationException("Hey, I'm just a mock interface.  I only know about monkeys and giraffes, not an expense type code like: " + expenseTypeCode);
                        }
                        return results;
                    }

                    public List<ExpenseTypeObjectCode> findMatchingExpenseTypesObjectCodes(Set<String> documentTypes, String tripType, String travelerType) {
                        ArrayList<ExpenseTypeObjectCode> results = new ArrayList<ExpenseTypeObjectCode>();
                        results.add(MockExpenseTypeObjectCode.MONKEY.buildExpenseTypeObjectCode());
                        results.add(MockExpenseTypeObjectCode.GIRAFFE_EMP_IN.buildExpenseTypeObjectCode());
                        results.add(MockExpenseTypeObjectCode.GIRAFFE_TT.buildExpenseTypeObjectCode());
                        results.add(MockExpenseTypeObjectCode.GIRAFFE_TA.buildExpenseTypeObjectCode());
                        results.add(MockExpenseTypeObjectCode.GIRAFFE_TRAVELER_ALL.buildExpenseTypeObjectCode());
                        results.add(MockExpenseTypeObjectCode.GIRAFFE_TRIP_ALL.buildExpenseTypeObjectCode());
                        return results;
                    }
                };
                return expenseTypeObjectCodeDao;
            }

            public TravelService getTravelService() {
                return (TravelService)SpringContext.getBean(TravelService.class);
            }
        };
    }

    public void testGetExpenseType() {
        ExpenseTypeObjectCode monkeyETOC1 = this.travelExpenseService.getExpenseType(MONKEY_EXPENSE_TYPE_CODE, "TA", "IN", "EMP");
        TravelExpenseServiceTest.assertEquals((String)"M-TA-EMP-IN found correct monkey expense type object code", (String)"6000", (String)monkeyETOC1.getFinancialObjectCode());
        ExpenseTypeObjectCode monkeyETOC2 = this.travelExpenseService.getExpenseType(MONKEY_EXPENSE_TYPE_CODE, "ENT", "IN", "EMP");
        TravelExpenseServiceTest.assertEquals((String)"M-ENT-EMP-IN found correct monkey expense type object code", (String)"6000", (String)monkeyETOC2.getFinancialObjectCode());
        ExpenseTypeObjectCode monkeyETOC3 = this.travelExpenseService.getExpenseType(MONKEY_EXPENSE_TYPE_CODE, "TA", "OUT", "EMP");
        TravelExpenseServiceTest.assertEquals((String)"M-TA-EMP-OUT found correct monkey expense type object code", (String)"6000", (String)monkeyETOC3.getFinancialObjectCode());
        ExpenseTypeObjectCode monkeyETOC4 = this.travelExpenseService.getExpenseType(MONKEY_EXPENSE_TYPE_CODE, "TA", "OUT", "NON");
        TravelExpenseServiceTest.assertEquals((String)"M-TA-NON-OUT found correct monkey expense type object code", (String)"6000", (String)monkeyETOC4.getFinancialObjectCode());
        ExpenseTypeObjectCode giraffeETOC1 = this.travelExpenseService.getExpenseType(GIRAFFE_EXPENSE_TYPE_CODE, "TA", "OUT", "NON");
        TravelExpenseServiceTest.assertEquals((String)"G-TA-NON-OUT found correct giraffe expense type object code", (String)"6002", (String)giraffeETOC1.getFinancialObjectCode());
        ExpenseTypeObjectCode giraffeETOC2 = this.travelExpenseService.getExpenseType(GIRAFFE_EXPENSE_TYPE_CODE, "ENT", "OUT", "NON");
        TravelExpenseServiceTest.assertEquals((String)"G-ENT-NON-OUT found correct giraffe expense type object code", (String)"6001", (String)giraffeETOC2.getFinancialObjectCode());
        ExpenseTypeObjectCode giraffeETOC3 = this.travelExpenseService.getExpenseType(GIRAFFE_EXPENSE_TYPE_CODE, "TA", "IN", "EMP");
        TravelExpenseServiceTest.assertEquals((String)"G-TA-EMP-IN found correct giraffe expense type object code", (String)"6003", (String)giraffeETOC3.getFinancialObjectCode());
        ExpenseTypeObjectCode giraffeETOC4 = this.travelExpenseService.getExpenseType(GIRAFFE_EXPENSE_TYPE_CODE, "TA", "IN", "NON");
        TravelExpenseServiceTest.assertEquals((String)"G-TA-NON-IN found correct giraffe expense type object code", (String)"6005", (String)giraffeETOC4.getFinancialObjectCode());
        ExpenseTypeObjectCode giraffeETOC5 = this.travelExpenseService.getExpenseType(GIRAFFE_EXPENSE_TYPE_CODE, "TA", "OUT", "EMP");
        TravelExpenseServiceTest.assertEquals((String)"G-TA-EMP-OUT found correct giraffe expense type object code", (String)"6004", (String)giraffeETOC5.getFinancialObjectCode());
        ExpenseTypeObjectCode giraffeETOC6 = this.travelExpenseService.getExpenseType(GIRAFFE_EXPENSE_TYPE_CODE, "ENT", "IN", "EMP");
        TravelExpenseServiceTest.assertEquals((String)"G-ENT-EMP-IN found correct giraffe expense type object code", (String)"6001", (String)giraffeETOC6.getFinancialObjectCode());
    }

    protected static enum MockExpenseTypeObjectCode {
        MONKEY("M", "TT", "All", "All", "6000"),
        GIRAFFE_TT("G", "TT", "All", "All", "6001"),
        GIRAFFE_TA("G", "TA", "All", "All", "6002"),
        GIRAFFE_EMP_IN("G", "TA", "EMP", "IN", "6003"),
        GIRAFFE_TRIP_ALL("G", "TA", "EMP", "All", "6004"),
        GIRAFFE_TRAVELER_ALL("G", "TA", "All", "IN", "6005");

        private String expenseTypeCode;
        private String documentTypeName;
        private String travelerType;
        private String tripType;
        private String financialObjectCode;

        private MockExpenseTypeObjectCode(String expenseTypeCode, String documentTypeName, String travelerType, String tripType, String financialObjectCode) {
            this.expenseTypeCode = expenseTypeCode;
            this.documentTypeName = documentTypeName;
            this.travelerType = travelerType;
            this.tripType = tripType;
            this.financialObjectCode = financialObjectCode;
        }

        protected ExpenseTypeObjectCode buildExpenseTypeObjectCode() {
            ExpenseTypeObjectCode etoc = new ExpenseTypeObjectCode();
            etoc.setExpenseTypeObjectCodeId(Long.valueOf(1L));
            etoc.setExpenseTypeCode(this.expenseTypeCode);
            etoc.setDocumentTypeName(this.documentTypeName);
            etoc.setTravelerTypeCode(this.travelerType);
            etoc.setTripTypeCode(this.tripType);
            etoc.setFinancialObjectCode(this.financialObjectCode);
            return etoc;
        }
    }
}

