/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.module.tem.batch.businessobject.PerDiemForLoad;
import org.kuali.kfs.module.tem.batch.service.PerDiemFileParsingService;
import org.kuali.kfs.module.tem.batch.service.PerDiemLoadService;
import org.kuali.kfs.module.tem.batch.service.PerDiemLoadValidationService;
import org.kuali.kfs.sys.batch.BatchInputFileTypeBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class PerDiemTxtInputFileType
extends BatchInputFileTypeBase {
    private static Logger LOG = Logger.getLogger(PerDiemTxtInputFileType.class);
    private PerDiemFileParsingService perDiemFileParsingService;
    private DateTimeService dateTimeService;
    private String fileNamePrefix;
    private String deliminator;
    private List<String> perDiemFieldsToPopulate;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        StringBuilder fileName = new StringBuilder();
        fileUserIdentifier = StringUtils.deleteWhitespace((String)fileUserIdentifier);
        fileUserIdentifier = StringUtils.remove((String)fileUserIdentifier, (String)"_");
        fileName.append(this.getFileNamePrefix()).append("_");
        fileName.append(principalName).append("_");
        fileName.append(fileUserIdentifier).append("_");
        fileName.append(this.dateTimeService.toDateTimeStringForFilename(this.dateTimeService.getCurrentDate()));
        return fileName.toString();
    }

    public String getFileTypeIdentifer() {
        return "perDiemInputFileType";
    }

    public Object parse(byte[] fileByteContent) throws ParseException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(fileByteContent)));
        List<PerDiemForLoad> perDiemList = this.getPerDiemFileParsingService().buildPerDiemsFromFlatFile(reader, this.getDeliminator(), this.getPerDiemFieldsToPopulate());
        PerDiemLoadService perDiemLoadService = (PerDiemLoadService)SpringContext.getBean(PerDiemLoadService.class);
        perDiemList = perDiemLoadService.updatePerDiem(perDiemList);
        return perDiemList;
    }

    public void process(String fileName, Object parsedFileContents) {
    }

    public boolean validate(Object parsedFileContents) {
        PerDiemLoadValidationService perDiemLoadValidationService = (PerDiemLoadValidationService)SpringContext.getBean(PerDiemLoadValidationService.class);
        List perDiemList = (List)parsedFileContents;
        return perDiemLoadValidationService.validate(perDiemList);
    }

    public String getAuthorPrincipalName(File file) {
        return StringUtils.substringBetween((String)file.getName(), (String)this.getFileNamePrefix(), (String)"_");
    }

    public String getTitleKey() {
        return "message.batchUpload.title.per.diem.file";
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public void setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
    }

    public PerDiemFileParsingService getPerDiemFileParsingService() {
        return this.perDiemFileParsingService;
    }

    public void setPerDiemFileParsingService(PerDiemFileParsingService perDiemFileParsingService) {
        this.perDiemFileParsingService = perDiemFileParsingService;
    }

    public String getDeliminator() {
        return this.deliminator;
    }

    public void setDeliminator(String deliminator) {
        this.deliminator = deliminator;
    }

    public List<String> getPerDiemFieldsToPopulate() {
        return this.perDiemFieldsToPopulate;
    }

    public void setPerDiemFieldsToPopulate(List<String> perDiemFieldsToPopulate) {
        this.perDiemFieldsToPopulate = perDiemFieldsToPopulate;
    }
}

