/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.batch.AgencyDataImportStep;
import org.kuali.kfs.module.tem.batch.service.ExpenseImportByTripService;
import org.kuali.kfs.module.tem.batch.service.ImportedExpensePendingEntryService;
import org.kuali.kfs.module.tem.batch.service.impl.ExpenseImportServiceBase;
import org.kuali.kfs.module.tem.businessobject.AgencyServiceFee;
import org.kuali.kfs.module.tem.businessobject.AgencyStagingData;
import org.kuali.kfs.module.tem.businessobject.CreditCardStagingData;
import org.kuali.kfs.module.tem.businessobject.ExpenseType;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TripAccountingInformation;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelAuthorizationService;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.module.tem.service.TravelEncumbranceService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ExpenseImportByTripServiceImpl
extends ExpenseImportServiceBase
implements ExpenseImportByTripService {
    public static Logger LOG = Logger.getLogger(ExpenseImportByTripServiceImpl.class);
    private TravelAuthorizationService travelAuthorizationService;
    private TemProfileService temProfileService;
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private TravelExpenseService travelExpenseService;
    private ImportedExpensePendingEntryService importedExpensePendingEntryService;
    private TravelDocumentService travelDocumentService;
    private TravelEncumbranceService travelEncumbranceService;

    @Override
    public List<ErrorMessage> validateMandatoryFieldsPresent(AgencyStagingData agencyData) {
        ErrorMessage error;
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        if (StringUtils.isEmpty((String)agencyData.getTripId())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"tripId"});
            errorMessages.add(error);
        }
        errorMessages.addAll(this.validateMissingAccountingInfo(agencyData));
        if (this.isAmountEmpty(agencyData.getTripExpenseAmount())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"tripExpenseAmount"});
            errorMessages.add(error);
        }
        if (StringUtils.isEmpty((String)agencyData.getTripInvoiceNumber())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"tripInvoiceNumber"});
            errorMessages.add(error);
        }
        if (ObjectUtils.isNull((Object)agencyData.getTransactionPostingDate())) {
            error = new ErrorMessage("message.batch.tem.agencyDataMandatoryFields", new String[]{"transactionPostingDate"});
            errorMessages.add(error);
        }
        if (this.isTripDataMissing(agencyData)) {
            error = new ErrorMessage("message.batch.tem.agencyDataAirLodgingRentalMissing", new String[0]);
            errorMessages.add(error);
        }
        if (!errorMessages.isEmpty()) {
            LOG.error((Object)"Missing one or more required fields.");
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> validateMissingAccountingInfo(AgencyStagingData agencyData) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        ArrayList<TripAccountingInformation> accountingInfoList = agencyData.getTripAccountingInformation();
        if (accountingInfoList.isEmpty()) {
            ErrorMessage error = new ErrorMessage("message.batch.tem.agencyDataAcctgInfoRequired", new String[0]);
            errorMessages.add(error);
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> validateAgencyData(AgencyStagingData agencyData) {
        LOG.info((Object)("Validating agency data. tripId: " + agencyData.getTripId()));
        List<ErrorMessage> errorMessages = this.validateMandatoryFieldsPresent(agencyData);
        if (!errorMessages.isEmpty()) {
            agencyData.setErrorCode("REQ");
            return errorMessages;
        }
        errorMessages = this.validateDuplicateData(agencyData);
        if (!errorMessages.isEmpty()) {
            agencyData.setErrorCode("DUP");
            return errorMessages;
        }
        agencyData.setErrorCode("OK");
        errorMessages = this.validateTripId(agencyData);
        errorMessages.addAll(this.validateAccountingInfo(agencyData));
        errorMessages.addAll(this.validateCreditCardAgency(agencyData));
        errorMessages.addAll(this.validateDistributionCode(agencyData));
        LOG.info((Object)("Finished validating agency data. tripId:" + agencyData.getTripId()));
        agencyData.setProcessingTimestamp(this.dateTimeService.getCurrentTimestamp());
        if (ObjectUtils.isNull((Object)agencyData.getCreationTimestamp())) {
            agencyData.setCreationTimestamp(this.dateTimeService.getCurrentTimestamp());
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> validateTripId(AgencyStagingData agencyData) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        TravelDocument travelDocument = this.getTravelDocumentService().getParentTravelDocument(agencyData.getTripId());
        if (ObjectUtils.isNotNull((Object)travelDocument)) {
            return errorMessages;
        }
        LOG.error((Object)("Unable to retrieve a travel document for tripId: " + agencyData.getTripId()));
        this.setErrorCode(agencyData, "TRIP");
        errorMessages.add(new ErrorMessage("message.batch.tem.agencyDataInvalidTripId", new String[0]));
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> validateAccountingInfo(AgencyStagingData agencyData) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        Collection validationParameters = this.getParameterService().getParameterValuesAsString(AgencyDataImportStep.class, "ACCOUNTING_LINE_VALIDATION");
        if (ObjectUtils.isNull((Object)validationParameters)) {
            return errorMessages;
        }
        ArrayList<TripAccountingInformation> accountingInfo = agencyData.getTripAccountingInformation();
        for (TripAccountingInformation account : accountingInfo) {
            errorMessages.addAll(this.validateAccountingInfoLine(agencyData, account, validationParameters).values());
        }
        return errorMessages;
    }

    @Override
    public Map<String, ErrorMessage> validateAccountingInfoLine(TripAccountingInformation accountingLine) {
        return this.validateAccountingInfoLine(null, accountingLine, null);
    }

    protected Map<String, ErrorMessage> validateAccountingInfoLine(AgencyStagingData agencyData, TripAccountingInformation accountingLine, Collection<String> validationParameters) {
        HashMap<String, ErrorMessage> errorMap = new HashMap<String, ErrorMessage>();
        if (ObjectUtils.isNull(validationParameters) && ObjectUtils.isNull((Object)(validationParameters = this.getParameterService().getParameterValuesAsString(AgencyDataImportStep.class, "ACCOUNTING_LINE_VALIDATION")))) {
            return errorMap;
        }
        boolean setAgencyDataErrorCode = false;
        String tripId = "";
        if (ObjectUtils.isNotNull((Object)((Object)agencyData))) {
            setAgencyDataErrorCode = true;
            tripId = agencyData.getTripId();
        }
        ErrorMessage error = null;
        if (validationParameters.contains("Account") && !this.isAccountNumberValid(accountingLine.getTripChartCode(), accountingLine.getTripAccountNumber())) {
            if (setAgencyDataErrorCode) {
                LOG.error((Object)("Invalid Account in Agency Data record. tripId: " + tripId + " chart code: " + accountingLine.getTripChartCode() + " account: " + accountingLine.getTripAccountNumber()));
                this.setErrorCode(agencyData, "ACT");
            }
            error = new ErrorMessage("message.batch.tem.agencyDataInvalidAccountNum", new String[]{accountingLine.getTripChartCode(), accountingLine.getTripAccountNumber()});
            errorMap.put("tripAccountNumber", error);
        }
        if (validationParameters.contains("Sub-Account") && StringUtils.isNotEmpty((String)accountingLine.getTripSubAccountNumber()) && !this.isSubAccountNumberValid(accountingLine.getTripChartCode(), accountingLine.getTripAccountNumber(), accountingLine.getTripSubAccountNumber())) {
            if (setAgencyDataErrorCode) {
                LOG.error((Object)("Invalid SubAccount in Agency Data record. tripId: " + tripId + " chart code: " + accountingLine.getTripChartCode() + " account: " + accountingLine.getTripAccountNumber() + " subaccount: " + accountingLine.getTripSubAccountNumber()));
                this.setErrorCode(agencyData, "SACT");
            }
            error = new ErrorMessage("message.batch.tem.agencyDataInvalidSubAccount", new String[]{accountingLine.getTripSubAccountNumber()});
            errorMap.put("tripSubAccountNumber", error);
        }
        if (StringUtils.isNotEmpty((String)accountingLine.getProjectCode()) && !this.isProjectCodeValid(accountingLine.getProjectCode())) {
            if (setAgencyDataErrorCode) {
                LOG.error((Object)("Invalid Project in Agency Data record. tripId: " + tripId + " project code: " + accountingLine.getProjectCode()));
                this.setErrorCode(agencyData, "PROJ");
            }
            error = new ErrorMessage("message.batch.tem.agencyDataInvalidProjectCode", new String[]{accountingLine.getProjectCode()});
            errorMap.put("projectCode", error);
        }
        return errorMap;
    }

    @Override
    public List<ErrorMessage> validateDuplicateData(AgencyStagingData agencyData) {
        List<ErrorMessage> errorMessages = this.validateMandatoryFieldsPresent(agencyData);
        if (!errorMessages.isEmpty()) {
            return errorMessages;
        }
        List<AgencyStagingData> agencyDataList = this.checkForDuplicates(agencyData);
        if (ObjectUtils.isNotNull(agencyDataList) && !agencyDataList.isEmpty()) {
            boolean isDuplicate = false;
            String errorMessage = "Found a duplicate entry for Agency Staging Data: Duplicate Ids ";
            for (AgencyStagingData duplicate : agencyDataList) {
                Integer duplicateId = duplicate.getId();
                if (!ObjectUtils.isNotNull((Object)agencyData.getId()) || agencyData.getId().intValue() == duplicateId.intValue()) continue;
                errorMessage = errorMessage + duplicate.getId() + " ";
                isDuplicate = true;
            }
            if (isDuplicate) {
                LOG.error((Object)errorMessage);
                ErrorMessage error = new ErrorMessage("message.batch.tem.agencyData.trip.DuplicateRecord", new String[]{agencyData.getTripId(), agencyData.getAgency(), agencyData.getTransactionPostingDate().toString(), agencyData.getTripExpenseAmount().toString(), agencyData.getItineraryDataString()});
                errorMessages.add(error);
            }
        }
        return errorMessages;
    }

    protected List<AgencyStagingData> checkForDuplicates(AgencyStagingData agencyStagingData) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        if (StringUtils.isNotEmpty((String)agencyStagingData.getTripId())) {
            fieldValues.put("tripId", agencyStagingData.getTripId());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getCreditCardOrAgencyCode())) {
            fieldValues.put("creditCardOrAgencyCode", agencyStagingData.getCreditCardOrAgencyCode());
        }
        if (ObjectUtils.isNotNull((Object)agencyStagingData.getTransactionPostingDate())) {
            fieldValues.put("transactionPostingDate", agencyStagingData.getTransactionPostingDate());
        }
        if (ObjectUtils.isNotNull((Object)agencyStagingData.getTripExpenseAmount())) {
            fieldValues.put("tripExpenseAmount", agencyStagingData.getTripExpenseAmount());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getAirTicketNumber())) {
            fieldValues.put("airTicketNumber", agencyStagingData.getAirTicketNumber());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getLodgingItineraryNumber())) {
            fieldValues.put("lodgingItineraryNumber", agencyStagingData.getLodgingItineraryNumber());
        }
        if (StringUtils.isNotEmpty((String)agencyStagingData.getRentalCarItineraryNumber())) {
            fieldValues.put("rentalCarItineraryNumber", agencyStagingData.getRentalCarItineraryNumber());
        }
        List agencyDataList = (List)this.businessObjectService.findMatching(AgencyStagingData.class, fieldValues);
        return agencyDataList;
    }

    @Override
    public List<ErrorMessage> validateCreditCardAgency(AgencyStagingData agencyData) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        if (!this.isCreditCardAgencyValid(agencyData)) {
            errorMessages.add(new ErrorMessage("message.batch.tem.agency.creditcard.data.InvalidCreditCardAgency", new String[]{agencyData.getCreditCardOrAgencyCode()}));
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> validateDistributionCode(AgencyStagingData agencyData) {
        AgencyServiceFee serviceFee;
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        String distributionCode = agencyData.getDistributionCode();
        if (ObjectUtils.isNotNull((Object)distributionCode) && ObjectUtils.isNull((Object)((Object)(serviceFee = this.getAgencyServiceFee(distributionCode))))) {
            LOG.error((Object)("Invalid Distribution Code: " + distributionCode));
            this.setErrorCode(agencyData, "DI");
            errorMessages.add(new ErrorMessage("message.batch.tem.agencyDataInvalidDistributionCode", new String[]{distributionCode}));
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> reconciliateExpense(AgencyStagingData agencyData, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        LOG.info((Object)("Reconciling expense for agency data: " + agencyData.getId() + " tripId: " + agencyData.getTripId()));
        ArrayList<ErrorMessage> errors = new ArrayList<ErrorMessage>();
        if (agencyData.isActive()) {
            if ("OK".equals(agencyData.getErrorCode())) {
                TemConstants.ExpenseTypeMetaCategory expenseTypeCategory = agencyData.getExpenseTypeCategory();
                CreditCardStagingData ccData = null;
                if (expenseTypeCategory == TemConstants.ExpenseTypeMetaCategory.AIRFARE) {
                    ccData = this.travelExpenseService.findImportedCreditCardExpense(agencyData.getTripExpenseAmount(), agencyData.getAirTicketNumber(), agencyData.getAirServiceFeeNumber());
                } else if (expenseTypeCategory == TemConstants.ExpenseTypeMetaCategory.LODGING) {
                    ccData = this.travelExpenseService.findImportedCreditCardExpense(agencyData.getTripExpenseAmount(), agencyData.getLodgingItineraryNumber());
                } else if (expenseTypeCategory == TemConstants.ExpenseTypeMetaCategory.RENTAL_CAR) {
                    ccData = this.travelExpenseService.findImportedCreditCardExpense(agencyData.getTripExpenseAmount(), agencyData.getRentalCarItineraryNumber());
                }
                if (ObjectUtils.isNotNull(ccData)) {
                    LOG.info((Object)("Found a match for Agency: " + agencyData.getId() + " Credit Card: " + ccData.getId() + " tripId: " + agencyData.getTripId()));
                    TravelDocument travelDocument = this.getTravelDocumentService().getParentTravelDocument(agencyData.getTripId());
                    ExpenseTypeObjectCode travelExpenseType = this.getTravelExpenseType(expenseTypeCategory, travelDocument);
                    if (travelExpenseType != null) {
                        if (this.isDocumentStatusValidForReconcilingCharges(agencyData)) {
                            if (this.isAccountingLinesMatch(agencyData)) {
                                ArrayList<TripAccountingInformation> accountingInfo = agencyData.getTripAccountingInformation();
                                HistoricalTravelExpense expense = this.travelExpenseService.createHistoricalTravelExpense(agencyData, ccData, travelExpenseType);
                                AgencyServiceFee serviceFee = this.getAgencyServiceFee(agencyData.getDistributionCode());
                                ArrayList<GeneralLedgerPendingEntry> entries = new ArrayList<GeneralLedgerPendingEntry>();
                                KualiDecimal remainingAmount = agencyData.getTripExpenseAmount();
                                KualiDecimal numAccounts = new KualiDecimal(accountingInfo.size());
                                KualiDecimal currentAmount = (KualiDecimal)agencyData.getTripExpenseAmount().divide((AbstractKualiDecimal)numAccounts);
                                KualiDecimal remainingFeeAmount = new KualiDecimal(0);
                                KualiDecimal currentFeeAmount = new KualiDecimal(0);
                                if (ObjectUtils.isNotNull((Object)((Object)serviceFee))) {
                                    remainingFeeAmount = serviceFee.getServiceFee();
                                    currentFeeAmount = (KualiDecimal)serviceFee.getServiceFee().divide((AbstractKualiDecimal)numAccounts);
                                }
                                String creditObjectCode = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "TRAVEL_CREDIT_CARD_CLEARING_OBJECT_CODE");
                                boolean allGlpesCreated = true;
                                for (int i = 0; i < accountingInfo.size(); ++i) {
                                    List<GeneralLedgerPendingEntry> pendingEntries;
                                    boolean generateOffset;
                                    TripAccountingInformation info = (TripAccountingInformation)((Object)accountingInfo.get(i));
                                    if (i < accountingInfo.size() - 1) {
                                        remainingAmount = (KualiDecimal)remainingAmount.subtract((AbstractKualiDecimal)currentAmount);
                                        remainingFeeAmount = (KualiDecimal)remainingFeeAmount.subtract((AbstractKualiDecimal)currentFeeAmount);
                                    } else {
                                        currentAmount = remainingAmount;
                                        currentFeeAmount = remainingFeeAmount;
                                    }
                                    String objectCode = info.getObjectCode();
                                    if (StringUtils.isEmpty((String)objectCode)) {
                                        objectCode = travelExpenseType.getFinancialObjectCode();
                                    }
                                    info.setAmount(currentAmount);
                                    if (ObjectUtils.isNotNull((Object)((Object)serviceFee))) {
                                        LOG.info((Object)("Processing Service Fee GLPE for agency: " + agencyData.getId() + " tripId: " + agencyData.getTripId()));
                                        generateOffset = true;
                                        pendingEntries = this.importedExpensePendingEntryService.buildDebitPendingEntry(agencyData, info, sequenceHelper, objectCode, currentFeeAmount, true);
                                        allGlpesCreated = this.importedExpensePendingEntryService.checkAndAddPendingEntriesToList(pendingEntries, entries, agencyData, false, true);
                                        pendingEntries = this.importedExpensePendingEntryService.buildServiceFeeCreditPendingEntry(agencyData, info, sequenceHelper, serviceFee, currentFeeAmount, true);
                                        allGlpesCreated &= this.importedExpensePendingEntryService.checkAndAddPendingEntriesToList(pendingEntries, entries, agencyData, true, true);
                                    }
                                    generateOffset = true;
                                    pendingEntries = this.importedExpensePendingEntryService.buildDebitPendingEntry(agencyData, info, sequenceHelper, objectCode, currentAmount, true);
                                    allGlpesCreated &= this.importedExpensePendingEntryService.checkAndAddPendingEntriesToList(pendingEntries, entries, agencyData, false, true);
                                    pendingEntries = this.importedExpensePendingEntryService.buildCreditPendingEntry(agencyData, info, sequenceHelper, creditObjectCode, currentAmount, true);
                                    allGlpesCreated &= this.importedExpensePendingEntryService.checkAndAddPendingEntriesToList(pendingEntries, entries, agencyData, true, true);
                                }
                                if (entries.size() > 0 && allGlpesCreated) {
                                    GeneralLedgerPendingEntry glpe = (GeneralLedgerPendingEntry)entries.get(0);
                                    expense.setDocumentNumber(glpe.getDocumentNumber());
                                    expense.setDocumentType(travelDocument.getDocumentTypeName());
                                    expense.setTravelCompany(ccData.getMerchantName());
                                    this.businessObjectService.save(entries);
                                    this.businessObjectService.save((PersistableBusinessObject)expense);
                                    ccData.setErrorCode("HIS");
                                    ccData.setMoveToHistoryIndicator(true);
                                    this.businessObjectService.save((PersistableBusinessObject)ccData);
                                    agencyData.setMoveToHistoryIndicator(true);
                                    agencyData.setErrorCode("HIS");
                                } else {
                                    LOG.error((Object)("An error occurred while creating GLPEs for agency data: " + agencyData.getId() + ", tripId: " + agencyData.getTripId() + ". Will not reconcile expense."));
                                    errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.glpeCreation", new String[0]));
                                }
                            } else {
                                LOG.error((Object)("The accounting lines on the agency data record do not have a match on the travel document. Agency data: " + agencyData.getId() + "; tripId: " + agencyData.getTripId() + "; documentNumber: " + travelDocument.getDocumentNumber()));
                                errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.accountingLineNoMatch", new String[]{travelDocument.getDocumentNumber()}));
                            }
                        } else {
                            LOG.error((Object)("The document has not been approved. Document Number: " + travelDocument.getDocumentNumber()));
                            errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.documentStatusInvalid", new String[]{travelDocument.getDocumentNumber()}));
                        }
                    } else {
                        LOG.info((Object)("No expense type object code could be found for agency data: " + agencyData.getId() + " tripId: " + agencyData.getTripId()));
                        errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.expenseTypeObjectCodeInvalid", new String[]{expenseTypeCategory.getCode(), travelDocument.getDocumentTypeName(), travelDocument.getTripTypeCode(), travelDocument.getTraveler().getTravelerTypeCode()}));
                    }
                } else {
                    LOG.info((Object)("No match found for agency data: " + agencyData.getId() + " tripId:" + agencyData.getTripId()));
                    if (expenseTypeCategory == TemConstants.ExpenseTypeMetaCategory.AIRFARE) {
                        errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.tripNoMatchAir", new String[]{agencyData.getTripExpenseAmount().toString(), agencyData.getAirTicketNumber(), agencyData.getAirServiceFeeNumber()}));
                    } else if (expenseTypeCategory == TemConstants.ExpenseTypeMetaCategory.LODGING) {
                        errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.tripNoMatch", new String[]{agencyData.getTripExpenseAmount().toString(), agencyData.getLodgingItineraryNumber()}));
                    } else if (expenseTypeCategory == TemConstants.ExpenseTypeMetaCategory.RENTAL_CAR) {
                        errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.tripNoMatch", new String[]{agencyData.getTripExpenseAmount().toString(), agencyData.getRentalCarItineraryNumber()}));
                    } else {
                        errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.invalidExpenseTypeCategory", new String[0]));
                    }
                }
            } else {
                LOG.info((Object)("Agency Data: " + agencyData.getId() + "; expected errorCode=" + "OK" + ", received errorCode=" + agencyData.getErrorCode() + ". Will not attempt to reconcile expense."));
                errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.errorCode", new String[]{"OK", agencyData.getErrorCode()}));
            }
        } else {
            LOG.info((Object)("Agency Data: " + agencyData.getId() + ", is not active. Will not attempt to reconcile expense."));
            errors.add(new ErrorMessage("message.batch.tem.agencydatareconciliation.active", new String[0]));
        }
        LOG.info((Object)("Finished reconciling expense for agency data: " + agencyData.getId() + ", Trip Id: " + agencyData.getTripId() + ". Agency data " + (errors.isEmpty() ? "was" : "was not") + " reconciled."));
        return errors;
    }

    protected boolean isAccountingLinesMatch(AgencyStagingData agencyStagingData) {
        ArrayList<TripAccountingInformation> agencyDataAccountingLines = agencyStagingData.getTripAccountingInformation();
        List<TemSourceAccountingLine> tripSourceAccountingLines = this.getSourceAccountingLinesByTrip(agencyStagingData.getTripId());
        Collection validationParams = this.getParameterService().getParameterValuesAsString(AgencyDataImportStep.class, "ACCOUNTING_LINE_VALIDATION");
        if (ObjectUtils.isNull((Object)validationParams)) {
            LOG.info((Object)"Did not find the parameter, ACCOUNTING_LINE_VALIDATION. Will not validate matching accounting lines.");
            return true;
        }
        for (TripAccountingInformation agencyAccount : agencyDataAccountingLines) {
            boolean foundAMatch = false;
            String documentNumbers = "";
            for (TemSourceAccountingLine sourceAccountingLine : tripSourceAccountingLines) {
                String sourceSubAccountNumber;
                String agencySubAccountNumber;
                String sourceAccountNumber;
                String agencyAccountNumber;
                boolean account = true;
                boolean subaccount = true;
                boolean objectcode = true;
                boolean subobjectcode = true;
                if (validationParams.contains("Account") && !StringUtils.equals((String)(agencyAccountNumber = StringUtils.trimToEmpty((String)agencyAccount.getTripAccountNumber())), (String)(sourceAccountNumber = StringUtils.trimToEmpty((String)sourceAccountingLine.getAccountNumber())))) {
                    account = false;
                }
                if (validationParams.contains("Sub-Account") && !StringUtils.equals((String)(agencySubAccountNumber = StringUtils.trimToEmpty((String)agencyAccount.getTripSubAccountNumber())), (String)(sourceSubAccountNumber = StringUtils.trimToEmpty((String)sourceAccountingLine.getSubAccountNumber())))) {
                    subaccount = false;
                }
                if (account && subaccount && objectcode && subobjectcode) {
                    LOG.debug((Object)("Found accounting line match on DocumentId: " + sourceAccountingLine.getDocumentNumber() + ", " + sourceAccountingLine));
                    foundAMatch = true;
                    break;
                }
                documentNumbers = documentNumbers + sourceAccountingLine.getDocumentNumber() + ",";
            }
            if (foundAMatch) continue;
            LOG.info((Object)("Agency accounting line did not match any document accounting lines: AgencyStgDataId: " + agencyAccount.getAgencyStagingDataId() + ",trpAcctInfoId: " + agencyAccount.getId() + ", documentNumbers:[" + documentNumbers + "]"));
            return false;
        }
        return true;
    }

    protected ExpenseTypeObjectCode getTravelExpenseType(TemConstants.ExpenseTypeMetaCategory expenseCategory, TravelDocument travelDoc) {
        ExpenseType expenseType = this.getTravelExpenseService().getDefaultExpenseTypeForCategory(expenseCategory);
        if (ObjectUtils.isNotNull((Object)travelDoc)) {
            ExpenseTypeObjectCode expenseTypeObjectCode = this.travelExpenseService.getExpenseType(expenseType.getCode(), travelDoc.getDocumentTypeName(), travelDoc.getTripTypeCode(), travelDoc.getTraveler().getTravelerTypeCode());
            if (expenseTypeObjectCode == null) {
                LOG.error((Object)("Unable to retrieve ExpenseTypeObjectCode for ExpenseTypeCode:" + expenseType.getCode() + ", DocTypeName:" + travelDoc.getDocumentTypeName() + ", TripType:" + travelDoc.getTripTypeCode() + ", TravelerType:" + travelDoc.getTraveler().getTravelerTypeCode()));
            }
            return expenseTypeObjectCode;
        }
        LOG.error((Object)"Unable to retrieve TemTravelExpenseTypeCode");
        return null;
    }

    protected AgencyServiceFee getAgencyServiceFee(String distributionCode) {
        if (StringUtils.isNotEmpty((String)distributionCode)) {
            HashMap<String, String> criteria = new HashMap<String, String>(1);
            criteria.put("code", distributionCode);
            criteria.put("active", "Y");
            List serviceFee = (List)this.getBusinessObjectService().findMatching(AgencyServiceFee.class, criteria);
            if (ObjectUtils.isNotNull((Object)serviceFee) && serviceFee.size() > 0) {
                return (AgencyServiceFee)((Object)serviceFee.get(0));
            }
        }
        return null;
    }

    protected List<TemSourceAccountingLine> getSourceAccountingLinesByTrip(String travelDocumentIdentifier) {
        Collection<String> travelDocumentNumbers = this.getTravelDocumentService().getApprovedTravelDocumentNumbersByTrip(travelDocumentIdentifier);
        LOG.info((Object)("Will attempt to retrieve source accounting lines for the following documents: " + travelDocumentNumbers));
        ArrayList<TemSourceAccountingLine> temSourceAccountingLines = new ArrayList<TemSourceAccountingLine>();
        if (!travelDocumentNumbers.isEmpty()) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put("documentNumber", travelDocumentNumbers);
            fieldValues.put("financialDocumentLineTypeCode", "F");
            temSourceAccountingLines.addAll(this.getBusinessObjectService().findMatchingOrderBy(TemSourceAccountingLine.class, fieldValues, "sequenceNumber", true));
        }
        return temSourceAccountingLines;
    }

    protected boolean isDocumentStatusValidForReconcilingCharges(AgencyStagingData agencyData) {
        TravelDocument parentDocument = this.getTravelDocumentService().getParentTravelDocument(agencyData.getTripId());
        return this.getTravelDocumentService().isDocumentStatusValidForReconcilingCharges(parentDocument);
    }

    public TravelAuthorizationService getTravelAuthorizationService() {
        return this.travelAuthorizationService;
    }

    public void setTravelAuthorizationService(TravelAuthorizationService travelAuthorizationService) {
        this.travelAuthorizationService = travelAuthorizationService;
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public TravelExpenseService getTravelExpenseService() {
        return this.travelExpenseService;
    }

    public void setTravelExpenseService(TravelExpenseService travelExpenseService) {
        this.travelExpenseService = travelExpenseService;
    }

    public ImportedExpensePendingEntryService getImportedExpensePendingEntryService() {
        return this.importedExpensePendingEntryService;
    }

    public void setImportedExpensePendingEntryService(ImportedExpensePendingEntryService importedExpensePendingEntryService) {
        this.importedExpensePendingEntryService = importedExpensePendingEntryService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public TravelEncumbranceService getTravelEncumbranceService() {
        return this.travelEncumbranceService;
    }

    public void setTravelEncumbranceService(TravelEncumbranceService travelEncumbranceService) {
        this.travelEncumbranceService = travelEncumbranceService;
    }
}

