/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.CreditCardAgency;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.dataaccess.TravelDocumentDao;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelPaymentsHelperService;
import org.kuali.kfs.pdp.PdpConstants;
import org.kuali.kfs.pdp.businessobject.PaymentAccountDetail;
import org.kuali.kfs.pdp.businessobject.PaymentDetail;
import org.kuali.kfs.pdp.businessobject.PaymentGroup;
import org.kuali.kfs.pdp.businessobject.PaymentNoteText;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.batch.service.PaymentSourceToExtractService;
import org.kuali.kfs.sys.businessobject.AccountingLine;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.document.PaymentSource;
import org.kuali.kfs.sys.document.service.PaymentSourceHelperService;
import org.kuali.kfs.sys.document.validation.event.AccountingDocumentSaveWithNoLedgerEntryGenerationEvent;
import org.kuali.kfs.vnd.businessobject.VendorAddress;
import org.kuali.kfs.vnd.businessobject.VendorDetail;
import org.kuali.kfs.vnd.document.service.VendorService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CorporateCardExtractionServiceImpl
implements PaymentSourceToExtractService<TEMReimbursementDocument> {
    static Logger LOG = Logger.getLogger(CorporateCardExtractionServiceImpl.class);
    protected ParameterService parameterService;
    protected DocumentService documentService;
    protected TravelDocumentDao travelDocumentDao;
    protected PaymentSourceHelperService paymentSourceHelperService;
    protected TravelPaymentsHelperService travelPaymentsHelperService;
    protected BusinessObjectService businessObjectService;
    protected VendorService vendorService;

    public Map<String, List<TEMReimbursementDocument>> retrievePaymentSourcesByCampus(boolean immediatesOnly) {
        boolean disburseCorporateCardPayments;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"retrievePaymentSourcesByCampus() started");
        }
        if (!(disburseCorporateCardPayments = this.getParameterService().getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "CORPORATE_CARD_PAYMENT_IND").booleanValue())) {
            return new HashMap<String, List<TEMReimbursementDocument>>();
        }
        HashMap<String, List<TEMReimbursementDocument>> documentsByCampus = new HashMap<String, List<TEMReimbursementDocument>>();
        List<TEMReimbursementDocument> reimbursables = this.retrieveAllCorporateCardDocuments(immediatesOnly);
        HashMap<String, String> initiatorCampuses = new HashMap<String, String>();
        for (TEMReimbursementDocument document : reimbursables) {
            String campusCode;
            if (!document.isCorporateCardPayable() || !this.shouldExtractPayment(document) || StringUtils.isBlank((String)(campusCode = this.getTravelPaymentsHelperService().findCampusForDocument(document, initiatorCampuses)))) continue;
            ArrayList<TEMReimbursementDocument> documentsForCampus = (ArrayList<TEMReimbursementDocument>)documentsByCampus.get(campusCode);
            if (documentsForCampus == null) {
                documentsForCampus = new ArrayList<TEMReimbursementDocument>();
                documentsByCampus.put(campusCode, documentsForCampus);
            }
            documentsForCampus.add(document);
        }
        return documentsByCampus;
    }

    protected List<TEMReimbursementDocument> retrieveAllCorporateCardDocuments(boolean immediatesOnly) {
        ArrayList<TEMReimbursementDocument> allReimbursables = new ArrayList<TEMReimbursementDocument>();
        allReimbursables.addAll(this.getTravelDocumentDao().getReimbursementDocumentsNeedingCorporateCardExtraction());
        allReimbursables.addAll(this.getTravelDocumentDao().getEntertainmentDocumentsNeedingCorporateCardExtraction());
        allReimbursables.addAll(this.getTravelDocumentDao().getRelocationDocumentsNeedingCorporateCardExtraction());
        return allReimbursables;
    }

    public String getPreDisbursementCustomerProfileUnit() {
        String unit = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PRE_DISBURSEMENT_EXTRACT_ORGANIZATION");
        return unit;
    }

    public String getPreDisbursementCustomerProfileSubUnit() {
        String subUnit = this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "PRE_DISBURSEMENT_EXTRACT_SUB_UNIT");
        return subUnit;
    }

    public void markAsExtracted(TEMReimbursementDocument document, Date sqlProcessRunDate, KualiInteger paymentGroupId) {
        try {
            document.setCorporateCardPaymentExtractDate(sqlProcessRunDate);
            this.associatePaymentGroupWithCreditCardData(document, paymentGroupId);
            this.getDocumentService().saveDocument((Document)document, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            LOG.error((Object)("Could not save TEMReimbursementDocument document #" + document.getDocumentNumber() + ": " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    protected void associatePaymentGroupWithCreditCardData(TEMReimbursementDocument document, KualiInteger paymentGroupNumber) {
        for (HistoricalTravelExpense expense : document.getHistoricalTravelExpenses()) {
            if (expense.getCreditCardStagingData() == null || !StringUtils.equals((String)expense.getCreditCardStagingData().getCreditCardAgency().getTravelCardTypeCode(), (String)"CORP")) continue;
            expense.getCreditCardStagingData().setPaymentGroupId(paymentGroupNumber);
            this.getBusinessObjectService().save((PersistableBusinessObject)expense.getCreditCardStagingData());
        }
    }

    public PaymentGroup createPaymentGroup(TEMReimbursementDocument document, Date processRunDate) {
        boolean disburseCorporateCardPayments;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"createPaymentGroupForReimbursable() started");
        }
        if (!(disburseCorporateCardPayments = this.getParameterService().getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "CORPORATE_CARD_PAYMENT_IND").booleanValue())) {
            return null;
        }
        PaymentGroup pg = new PaymentGroup();
        CreditCardAgency creditCardAgency = this.getCorporateCreditCardAgency(document);
        if (creditCardAgency == null) {
            LOG.error((Object)("Skipping corporate card payment for " + document.getDocumentNumber() + " because no credit card agency could be found."));
            return null;
        }
        VendorDetail vendor = this.getCorporateCardVendor(creditCardAgency);
        if (vendor == null) {
            LOG.error((Object)("Skipping corporate card payment for " + document.getDocumentNumber() + " because no vendor could be found."));
            return null;
        }
        VendorAddress vendorAddress = this.getVendorService().getVendorDefaultAddress((Collection)vendor.getVendorAddresses(), vendor.getVendorHeader().getVendorType().getAddressType().getVendorAddressTypeCode(), "");
        pg.setCombineGroups(Boolean.TRUE);
        pg.setCampusAddress(Boolean.FALSE);
        pg.setCity(vendorAddress.getVendorCityName());
        pg.setCountry(vendorAddress.getVendorCountryCode());
        pg.setLine1Address(vendorAddress.getVendorLine1Address());
        pg.setLine2Address(vendorAddress.getVendorLine2Address());
        pg.setPayeeName(vendor.getVendorName());
        pg.setState(vendorAddress.getVendorStateCode());
        pg.setZipCd(vendorAddress.getVendorZipCode());
        pg.setPaymentDate(this.getNextDate(processRunDate));
        pg.setProcessImmediate(Boolean.valueOf(false));
        pg.setPymtAttachment(Boolean.valueOf(false));
        pg.setPymtSpecialHandling(Boolean.valueOf(false));
        pg.setNraPayment(Boolean.valueOf(false));
        pg.setBankCode(creditCardAgency.getBankCode());
        pg.setPaymentStatusCode(PdpConstants.PaymentStatusCodes.OPEN);
        if (StringUtils.equals((String)document.getTraveler().getTravelerTypeCode(), (String)"EMP")) {
            pg.setEmployeeIndicator(Boolean.valueOf(true));
        }
        pg.setPayeeId(vendor.getVendorNumber());
        pg.setPayeeIdTypeCd(PdpConstants.PayeeIdTypeCodes.VENDOR_ID);
        pg.setTaxablePayment(Boolean.FALSE);
        pg.setPayeeOwnerCd(vendor.getVendorHeader().getVendorOwnershipCode());
        PaymentDetail paymentDetail = this.buildPaymentDetail(document, processRunDate);
        pg.addPaymentDetails(paymentDetail);
        paymentDetail.setPaymentGroup(pg);
        return pg;
    }

    protected VendorDetail getCorporateCardVendor(CreditCardAgency creditCardAgency) {
        String vendorNumber;
        if (!ObjectUtils.isNull((Object)((Object)creditCardAgency)) && !StringUtils.isBlank((String)(vendorNumber = creditCardAgency.getVendorNumber()))) {
            return this.getVendorService().getByVendorNumber(vendorNumber);
        }
        return null;
    }

    protected CreditCardAgency getCorporateCreditCardAgency(TEMReimbursementDocument document) {
        for (ImportedExpense importedExpense : document.getImportedExpenses()) {
            if (!StringUtils.equals((String)importedExpense.getCardType(), (String)"CORP") || ObjectUtils.isNull((Object)((Object)importedExpense.getHistoricalTravelExpense()))) continue;
            importedExpense.getHistoricalTravelExpense().refreshReferenceObject("creditCardAgency");
            if (ObjectUtils.isNull((Object)((Object)importedExpense.getHistoricalTravelExpense().getCreditCardAgency())) || StringUtils.isBlank((String)importedExpense.getHistoricalTravelExpense().getCreditCardAgency().getVendorNumber())) continue;
            return importedExpense.getHistoricalTravelExpense().getCreditCardAgency();
        }
        return null;
    }

    protected String findCorporateCardVendorNumber(TEMReimbursementDocument document) {
        CreditCardAgency creditCardAgency = this.getCorporateCreditCardAgency(document);
        if (!ObjectUtils.isNull((Object)((Object)creditCardAgency))) {
            return creditCardAgency.getVendorNumber();
        }
        return null;
    }

    protected Date getNextDate(Date processDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(processDate.getTime());
        cal.add(5, 1);
        return new Date(cal.getTimeInMillis());
    }

    protected PaymentDetail buildPaymentDetail(TEMReimbursementDocument document, Date processRunDate) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"buildPaymentDetail() started");
        }
        PaymentDetail pd = new PaymentDetail();
        if (StringUtils.isNotEmpty((String)document.getDocumentHeader().getOrganizationDocumentNumber())) {
            pd.setOrganizationDocNbr(document.getDocumentHeader().getOrganizationDocumentNumber());
        }
        pd.setCustPaymentDocNbr(document.getDocumentNumber());
        pd.setInvoiceDate(new Date(processRunDate.getTime()));
        pd.setOrigInvoiceAmount(this.getPaymentAmount(document));
        pd.setInvTotDiscountAmount(KualiDecimal.ZERO);
        pd.setInvTotOtherCreditAmount(KualiDecimal.ZERO);
        pd.setInvTotOtherDebitAmount(KualiDecimal.ZERO);
        pd.setInvTotShipAmount(KualiDecimal.ZERO);
        pd.setNetPaymentAmount(this.getPaymentAmount(document));
        pd.setPrimaryCancelledPayment(Boolean.FALSE);
        pd.setFinancialDocumentTypeCode(this.getAchCheckDocumentType(document));
        pd.setFinancialSystemOriginCode("01");
        pd.setPurchaseOrderNbr(document.getTravelDocumentIdentifier());
        pd.setOrganizationDocNbr(document.getTravelDocumentIdentifier());
        int line = 0;
        PaymentNoteText pnt = new PaymentNoteText();
        pnt.setCustomerNoteLineNbr(new KualiInteger((long)line++));
        String travelerId = !ObjectUtils.isNull((Object)((Object)document.getTemProfile())) ? (!ObjectUtils.isNull((Object)document.getTemProfile().getPrincipal()) ? document.getTemProfile().getPrincipal().getPrincipalName() : document.getTemProfile().getCustomerNumber()) : document.getDocumentNumber();
        pnt.setCustomerNoteText("Info: " + travelerId + " " + document.getTemProfile().getPhoneNumber());
        pd.addNote(pnt);
        String text = document.getDocumentHeader().getDocumentDescription();
        if (!StringUtils.isBlank((String)text)) {
            pnt = this.getPaymentSourceHelperService().buildNoteForCheckStubText(text, line);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating check stub text note: " + pnt.getCustomerNoteText()));
            }
            pd.addNote(pnt);
        }
        ArrayList<TemSourceAccountingLine> corporateCardLines = new ArrayList<TemSourceAccountingLine>();
        for (TemSourceAccountingLine accountingLine : document.getSourceAccountingLines()) {
            if (!StringUtils.equals((String)"CORP", (String)accountingLine.getCardType())) continue;
            corporateCardLines.add(accountingLine);
        }
        List<PaymentAccountDetail> paymentAccounts = this.buildPaymentAccountDetails(corporateCardLines);
        for (PaymentAccountDetail pad : paymentAccounts) {
            pd.addAccountDetail(pad);
        }
        return pd;
    }

    protected List<PaymentAccountDetail> buildPaymentAccountDetails(List<? extends AccountingLine> accountingLines) {
        ArrayList<PaymentAccountDetail> details = new ArrayList<PaymentAccountDetail>();
        for (AccountingLine accountingLine : accountingLines) {
            TemSourceAccountingLine accountingLine2 = (TemSourceAccountingLine)accountingLine;
            if (!StringUtils.equals((String)accountingLine2.getCardType(), (String)"CORP")) continue;
            PaymentAccountDetail pad = new PaymentAccountDetail();
            pad.setFinChartCode(accountingLine2.getChartOfAccountsCode());
            pad.setAccountNbr(accountingLine2.getAccountNumber());
            if (!StringUtils.isBlank((String)accountingLine2.getSubAccountNumber())) {
                pad.setSubAccountNbr(accountingLine2.getSubAccountNumber());
            } else {
                pad.setSubAccountNbr(KFSConstants.getDashSubAccountNumber());
            }
            pad.setFinObjectCode(accountingLine2.getFinancialObjectCode());
            if (!StringUtils.isBlank((String)accountingLine2.getFinancialSubObjectCode())) {
                pad.setFinSubObjectCode(accountingLine2.getFinancialSubObjectCode());
            } else {
                pad.setFinSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
            }
            if (!StringUtils.isBlank((String)accountingLine2.getOrganizationReferenceId())) {
                pad.setOrgReferenceId(accountingLine2.getOrganizationReferenceId());
            }
            if (!StringUtils.isBlank((String)accountingLine2.getProjectCode())) {
                pad.setProjectCode(accountingLine2.getProjectCode());
            } else {
                pad.setProjectCode(KFSConstants.getDashProjectCode());
            }
            pad.setAccountNetAmount(accountingLine2.getAmount());
            details.add(pad);
        }
        return details;
    }

    public KualiDecimal getPaymentAmount(TEMReimbursementDocument document) {
        KualiDecimal amount = KualiDecimal.ZERO;
        for (TemSourceAccountingLine line : document.getSourceAccountingLines()) {
            if (!StringUtils.equals((String)line.getCardType(), (String)"CORP")) continue;
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)line.getAmount());
        }
        return amount;
    }

    public void markAsPaid(TEMReimbursementDocument paymentSource, Date processDate) {
        try {
            paymentSource.setCorporateCardPaymentPaidDate(processDate);
            this.getDocumentService().saveDocument((Document)paymentSource, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + paymentSource.getDocumentNumber() + " " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    public void cancelPayment(TEMReimbursementDocument paymentSource, Date cancelDate) {
        if (paymentSource.getCorporateCardPaymentCancelDate() == null) {
            try {
                paymentSource.setCorporateCardPaymentCancelDate(cancelDate);
                this.getPaymentSourceHelperService().handleEntryCancellation((PaymentSource)paymentSource, (PaymentSourceToExtractService)this);
                this.getDocumentService().saveDocument((Document)paymentSource, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
            }
            catch (WorkflowException we) {
                LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + paymentSource.getDocumentNumber() + " " + (Object)((Object)we)));
                throw new RuntimeException(we);
            }
        }
    }

    public boolean shouldRollBackPendingEntry(GeneralLedgerPendingEntry entry) {
        return StringUtils.equals((String)"RCCA", (String)entry.getFinancialDocumentTypeCode());
    }

    public void resetFromExtraction(TEMReimbursementDocument paymentSource) {
        try {
            paymentSource.setCorporateCardPaymentExtractDate(null);
            paymentSource.setCorporateCardPaymentPaidDate(null);
            this.getDocumentService().saveDocument((Document)paymentSource, AccountingDocumentSaveWithNoLedgerEntryGenerationEvent.class);
        }
        catch (WorkflowException we) {
            LOG.error((Object)("encountered workflow exception while attempting to save Disbursement Voucher: " + paymentSource.getDocumentNumber() + " " + (Object)((Object)we)));
            throw new RuntimeException(we);
        }
    }

    public String getImmediateExtractEMailFromAddress() {
        return this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_DOCUMENT.class, "IMMEDIATE_EXTRACT_NOTIFICATION_FROM_EMAIL_ADDRESS");
    }

    public List<String> getImmediateExtractEmailToAddresses() {
        ArrayList<String> toAddresses = new ArrayList<String>();
        toAddresses.addAll(this.getParameterService().getParameterValuesAsString(TemParameterConstants.TEM_DOCUMENT.class, "IMMEDIATE_EXTRACT_NOTIFICATION_TO_EMAIL_ADDRESSES"));
        return toAddresses;
    }

    public String getAchCheckDocumentType(TEMReimbursementDocument paymentSource) {
        return "RCCA";
    }

    public boolean handlesAchCheckDocumentType(String achCheckDocumentType) {
        return StringUtils.equals((String)"RCCA", (String)achCheckDocumentType);
    }

    public boolean shouldExtractPayment(TEMReimbursementDocument paymentSource) {
        return KualiDecimal.ZERO.isLessThan((AbstractKualiDecimal)this.getPaymentAmount(paymentSource));
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public TravelDocumentDao getTravelDocumentDao() {
        return this.travelDocumentDao;
    }

    public void setTravelDocumentDao(TravelDocumentDao travelDocumentDao) {
        this.travelDocumentDao = travelDocumentDao;
    }

    public PaymentSourceHelperService getPaymentSourceHelperService() {
        return this.paymentSourceHelperService;
    }

    public void setPaymentSourceHelperService(PaymentSourceHelperService paymentSourceHelperService) {
        this.paymentSourceHelperService = paymentSourceHelperService;
    }

    public TravelPaymentsHelperService getTravelPaymentsHelperService() {
        return this.travelPaymentsHelperService;
    }

    public void setTravelPaymentsHelperService(TravelPaymentsHelperService travelPaymentsHelperService) {
        this.travelPaymentsHelperService = travelPaymentsHelperService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public VendorService getVendorService() {
        return this.vendorService;
    }

    public void setVendorService(VendorService vendorService) {
        this.vendorService = vendorService;
    }
}

