/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.Date;
import java.util.List;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PerDiemExpenseValidation
extends GenericValidation {
    protected DictionaryValidationService dictionaryValidationService;
    protected DateTimeService dateTimeService;
    protected Boolean incidentalsWithMealsOnlyInd;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        TravelDocument travelDocument = (TravelDocument)event.getDocument();
        List errorPath = GlobalVariables.getMessageMap().getErrorPath();
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().addToErrorPath("document");
        int counter = 0;
        for (PerDiemExpense perDiem : travelDocument.getPerDiemExpenses()) {
            String path = "perDiemExpenses[" + counter + "]";
            GlobalVariables.getMessageMap().addToErrorPath(path);
            success = this.validatePerDiemValues(perDiem);
            if (success) {
                success &= this.validatePerDiemIncidentals(perDiem);
            }
            GlobalVariables.getMessageMap().removeFromErrorPath(path);
            ++counter;
        }
        GlobalVariables.getMessageMap().clearErrorPath();
        GlobalVariables.getMessageMap().getErrorPath().addAll(errorPath);
        return success;
    }

    protected boolean validatePerDiemValues(PerDiemExpense perDiemExpense) {
        boolean success = true;
        if (perDiemExpense.getUnfilteredBreakfastValue() != null && perDiemExpense.getUnfilteredBreakfastValue().isNegative() || perDiemExpense.getUnfilteredLunchValue() != null && perDiemExpense.getUnfilteredLunchValue().isNegative() || perDiemExpense.getUnfilteredDinnerValue() != null && perDiemExpense.getUnfilteredDinnerValue().isNegative() || perDiemExpense.getUnfilteredIncidentalsValue() != null && perDiemExpense.getUnfilteredIncidentalsValue().isNegative() || perDiemExpense.getUnfilteredLodging() != null && perDiemExpense.getUnfilteredLodging().isNegative() || perDiemExpense.getUnfilteredMiles() != null && perDiemExpense.getUnfilteredMiles() < 0) {
            GlobalVariables.getMessageMap().putError("mileageDate", "error.document.per.diem.less.than.zero", new String[0]);
            success = false;
        }
        return success;
    }

    protected boolean validatePerDiemIncidentals(PerDiemExpense perDiemExpense) {
        boolean success = true;
        if (this.isIncidentalsWithMealsOnlyInd() && perDiemExpense.getIncidentalsValue() != null && perDiemExpense.getIncidentalsValue().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && (perDiemExpense.getBreakfastValue() == null || perDiemExpense.getBreakfastValue().equals((Object)KualiDecimal.ZERO)) && (perDiemExpense.getLunchValue() == null || perDiemExpense.getLunchValue().equals((Object)KualiDecimal.ZERO)) && (perDiemExpense.getDinnerValue() == null || perDiemExpense.getDinnerValue().equals((Object)KualiDecimal.ZERO))) {
            GlobalVariables.getMessageMap().putError("unfilteredIncidentalsValue", "error.document.per.diem.incidentals.but.no.meals", new String[]{this.getDateTimeService().toDateString((Date)perDiemExpense.getMileageDate())});
            success = false;
        }
        return success;
    }

    protected boolean isIncidentalsWithMealsOnlyInd() {
        if (this.incidentalsWithMealsOnlyInd == null) {
            this.incidentalsWithMealsOnlyInd = (boolean)((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(TemParameterConstants.TEM_DOCUMENT.class, "INCIDENTALS_WITH_MEALS_IND", Boolean.FALSE);
        }
        return this.incidentalsWithMealsOnlyInd;
    }

    public final DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }
}

