/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemConstants;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.MileageRate;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.springframework.util.AutoPopulatingList;

public abstract class TemDocumentExpenseLineValidation
extends GenericValidation {
    protected boolean warningOnly = true;
    protected BusinessObjectService businessObjectService;
    protected DictionaryValidationService dictionaryValidationService;

    protected boolean validatePerDiemRules(ActualExpense actualExpense, TravelDocument document) {
        boolean success = true;
        TemConstants.PerDiemType perDiem = null;
        if (actualExpense.isMileage() && this.isPerDiemMileageEntered(actualExpense.getExpenseDate(), document.getPerDiemExpenses())) {
            perDiem = TemConstants.PerDiemType.mileage;
        } else if (actualExpense.isLodging() && this.isPerDiemLodgingEntered(actualExpense.getExpenseDate(), document.getPerDiemExpenses())) {
            perDiem = TemConstants.PerDiemType.lodging;
        } else if (actualExpense.isIncidental() && this.isPerDiemIncidentalEntered(actualExpense.getExpenseDate(), document.getPerDiemExpenses())) {
            perDiem = TemConstants.PerDiemType.incidentals;
        } else if (actualExpense.isBreakfast() && this.isPerDiemBreakfastEntered(actualExpense.getExpenseDate(), document.getPerDiemExpenses())) {
            perDiem = TemConstants.PerDiemType.breakfast;
        } else if (actualExpense.isLunch() && this.isPerDiemLunchEntered(actualExpense.getExpenseDate(), document.getPerDiemExpenses())) {
            perDiem = TemConstants.PerDiemType.lunch;
        } else if (actualExpense.isDinner() && this.isPerDiemDinnerEntered(actualExpense.getExpenseDate(), document.getPerDiemExpenses())) {
            perDiem = TemConstants.PerDiemType.dinner;
        }
        if (perDiem != null) {
            success &= this.addPerDiemError(perDiem, this.isWarningOnly());
        }
        return success;
    }

    protected boolean addPerDiemError(TemConstants.PerDiemType perDiem, boolean warningOnly) {
        boolean success = true;
        if (warningOnly) {
            GlobalVariables.getMessageMap().putWarning("expenseTypeObjectCodeId", "warning.document.tem.actualexpense.duplicateExpenseType", new String[]{perDiem.label});
        } else {
            success = false;
            GlobalVariables.getMessageMap().putError("expenseTypeObjectCodeId", "warning.document.tem.actualexpense.duplicateExpenseType", new String[]{perDiem.label});
            String matchingErrorPath = StringUtils.join((Collection)GlobalVariables.getMessageMap().getErrorPath(), (String)".") + "." + "expenseTypeObjectCodeId";
            GlobalVariables.getMessageMap().removeAllWarningMessagesForProperty(matchingErrorPath);
        }
        return success;
    }

    protected boolean isPerDiemMileageEntered(Date expenseDate, List<PerDiemExpense> perDiemExpenses) {
        for (PerDiemExpense perDiemExpenseLine : perDiemExpenses) {
            if (!KfsDateUtils.isSameDay((java.util.Date)perDiemExpenseLine.getMileageDate(), (java.util.Date)expenseDate) || !ObjectUtils.isNotNull((Object)perDiemExpenseLine.getMiles()) || perDiemExpenseLine.getMiles() <= 0) continue;
            return true;
        }
        return false;
    }

    protected boolean isPerDiemMealsEntered(Date expenseDate, List<PerDiemExpense> perDiemExpenses) {
        for (PerDiemExpense perDiemExpenseLine : perDiemExpenses) {
            if (!KfsDateUtils.isSameDay((java.util.Date)perDiemExpenseLine.getMileageDate(), (java.util.Date)expenseDate) || !ObjectUtils.isNotNull((Object)perDiemExpenseLine.getMealsAndIncidentals()) || !perDiemExpenseLine.getMealsAndIncidentals().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO) && !perDiemExpenseLine.getMealsTotal().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPerDiemLodgingEntered(Date expenseDate, List<PerDiemExpense> perDiemExpenses) {
        for (PerDiemExpense perDiemExpenseLine : perDiemExpenses) {
            if (!KfsDateUtils.isSameDay((java.util.Date)perDiemExpenseLine.getMileageDate(), (java.util.Date)expenseDate) || !ObjectUtils.isNotNull((Object)perDiemExpenseLine.getLodgingTotal()) || !perDiemExpenseLine.getLodgingTotal().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPerDiemIncidentalEntered(Date expenseDate, List<PerDiemExpense> perDiemExpenses) {
        for (PerDiemExpense perDiemExpenseLine : perDiemExpenses) {
            if (!KfsDateUtils.isSameDay((java.util.Date)perDiemExpenseLine.getMileageDate(), (java.util.Date)expenseDate) || !perDiemExpenseLine.getLodgingTotal().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPerDiemBreakfastEntered(Date expenseDate, List<PerDiemExpense> perDiemExpenses) {
        for (PerDiemExpense perDiemExpenseLine : perDiemExpenses) {
            if (!KfsDateUtils.isSameDay((java.util.Date)perDiemExpenseLine.getMileageDate(), (java.util.Date)expenseDate) || !perDiemExpenseLine.getBreakfastValue().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPerDiemLunchEntered(Date expenseDate, List<PerDiemExpense> perDiemExpenses) {
        for (PerDiemExpense perDiemExpenseLine : perDiemExpenses) {
            if (!KfsDateUtils.isSameDay((java.util.Date)perDiemExpenseLine.getMileageDate(), (java.util.Date)expenseDate) || !perDiemExpenseLine.getLunchValue().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPerDiemDinnerEntered(Date expenseDate, List<PerDiemExpense> perDiemExpenses) {
        for (PerDiemExpense perDiemExpenseLine : perDiemExpenses) {
            if (!KfsDateUtils.isSameDay((java.util.Date)perDiemExpenseLine.getMileageDate(), (java.util.Date)expenseDate) || !perDiemExpenseLine.getDinnerValue().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) continue;
            return true;
        }
        return false;
    }

    protected boolean validateAirfareRules(ActualExpense actualExpense, TravelDocument document) {
        boolean success = true;
        MessageMap message = GlobalVariables.getMessageMap();
        if (actualExpense.isAirfare() && StringUtils.isEmpty((String)actualExpense.getDescription())) {
            boolean justificationAdded = false;
            for (TemExpense temExpense : actualExpense.getExpenseDetails()) {
                justificationAdded = !StringUtils.isEmpty((String)temExpense.getDescription());
            }
            if (!message.containsMessageKey("description") && !justificationAdded) {
                if (this.isWarningOnly()) {
                    message.putWarning("description", "warning.document.tem.actualexpense.notesJustification", new String[0]);
                } else {
                    this.removeWarningsForProperty("description");
                    message.putError("description", "warning.document.tem.actualexpense.notesJustification", new String[0]);
                    success = false;
                }
            }
        }
        return success;
    }

    protected void removeWarningsForProperty(String propertyName) {
        String fullPropertyName = StringUtils.join((Collection)GlobalVariables.getMessageMap().getErrorPath(), (String)".") + "." + propertyName;
        AutoPopulatingList warningMessages = GlobalVariables.getMessageMap().getWarningMessagesForProperty(fullPropertyName);
        if (warningMessages != null && !warningMessages.isEmpty()) {
            GlobalVariables.getMessageMap().removeAllWarningMessagesForProperty(fullPropertyName);
        }
    }

    public boolean validateRentalCarRules(ActualExpense expense, TravelDocument document) {
        boolean success = true;
        MessageMap message = GlobalVariables.getMessageMap();
        if (ObjectUtils.isNotNull((Object)((Object)expense.getExpenseTypeObjectCode())) && expense.getExpenseTypeObjectCode().isSpecialRequestRequired() && StringUtils.isBlank((String)expense.getDescription())) {
            boolean justificationAdded = false;
            for (TemExpense temExpense : expense.getExpenseDetails()) {
                justificationAdded = !StringUtils.isEmpty((String)temExpense.getDescription());
            }
            if (!message.containsMessageKey("description") && !justificationAdded) {
                if (this.isWarningOnly()) {
                    message.putWarning("description", "warning.document.tem.actualexpense.notesJustification", new String[0]);
                } else {
                    this.removeWarningsForProperty("description");
                    message.putError("description", "warning.document.tem.actualexpense.notesJustification", new String[0]);
                    success = false;
                }
            }
        }
        return success;
    }

    public BigDecimal getMaxMileageRate() {
        BigDecimal maxMileage = BigDecimal.ZERO;
        Collection mileageRates = this.getBusinessObjectService().findAll(MileageRate.class);
        for (MileageRate mileageRate : mileageRates) {
            if (mileageRate.getRate().compareTo(maxMileage) <= 0) continue;
            maxMileage = mileageRate.getRate();
        }
        return maxMileage;
    }

    public boolean isWarningOnly() {
        return this.warningOnly;
    }

    public void setWarningOnly(boolean warningOnly) {
        this.warningOnly = warningOnly;
    }

    public final DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

