/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.document.TravelArrangerDocument;
import org.kuali.kfs.module.tem.document.service.TravelArrangerDocumentService;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class TravelerOnlyOnePrimaryArranger
extends GenericValidation {
    private TravelArrangerDocumentService arrangerDocumentService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean success = true;
        TravelArrangerDocument document = (TravelArrangerDocument)event.getDocument();
        Integer profileId = document.getProfileId();
        String arrangerId = document.getArrangerId();
        if (!document.getPrimaryInd().booleanValue()) {
            return success;
        }
        if (ObjectUtils.isNotNull((Object)profileId)) {
            document.refreshReferenceObject("profile");
        }
        if (ObjectUtils.isNotNull((Object)((Object)this.arrangerDocumentService.findPrimaryTravelProfileArranger(arrangerId, profileId)))) {
            GlobalVariables.getMessageMap().putError("primaryInd", "error.tta.arrangerOnePrimary", new String[0]);
            return false;
        }
        return success;
    }

    public TravelArrangerDocumentService getArrangerDocumentService() {
        return this.arrangerDocumentService;
    }

    public void setArrangerDocumentService(TravelArrangerDocumentService arrangerDocumentService) {
        this.arrangerDocumentService = arrangerDocumentService;
    }
}

