/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ar.AccountsReceivableOrganizationOptions;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.uif.field.LinkField;
import org.kuali.kfs.module.tem.businessobject.ActualExpense;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeAware;
import org.kuali.kfs.module.tem.businessobject.GroupTraveler;
import org.kuali.kfs.module.tem.businessobject.PerDiem;
import org.kuali.kfs.module.tem.businessobject.PerDiemExpense;
import org.kuali.kfs.module.tem.businessobject.SpecialCircumstances;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.businessobject.TransportationModeDetail;
import org.kuali.kfs.module.tem.businessobject.TravelAdvance;
import org.kuali.kfs.module.tem.businessobject.TripType;
import org.kuali.kfs.module.tem.document.TEMReimbursementDocument;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;

public class MockTravelDocumentServiceImpl
implements TravelDocumentService {
    protected static Logger LOG = Logger.getLogger(MockTravelDocumentServiceImpl.class);
    protected TravelDocumentService realTravelDocumentService;
    protected DateTimeService dateTimeService;
    public static final String VALID_DOCUMENT_IDENTIFIER = "T-MOCK";
    public static final int VALID_TEM_PROFILE_ID = 37;

    public TravelDocument findRootForTravelReimbursement(String travelDocumentIdentifier) {
        if (StringUtils.equals((String)travelDocumentIdentifier, (String)VALID_DOCUMENT_IDENTIFIER)) {
            return this.createTA();
        }
        return this.realTravelDocumentService.findRootForTravelReimbursement(travelDocumentIdentifier);
    }

    protected TravelAuthorizationDocument createTA() {
        TravelAuthorizationDocument ta = new TravelAuthorizationDocument();
        ta.setTravelDocumentIdentifier(VALID_DOCUMENT_IDENTIFIER);
        ta.setTemProfile(this.createTemProfile());
        ta.setTemProfileId(ta.getTemProfile().getProfileId());
        return ta;
    }

    protected TemProfile createTemProfile() {
        TemProfile profile = new TemProfile();
        profile.setProfileId(Integer.valueOf(37));
        profile.getTemProfileAddress().setProfileId(Integer.valueOf(37));
        profile.setDefaultChartCode("BL");
        profile.setDefaultAccount("1031400");
        profile.setDefaultSubAccount("ADV");
        profile.setDefaultProjectCode("KUL");
        profile.setDateOfBirth(this.dateTimeService.getCurrentSqlDate());
        profile.setGender("M");
        profile.setHomeDeptOrgCode("BL");
        profile.setHomeDeptChartOfAccountsCode("BL");
        return profile;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.realTravelDocumentService = travelDocumentService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public String getMessageFrom(String messageType, String ... args) {
        return this.realTravelDocumentService.getMessageFrom(messageType, args);
    }

    public List<SpecialCircumstances> findActiveSpecialCircumstances(String documentNumber, String documentType) {
        return this.realTravelDocumentService.findActiveSpecialCircumstances(documentNumber, documentType);
    }

    public List<TravelAuthorizationDocument> findAuthorizationDocuments(String travelDocumentNumber) {
        return this.realTravelDocumentService.findAuthorizationDocuments(travelDocumentNumber);
    }

    public List<String> findAuthorizationDocumentNumbers(String travelDocumentNumber) {
        return this.realTravelDocumentService.findAuthorizationDocumentNumbers(travelDocumentNumber);
    }

    public List<TravelReimbursementDocument> findReimbursementDocuments(String travelDocumentNumber) {
        return this.realTravelDocumentService.findReimbursementDocuments(travelDocumentNumber);
    }

    public void updatePerDiemItemsFor(TravelDocument document, List<PerDiemExpense> perDiemList, Integer perDiemId, Timestamp start, Timestamp end) {
        this.realTravelDocumentService.updatePerDiemItemsFor(document, perDiemList, perDiemId, start, end);
    }

    public Map<String, List<Document>> getDocumentsRelatedTo(TravelDocument document) throws WorkflowException {
        return this.realTravelDocumentService.getDocumentsRelatedTo(document);
    }

    public Map<String, List<Document>> getDocumentsRelatedTo(String documentNumber) throws WorkflowException {
        return this.realTravelDocumentService.getDocumentsRelatedTo(documentNumber);
    }

    public List<Document> getDocumentsRelatedTo(TravelDocument document, String ... documentType) {
        return this.realTravelDocumentService.getDocumentsRelatedTo(document, documentType);
    }

    public void addAdHocFYIRecipient(Document document) {
        this.realTravelDocumentService.addAdHocFYIRecipient(document);
    }

    public void addAdHocFYIRecipient(Document document, String initiatorUserId) {
        this.realTravelDocumentService.addAdHocFYIRecipient(document, initiatorUserId);
    }

    public void addAdHocRecipient(Document document, String initiatorUserId, String actionRequested) {
        this.realTravelDocumentService.addAdHocRecipient(document, initiatorUserId, actionRequested);
    }

    public void routeToFiscalOfficer(TravelDocument document, String noteText) throws WorkflowException, Exception {
        this.realTravelDocumentService.routeToFiscalOfficer(document, noteText);
    }

    public PerDiemExpense copyPerDiemExpense(PerDiemExpense perDiemExpense) {
        return this.realTravelDocumentService.copyPerDiemExpense(perDiemExpense);
    }

    public KualiDecimal calculateMileage(ActualExpense actualExpense) {
        return this.realTravelDocumentService.calculateMileage(actualExpense);
    }

    public void handleNewActualExpense(ActualExpense newActualExpenseLine) {
        this.realTravelDocumentService.handleNewActualExpense(newActualExpenseLine);
    }

    public Map<String, KualiDecimal> calculateDailyTotal(PerDiemExpense perDiemMilaeage) {
        return this.realTravelDocumentService.calculateDailyTotal(perDiemMilaeage);
    }

    public List<Map<String, KualiDecimal>> calculateDailyTotals(List<PerDiemExpense> perDiemExpenses) {
        return this.realTravelDocumentService.calculateDailyTotals(perDiemExpenses);
    }

    public void copyDownPerDiemExpense(TravelDocument travelDocument, int copyIndex, List<PerDiemExpense> perDiemExpenses) {
        this.realTravelDocumentService.copyDownPerDiemExpense(travelDocument, copyIndex, perDiemExpenses);
    }

    public boolean isHostedMeal(ExpenseTypeAware havingExpenseType) {
        return this.realTravelDocumentService.isHostedMeal(havingExpenseType);
    }

    public boolean isTravelManager(Person user) {
        return this.realTravelDocumentService.isTravelManager(user);
    }

    public Integer calculateProratePercentage(PerDiemExpense perDiemExpense, String perDiemCalcMethod, Timestamp tripEnd) {
        return this.realTravelDocumentService.calculateProratePercentage(perDiemExpense, perDiemCalcMethod, tripEnd);
    }

    public boolean isOpen(TravelDocument document) {
        return this.realTravelDocumentService.isOpen(document);
    }

    public boolean isProcessed(TravelDocument document) {
        return this.realTravelDocumentService.isProcessed(document);
    }

    public boolean isFinal(TravelDocument document) {
        return this.realTravelDocumentService.isFinal(document);
    }

    public boolean isTravelAuthorizationProcessed(TravelAuthorizationDocument document) {
        return this.realTravelDocumentService.isTravelAuthorizationProcessed(document);
    }

    public boolean isTravelAuthorizationOpened(TravelAuthorizationDocument document) {
        return this.realTravelDocumentService.isTravelAuthorizationOpened(document);
    }

    public boolean isUnsuccessful(TravelDocument document) {
        return this.realTravelDocumentService.isUnsuccessful(document);
    }

    public Integer calculatePerDiemPercentageFromTimestamp(PerDiemExpense perDiemExpense, Timestamp tripEnd) {
        return this.realTravelDocumentService.calculatePerDiemPercentageFromTimestamp(perDiemExpense, tripEnd);
    }

    public KualiDecimal getAmountDueFromInvoice(String documentNumber, KualiDecimal requestedAmount) {
        return this.realTravelDocumentService.getAmountDueFromInvoice(documentNumber, requestedAmount);
    }

    public TravelAuthorizationDocument findCurrentTravelAuthorization(TravelDocument document) {
        return this.realTravelDocumentService.findCurrentTravelAuthorization(document);
    }

    public KualiDecimal getTotalCumulativeReimbursements(TravelDocument document) {
        return this.realTravelDocumentService.getTotalCumulativeReimbursements(document);
    }

    public KualiDecimal getTotalAuthorizedEncumbrance(TravelDocument document) {
        return this.realTravelDocumentService.getTotalAuthorizedEncumbrance(document);
    }

    public boolean isResponsibleForAccountsOn(TravelDocument document, String principalId) {
        return this.realTravelDocumentService.isResponsibleForAccountsOn(document, principalId);
    }

    public boolean checkNonEmployeeTravelerTypeCode(String travelerTypeCode) {
        return this.realTravelDocumentService.checkNonEmployeeTravelerTypeCode(travelerTypeCode);
    }

    public String getAllStates(String countryCode) {
        return this.realTravelDocumentService.getAllStates(countryCode);
    }

    public List<GroupTraveler> copyGroupTravelers(List<GroupTraveler> groupTravelers, String documentNumber) {
        return this.realTravelDocumentService.copyGroupTravelers(groupTravelers, documentNumber);
    }

    public List<? extends TemExpense> copyActualExpenses(List<? extends TemExpense> actualExpenses, String documentNumber) {
        return this.realTravelDocumentService.copyActualExpenses(actualExpenses, documentNumber);
    }

    public List<PerDiemExpense> copyPerDiemExpenses(List<PerDiemExpense> perDiemExpenses, String documentNumber) {
        return this.realTravelDocumentService.copyPerDiemExpenses(perDiemExpenses, documentNumber);
    }

    public List<TravelAdvance> copyTravelAdvances(List<TravelAdvance> travelAdvances, String documentNumber) {
        return this.realTravelDocumentService.copyTravelAdvances(travelAdvances, documentNumber);
    }

    public List<SpecialCircumstances> copySpecialCircumstances(List<SpecialCircumstances> specialCircumstancesList, String documentNumber) {
        return this.realTravelDocumentService.copySpecialCircumstances(specialCircumstancesList, documentNumber);
    }

    public List<TransportationModeDetail> copyTransportationModeDetails(List<TransportationModeDetail> transportationModeDetails, String documentNumber) {
        return this.realTravelDocumentService.copyTransportationModeDetails(transportationModeDetails, documentNumber);
    }

    public void showNoTravelAuthorizationError(TravelReimbursementDocument document) {
        this.realTravelDocumentService.showNoTravelAuthorizationError(document);
    }

    public KualiDecimal getAdvancesTotalFor(TravelDocument travelDocument) {
        return this.realTravelDocumentService.getAdvancesTotalFor(travelDocument);
    }

    public List<TravelAdvance> getOutstandingTravelAdvanceByInvoice(Set<String> arInvoiceDocNumber) {
        return this.realTravelDocumentService.getOutstandingTravelAdvanceByInvoice(arInvoiceDocNumber);
    }

    public String retrieveAddressFromLocationCode(String locationCode) {
        return this.realTravelDocumentService.retrieveAddressFromLocationCode(locationCode);
    }

    public void detachImportedExpenses(TravelDocument document) {
        this.realTravelDocumentService.detachImportedExpenses(document);
    }

    public void attachImportedExpenses(TravelDocument document) {
        this.realTravelDocumentService.attachImportedExpenses(document);
    }

    public boolean checkHoldGLPEs(TravelDocument document) {
        return this.realTravelDocumentService.checkHoldGLPEs(document);
    }

    public void revertOriginalDocument(TravelDocument travelDocument, String status) {
        this.realTravelDocumentService.revertOriginalDocument(travelDocument, status);
    }

    public Date findLatestTaxableRamificationNotificationDate() {
        return this.realTravelDocumentService.findLatestTaxableRamificationNotificationDate();
    }

    public boolean validateSourceAccountingLines(TravelDocument travelDocument, boolean addToErrorPath) {
        return this.realTravelDocumentService.validateSourceAccountingLines(travelDocument, addToErrorPath);
    }

    public String getDocumentType(TravelDocument document) {
        return this.realTravelDocumentService.getDocumentType(document);
    }

    public List<KeyValue> getMileageRateKeyValues(Date searchDate) {
        return this.realTravelDocumentService.getMileageRateKeyValues(searchDate);
    }

    public List<GroupTraveler> importGroupTravelers(TravelDocument document, String csvData) throws Exception {
        return this.realTravelDocumentService.importGroupTravelers(document, csvData);
    }

    public <T> List<T> importFile(String fileContents, Class<T> c, String[] attributeNames, Map<String, List<String>> defaultValues, Integer[] attributeMaxLength, String tabErrorKey) {
        return this.realTravelDocumentService.importFile(fileContents, c, attributeNames, defaultValues, attributeMaxLength, tabErrorKey);
    }

    public List<TravelAdvance> getTravelAdvancesForTrip(String travelDocumentIdentifier) {
        return this.realTravelDocumentService.getTravelAdvancesForTrip(travelDocumentIdentifier);
    }

    public AccountsReceivableOrganizationOptions getOrgOptions() {
        return this.realTravelDocumentService.getOrgOptions();
    }

    public void disableDuplicateExpenses(TravelDocument trDocument, ActualExpense actualExpense) {
        this.realTravelDocumentService.disableDuplicateExpenses(trDocument, actualExpense);
    }

    public void setPerDiemMealsAndIncidentals(PerDiemExpense expense, PerDiem perDiem, TripType tripType, Timestamp tripEnd, boolean shouldProrate) {
        this.realTravelDocumentService.setPerDiemMealsAndIncidentals(expense, perDiem, tripType, tripEnd, shouldProrate);
    }

    public TravelDocument getParentTravelDocument(String travelDocumentIdentifier) {
        return this.realTravelDocumentService.getParentTravelDocument(travelDocumentIdentifier);
    }

    public Collection<String> getApprovedTravelDocumentNumbersByTrip(String travelDocumentIdentifier) {
        return this.realTravelDocumentService.getApprovedTravelDocumentNumbersByTrip(travelDocumentIdentifier);
    }

    public List<String> findMatchingTrips(TravelDocument document) {
        return this.realTravelDocumentService.findMatchingTrips(document);
    }

    public void restorePerDiemProperty(TravelDocument document, String property) {
        this.realTravelDocumentService.restorePerDiemProperty(document, property);
    }

    public TravelDocument getRootTravelDocumentWithoutWorkflowDocument(String travelDocumentIdentifier) {
        return this.realTravelDocumentService.getRootTravelDocumentWithoutWorkflowDocument(travelDocumentIdentifier);
    }

    public List<TemSourceAccountingLine> smooshAccountingLinesToSubAccount(List<TemSourceAccountingLine> originalAccountingLines) {
        return this.realTravelDocumentService.smooshAccountingLinesToSubAccount(originalAccountingLines);
    }

    public List<LinkField> getAgencyLinks(TravelDocument travelDocument) {
        return this.realTravelDocumentService.getAgencyLinks(travelDocument);
    }

    public String customizeAgencyLink(TravelDocument travelDocument, String agencyName, String link) {
        return this.realTravelDocumentService.customizeAgencyLink(travelDocument, agencyName, link);
    }

    public boolean isDocumentStatusValidForReconcilingCharges(TravelDocument travelDocument) {
        return this.realTravelDocumentService.isDocumentStatusValidForReconcilingCharges(travelDocument);
    }

    public boolean isInitiatorTraveler(TravelDocument travelDoc) {
        return this.realTravelDocumentService.isInitiatorTraveler(travelDoc);
    }

    public boolean requiresTravelerApproval(TravelAuthorizationDocument taDoc) {
        return this.realTravelDocumentService.requiresTravelerApproval(taDoc);
    }

    public boolean requiresTravelerApproval(TEMReimbursementDocument trDoc) {
        return this.realTravelDocumentService.requiresTravelerApproval(trDoc);
    }
}

