/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.batch.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.TemParameterConstants;
import org.kuali.kfs.module.tem.batch.TravelImportedExpenseNotificationStep;
import org.kuali.kfs.module.tem.batch.service.TravelImportedExpenseNotificationService;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.HistoricalTravelExpenseService;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.service.KfsNotificationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

public class TravelImportedExpenseNotificationServiceImpl
implements TravelImportedExpenseNotificationService {
    protected DateTimeService dateTimeService;
    protected BusinessObjectService businessObjectService;
    protected TemProfileService temProfileService;
    protected HistoricalTravelExpenseService historicalTravelExpenseService;
    protected TravelDocumentService travelDocumentService;
    protected DocumentService documentService;
    protected KfsNotificationService kfsNotificationService;
    protected ParameterService parameterService;
    protected String notificationTemplate;

    @Override
    public void sendImportedExpenseNotification() {
        List<HistoricalTravelExpense> travelExpenses = this.getHistoricalTravelExpenseService().getImportedExpesnesToBeNotified();
        Map<Integer, List<HistoricalTravelExpense>> expensesGroupByTraveler = this.groupExpensesByTraveler(travelExpenses);
        for (Integer travelerProfileId : expensesGroupByTraveler.keySet()) {
            List<HistoricalTravelExpense> expensesOfTraveler;
            if (travelerProfileId == null || !ObjectUtils.isNotNull(expensesOfTraveler = expensesGroupByTraveler.get(travelerProfileId)) || expensesOfTraveler.isEmpty()) continue;
            this.sendImportedExpenseNotification(travelerProfileId, expensesOfTraveler);
        }
    }

    @Override
    @Transactional
    public void sendImportedExpenseNotification(Integer travelerProfileId) {
        List<HistoricalTravelExpense> expensesOfTraveler = this.getHistoricalTravelExpenseService().getImportedExpesnesToBeNotified(travelerProfileId);
        this.sendImportedExpenseNotification(travelerProfileId, expensesOfTraveler);
    }

    @Override
    @Transactional
    public void sendImportedExpenseNotification(Integer travelerProfileId, List<HistoricalTravelExpense> expensesOfTraveler) {
        Date notificationDate = this.getDateTimeService().getCurrentSqlDate();
        ArrayList<HistoricalTravelExpense> expensesOfTravelerImportByTrip = new ArrayList<HistoricalTravelExpense>();
        ArrayList<HistoricalTravelExpense> expensesOfTravelerImportByTraveler = new ArrayList<HistoricalTravelExpense>();
        for (HistoricalTravelExpense expense : expensesOfTraveler) {
            expense.setExpenseNotificationDate(notificationDate);
            String importBy = ObjectUtils.isNotNull((Object)((Object)expense.getAgencyStagingData())) ? expense.getAgencyStagingData().getImportBy() : "";
            String string = importBy = ObjectUtils.isNotNull((Object)((Object)expense.getCreditCardStagingData())) ? expense.getCreditCardStagingData().getImportBy() : "";
            if ("TRP".equals(importBy)) {
                expensesOfTravelerImportByTrip.add(expense);
            } else {
                expensesOfTravelerImportByTraveler.add(expense);
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)expense);
        }
        if (!expensesOfTravelerImportByTrip.isEmpty()) {
            MailMessage mailMessageByTrip = this.buildExpenseNotificationMailMessage(travelerProfileId, expensesOfTravelerImportByTrip, "TRP");
            this.getKfsNotificationService().sendNotificationByMail(mailMessageByTrip);
        }
        if (!expensesOfTravelerImportByTraveler.isEmpty()) {
            MailMessage mailMessageByTraveler = this.buildExpenseNotificationMailMessage(travelerProfileId, expensesOfTravelerImportByTraveler, "TRV");
            this.getKfsNotificationService().sendNotificationByMail(mailMessageByTraveler);
        }
    }

    protected MailMessage buildExpenseNotificationMailMessage(Integer travelerProfileId, List<HistoricalTravelExpense> expensesOfTraveler, String importBy) {
        MailMessage mailMessage = new MailMessage();
        String senderEmailAddress = this.getNotificationSender();
        mailMessage.setFromAddress(senderEmailAddress);
        TemProfile travelerProfile = this.getTemProfileService().findTemProfileById(travelerProfileId);
        String travelerEmailAddress = travelerProfile.getEmailAddress();
        mailMessage.addToAddress(travelerEmailAddress);
        String notificationSubject = this.getNotificationSubject();
        mailMessage.setSubject(this.getNotificationSubject());
        String notificationBody = this.buildNotificationBody(travelerProfile, expensesOfTraveler, importBy);
        mailMessage.setMessage(notificationBody);
        return mailMessage;
    }

    protected String buildNotificationBody(TemProfile travelerProfile, List<HistoricalTravelExpense> expensesOfTraveler, String importBy) {
        HashMap<String, Object> notificationInformationHolder = new HashMap<String, Object>();
        notificationInformationHolder.put("travelerProfile", (Object)travelerProfile);
        notificationInformationHolder.put("travelExpenses", expensesOfTraveler);
        notificationInformationHolder.put("notificationText", this.getNotificationText(importBy));
        return this.getKfsNotificationService().generateNotificationContent(this.getNotificationTemplate(), notificationInformationHolder);
    }

    protected Map<Integer, List<HistoricalTravelExpense>> groupExpensesByTraveler(List<HistoricalTravelExpense> travelExpenses) {
        HashMap<Integer, List<HistoricalTravelExpense>> expensesGroupedByTraveler = new HashMap<Integer, List<HistoricalTravelExpense>>();
        for (HistoricalTravelExpense expense : travelExpenses) {
            List<HistoricalTravelExpense> expensesOfTraveler;
            Integer profileId = expense.getProfileId();
            if (profileId == null) {
                profileId = this.lookupProfileId(expense);
            }
            if (expensesGroupedByTraveler.containsKey(profileId)) {
                expensesOfTraveler = (List)expensesGroupedByTraveler.get(profileId);
                expensesOfTraveler.add(expense);
                continue;
            }
            expensesOfTraveler = new ArrayList();
            expensesOfTraveler.add(expense);
            expensesGroupedByTraveler.put(profileId, expensesOfTraveler);
        }
        return expensesGroupedByTraveler;
    }

    protected Integer lookupProfileId(HistoricalTravelExpense reconciledExpense) {
        TravelDocument travelDoc;
        if (reconciledExpense.getProfileId() != null) {
            return reconciledExpense.getProfileId();
        }
        if (!StringUtils.isBlank((String)reconciledExpense.getDocumentNumber())) {
            try {
                travelDoc = (TravelDocument)this.getDocumentService().getByDocumentHeaderIdSessionless(reconciledExpense.getDocumentNumber());
                if (travelDoc != null && !ObjectUtils.isNull((Object)travelDoc.getTemProfileId())) {
                    return travelDoc.getTemProfileId();
                }
            }
            catch (WorkflowException we) {
                throw new RuntimeException("Cannot retrieve document #" + reconciledExpense.getDocumentNumber() + "...and really, I'm just trying to look up a traveler is all", we);
            }
        }
        if (!StringUtils.isBlank((String)reconciledExpense.getTripId()) && (travelDoc = this.getTravelDocumentService().getParentTravelDocument(reconciledExpense.getTripId())) != null && !ObjectUtils.isNull((Object)travelDoc.getTemProfileId())) {
            return travelDoc.getTemProfileId();
        }
        return null;
    }

    protected List<HistoricalTravelExpense> getImportedExpesnesToBeNotified() {
        return null;
    }

    protected String getNotificationSender() {
        return this.getParameterService().getParameterValueAsString(TemParameterConstants.TEM_ALL.class, "FROM_EMAIL_ADDRESS");
    }

    protected String getNotificationSubject() {
        return this.getParameterService().getParameterValueAsString(TravelImportedExpenseNotificationStep.class, "NOTIFICATION_SUBJECT");
    }

    protected String getNotificationText(String importBy) {
        String parameterName = "TRP".equals(importBy) ? "NOTIFICATION_TEXT_BY_TRP" : "NOTIFICATION_TEXT_BY_TRV";
        String notificationText = this.getParameterService().getParameterValueAsString(TravelImportedExpenseNotificationStep.class, parameterName);
        return notificationText;
    }

    public TemProfileService getTemProfileService() {
        return this.temProfileService;
    }

    public void setTemProfileService(TemProfileService temProfileService) {
        this.temProfileService = temProfileService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KfsNotificationService getKfsNotificationService() {
        return this.kfsNotificationService;
    }

    public void setKfsNotificationService(KfsNotificationService kfsNotificationService) {
        this.kfsNotificationService = kfsNotificationService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public String getNotificationTemplate() {
        return this.notificationTemplate;
    }

    public void setNotificationTemplate(String notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
    }

    public HistoricalTravelExpenseService getHistoricalTravelExpenseService() {
        return this.historicalTravelExpenseService;
    }

    public void setHistoricalTravelExpenseService(HistoricalTravelExpenseService historicalTravelExpenseService) {
        this.historicalTravelExpenseService = historicalTravelExpenseService;
    }

    public TravelDocumentService getTravelDocumentService() {
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

