/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document;

import javax.persistence.Entity;
import javax.persistence.Table;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

@Entity
@Table(name="TEM_TRVL_AUTH_AMEND_DOC_T")
public class TravelAuthorizationAmendmentDocument
extends TravelAuthorizationDocument {
    @Override
    public void initiateDocument() {
        super.initiateDocument();
        this.tripProgenitor = false;
    }

    @Override
    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (DocumentStatus.PROCESSED.getCode().equals(statusChangeEvent.getNewRouteStatus())) {
            this.retirePreviousAuthorizations();
        }
    }

    @Override
    public void setDefaultBankCode() {
        Bank defaultBank = ((BankService)SpringContext.getBean(BankService.class)).getDefaultBankByDocType(TravelAuthorizationDocument.class);
        if (defaultBank != null) {
            this.setFinancialDocumentBankCode(defaultBank.getBankCode());
            this.setBank(defaultBank);
        }
    }

    @Override
    public boolean shouldRevertToOriginalAuthorizationOnCopy() {
        return true;
    }

    @Override
    public boolean generateDocumentGeneralLedgerPendingEntries(GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        boolean result = super.generateDocumentGeneralLedgerPendingEntries(sequenceHelper);
        this.getTravelEncumbranceService().adjustEncumbranceForAmendment(this, sequenceHelper);
        return result;
    }

    @Override
    public boolean isTripProgenitor() {
        return false;
    }

    @Override
    public void setTripProgenitor(boolean tripProgenitor) {
    }

    @Override
    public boolean maskTravelDocumentIdentifierAndOrganizationDocNumber() {
        return false;
    }
}

