/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.authorization;

import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.tem.businessobject.TemProfile;
import org.kuali.kfs.module.tem.service.TemProfileService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.authorization.FinancialSystemTransactionalDocumentAuthorizerBase;
import org.kuali.rice.kim.api.identity.Person;

public class CardApplicationDocumentAuthorizer
extends FinancialSystemTransactionalDocumentAuthorizerBase {
    protected static volatile TemProfileService temProfileService;

    protected void addRoleQualification(Object dataObject, Map<String, String> qualification) {
        super.addRoleQualification(dataObject, qualification);
        this.addCurrentUserQualifiers(qualification);
    }

    protected void addCurrentUserQualifiers(Map<String, String> qualification) {
        String currentUserPrincipalId = GlobalVariables.getUserSession().getPrincipalId();
        qualification.put("profilePrincipalId", currentUserPrincipalId);
        TemProfile profile = this.getTemProfileService().findTemProfileByPrincipalId(currentUserPrincipalId);
        if (profile != null) {
            if (!qualification.containsKey("chartOfAccountsCode")) {
                qualification.put("chartOfAccountsCode", profile.getHomeDeptChartOfAccountsCode());
            }
            if (!qualification.containsKey("organizationCode")) {
                qualification.put("organizationCode", profile.getHomeDeptOrgCode());
            }
        }
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        String nameSpaceCode = "KR-SYS";
        HashMap<String, String> permissionDetails = new HashMap<String, String>();
        HashMap<String, String> qualificationDetails = new HashMap<String, String>();
        this.addCurrentUserQualifiers(qualificationDetails);
        qualificationDetails.put("documentTypeName", documentTypeName);
        permissionDetails.put("documentTypeName", documentTypeName);
        return CardApplicationDocumentAuthorizer.getPermissionService().isAuthorizedByTemplate(user.getPrincipalId(), nameSpaceCode, "Initiate Document", permissionDetails, qualificationDetails);
    }

    public TemProfileService getTemProfileService() {
        if (temProfileService == null) {
            temProfileService = (TemProfileService)SpringContext.getBean(TemProfileService.class);
        }
        return temProfileService;
    }
}

