/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.document.validation.impl;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.tem.businessobject.PrimaryDestination;
import org.kuali.kfs.module.tem.document.TravelAuthorizationDocument;
import org.kuali.kfs.module.tem.document.TravelDocumentBase;
import org.kuali.kfs.module.tem.document.TravelReimbursementDocument;
import org.kuali.kfs.module.tem.document.service.TravelDocumentService;
import org.kuali.kfs.module.tem.service.TravelService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class TravelAuthTripInformationValidation
extends GenericValidation {
    private TravelService travelService;
    private TravelDocumentService travelDocumentService;
    private DictionaryValidationService dictionaryValidationService;

    public boolean validate(AttributedDocumentEvent event) {
        String errorMessage;
        TravelDocumentBase document = (TravelDocumentBase)event.getDocument();
        Boolean rulePassed = true;
        if (!(StringUtils.isBlank((String)document.getTraveler().getPhoneNumber()) || StringUtils.isBlank((String)document.getTraveler().getCountryCode()) || StringUtils.isBlank((String)(errorMessage = this.getTravelService().validatePhoneNumber(document.getTraveler().getCountryCode(), document.getTraveler().getPhoneNumber(), "error.document.tem.phoneNumber"))))) {
            GlobalVariables.getMessageMap().putError("document.traveler.phoneNumber", errorMessage, new String[]{"Traveler Phone Number"});
            rulePassed = false;
        }
        if (event.getDocument() instanceof TravelReimbursementDocument && document.getTripEnd() != null) {
            Date endDate = KfsDateUtils.clearTimeFields((Date)document.getTripEnd());
            Date today = KfsDateUtils.clearTimeFields((Date)new Date());
            Boolean value = this.getParameterService().getParameterValueAsBoolean(TravelReimbursementDocument.class, "PRETRIP_REIMBURSEMENT_IND");
            if (endDate != null && today.before(endDate) && !value.booleanValue()) {
                GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.custom", new String[]{"Travel Reimbursement Document cannot be submitted before the trip end date has passed."});
                rulePassed = false;
            }
        }
        if (document.getTripTypeCode() != null) {
            TravelAuthorizationDocument taDoc;
            PrimaryDestination destination;
            document.refreshReferenceObject("tripType");
            if (!document.getTripType().getUsePerDiem() && document.getPerDiemExpenses() != null && !document.getPerDiemExpenses().isEmpty()) {
                GlobalVariables.getMessageMap().putError("document.perDiemExpenses", "error.custom", new String[]{"Per Diem entry is not allowed for this Trip Type [" + document.getTripType().getCode() + "]."});
                rulePassed = false;
            }
            if (!document.isBlanketTravel().booleanValue() && document.getDocumentGrandTotal().isLessEqual((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                GlobalVariables.getMessageMap().putError("document.estimateAmount", "error.document.tem.total.estimated", new String[0]);
                rulePassed = false;
            }
            if (!(document.getPrimaryDestinationIndicator().booleanValue() || ObjectUtils.isNull((Object)(destination = document.getPrimaryDestination()).getRegion()) || document.getTripTypeCode().equals(destination.getRegion().getTripTypeCode()))) {
                GlobalVariables.getMessageMap().putError("document.tripTypeCode", "error.document.tem.trip.type.primary.destination.mismatch", new String[0]);
                rulePassed = false;
            }
            if (document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName().equals("TR") && document.getTripType().getTravelAuthorizationRequired() && (taDoc = this.getTravelDocumentService().findCurrentTravelAuthorization(document)) == null) {
                GlobalVariables.getMessageMap().putError("document.document*,document.explanation*,document.reversal*,document.selected*,document.header*", "error.custom", new String[]{"Travel Authorization Document is required for this Trip Type [" + document.getTripType().getCode() + "]."});
                rulePassed = false;
            }
        }
        return rulePassed;
    }

    public TravelService getTravelService() {
        return this.travelService;
    }

    public void setTravelService(TravelService travelService) {
        this.travelService = travelService;
    }

    public DictionaryValidationService getDictionaryValidationService() {
        return this.dictionaryValidationService;
    }

    public void setDictionaryValidationService(DictionaryValidationService dictionaryValidationService) {
        this.dictionaryValidationService = dictionaryValidationService;
    }

    protected TravelDocumentService getTravelDocumentService() {
        if (this.travelDocumentService == null) {
            this.travelDocumentService = (TravelDocumentService)SpringContext.getBean(TravelDocumentService.class);
        }
        return this.travelDocumentService;
    }

    public void setTravelDocumentService(TravelDocumentService travelDocumentService) {
        this.travelDocumentService = travelDocumentService;
    }

    public ParameterService getParameterService() {
        return (ParameterService)SpringContext.getBean(ParameterService.class);
    }
}

