<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2019 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="rows" required="true" type="java.util.List"
              description="The rows of fields that we'll iterate to display." %>
<%@ attribute name="numberOfColumns" required="false"
              description="The # of fields in this row." %>
<%@ attribute name="skipTheOldNewBar" required="false"
              description="boolean that indicates whether the old and new bar should be skipped" %>
<%@ attribute name="depth" required="false"
              description="the recursion depth number" %>
<%@ attribute name="rowsHidden" required="false"
              description="boolean that indicates whether the rows should be hidden or all fields are hidden" %>
<%@ attribute name="rowsReadOnly" required="false"
              description="boolean that indicates whether the rows should be rendered as read-only (note that rows will automatically be rendered as readonly if it is an inquiry or if it is a maintenance document in readOnly mode" %>
<%@ attribute name="sessionDocument" required="false"
              description="boolean that indicates whether the sessionDocument declared in DD" %>

<%@ attribute name="subtable" required="false" description="boolean that indicates if this table will be embedded in a rowdisplay" %>

<c:if test="${empty depth}">
    <c:set var="depth" value="0" />
</c:if>

<c:set var="maintenanceViewMode" value="${requestScope[Constants.PARAM_MAINTENANCE_VIEW_MODE]}" />
<c:set var="isInquiry" value="${maintenanceViewMode eq Constants.PARAM_MAINTENANCE_VIEW_MODE_INQUIRY}" />
<c:set var="isMaintenanceForm" value='false' />

<c:if test='<%= jspContext.findAttribute("KualiForm") != null %>'>
	<c:set var="isMaintenanceForm" value='<%= jspContext.findAttribute("KualiForm").getClass() == org.kuali.kfs.kns.web.struts.form.KualiMaintenanceForm.class %>' />
</c:if>

<c:set var="isMaintenance" value="${isMaintenanceForm || maintenanceViewMode eq Constants.PARAM_MAINTENANCE_VIEW_MODE_MAINTENANCE}" />
<c:set var="isLookup" value="${maintenanceViewMode eq Constants.PARAM_MAINTENANCE_VIEW_MODE_LOOKUP}" />
<c:set var="isFormReadOnly" value="${rowsReadOnly || isInquiry || (isMaintenance && KualiForm.readOnly)}" />
<c:set var="requestedAction" value="${isMaintenance ? KualiForm.maintenanceAction : KualiForm.methodToCall}" />
<c:set var="isActionEdit" value="${Constants.MAINTENANCE_EDIT_ACTION eq requestedAction}" />
<c:set var="isActionCopy" value="${Constants.MAINTENANCE_COPY_ACTION eq requestedAction}" />
<c:set var="isActionNew" value="${Constants.MAINTENANCE_NEW_ACTION eq requestedAction || Constants.MAINTENANCE_NEWWITHEXISTING_ACTION eq requestedAction}" />
<c:set var="addHighlighting" value="${isMaintenance && isActionEdit}" />

<c:if test="${isMaintenance}">
    <c:set var="numberOfColumns" value="1" />
</c:if>

<c:set var="isHeaderDisplayed" value="false" />
<c:set var="rowClass" value="header"/>

<c:forEach items="${rows}" var="row" varStatus="rowVarStatus">

    <c:set var="rowHidden" value="${rowsHidden || row.hidden}" />

    <c:if test="${row.fields[0].fieldType ne row.fields[0].LOOKUP_READONLY}">
        <c:set var="rowClass" value=""/>
    </c:if>

    <c:choose>
		<c:when test="${rowHidden}"><tr class="${rowClass}" style="display: none;"></c:when>
		<c:otherwise><tr class="${rowClass}"></c:otherwise>
	</c:choose>

        <c:forEach items="${row.fields}" var="field" varStatus="fieldVarStatus">
            <c:set var="isFieldAContainer" value="${field.fieldType eq field.CONTAINER}" />
            <c:set var="isFieldAddingToACollection" value="${fn:contains(field.propertyName, 'add.')}" />

            <c:set var="headerColspan" value="${numberOfColumns}" />
            <c:set var="dataCellWidth" value="${100 / (numberOfColumns * ((isMaintenance || requestedAction eq 'addLine') ? 4 : 2))}" />

            <c:set var="tabIndex" value="0"/>
            <c:set var="dummyIncrementVar" value="${kfunc:incrementTabIndex(KualiForm, tabIndex)}" />

            <%--
                ######################
                # SHOW THE OLD/NEW BAR
                ###################### --%>
            <c:if test="${isMaintenance && not skipTheOldNewBar && not rowHidden &&  rowVarStatus.count eq 1 && not isHeaderDisplayed && not isFieldAContainer && not isFieldAddingToACollection && field.fieldType ne field.IMAGE_SUBMIT}">
                <%-- For Copy and Edit the Old and New views are shown.
                     For all other actions a New bar (row) is shown at the top level only (not in containers). --%>
                <kul:sectionOldNewBar action="${requestedAction}" colspan="${headerColspan}"  depth="${depth}"/>
                <c:set var="isHeaderDisplayed" value="true" />
                <c:set var="rowClass" value=""/>
            </c:if>

            <%--
                ###################################################################
                # GATHER SOME INFORMATION ABOUT THE FIELD AND STORE IT IN VARIABLES
                ################################################################### --%>
            <%-- isFieldSecure determines whether or not the encrypted value should be shown for
            non-collections and a similar function for collections --%>
            <c:set var="isFieldSecure" value="${field.secure}" />

            <%-- isFieldReadOnly determines whether or not a field is readOnly --%>
            <%-- NOTE: The part about "fieldVarStatus.count mod 2" will work for any even number
            of columns assuming that all columns alternate between read-only and not-read-only. --%>
            <c:set var="isFieldReadOnly" value="${isFieldSecure || field.readOnly || isFormReadOnly || (isMaintenance && not isActionNew && fieldVarStatus.count le numberOfColumns)}" />

            <%-- textStyle is used to store the style of the field value. i.e. whether or not it
            should display as red text. --%>
            <c:set var="textStyle" value="" />

            <%-- fieldValue should be used to store the appropriate value for a field, i.e. handle
            showing the encrypted value if a field is secure, etc. --%>
            <c:set var="fieldValue" value="${field.propertyValue}" />

            <%--
                #######################################################
                # PojoForm saves request input that the Formatter framework
                # could not convert to the type of a given field,
                # so that it can be redisplayed here for correction.
                #
                # (jdb) KualiRequestProcessor.processPopulate() puts this
                # in the request too (UnconvertedHash and UnconvertedValues),
                # but is that necessary?  Also, the non-maintenance
                # docs get this automatically by using the Struts tags
                # (e.g., html:text), because Struts is using PojoPropertyUtilsBean.
                # Should the maintenance framework use the Struts html tags too?
                ####################################################### --%>
            <c:set var="unconvertedValue" value="${KualiForm.unconvertedValues[field.propertyName]}"/>
            <c:if test="${not empty unconvertedValue}">
                <c:set var="textStyle" value="border-color: red" />
                <c:set var="fieldValue" value="${unconvertedValue}" />
            </c:if>

            <%--
                #######################################################
                # If the field has errors, highlight its display in red.
                ####################################################### --%>
            <kul:checkErrors keyMatch="${field.propertyName}" />


            <%--
                #######################################################
                # Set the onBlur handlers for the field.
                ####################################################### --%>
            <c:set var="onblur" value="" />
            <c:set var="onblurcall" value="" />

            <c:if test="${!(empty field.webOnBlurHandler)}">

				<c:set var="onblurParameters" value="" />
                <c:choose>

                    <c:when test="${!(empty field.webOnBlurHandlerCallback)}">
                        <c:set var="onblurParameters" value="this, ${field.webOnBlurHandlerCallback}" />
                    </c:when>

                    <c:otherwise>
                        <c:set var="onblurParameters" value="this" />
                    </c:otherwise>

                </c:choose>
                <c:if test="${!(empty field.webUILeaveFieldFunctionParameters)}">
					<c:set var="onblurParameters" value="${onblurParameters},${field.webUILeaveFieldFunctionParametersString}" />
				</c:if>

				<c:set var="onblur" value="${field.webOnBlurHandler}( ${onblurParameters} );" />
                <c:set var="onblurcall" value='onblur="${onblur}"' />
            </c:if>

            <c:if test="${isFieldSecure and field.fieldType ne field.FILE}">
                <input type="hidden" name="${field.propertyName}" value='<c:out value="${field.encryptedValue}"/>' />
            </c:if>

            <%-- Set onchange to submit form if field configured to trigger on change --%>
            <c:set var="onchange" value="" />
            <c:set var="onchangecall" value="" />

            <c:if test="${field.triggerOnChange}">
                <c:set var="onchange" value="setFieldToFocusAndSubmit(this);" />
                <c:set var="onchangecall" value='onchange="${onchange}"' />
            </c:if>

            <c:if test="${numberOfColumns > 1}">
                <td>
                <table>
                <tr>
            </c:if>

            <%--
                ###########################################################
                # SHOW FIELD
                ########################################################### --%>
            <c:choose>

                <c:when test="${not isActionNew && fieldVarStatus.count eq 1 && isFieldAddingToACollection && not isFieldAContainer}">
                    <%-- Don't show anything --%>
                    <c:set var="rowClass" value=""/>
                </c:when>

                <c:when test="${not isActionNew && not (requestedAction eq Constants.SAVE_METHOD and isFieldAddingToACollection) && (not isActionNew && requestedAction ne Constants.ADD_LINE_METHOD && fieldVarStatus.count eq 1 && isFieldAddingToACollection && not isFieldAContainer)}">
                    <%-- Don't show anything --%>
                    <c:set var="rowClass" value=""/>
                </c:when>

                <c:when test="${empty field.fieldType}">
                    <%-- Don't show anything --%>
                </c:when>

                <c:when test="${isFieldSecure}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                                           isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%"
                                           fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                                           fieldLabel="${field.fieldLabel}" />

                    <td class="grid" style="width:${dataCellWidth}%;">
                         <c:out value="${field.displayMaskValue}"/>
                        <kul:fieldShowIcons isReadOnly="${isFieldReadOnly && !isLookup}" field="${field}" addHighlighting="${addHighlighting}" />
                    </td>
                </c:when>

                <c:when test="${isFormReadOnly && isFieldAddingToACollection}">
                    <%-- Don't show anything. --%>
                </c:when>

                <c:when test="${isFieldAContainer}">
                    <td colspan="${headerColspan * 4}" class="container-tab-subhead" style="${depth eq 0 ? '' : 'padding-top: 20px; padding-bottom: 20px;'}">
                        <%-- Set the width for the collection container. --%>
                        <c:set var="width" value="${depth eq 0 ? '100%' : '85%'}" />
                        <c:set var="subTabTitle">
                            <kul:containerElementSubTabTitle containerField="${field}" isFieldAddingToACollection="${isFieldAddingToACollection}"/>
                        </c:set>
                        <c:set var="subTabButtonAlt">
                            <kul:containerElementSubTabTitle containerField="${field}" isFieldAddingToACollection="${isFieldAddingToACollection}"/>
                        </c:set>

                        <%-- determine whether there are highlighted fields in the container. If so highlight subtab --%>
                        <kul:checkTabHighlight rows="${field.containerRows}" addHighlighting="${addHighlighting}" />

                        <%-- Only show the show/hide button on collection entries that
                        contain data (i.e. those that aren't adding --%>
                        <kul:subtab noShowHideButton="${isFieldAddingToACollection or empty field.containerRows}"
                                    subTabTitle="${kfunc:scrubWhitespace(subTabTitle)}"
                                    buttonAlt="${kfunc:scrubWhitespace(subTabButtonAlt)}" width="${width}"
                                    highlightTab="${tabHighlight}" boClassName="${field.multipleValueLookupClassName}"
                                    lookedUpBODisplayName="${field.multipleValueLookupClassLabel}"
                                    lookedUpCollectionName="${field.multipleValueLookedUpCollectionName}"
                                    useCurrentTabIndexAsKey="true">
                            <table class="standard">
                                <%-- cannot refer to recursive tag (containerRowDisplay) using kul alias or Jetty 7 will have jsp compilation errors on Linux --%>
    							<%-- this tag ends up being recursive b/c it calls rowDisplay--%>
                                <%@ taglib tagdir="/WEB-INF/tags/kr" prefix="kul2"%>
                                <kul2:containerRowDisplay rows="${field.containerRows}"
                                                          numberOfColumns="${isMaintenance ? numberOfColumns : field.numberOfColumnsForCollection}"
                                                          depth="${depth + 1}" rowsReadOnly="${rowsReadOnly}"/>
                            </table>
                        </kul:subtab>
                    </td>
                </c:when>


                <c:when test="${field.fieldType eq field.SUB_SECTION_SEPARATOR}">
                    <td></td>
                    <td colspan="${headerColspan}" class="tab-subhead heavy">
                        <c:out value="${field.fieldLabel}" />&nbsp;
                    </td>
                </c:when>

                <c:when test="${(field.fieldType eq field.BLANK_SPACE)}">
                    <c:if test="${(isInquiry or isLookup)}">
                        <th class="grid" style="width:${dataCellWidth}%;">&nbsp;</th>

                        <c:if test="${numberOfColumns > 1}">
                            </tr>
                            <tr>
                        </c:if>

                        <td class="grid" style="width:${dataCellWidth}%;">
                            <c:out value="${field.fieldLabel}" />&nbsp;
                        </td>
                    </c:if>
                </c:when>

                <c:when test="${field.fieldType eq field.CURRENCY}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                                           isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%"
                                           fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                                           fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <input type="text" id='${field.propertyName}' name='${field.propertyName}'
                                    value='<c:out value="${fieldValue}"/>'
                                    size='${field.size + 1}'
                                    maxlength='${field.formattedMaxLength}'
                                    style="${textStyle}" ${onblurcall} ${onchangecall}
                                    class="${field.styleClass}" tabIndex="${tabIndex}" />

                                <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                            </c:otherwise>
                        </c:choose>
                    </td>
                </c:when>

                <c:when test="${field.fieldType eq field.TEXT or field.fieldType eq field.TITLE_LINKED_TEXT}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                                           isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%"
                                           fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                                           fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <input type="text" name='${field.propertyName}'
                                    id='${field.propertyName}'
                                    value='<c:out value="${fieldValue}"/>'
                                    size='${field.size + 1}'
                                    maxlength='${field.maxLength}'
                                    style="${textStyle}" ${onblurcall} ${onchangecall}
                                    class="${field.styleClass}" tabindex="${tabIndex}"/>

                                <c:if test="${field.datePicker eq true}">
                                    <img src="${ConfigProperties.kr.externalizable.images.url}cal.png"
                                         width="24"
                                        id="${field.propertyName}_datepicker"
                                        style="cursor: pointer;"
                                        title="Date selector"
                                        alt="Date selector" />

                                    <script type="text/javascript">
                                        Calendar.setup(
                                            {
                                                inputField : "${field.propertyName}", // ID of the input field
                                                ifFormat : "%m/%d/%Y", // the date format
                                                button : "${field.propertyName}_datepicker" // ID of the button
                                            }
                                        );
                                    </script>
                                </c:if>

                                <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                            </c:otherwise>
                        </c:choose>
                    </td>
                </c:when>

                <c:when test="${field.fieldType eq field.HIDDEN}">
                    <c:if test="${isLookup}">
                        <%-- only render the hidden field if this is part of a lookup criteria set --%>
                        ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                        <input type="hidden" name='${field.propertyName}' value='<c:out value="${fieldValue}"/>' />
                    </c:if>
                </c:when>

                <c:when test="${field.fieldType eq field.TEXT_AREA}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                                           isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%"
                                           fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                                           fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <textarea id='${field.propertyName}' name='${field.propertyName}'
                                    rows='${field.rows}'
                                    cols='${field.cols}'
                                    style="${textStyle}" ${onblurcall} ${onchangecall}
                                    maxlength='${field.maxLength}' tabIndex="${tabIndex}"><c:out
                                    value="${fieldValue}" /></textarea>

                                <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                            </c:otherwise>
                        </c:choose>
                    </td>
                </c:when>

                <c:when test="${field.fieldType eq field.CHECKBOX}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%"
                        fieldName="${field.propertyName}" fieldType="${field.fieldType}" fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <c:set var="checkboxPresentOnFormAnnotationFieldName" value="${field.propertyName}${Constants.CHECKBOX_PRESENT_ON_FORM_ANNOTATION}" />
                                ${kfunc:registerEditableProperty(KualiForm, checkboxPresentOnFormAnnotationFieldName)}
                                <input type="checkbox" id='${field.propertyName}' name="${field.propertyName}"
                                    ${field.propertyValue eq 'Yes' || field.propertyValue eq 'YES' || field.propertyValue eq 'Y' || field.propertyValue eq 'on' ? 'checked="checked"' : ''}
                                    ${onblurcall} ${onchangecall} tabIndex="${tabIndex}"/>
                                <input type="hidden" name="${checkboxPresentOnFormAnnotationFieldName}" value="present"/>
                            </c:otherwise>
                        </c:choose>

                        <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                    </td>
                </c:when>

                <c:when test="${field.fieldType eq field.DROPDOWN}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%"
                        fieldName="${field.propertyName}" fieldType="${field.fieldType}" fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <select id='${field.propertyName}' name='${field.propertyName}' style="${textStyle}" ${onblurcall} ${onchangecall} tabIndex="${tabIndex}">
                                    <c:if test="${!field.hasBlankValidValue and !field.skipBlankValidValue}">
                                        <option value=""></option>
                                    </c:if>
                                    <kul:fieldSelectValues field="${field}"/>
                                </select>
                            </c:otherwise>
                        </c:choose>

                        <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                    </td>
                </c:when>
                <c:when test="${field.fieldType eq field.DROPDOWN_REFRESH}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%" fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                        fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <select id='${field.propertyName}' name='${field.propertyName}'
                                        onchange="document.forms[0].submit();" style="${textStyle}" tabIndex="${tabIndex}">

                                    <kul:fieldSelectValues field="${field}"/>
                                </select>
                            </c:otherwise>
                        </c:choose>

                        &nbsp;

                        <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                    </td>
                </c:when>

                <c:when test="${field.fieldType eq field.DROPDOWN_SCRIPT}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%" fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                        fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                <c:set var="fieldScript" value="${field.script}" />
                                <c:if test="${!fn:endsWith(fieldScript,';')}" >
                                   <c:set var="fieldScript" value="${fieldScript};" />
                                </c:if>

                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <select id='${field.propertyName}' name='${field.propertyName}'
                                        onchange="${fieldScript}${onchangecall}" style="${textStyle}" tabIndex="${tabIndex}">
                                    <kul:fieldSelectValues field="${field}"/>
                                </select>
                            </c:otherwise>
                        </c:choose>
                        &nbsp;
                        <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                    </td>
                </c:when>

                <c:when test="${field.fieldType eq field.MULTISELECT}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%"
                        fieldName="${field.propertyName}" fieldType="${field.fieldType}" fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <select multiple="${true}" id='${field.propertyName}' name='${field.propertyName}' size="${field.size + 1}" style="${textStyle}" ${onblurcall} ${onchangecall} tabIndex="${tabIndex}">
                                    <kul:fieldMultiSelectValues field="${field}"/>
                                </select>
                            </c:otherwise>
                        </c:choose>

                        <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                    </td>
                </c:when>
                <c:when test="${field.fieldType eq field.RADIO}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%" fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                        fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                <kul:fieldRadioValues field="${field}" onblur="${onblur}" onchange="${onchange}" tabIndex="${tabIndex}"/>
                                <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                            </c:otherwise>
                        </c:choose>
                    </td>
                </c:when>

                <c:when test="${field.fieldType eq field.KUALIUSER}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%" fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                        fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:if test="${!hasErrors}">
                            <kul:checkErrors keyMatch="${field.universalIdAttributeName}" />
                        </c:if>
                        <c:if test="${numberOfColumns > 1}">
                            <c:set var="hideEmptyCell" value="true" />
                        </c:if>

                        <kul:user userIdFieldName="${field.propertyName}"
                                  universalIdFieldName="${field.universalIdAttributeName}"
                                  userNameFieldName="${field.personNameAttributeName}"
                                  userId="${field.propertyValue}"
                                  universalId="${field.universalIdValue}"
                                  userName="${field.personNameValue}"
                                  label="${field.fieldLabel}"
                                  referencesToRefresh="${field.referencesToRefresh}"
                                  fieldConversions="${field.fieldConversions}"
                                  lookupParameters="${field.lookupParameters}"
                                  hasErrors="${hasErrors}"
                                  readOnly="${field.keyField || isFieldReadOnly}"
                                  onblur="${onblur}"
                                  onchange="${onchange}"
                                  highlight="${addHighlighting && field.highlightField}"
                                  tabIndex="${tabIndex}"
                                  hideEmptyCell="${hideEmptyCell}">
                            <jsp:attribute name="helpLink" trim="true">
                                <c:if test="${field.fieldLevelHelpEnabled || (!field.fieldLevelHelpDisabled && KualiForm.fieldLevelHelpEnabled)}">
                                <kul:help
                                    businessObjectClassName="${field.businessObjectClassName}"
                                    attributeName="${field.fieldHelpName}"
                                    altText="${field.fieldHelpSummary}"
                                    alternativeHelp="${field.fieldLevelHelpUrl}"/>
                                </c:if>
                            </jsp:attribute>
                        </kul:user>
                    </td>
                </c:when>
                <c:when test="${field.fieldType eq field.WORKFLOW_WORKGROUP}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%" fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                        fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                            </c:when>
                            <c:otherwise>
                                ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                <input type="text" name='${field.propertyName}'
                                    id='${field.propertyName}'
                                    value='<c:out value="${fieldValue}"/>'
                                    size='${field.size + 1}'
                                    maxlength='${field.maxLength}'
                                    style="${textStyle}" ${onblurcall} ${onchangecall}
                                    class="${field.styleClass}" tabIndex="${tabIndex}"/>

                                <!--  adding a lookup here because it goes to workflow as opposed to Kuali -->
                                <kul:workflowWorkgroupLookup fieldConversions="workgroupName:${field.propertyName}" />

                                <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                            </c:otherwise>
                        </c:choose>
                    </td>
                </c:when>

                <c:when test="${field.fieldType eq field.FILE}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}" isReadOnly="${isFieldReadOnly}"
                        cellWidth="${dataCellWidth}%" fieldType="${field.fieldType}" fieldLabel="${field.fieldLabel}" fieldName="${field.propertyName}"/>

                    <c:set var="lineNum" value="" />
                    <c:if test="${fn:contains(field.propertyName, '[') and fn:contains(field.propertyName, '].')}" >
                      <c:set var="lineNum" value=".line${fn:substringBefore(fn:substringAfter(field.propertyName, '['), '].')}.anchor${tabIndex}"/>
                    </c:if>
                    <td class="grid" style="width:${dataCellWidth}%;">
                        <c:choose>
                            <c:when test="${isFieldReadOnly}">
                                <c:if test="${empty fieldValue}" >
                                    <c:out value="<%=((String) request.getAttribute(\"fileName\"))%>" />&nbsp;
                                </c:if>
                                <c:if test="${not empty fieldValue}" >
                                    <c:if test="${(isInquiry or isLookup)}">
                                      <html:submit
                                              property="methodToCall.downloadAttachment${lineNum}"
                                              alt="download attachment"
                                              style="padding:5px"
                                              onclick="excludeSubmitRestriction=true"
                                              styleClass="btn btn-default"
                                              value="Download Attachment"/>
                                    </c:if>
                                    <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                                </c:if>
                            </c:when>
                            <c:otherwise>
                                    <c:choose>
                                        <c:when test="${empty fieldValue}" >
                                            <c:if test="${isMaintenance}" >
                                            ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                            <input type="file" name='${field.propertyName}'
                                                id='${field.propertyName}'
                                                size='${field.size + 1}'
                                                class="${field.styleClass}" tabIndex="${tabIndex}"/>
                                            </c:if>
                                        </c:when>
                                        <c:otherwise>

                                          <div id="replaceDiv" style="display:block;">

                                            <html:submit
                                                    property="methodToCall.downloadAttachment${lineNum}"
                                                    alt="download attachment"
                                                    style="padding:5px"
                                                    styleClass="btn btn-default small"
                                                    onclick="excludeSubmitRestriction=true"
                                                    value="Download Attachment"/>
                                            <c:out value="${fieldValue}"/>
                                            &nbsp;&nbsp;
                                                                                        <input type="hidden" name='methodToCall' />
                                            <script type="text/javascript">
                                                function replaceAttachment() {
                                                    excludeSubmitRestriction=true;
                                                    showHide('replaceFileDiv','replaceDiv');
                                                    document.forms[0].methodToCall.value='replaceAttachment';
                                                    submitForm();
                                                }
                                            </script>
                                           <html:submit
                                                   property="methodToCall.replaceAttachment.${lineNum}"
                                                   alt="replace attachment"
                                                   styleClass="btn btn-default"
                                                   onclick="excludeSubmitRestriction=true"
                                                   value="Replace"/>
                                        </div>
                                        <div id="replaceFileDiv" valign="middle" style="display:none;">
                                            ${kfunc:registerEditableProperty(KualiForm, field.propertyName)}
                                            <input type="file" name='${field.propertyName}'
                                                id='${field.propertyName}'
                                                size='${field.size + 1}'
                                                class="${field.styleClass}" tabIndex="${tabIndex}"/>
                                        </div>
                                        </c:otherwise>
                                    </c:choose>


                                <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                            </c:otherwise>
                        </c:choose>
                        </div>
                    </td>
                </c:when>
                <c:when test="${field.fieldType eq field.LOOKUP_READONLY}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                        isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%" fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                        fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                        <kul:fieldShowReadOnly field="${field}" addHighlighting="${addHighlighting}" isLookup="${isLookup}" />
                        <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                    </td>
                </c:when>
                <c:when test="${field.fieldType eq field.LOOKUP_HIDDEN}">
                    <kul:fieldDefaultLabel isLookup="${isLookup}" isRequired="${field.fieldRequired}"
                    isReadOnly="${isFieldReadOnly}" cellWidth="${dataCellWidth}%" fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                    fieldLabel="${field.fieldLabel}" />

                    <c:if test="${numberOfColumns > 1}">
                        </tr>
                        <tr>
                    </c:if>

                    <td class="grid" style="width:${dataCellWidth}%;">
                    <input type="hidden" name='${field.propertyName}' value='<c:out value="${fieldValue}"/>' />
                    &nbsp;
                    <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="${addHighlighting}" />
                  </td>
                </c:when>
                <c:when test="${field.fieldType eq field.IMAGE_SUBMIT && not isFormReadOnly}">
                    <%-- Might need something in here to show conditionally based upon isFieldReadOnly. --%>
                    <c:set var="imageCellSpan" value="2" />
                    <c:if test="${!isFieldAddingToACollection && isActionEdit}" >
                        <c:set var="imageCellSpan" value="4" />
                    </c:if>

                    <c:set var="cellAlign" value="center" />
                    <c:if test="${!empty field.cellAlign}" >
                      <c:set var="cellAlign" value="${field.cellAlign}" />
                    </c:if>

                    <c:set var="anchorTabIndex" value="${currentTabIndex}"/>
                    <c:if test="${fn:contains(field.propertyName, Constants.DELETE_LINE_METHOD)}">
                        <%-- when deleting, we have to anchor back to the top level tab, rather than the sub tab that we were viewing --%>
                        <c:set var="anchorTabIndex" value="${topLevelTabIndex}"/>
                    </c:if>
                    <th class="grid ${cellAlign}" colspan="4">
                        <c:set var="imageButtonName" value="${field.propertyName}.${Constants.METHOD_TO_CALL_PARM13_LEFT_DEL}${currentTabIndex}${Constants.METHOD_TO_CALL_PARM13_RIGHT_DEL}.anchor${anchorTabIndex}" />
                        ${kfunc:registerEditableProperty(KualiForm, imageButtonName)}
                        <input type="submit"
                                id='${field.propertyName}'
                                name='${imageButtonName}'
                                class="${field.styleClass}"
                                tabIndex="${tabIndex}"
                                value="${field.fieldShortLabel}"/>
                        <kul:fieldShowIcons isReadOnly="${isFieldReadOnly}" field="${field}" addHighlighting="false"/>
                    </th>
                </c:when>
            <c:when test="${field.fieldType eq field.BUTTON && isMaintenance && not isFormReadOnly}">
                <c:choose>
                    <c:when test="${not fn:contains(field.propertyName, Constants.MAINTENANCE_OLD_MAINTAINABLE)}">
                        <kul:fieldDefaultLabel isLookup="false"
                            isRequired="false"
                            isReadOnly="true" cellWidth="${dataCellWidth}%"
                            fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                            fieldLabel="${field.fieldLabel}" />

                        <c:if test="${numberOfColumns > 1}">
                            </tr>
                            <tr>
                        </c:if>

                        <td class="grid" style="width:${dataCellWidth}%;">
                        <html:submit
                                styleClass="${field.styleClass}"
                                property="${Constants.DISPATCH_REQUEST_PARAMETER}.${Constants.RETURN_METHOD_TO_CALL}.${Constants.METHOD_TO_CALL_PARM1_LEFT_DEL}${Constants.CUSTOM_ACTION}.${fn:substringAfter(field.propertyName, Constants.MAINTENANCE_NEW_MAINTAINABLE)}${Constants.METHOD_TO_CALL_PARM1_RIGHT_DEL}"
                                title="${field.fieldLabel}" alt="${field.fieldLabel}"
                                value="${field.fieldShortLabel}"/>
                        </td>
                    </c:when>
                    <c:otherwise>
                        <kul:fieldDefaultLabel isLookup="false"
                            isRequired="false"
                            isReadOnly="true" cellWidth="${dataCellWidth}%"
                            fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                            fieldLabel="" />

                        <c:if test="${numberOfColumns > 1}">
                            </tr>
                            <tr>
                        </c:if>

                        <td class="grid" style="width:${dataCellWidth}%;">&nbsp;</td>
                    </c:otherwise>
                </c:choose>
            </c:when>

            <c:when test="${field.fieldType eq field.LINK}">
                <c:choose>
                    <c:when
                        test="${not fn:contains(field.propertyName, Constants.MAINTENANCE_OLD_MAINTAINABLE)}">
                        <kul:fieldDefaultLabel isLookup="false"
                            isRequired="false"
                            isReadOnly="true" cellWidth="${dataCellWidth}%"
                            fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                            fieldLabel="${field.fieldLabel}" />

                        <c:if test="${numberOfColumns > 1}">
                            </tr>
                            <tr>
                        </c:if>

                        <td class="grid" style="width:${dataCellWidth}%;">
                        <c:if test="${not empty field.propertyValue }" >
                                <html:link href="${field.propertyValue}" target="${field.target}" styleClass="${field.styleClass}">${field.hrefText}
                                </html:link>
                        </c:if>
                        </td>
                    </c:when>
                    <c:otherwise>
                        <kul:fieldDefaultLabel isLookup="false"
                            isRequired="false"
                            isReadOnly="true" cellWidth="${dataCellWidth}%"
                            fieldName="${field.propertyName}" fieldType="${field.fieldType}"
                            fieldLabel="" />

                        <c:if test="${numberOfColumns > 1}">
                            </tr>
                            <tr>
                        </c:if>

                        <td class="grid" style="width:${dataCellWidth}%;">&nbsp;</td>
                    </c:otherwise>
                </c:choose>
            </c:when>
            </c:choose>

            <c:if test="${numberOfColumns > 1}">
                </tr>
                </table>
                </td>
            </c:if>
        </c:forEach>
    </tr>
</c:forEach>
