<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2020 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="docPhoneAttributes" value="${DataDictionary.PersonDocumentPhone.attributes}" />

<c:set var="canModify" scope="request" value="${!KualiForm.document.privacy.suppressPhone || KualiForm.canOverrideEntityPrivacyPreferences}" />
<c:set var="maskData" value="${KualiForm.document.privacy.suppressPhone && !KualiForm.canOverrideEntityPrivacyPreferences}" />

<kul:subtab lookedUpCollectionName="phone" width="${tableWidth}" subTabTitle="Phone Numbers" noShowHideButton="true">      
    <table class="standard side-margins">
        <tr>
            <th>&nbsp;</th> 
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docPhoneAttributes.phoneTypeCode}" noColon="true" /></div></th>
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docPhoneAttributes.phoneNumber}" noColon="true" /></div></th>
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docPhoneAttributes.extensionNumber}" noColon="true" /></div></th>
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docPhoneAttributes.countryCode}" noColon="true" /></div></th>
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docPhoneAttributes.dflt}" noColon="true" /></div></th>
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docPhoneAttributes.active}" noColon="true" /></div></th>
            <c:if test="${not inquiry and canModify}">  
                <kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
            </c:if>
         </tr>     
         <c:if test="${not inquiry and not readOnlyEntity and canModify}">              
             <tr>
                <th class="infoline">
                    <c:out value="Add:" />
                </th>

                <td align="left" valign="middle" class="infoline">
                    <div align="left">
                        <kul:htmlControlAttribute property="newPhone.phoneTypeCode" attributeEntry="${docPhoneAttributes.phoneTypeCode}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td class="infoline">
                    <div align="left">
                        <kul:htmlControlAttribute property="newPhone.phoneNumber" attributeEntry="${docPhoneAttributes.phoneNumber}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td class="infoline">   
                    <div align="left">
                      <kul:htmlControlAttribute property="newPhone.extensionNumber" attributeEntry="${docPhoneAttributes.extensionNumber}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                    <div align="left"><kul:htmlControlAttribute property="newPhone.countryCode" attributeEntry="${docPhoneAttributes.countryCode}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td class="infoline">   
                    <div align="left">
                      <kul:htmlControlAttribute property="newPhone.dflt" attributeEntry="${docPhoneAttributes.dflt}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>
                <td class="infoline">   
                    <div align="left">
                      <kul:htmlControlAttribute property="newPhone.active" attributeEntry="${docPhoneAttributes.active}" readOnly="${readOnlyEntity}" />
                    </div>
                </td>                                
                <td class="infoline">
                    <div align=left>
                        <html:submit property="methodToCall.addPhone.anchor${tabKey}"
                        value="Add" styleClass="btn btn-green"/>
                    </div>
                </td>
            </tr>         
        </c:if>        
        <c:forEach var="phone" items="${KualiForm.document.phones}" varStatus="status">
            <c:if test="${!(inquiry and readOnlyEntity and kfunc:isHiddenKimObjectType(phone.phoneType.code, 'kim.hide.PersonDocumentPhone.type'))}">
              <tr>
                <th class="infoline">
                    <c:out value="${status.index+1}" />
                </th>
                <td align="left" valign="middle">
                    <div align="left"> <kul:htmlControlAttribute property="document.phones[${status.index}].phoneTypeCode"  attributeEntry="${docPhoneAttributes.phoneTypeCode}"  readOnlyAlternateDisplay="${fn:escapeXml(phone.phoneType.name)}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <td>
                    <div align="left"> <kul:htmlControlAttribute property="document.phones[${status.index}].phoneNumber" attributeEntry="${docPhoneAttributes.phoneNumber}" readOnly="${readOnlyEntity or !canModify}"   displayMask="${maskData}" displayMaskValue="(XXX) XXX-XXXX" />
                    </div>
                </td>
                <td>     
                    <div align="left">
                      <kul:htmlControlAttribute property="document.phones[${status.index}].extensionNumber" attributeEntry="${docPhoneAttributes.extensionNumber}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="XXXX" />
                    </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                    <div align="left"><kul:htmlControlAttribute property="document.phones[${status.index}].countryCode" attributeEntry="${docPhoneAttributes.countryCode}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="XX" />
                    </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                    <div align="left"><kul:htmlControlAttribute property="document.phones[${status.index}].dflt" attributeEntry="${docPhoneAttributes.dflt}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                    <div align="left"><kul:htmlControlAttribute property="document.phones[${status.index}].active" attributeEntry="${docPhoneAttributes.active}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <c:if test="${not inquiry and canModify}">                      
                    <td>
                        <div align="left">&nbsp;
                             <c:choose>
                               <c:when test="${phone.edit or readOnlyEntity}">
                                   <button class="btn btn-red" disabled>Delete</button>
                               </c:when>
                               <c:otherwise>
                                  <html:submit property='methodToCall.deletePhone.line${status.index}.anchor${currentTabIndex}'
                                        value="Delete" styleClass='btn btn-red'/>
                               </c:otherwise>
                             </c:choose>  
                        </div>
                    </td>
                </c:if>    
              </tr>
            </c:if>  
        </c:forEach>
    </table>
</kul:subtab>
