<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2020 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="roleAttributes" value="${DataDictionary.RoleBo.attributes}"/>
<c:set var="roleTypeAttributes" value="${DataDictionary.KimTypeBo.attributes}"/>

<kul:tab tabTitle="Overview" defaultOpen="true" transparentBackground="${inquiry}"
		 tabErrorKey="document.role*,document.active">
	<div class="tab-container" align="center">
		<table class="standard side-margins">
			<tr>
				<kul:htmlAttributeHeaderCell labelFor="document.roleId"	attributeEntry="${roleAttributes.id}"
											 horizontal="true" addClass="right" width="25%" useShortLabel="false"/>
				<td class="datacell-nowrap" width="25%">
						<kul:htmlControlAttribute property="document.roleId" attributeEntry="${roleAttributes.id}"
												  readOnly="true"/>
				</td>
				<kul:htmlAttributeHeaderCell labelFor="document.roleTypeName" attributeEntry="${roleTypeAttributes.name}"
											 horizontal="true" addClass="right" width="25%" useShortLabel="false"/>
				<td class="datacell-nowrap" width="25%">
						<kul:htmlControlAttribute property="document.roleTypeName"
												  attributeEntry="${roleTypeAttributes.name}" readOnly="true"/>
				</td>
				<html:hidden property="document.roleTypeId"/>
			</tr>
			<tr>
				<kul:htmlAttributeHeaderCell labelFor="document.roleNamespace"
											 attributeEntry="${roleAttributes.namespaceCode}" horizontal="true"
											 addClass="right" width="25%" useShortLabel="false"/>
				<td class="datacell-nowrap" width="25%">
					<kul:htmlControlAttribute property="document.roleNamespace"
											  attributeEntry="${roleAttributes.namespaceCode}"
											  readOnly="${readOnly || editingDocument}"
											  onchange="namespaceChanged( this.form );"/>
					<c:if test="${!inquiry && !readOnly && !editingDocument}">
						<noscript>
							<html:image tabindex="32768" property="methodToCall.changeNamespace"
										src="${ConfigProperties.kr.externalizable.images.url}tinybutton-refresh.gif"
										styleClass="tinybutton"
										title="Click to refresh the page after changing the namespace."
										alt="Click to refresh the page after changing the namespace."/>
						</noscript>
					</c:if>
				</td>
				<kul:htmlAttributeHeaderCell labelFor="document.roleName" attributeEntry="${roleAttributes.name}"
											 horizontal="true" addClass="right" width="25%" useShortLabel="false"/>
				<td class="datacell-nowrap" width="25%">
					<kul:htmlControlAttribute property="document.roleName" attributeEntry="${roleAttributes.name}"
											  readOnly="${readOnly}"/>
				</td>
			</tr>
			<tr>
				<kul:htmlAttributeHeaderCell labelFor="document.active" attributeEntry="${roleAttributes.active}"
											 horizontal="true" addClass="right" width="25%" useShortLabel="false"/>
				<td class="datacell-nowrap" width="25%">
					<kul:htmlControlAttribute property="document.active" attributeEntry="${roleAttributes.active}"
											  readOnly="${readOnly}"/>
				</td>
				<kul:htmlAttributeHeaderCell labelFor="document.roleDescription"
											 attributeEntry="${roleAttributes.description}" horizontal="true"
											 addClass="right" width="25%" useShortLabel="false"/>
				<td class="datacell-nowrap" width="25%">
					<kul:htmlControlAttribute property="document.roleDescription"
											  attributeEntry="${roleAttributes.description}" readOnly="${readOnly}"/>
				</td>
			</tr>
		</table>
	</div>
</kul:tab>
