<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<kul:page headerTitle="Stuck Documents" lookup="true"
          transactionalDocument="false" showDocumentInfo="false"
          htmlFormAction="StuckDocuments" docTitle="Stuck Documents">
    <script>
        function updateConfig() {
            document.forms[0].elements['methodToCall'].value = 'updateConfig';
            document.forms[0].submit();
        }
        function runStuckNotificationNow() {
            document.forms[0].elements['methodToCall'].value = 'runStuckNotificationNow';
            document.forms[0].submit();
        }
        function report() {
            window.location.href='StuckDocuments.do?methodToCall=report';
        }
        function autofixReport() {
            window.location.href='StuckDocuments.do?methodToCall=autofixReport';
        }
    </script>
    <div class="headerarea-small" id="headerarea">
        <h1>Stuck Document Processing</h1>
    </div>
    <html-el:form action="StuckDocuments">
        <html-el:hidden property="methodToCall" value=""/>
        <kul:csrf />
        <div style="margin:2em">
            <p>
                Use this page to manage and configure:
            </p>
            <ul style="font-size: 13px;">
                <li>
                    Stuck Document notification
                </li>
                <li>
                    Autofix for system-detected stuck documents
                </li>
            </ul>
            <p>
                * use <a href="http://www.cronmaker.com/">Cron Maker</a> to help construct and interpret cron expressions.
            </p>
                <div class="tab-container">
                <h3>Notification</h3>
                <table class="standard">
                    <tr>
                        <th class="right top" width="46%">
                            Enable:
                        </th>
                        <td>
                            <html-el:radio property="notificationEnabled" styleId="notificationEnabled" value="true"/> True
                            <html-el:radio property="notificationEnabled" styleId="notificationEnabled" value="false"/> False
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            Cron Expression:
                        </th>
                        <td>
                            <html-el:text property="notificationCronExpression" styleId="notificationCronExpression"/>
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            From:
                        </th>
                        <td>
                            <html-el:text property="notificationFrom" styleId="notificationFrom"/>
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            To:
                        </th>
                        <td>
                            <html-el:text property="notificationTo" styleId="notificationTo"/>
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            Subject:
                        </th>
                        <td>
                            <html-el:text property="notificationSubject" styleId="notificationSubject" style="width:300px"/>
                            <aside>
                                <p>Available variables to use in the subject include:</p>
                                <ul>
                                    <li>&#36;{numStuckDocuments}</li>
                                    <li>&#36;{environment}</li>
                                    <li>&#36;{applicationUrl}</li>
                                </ul>
                            </aside>
                        </td>
                    </tr>
                </table>
            </div>

            <div class="tab-container">
                <h3>Autofix</h3>
                <table class="standard">
                    <tr>
                        <th class="right top" width="46%">
                            Enable:
                        </th>
                        <td>
                            <html-el:radio property="autofixEnabled" styleId="autofixEnabled" value="true"/> True
                            <html-el:radio property="autofixEnabled" styleId="autofixEnabled" value="false"/> False
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            Cron Expression:
                        </th>
                        <td>
                            <html-el:text property="autofixCronExpression" styleId="autofixCronExpression"/>
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            Quiet Period (sec):
                        </th>
                        <td>
                            <html-el:text property="autofixQuietPeriod" styleId="autofixQuietPeriod"/>
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            Max Attempts:
                        </th>
                        <td>
                            <html-el:text property="autofixMaxAttempts" styleId="autofixMaxAttempts"/>
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            Notify on Autofix Failure:
                        </th>
                        <td>
                            <html-el:radio property="autofixNotificationEnabled" styleId="autofixNotificationEnabled" value="true"/> True
                            <html-el:radio property="autofixNotificationEnabled" styleId="autofixNotificationEnabled" value="false"/> False
                        </td>
                    </tr>
                    <tr>
                        <th class="right top" width="46%">
                            Autofix Notification Subject:
                        </th>
                        <td>
                            <html-el:text property="autofixNotificationSubject" styleId="autofixNotificationSubject" style="width:300px"/>
                            <aside>
                                <p>Available variables to use in the subject include:</p>
                                <ul>
                                    <li>&#36;{documentId}</li>
                                    <li>&#36;{documentTypeLabel}</li>
                                    <li>&#36;{startDate}</li>
                                    <li>&#36;{endDate}</li>
                                    <li>&#36;{numberOfAutofixAttempts}</li>
                                    <li>&#36;{environment}</li>
                                    <li>&#36;{applicationUrl}</li>
                                </ul>
                            </aside>
                        </td>
                    </tr>
                </table>
            </div>

            <div style="text-align: center; box-shadow: 0 -2px 0 #F3F3F3; padding-top: 20px;">
                    <input class="btn btn-default" type="button" value="Update" onclick="updateConfig()"/>
                    <input class="btn btn-default" type="button" value="Run Notification Now" onclick="runStuckNotificationNow()"/>
                    <input class="btn btn-default" type="button" value="View Stuck Documents Report" onclick="report()"/>
                    <input class="btn btn-default" type="button" value="View Autofix Report" onclick="autofixReport()"/>
            </div>
        </div>
    </html-el:form>

</kul:page>
