<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<style type="text/css">
    .tab-subhead input {
        position: absolute;
        right: 60px;
    }
    .main-panel .tab-container h3 {
        padding: 10px 0 !important;
    }
    .main-panel .tab-container .tab-subhead {
        padding: 5px 0 !important;
    }
    tr.overridden td {
        text-decoration: line-through;
        color: #909090;
    }
    tr.overridden td a {
        color: #909090;
    }
    .main-panel .tab-container .tab-subhead h3 {
      text-transform: none;
    }
</style>

<c:set var="documentTypeAttributes" value="${DataDictionary.DocumentType.attributes}" scope="request" />
<c:set var="permissionAttributes" value="${DataDictionary.UberPermission.attributes}" scope="request" />
<c:set var="responsibilityAttributes" value="${DataDictionary.UberResponsibility.attributes}" scope="request" />
<c:set var="documentType" value="${KualiForm.documentType}" scope="request" />
<c:set var="attributeLabels" value="${KualiForm.attributeLabels}" scope="request" />
<c:set var="kimAttributes" value="${DataDictionary.KimAttributes.attributes}" scope="request" />

<kul:page
  headerTitle="Document Configuration - ${documentType.name}"
  transactionalDocument="false"
  showDocumentInfo="false"
  htmlFormAction="DocumentConfigurationView"
  docTitle="Document Configuration - ${documentType.name}"
>
	<html-el:hidden property="documentTypeName" />
    <c:if test="${empty documentType}">
        Unknown Document Type - <c:out value="${KualiForm.documentTypeName}" />
    </c:if>
<%--
    TODO: remove hard coded KIM class Impl names - if anything, redirect to the action to allow the code the make the
    determination of how to implement
    TODO: some attributes need to
--%>
    <c:if test="${!empty documentType}">
        <kul:tabTop
          tabTitle="Document Information"
          defaultOpen="true"
        >
            <div class="tab-container" style="width:auto;">
                <table style="margin: 16px 24px; width: 90%;" class="datatable">
                  <tbody>
                    <tr>
                      <kul:htmlAttributeHeaderCell scope="col" align="left"
                        attributeEntry="${documentTypeAttributes.name}" />
                      <td>
                        <kul:inquiry boClassName="org.kuali.kfs.kew.doctype.bo.DocumentType"
                                     keyValues="documentTypeId=${documentType.documentTypeId}" render="true">
                            <kul:htmlControlAttribute attributeEntry="${documentTypeAttributes.name}"
                              property="documentType.name"
                              readOnly="true" />
                        </kul:inquiry>
                        <c:if test="${KualiForm.canInitiateDocumentTypeDocument}">
                        <a href="<c:url value="${ConfigProperties.application.url}/${KRADConstants.MAINTENANCE_ACTION}">
                            <c:param name="methodToCall" value="edit" />
                            <c:param name="businessObjectClassName" value="org.kuali.kfs.kew.doctype.bo.DocumentType"/>
                            <c:param name="documentTypeId" value="${documentType.documentTypeId}"/>
                            <c:param name="name" value="${documentType.name}"/>
                          </c:url>" target="_blank">Edit Document Type</a>
                          </c:if>
                      </td>
                      <kul:htmlAttributeHeaderCell scope="col" align="left"
                        attributeEntry="${documentTypeAttributes.unresolvedDocHandlerUrl}" />
                      <td>
                        <kul:htmlControlAttribute attributeEntry="${documentTypeAttributes.unresolvedDocHandlerUrl}"
                          property="documentType.unresolvedDocHandlerUrl"
                          readOnly="true" />
                      </td>
                    </tr>
                    <tr>
                      <kul:htmlAttributeHeaderCell scope="col" align="left"
                        attributeEntry="${documentTypeAttributes.label}" />
                      <td>
                        <kul:htmlControlAttribute attributeEntry="${documentTypeAttributes.label}"
                          property="documentType.label"
                          readOnly="true" />
                      </td>
                      <kul:htmlAttributeHeaderCell scope="col" align="left"
                        attributeEntry="${documentTypeAttributes.unresolvedHelpDefinitionUrl}" />
                      <td>
                        <kul:htmlControlAttribute attributeEntry="${documentTypeAttributes.unresolvedHelpDefinitionUrl}"
                          property="documentType.helpDefinitionUrl"
                          readOnly="true" />
                      </td>
                    </tr>
                    <tr>
                      <kul:htmlAttributeHeaderCell
                        scope="col"
                        align="left"
                        attributeEntry="${documentTypeAttributes['parentDocType.name']}"
                      />
                      <td>
                        <c:if test="${!empty KualiForm.parentDocumentType.name}">
                        <a href="?documentTypeName=${KualiForm.parentDocumentType.name}">
                          <kul:htmlControlAttribute attributeEntry="${documentTypeAttributes['parentDocType.name']}"
                                                    property="parentDocumentType.name"
                                                    readOnly="true" />
                          <c:if test="${fn:length( KualiForm.parentDocumentType.name ) <= 10}">
                              (<c:out value="${KualiForm.parentDocumentType.label}" />)
                          </c:if>
                        </a>
                        </c:if>
                      </td>
                      <th align="left" scope="col">
                        Child Document Types
                      </th>
                      <td>
                        <c:forEach var="childDocType" items="${KualiForm.childDocumentTypes}" varStatus="status">
                        <a href="?documentTypeName=${childDocType.name}"><c:out value="${childDocType.name}" />
                          <c:if test="${fn:length( childDocType.name ) <= 10}">
                          (<c:out value="${childDocType.label}" />)
                          </c:if>
                        </a><br />
                          </c:forEach>
                      </td>
                    </tr>
                </tbody>
            </table>
          </div>
        </kul:tabTop>
          <kul:tab tabTitle="Permissions" defaultOpen="true">
            <div class="tab-container" style="width:auto; margin: 16px 24px;">
             Gray lines that are stricken through represent inherited permissions that have been overridden by a more specific permission.
             <%-- loop over the document types, going up the hierarchy --%>
                <c:forEach var="permDocTypeName" items="${KualiForm.docTypeHierarchyList}">
                    <c:choose>
                        <c:when test="${permDocTypeName == documentType.name}">
                            <c:set var="tabLabel" value="Defined For This Document" />
                            <c:set var="docTypeNameSave" value="${permDocTypeName}" />
                        </c:when>
                        <c:otherwise>
                            <c:set var="tabLabel" value="Inherited From: ${permDocTypeName}" />
                            <c:set var="docTypeNameSave" value="${permDocTypeName}" />
                        </c:otherwise>
                    </c:choose>
                    <kul:subtab width="100%" subTabTitle="${tabLabel}" noShowHideButton="false" open="true">
                        <c:set var="permissions" value="${KualiForm.permissionsByDocumentType[permDocTypeName]}" scope="request" />
                        <c:set var="docTypeNameVar" value="${docTypeNameSave}" scope="request" />
                        <c:import url="DocumentConfigurationViewPermissionList.jsp" />
                    </kul:subtab>
                </c:forEach>
            </div>
            </kul:tab>

            <kul:tab tabTitle="Workflow / Responsibilities" defaultOpen="true" >
                <div class="tab-container" style="margin: 16px 24px;">
                  Gray lines that are stricken through represent inherited responsibilities that have been overridden by a more specific responsibilities.
                  <kul:subtab width="100%" subTabTitle="Exception Routing" noShowHideButton="true">
                      <c:set var="responsibilities" value="${KualiForm.exceptionResponsibilities}" scope="request" />
                      <c:set var="exceptionResp" value="true" scope="request"/>
                      <c:import url="DocumentConfigurationViewResponsibilityList.jsp" />
                  </kul:subtab>
                  <c:set var="routeNodeIndentLevel" value="0" />
                  <c:forEach var="node" items="${KualiForm.routeNodes}">
                  <%-- ${node.nodeType} - ${node.routeNodeName}<br /> --%>
                  <c:if test="${fn:contains(node.nodeType,'SplitNode')}">
                  <table
                      class="datatable"
                      cellpadding="0"
                      cellspacing="0"
                      align="center"
                      style="
                          text-align: left;
                          margin-left: ${routeNodeIndentLevel}em;
                          background-color: #F3F3F3;
                      "
                  >
                    <c:set var="routeNodeIndentLevel" value="${routeNodeIndentLevel + 5}" />
                    <tbody>
                      <tr>
                        <td class="tab-subhead" style="padding-top: 8px !important;">
                          <span class="left">Split Node: ${node.routeNodeName}</span>
                        </td>
                      </tr>
                      <tr>
                          <td style="margin-left: ${routeNodeIndentLevel}em;">
                    </c:if>
                    <c:if test="${node.routeNodeName != 'AdHoc' && !fn:contains(node.nodeType,'NoOpNode') && !fn:contains(node.nodeType,'SplitNode') && !fn:contains(node.nodeType,'JoinNode')}">
                        <c:set var="responsibilities" value="${KualiForm.responsibilityMap[node.routeNodeName]}" scope="request" />
                        <c:set var="routeNodeName" value="${node.routeNodeName}" scope="request"/>
                        <c:set var="exceptionResp" value="false" scope="request"/>
                        <kul:subtab width="100%" subTabTitle="Route Node: ${node.routeNodeName}" noShowHideButton="true">
                        <c:import url="DocumentConfigurationViewResponsibilityList.jsp" />
                        </kul:subtab>
                    </c:if>
                    <c:if test="${fn:contains(node.nodeType,'JoinNode')}">
                        </td></tr>
                    </tbody>
                  </table>
                  <c:set var="routeNodeIndentLevel" value="${routeNodeIndentLevel - 5}" />
                  </c:if>
                    </c:forEach>
                </div>
            </kul:tab>
          <kul:panelFooter />
  </c:if>

</kul:page>
