<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2021 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<c:set var="inquiry" scope="request" value="${KualiForm.inquiry}" />
<c:set var="readOnly" scope="request" value="${inquiry}" />
<c:set var="readOnly" scope="request" value="${!KualiForm.documentActions[KRADConstants.KUALI_ACTION_CAN_EDIT] || inquiry}" />
<c:set var="canAssignGroup" scope="request" value="${KualiForm.canAssignGroup && !readOnly}" />
<c:set var="editingDocument" scope="request" value="${KualiForm.document.editing}" />

<c:set var="formAction" value="identityManagementGroupDocument" />
<c:if test="${inquiry}">
	<c:set var="formAction" value="identityManagementGroupInquiry" />
</c:if>

<kul:documentPage
	showDocumentInfo="${!inquiry}"
	htmlFormAction="${formAction}"
	documentTypeName="GRUP"
	renderMultipart="${inquiry}"
	showTabButtons="true"
>

    <c:if test="${!inquiry}">
        <kul:hiddenDocumentFields />
        <kul:documentOverview editingMode="${KualiForm.editingMode}" />
    </c:if>
    <c:if test="${inquiry}">
        <div id="workarea">
    </c:if>
	<kim:groupOverview />
	<kim:groupAttributes />
	<kim:groupAssignees />

    <c:if test="${!inquiry}">
        <kul:adHocRecipients /> 
        <kul:routeLog />
    </c:if>
    <kul:superUserActions />
    <c:if test="${inquiry}">
        </div>
    </c:if>
    <c:choose>
        <c:when test="${!inquiry}">
            <kul:documentControls transactionalDocument="false" />
            <input type="hidden" name="groupId" value="${KualiForm.document.groupId}" />
            <script type="text/javascript">
            function changeMemberTypeCode( frm ) {
                postMethodToCall( frm, "changeMemberTypeCode" );
            }
            function namespaceChanged( frm ) {
                postMethodToCall( frm, "changeNamespace" );
            }
            function postMethodToCall( frm, methodToCall ) {
                var methodToCallElement=document.createElement("input");
                methodToCallElement.setAttribute("type","hidden");
                methodToCallElement.setAttribute("name","methodToCall");
                methodToCallElement.setAttribute("value", methodToCall );
                frm.appendChild(methodToCallElement);
                frm.submit();
            } 
            </script>
        </c:when>
        <c:otherwise>
            <kul:inquiryControls />
            <input type="hidden" name="groupId" value="${KualiForm.document.groupId}" />
        </c:otherwise>
    </c:choose>
</kul:documentPage>
