/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2021 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// eslint-disable-next-line no-unused-vars
function updateLocationByPostalCode (postalCodeField, callbackFunction) {
  var postalCode = getElementValue(postalCodeField.name)
  var postalCountryCode = getElementValue(
    findElPrefix(postalCodeField.name) + '.organizationCountryCode'
  )

  if (postalCode !== '' && postalCountryCode !== '') {
    var dwrReply = {
      callback: callbackFunction,
      errorHandler: function (errorMessage) {
        setRecipientValue(
          'document.newMaintainableObject.organizationCityName',
          wrapError('postal code not found'),
          true
        )
        clearRecipients('document.newMaintainableObject.organizationStateCode')
      }
    }
    // eslint-disable-next-line
    LocationService.getPostalCode(postalCountryCode, postalCode, dwrReply)
  }
}

// eslint-disable-next-line
function updateLocationByPostalCode_Callback(data) {
  setRecipientValue(
    'document.newMaintainableObject.organizationCityName',
    data.cityName
  )
  setRecipientValue(
    'document.newMaintainableObject.organizationStateCode',
    data.stateCode
  )
}

// eslint-disable-next-line no-unused-vars
function updateLocationByCountryCode (countryCodeField, callbackFunction) {
  var postalCountryCode = getElementValue(countryCodeField.name)
  var postalCode = getElementValue(
    findElPrefix(countryCodeField.name) + '.organizationZipCode'
  )

  if (postalCode !== '' && postalCountryCode !== '') {
    var dwrReply = {
      callback: callbackFunction,
      errorHandler: function (errorMessage) {
        setRecipientValue(
          'document.newMaintainableObject.organizationCityName',
          wrapError('postal code not found'),
          true
        )
        clearRecipients('document.newMaintainableObject.organizationStateCode')
      }
    }
    // eslint-disable-next-line
    PostalCodeService.getPostalCode(postalCountryCode, postalCode, dwrReply)
  }
}

// eslint-disable-next-line
function updateLocationByCountryCode_Callback(data) {
  setRecipientValue(
    'document.newMaintainableObject.organizationCityName',
    data.cityName
  )
  setRecipientValue(
    'document.newMaintainableObject.organizationStateCode',
    data.stateCode
  )
}
