<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2026 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<%--* KULRICE-12294, removed this line in order to establish the User session
  --%>
<%-- <%@ page session="false" %> --%>
<%@ page import="java.util.List" %>
<%@ page import="java.util.Iterator" %>


<kul:page docTitle="Ingester" headerMenuBar=""
	headerTitle="Ingester" transactionalDocument="" htmlFormAction="Ingester" renderMultipart="true" lookup="true"
	>

<div id="headerarea-small" class="headerarea-small">
<h1>Ingester</h1>
</div>

<div class="error">

<input class="tinybutton" name="methodToCall.search" src="static/images/pixel_clear.gif" type="image" border="0" height="0" width="0">

<c:if test="${messages != null}">
  <ul style="list-style-type: none; margin-bottom: 30px;">
    <c:forEach var="message" items="${messages}" >
      <li>
  	    <!-- pre makes stack traces, etc. format correctly -->
        <pre><c:out value="${message}"/></pre>
      </li>
    </c:forEach>
  </ul>
</c:if>

<kul:errors displayRemaining="true"
	errorTitle="Other errors:"
	warningTitle="Other warnings:"
	infoTitle="Other informational messages:"/>

</div>
<div>
	<table class="datatable-center" style="margin: 10px auto 30px auto;" cellspacing="0" cellpadding="0">
		<tbody>
			<tr>
				<th class="grid" valign="center">
					<label style="margin-bottom: 0; margin-right: 8px">XML File:</label>
				</th>
				<td class="grid" valign="center">
					<html-el:file styleClass="dataCell" name="IngesterForm" size="50" property="file[0]" />
				</td>
				<td class="infoline" height="30" colspan="2">
					 <html:submit
						title="Upload XML data"
						styleClass="btn btn-default"
						styleId="imageField"
					 >
						 Upload
					 </html:submit>
				</td>
			</tr>
		</tbody>
	</table>
</div>
<%--* Ingester alert
  --%>
  <c:if test="${kfunc:isProductionEnvironment()}">
    <script type="text/javascript">
      jQuery(function() {
        alert('<bean:message key="ingester.alert.initial" />');
        jQuery('#kualiForm').submit(function() {
          var bool = confirm('<bean:message key="ingester.alert.onsubmit" />');
          excludeSubmitRestriction = !bool;
          return bool;
        });
        excludeSubmitRestriction = true;
      });
    </script>
  </c:if>
</kul:page>
