<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2026 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ attribute name="readOnly" required="true" description="If document is in read only mode"%>

<style type="text/css">
	.submit-link {
		background: none;
		border: none;
		color: #06c;
		outline: none;
		padding: 0;
		text-decoration: underline;
	}

	.send-indicator-checkbox {
		vertical-align: top !important;
		padding-right: 0px !important;
		width: 0px;
	}
</style>

<script type="text/javascript">
	$(document).ready(function() {
		$('.resendInvoice').attr("disabled",true);
		$('.send-indicator').change(function() {
			$('.resendInvoice').attr('disabled', $('.send-indicator:checked').length == 0);
		});
	});
</script>

<c:set var="invoiceAccountDetailsAttributes" value="${DataDictionary.InvoiceAccountDetail.attributes}" />
<c:set var="invoiceAddressDetailsAttributes" value="${DataDictionary.InvoiceAddressDetail.attributes}" />
<c:set var="invoiceGeneralDetailAttributes" value="${DataDictionary.InvoiceGeneralDetail.attributes}" />

<c:if test="${!empty KualiForm.document.invoiceGeneralDetail.proposalNumber}">
	<kul:tab tabTitle="Transmission Details" defaultOpen="true"
			 tabErrorKey="document.invoiceAddressDetails*,document.invoiceGeneralDetail.customerInvoiceTemplateCode">
		<div class="tab-container" align="center">
			<br/>
			<table cellpadding="0" cellspacing="0" class="datatable standard side-margins" summary="Customer Address">
				<tr class="header">
					<th class="left" style="width: 25%;">
						<kul:htmlAttributeLabel attributeEntry="${invoiceGeneralDetailAttributes['customerAddress.customerAddressName']}" />
					</th>
					<th class="left" style="width: 25%;">
						<kul:htmlAttributeLabel attributeEntry="${invoiceGeneralDetailAttributes.customerInvoiceTemplateCode}" />
					</th>
				</tr>
				<tr>
					<td class="top">
						<kul:htmlControlAttribute
								attributeEntry="${invoiceGeneralDetailAttributes['customerAddress.customerAddressName']}"
								property="document.invoiceGeneralDetail.customerAddress.customerAddressName"
								readOnly="true" />
					</td>
					<td class="datacell" style="width: 85%;">
						<kul:htmlControlAttribute
								attributeEntry="${invoiceGeneralDetailAttributes.customerInvoiceTemplateCode}"
								property="document.invoiceGeneralDetail.customerInvoiceTemplateCode"
								readOnly="${readOnly}" />
					</td>
				</tr>
			</table>
			<table cellpadding=0 class="datatable standard side-margins no-min" summary="Transmission Details section">
				<tr class="header">
					<kul:htmlAttributeHeaderCell attributeEntry="${invoiceAddressDetailsAttributes.sendIndicator}"
												 useShortLabel="true" colspan="2"/>
					<kul:htmlAttributeHeaderCell
							attributeEntry="${invoiceAddressDetailsAttributes.transmissionStatusCode}"
							useShortLabel="true" />
					<kul:htmlAttributeHeaderCell attributeEntry="${invoiceAddressDetailsAttributes.transmissionDate}"
												 useShortLabel="true" />
					<kul:htmlAttributeHeaderCell
							attributeEntry="${invoiceAddressDetailsAttributes['transmittedBy.name']}"
							useShortLabel="true" />
					<kul:htmlAttributeHeaderCell attributeEntry="${invoiceAddressDetailsAttributes.transmissionCount}"
												 useShortLabel="false" addClass="right"/>
				</tr>
				<c:forEach var="invoiceAddressDetail" items="${KualiForm.document.invoiceAddressDetails}"
						   varStatus="loopCounter" >
					<tr class="${loopCounter.index % 2 == 0 ? 'highlight' : ''}">
						<td class="datacell send-indicator-checkbox">
							<kul:htmlControlAttribute
									attributeEntry="${invoiceAddressDetailsAttributes.sendIndicator}"
									property="document.invoiceAddressDetails[${loopCounter.index}].sendIndicator"
									styleClass="send-indicator"
									disabled="${invoiceAddressDetail.queued || !KualiForm.sendIndicatorSelectable}"/>
						</td>
						<td class="datacell">
							<c:if test="${invoiceAddressDetail.invoiceTransmissionMethodCode == ArConstants.InvoiceTransmissionMethod.MAIL}">
								${invoiceAddressDetail.customerLine1StreetAddress}<br/>
								<c:if test="${not empty invoiceAddressDetail.customerLine2StreetAddress}">${invoiceAddressDetail.customerLine2StreetAddress}<br/></c:if>
								<c:if test="${not empty invoiceAddressDetail.customerCityName}">${invoiceAddressDetail.customerCityName},</c:if>
								<c:if test="${not empty invoiceAddressDetail.customerStateCode || not empty invoiceAddressDetail.customerZipCode}">${invoiceAddressDetail.customerStateCode}, ${invoiceAddressDetail.customerZipCode}<br/></c:if>
								<c:if test="${not empty invoiceAddressDetail.customerAddressInternationalProvinceName || not empty invoiceAddressDetail.customerInternationalMailCode}">${invoiceAddressDetail.customerAddressInternationalProvinceName}, ${invoiceAddressDetail.customerInternationalMailCode}<br/></c:if>
								<kul:htmlControlAttribute
										attributeEntry="${invoiceAddressDetailsAttributes.customerCountryCode}"
										property="document.invoiceAddressDetails[${loopCounter.index}].customerCountryCode"
										readOnly="true" />
							</c:if>
							<c:if test="${invoiceAddressDetail.invoiceTransmissionMethodCode == ArConstants.InvoiceTransmissionMethod.EMAIL}">
								<kul:htmlControlAttribute
										attributeEntry="${invoiceAddressDetailsAttributes.customerEmailAddress}"
										property="document.invoiceAddressDetails[${loopCounter.index}].customerEmailAddress"
										readOnly="${readOnly || invoiceAddressDetail.queued || !KualiForm.showTransmissionButton}"/>
							</c:if>
						</td>
						<td class="datacell">
							<kul:htmlControlAttribute
									attributeEntry="${invoiceAddressDetailsAttributes.transmissionStatusCode}"
									property="document.invoiceAddressDetails[${loopCounter.index}].transmissionStatusCode"
									readOnly="true" />
							&nbsp;
							<c:if test="${invoiceAddressDetail.queued && KualiForm.showTransmissionButton}">
								<html:submit
										property="methodToCall.unqueueTransmission.line${loopCounter.index}"
										alt="Un-Queue from Transmission"
										title="Un-Queue from Transmission"
										styleClass="submit-link"
										value="cancel"/>
							</c:if>
						</td>
						<td class="datacell">
							<kul:htmlControlAttribute
									attributeEntry="${invoiceAddressDetailsAttributes.initialTransmissionDate}"
									property="document.invoiceAddressDetails[${loopCounter.index}].transmissionDate"
									readOnly="true"/>
						</td>
						<td class="datacell">
							<kul:htmlControlAttribute
									attributeEntry="${invoiceAddressDetailsAttributes.invoiceTransmissionMethodCode}"
									property="document.invoiceAddressDetails[${loopCounter.index}].transmittedBy.name"
									readOnly="true"/>
						</td>
						<td class="datacell text-right">
							<c:choose>
								<c:when test="${invoiceAddressDetail.transmissionCount > 0}">
									<kul:htmlControlAttribute
											attributeEntry="${invoiceAddressDetailsAttributes.invoiceTransmissionMethodCode}"
											property="document.invoiceAddressDetails[${loopCounter.index}].transmissionCount"
											readOnly="true"/>
								</c:when>
								<c:otherwise>
									&nbsp;
								</c:otherwise>
							</c:choose>
						</td>
					</tr>
				</c:forEach>
				<tr>
					<c:if test="${KualiForm.showTransmissionButton}">
						<td class="datacell-nowrap" colspan="6">
							<br/>
							<html:submit
									property="methodToCall.queueTransmission"
									alt="Resend Invoice"
									title="Resend Invoice"
									styleClass="btn btn-primary resendInvoice"
									value="Resend Invoice"/>
							<html:submit
									property="methodToCall.markManuallySent"
									alt="Sent Manually"
									title="Sent Manually"
									styleClass="btn btn-primary resendInvoice"
									value="Sent Manually"/>
						</td>
					</c:if>
				</tr>
			</table>
		</div>
	</kul:tab>
</c:if>
