/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


// eslint-disable-next-line
function onblur_customerNumber (customerNumberField) {
  // eslint-disable-next-line
  singleKeyLookup(
    CustomerService.getByPrimaryKey,
    customerNumberField,
    'customer',
    'customerName',
  )
}
function singleKeyLookup (dwrFunction, primaryKeyField, boName, propertyName) {
  var primaryKeyValue = dwr.util.getValue(primaryKeyField.name).trim()
  var targetFieldName = findElPrefix(primaryKeyField.name) + '.' + boName + '.' + propertyName
  if (primaryKeyValue === '') {
    clearRecipients(targetFieldName)
  } else {
    dwrFunction(primaryKeyValue, makeDwrSingleReply(boName, propertyName, targetFieldName))
  }
}

function makeDwrSingleReply (boName, propertyName, targetFieldName) {
  var friendlyBoName = boName.replace(/([A-Z])/g, ' $1').toLowerCase()
  return {
    callback: function (data) {
      if (data != null && typeof data === 'object') {
        setRecipientValue(targetFieldName, data[propertyName])
      } else {
        setRecipientValue(targetFieldName, wrapError(friendlyBoName + ' not found'), true)
      }
    },
    errorHandler: function (errorMessage) {
      setRecipientValue(targetFieldName, wrapError(friendlyBoName + ' not found'), true)
    }
  }
}
