/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import babelParser from '@babel/eslint-parser';
import { fileURLToPath } from 'node:url';
import { FlatCompat } from '@eslint/eslintrc';
import globals from 'globals';
import js from '@eslint/js';
import path from 'node:path';
import tsParser from '@typescript-eslint/parser';
import typescriptEslint from '@typescript-eslint/eslint-plugin';
import vitestGlobals from 'eslint-plugin-vitest-globals';
import { fixupConfigRules, fixupPluginRules } from '@eslint/compat';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);
const compat = new FlatCompat({
  baseDirectory: __dirname,
  recommendedConfig: js.configs.recommended,
  allConfig: js.configs.all
});

export default [{
  ignores: [
    '**/*.min.js',
    '**/coa/*.js',
    '**/fp/*.js',
    '**/module/*.js',
    '**/pdp/*.js',
    '**/vnd/*.js'
  ]
}, ...fixupConfigRules(compat.extends(
  'semistandard',
  'standard-jsx',
  'standard-react',
  'plugin:react-hooks/recommended',
  'plugin:testing-library/react',
  'plugin:vitest-globals/recommended'
)), {
  languageOptions: {
    globals: {
      ...vitestGlobals.environments.env.globals,
      ...globals.browser,
      ...globals.node,
      ...globals.jquery,
      vi: true,
      stayOnPage: true,
      dwr: true,
      wrapError: true,
      setRecipientValue: true,
      clearRecipients: true,
      valueChanged: true,
      findElPrefix: true,
      getElementValue: true,
      setElementValue: true,
      divSuffix: true,
      kualiElements: true
    },

    parser: babelParser
  },

  rules: {
    'sort-imports': ['warn', {
      ignoreCase: true,
      ignoreMemberSort: false,
      memberSyntaxSortOrder: ['none', 'all', 'single', 'multiple']
    }],

    'testing-library/no-unnecessary-act': 'off',
    'react/jsx-uses-react': 'off',
    'react/react-in-jsx-scope': 'off'
  }
}, ...fixupConfigRules(compat.extends(
  'semistandard',
  'standard-jsx',
  'standard-react',
  'plugin:react-hooks/recommended',
  'plugin:@typescript-eslint/recommended-type-checked',
  'plugin:@typescript-eslint/stylistic-type-checked',
  'plugin:testing-library/react',
  'plugin:vitest-globals/recommended'
)).map(config => ({
  ...config,
  files: ['**/*.ts', '**/*.tsx']
})), {
  files: ['**/*.ts', '**/*.tsx'],

  plugins: {
    '@typescript-eslint': fixupPluginRules(typescriptEslint)
  },

  languageOptions: {
    parser: tsParser,
    ecmaVersion: 5,
    sourceType: 'module',

    parserOptions: {
      project: true
    }
  },

  rules: {
    'sort-imports': ['warn', {
      ignoreCase: true,
      ignoreMemberSort: false,
      memberSyntaxSortOrder: ['none', 'all', 'single', 'multiple']
    }],

    'linebreak-style': ['warn', 'unix'],
    '@typescript-eslint/no-unsafe-assignment': 'off',
    '@typescript-eslint/no-unsafe-member-access': 'off',

    '@typescript-eslint/no-unused-vars': ['warn', {
      argsIgnorePattern: '^_',
      varsIgnorePattern: '^_',
      caughtErrorsIgnorePattern: '^_'
    }],

    'react/jsx-uses-react': 'off',
    'react/react-in-jsx-scope': 'off'
  }
}];
