<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2025 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>
<%@ page import="org.kuali.kfs.coa.service.AccountService" %>
<%@ page import="org.kuali.kfs.sys.context.SpringContext" %>

<c:set var="gltDocumentAttributes" value="${DataDictionary.GeneralLedgerTransferDocument.attributes}"/>
<c:set var="readOnly" value="${!KualiForm.documentActions[KRADConstants.KUALI_ACTION_CAN_EDIT]}"/>
<c:set var="accountsCanCrossCharts" value="<%=SpringContext.getBean(AccountService.class).accountsCanCrossCharts()%>"/>

<kul:documentPage showDocumentInfo="true"
                  documentTypeName="GeneralLedgerTransferDocument"
                  htmlFormAction="financialGeneralLedgerTransfer" renderMultipart="true"
                  showTabButtons="true">

    <sys:documentOverview editingMode="${KualiForm.editingMode}"/>

    <c:if test="${KualiForm.document.documentHeader.workflowDocument.initiated || KualiForm.document.documentHeader.workflowDocument.saved}">
        <kul:tab tabTitle="Accounting Lines Lookup" defaultOpen="true">
            <div class="tab-container">
                <table class="standard" summary="Ledger Balance Importing">
                    <tr>
                        <kul:htmlAttributeHeaderCell
                                attributeEntry="${gltDocumentAttributes.universityFiscalYear}"
                                horizontal="true" width="35%" labelFor="universityFiscalYear" useShortLabel="false" addClass="right"/>

                        <td class="datacell-nowrap"><kul:htmlControlAttribute
                                attributeEntry="${gltDocumentAttributes.universityFiscalYear}"
                                property="generalLedgerTransferDocument.universityFiscalYear" readOnly="${readOnly}"/>

                            <c:if test="${!readOnly}">
                                <kul:lookup boClassName="org.kuali.kfs.sys.businessobject.SystemOptions"
                                            lookupParameters="generalLedgerTransferDocument.universityFiscalYear:universityFiscalYear"
                                            fieldConversions="universityFiscalYear:generalLedgerTransferDocument.universityFiscalYear"
                                            fieldLabel="${gltDocumentAttributes.universityFiscalYear.label}"/>
                            </c:if>
                        </td>
                    </tr>

                    <tr>
                        <kul:htmlAttributeHeaderCell
                                attributeEntry="${gltDocumentAttributes.universityFiscalAccountingPeriod}"
                                horizontal="true" width="35%" labelFor="universityFiscalPeriod" useShortLabel="false"
                                addClass="right"/>

                        <td class="datacell-nowrap"><kul:htmlControlAttribute
                                attributeEntry="${gltDocumentAttributes.universityFiscalAccountingPeriod}"
                                property="generalLedgerTransferDocument.universityFiscalAccountingPeriod"
                                readOnly="${readOnly}"/>

                            <c:if test="${!readOnly}">
                                <kul:lookup boClassName="org.kuali.kfs.coa.businessobject.AccountingPeriod"
                                            lookupParameters="generalLedgerTransferDocument.universityFiscalYear:universityFiscalYear"
                                            fieldConversions="universityFiscalPeriodCode:generalLedgerTransferDocument.universityFiscalAccountingPeriod"
                                            fieldLabel="${gltDocumentAttributes.universityFiscalAccountingPeriod.label}"/>
                            </c:if>
                        </td>
                    </tr>

                    <tr>
                        <kul:htmlAttributeHeaderCell
                                attributeEntry="${gltDocumentAttributes.chartOfAccountsCode}"
                                horizontal="true" width="35%" labelFor="chartOfAccountsCode" hideRequiredAsterisk="true"
                                useShortLabel="false" addClass="right"/>

                        <td class="datacell-nowrap">
                            <kul:htmlControlAttribute
                                    onblur="loadChartInfo(this.name, 'generalLedgerTransferDocument.chart.finChartOfAccountDescription')"
                                    onchange="loadChartInfo(this.name, 'generalLedgerTransferDocument.chart.finChartOfAccountDescription')"
                                    attributeEntry="${gltDocumentAttributes.chartOfAccountsCode}"
                                    property="generalLedgerTransferDocument.chartOfAccountsCode"
                                    readOnly="${readOnly or !accountsCanCrossCharts}"/>

                            <c:if test="${!readOnly and accountsCanCrossCharts}">
                                <kul:lookup boClassName="org.kuali.kfs.coa.businessobject.Chart"
                                            lookupParameters="generalLedgerTransferDocument.chartOfAccountsCode:chartOfAccountsCode"
                                            fieldConversions="chartOfAccountsCode:generalLedgerTransferDocument.chartOfAccountsCode"
                                            fieldLabel="${gltDocumentAttributes.chartOfAccountsCode.label}"/>
                            </c:if>
                            <div id="generalLedgerTransferDocument.chart.finChartOfAccountDescription.div"><bean:write name="KualiForm" property="generalLedgerTransferDocument.chart.finChartOfAccountDescription"/></div>
                        </td>
                    </tr>

                    <tr>
                        <kul:htmlAttributeHeaderCell
                                attributeEntry="${gltDocumentAttributes.accountNumber}"
                                horizontal="true" width="35%" labelFor="accountNumber" hideRequiredAsterisk="true" useShortLabel="false" addClass="right"/>

                        <td class="datacell-nowrap"><kul:htmlControlAttribute
                                onblur="loadAccountInfo(this.name, 'generalLedgerTransferDocument.account.accountName')"
                                attributeEntry="${gltDocumentAttributes.accountNumber}"
                                property="generalLedgerTransferDocument.accountNumber" readOnly="${readOnly}"/>

                            <c:if test="${!readOnly}">
                                <kul:lookup boClassName="org.kuali.kfs.coa.businessobject.Account"
                                            fieldConversions="chartOfAccountsCode:generalLedgerTransferDocument.chartOfAccountsCode,accountNumber:generalLedgerTransferDocument.accountNumber"
                                            newLookup="true"/>
                            </c:if>
                            <div id="generalLedgerTransferDocument.account.accountName.div"><bean:write name="KualiForm" property="generalLedgerTransferDocument.account.accountName"/></div>
                        </td>
                    </tr>

                    <tr>
                        <kul:htmlAttributeHeaderCell
                                attributeEntry="${gltDocumentAttributes.financialObjectCode}"
                                horizontal="true" width="35%" labelFor="financialObjectCode" hideRequiredAsterisk="true" useShortLabel="false" addClass="right"/>

                        <td class="datacell-nowrap"><kul:htmlControlAttribute
                                onblur="loadObjectInfo('${KualiForm.document.postingYear}', '','', this.name, 'generalLedgerTransferDocument.objectCode.financialObjectCodeName')"
                                attributeEntry="${gltDocumentAttributes.financialObjectCode}"
                                property="generalLedgerTransferDocument.financialObjectCode" readOnly="${readOnly}"/>

                            <c:if test="${!readOnly}">
                                <kul:lookup boClassName="org.kuali.kfs.coa.businessobject.ObjectCode"
                                            lookupParameters="generalLedgerTransferDocument.universityFiscalYear:universityFiscalYear,generalLedgerTransferDocument.chartOfAccountsCode:chartOfAccountsCode,generalLedgerTransferDocument.financialObjectCode:financialObjectCode"
                                            fieldConversions="universityFiscalYear:generalLedgerTransferDocument.universityFiscalYear,chartOfAccountsCode:generalLedgerTransferDocument.chartOfAccountsCode,financialObjectCode:generalLedgerTransferDocument.financialObjectCode"
                                            fieldLabel="${gltDocumentAttributes.financialObjectCode.label}"/>
                            </c:if>
                            <div id="generalLedgerTransferDocument.objectCode.financialObjectCodeName.div"><bean:write name="KualiForm" property="generalLedgerTransferDocument.objectCode.financialObjectCodeName"/></div>
                        </td>
                    </tr>

                    <tr>
                        <kul:htmlAttributeHeaderCell
                                attributeEntry="${gltDocumentAttributes.lookupDocumentNumber}"
                                horizontal="true" width="35%" labelFor="lookupDocumentNumber" useShortLabel="false" addClass="right"/>

                        <td class="datacell-nowrap"><kul:htmlControlAttribute
                                attributeEntry="${gltDocumentAttributes.lookupDocumentNumber}"
                                property="generalLedgerTransferDocument.lookupDocumentNumber" readOnly="${readOnly}"/>
                        </td>
                    </tr>

                    <tr>
                        <td height="30" class="infoline">&nbsp;</td>
                        <td height="30" class="infoline">
                            <c:if test="${!readOnly}">
                                <kul:multipleValueLookup
                                        boClassName="org.kuali.kfs.fp.businessobject.GeneralLedgerTransferEntry"
                                        lookupParameters="generalLedgerTransferDocument.universityFiscalYear:universityFiscalYear,generalLedgerTransferDocument.universityFiscalAccountingPeriod:universityFiscalPeriodCode,generalLedgerTransferDocument.chartOfAccountsCode:chartOfAccountsCode,generalLedgerTransferDocument.accountNumber:accountNumber,generalLedgerTransferDocument.financialObjectCode:financialObjectCode,generalLedgerTransferDocument.lookupDocumentNumber:documentNumber"
                                        lookedUpCollectionName="sourceAccountingLines" autoSearch="yes"
                                        useDefaultButton="true"/>
                            </c:if>
                        </td>
                    </tr>
                </table>
            </div>
        </kul:tab>
    </c:if>

    <kul:tab tabTitle="Accounting Lines" defaultOpen="true" tabErrorKey="${KFSConstants.ACCOUNTING_LINE_ERRORS}">
        <sys-java:accountingLines>
            <sys-java:accountingLineGroup collectionPropertyName="document.sourceAccountingLines" collectionItemPropertyName="document.sourceAccountingLine" attributeGroupName="source"/>
            <sys-java:accountingLineGroup collectionPropertyName="document.targetAccountingLines" collectionItemPropertyName="document.targetAccountingLine" attributeGroupName="target"/>
        </sys-java:accountingLines>
        <style>
            /**
                GLT documents are the only ones that show actions on read only lines. Instead of making a global change
                to accounting lines this just prevents descriptions inside the accounting line section from overflowing
                into the actions column
             */
            #tab-AccountingLines-div span[id*="financialDocumentLineDescription"]  {
                display: block;
                overflow: hidden;
            }
        </style>
        <script>
            function removeElement (element) {
                element && element.parentNode && element.parentNode.removeChild(element);
            }

            function createSelection (title, onSelect) {
                var id = 'copy-down-' + title

                var checkbox = document.createElement('input')
                checkbox.setAttribute('type', 'checkbox')
                checkbox.setAttribute('value', title)
                checkbox.setAttribute('id', id)
                checkbox.onclick = onSelect

                var label = document.createElement('label')
                label.setAttribute('for', id)
                label.insertAdjacentText('beforeend', title)

                var listItem = document.createElement('li')
                listItem.insertAdjacentElement('afterbegin', checkbox)
                listItem.insertAdjacentElement('beforeend', label)

                return listItem;
            }

            function createButton (text, className, onClick) {
                var button = document.createElement('button')
                button.setAttribute('value', text)
                button.setAttribute('aria-label', text)
                button.insertAdjacentText('beforeend', text)
                button.classList.add(className)
                button.onclick = onClick

                return button
            }

            function getCoords (elem) { // crossbrowser version
                var box = elem.getBoundingClientRect();

                var body = document.body;
                var docEl = document.documentElement;

                var scrollTop = window.pageYOffset || docEl.scrollTop || body.scrollTop;
                var scrollLeft = window.pageXOffset || docEl.scrollLeft || body.scrollLeft;

                var clientTop = docEl.clientTop || body.clientTop || 0;
                var clientLeft = docEl.clientLeft || body.clientLeft || 0;

                var top  = box.top +  scrollTop - clientTop;
                var left = box.left + scrollLeft - clientLeft;

                return { top: Math.round(top), left: Math.round(left) };
            }

            function getInputSelectorForRow (rowIndex) {
                return 'input[type="text"][name^="document.targetAccountingLine[' + rowIndex + ']"'
            }

            function getChartElement (acctLinesTable, rowIndex) {
                return acctLinesTable.querySelector('[name^="document.targetAccountingLine[' + rowIndex + '].chartOfAccountsCode"]')
                    || acctLinesTable.querySelector('[id^="document.targetAccountingLine[' + rowIndex + '].chartOfAccountsCode.div"]')
            }

            function setChartValue (chartElement, chartValue) {
                if (chartElement.tagName.toLowerCase() === 'span') {
                    chartElement.innerHTML = chartValue
                } else if (chartElement.tagName.toLowerCase() === 'select') {
                    chartElement.value = chartValue
                    chartElement.onblur()
                }
            }

            function processRows (currentRow, targetHeaderText, selectedInputs, copyables, index, lastRowWithInput) {
                var hasInput = currentRow.querySelector('td input[type="text"]')
                var copyDownButton = currentRow.querySelector('button[name^="methodToCall.copyDownAccountingLine.line"]')
                if (currentRow.nextSibling === null || currentRow.nextSibling.classList.contains('total-line')) {
                    removeElement(copyDownButton)
                    return
                } else if (hasInput === null || index >= lastRowWithInput) {
                    removeElement(copyDownButton)
                } else {
                    var columns = currentRow.querySelectorAll('td')
                    Array.prototype.slice.call(columns).forEach(function (elem, index) {
                        var adjustedIndex = index + 1
                        var columnTitle = targetHeaderText[adjustedIndex].textContent.replace(/\n|\*\s/g, '')
                        if (elem.querySelector('input[type="text"]') && copyables.indexOf(columnTitle) === -1) {
                            copyables.push(columnTitle)
                        }
                    })

                    copyDownButton.onclick = function (event) {
                        event.preventDefault();
                        var dialog = createDialog(acctLinesTable, copyables, selectedInputs, index)
                        var buttonPosition = getCoords(copyDownButton)

                        copyDownButton.insertAdjacentElement('afterend', dialog)
                        var headerHeight = document.querySelector('#test-header') ? 100 : 60
                        var viewportOffsetTop = dialog.getBoundingClientRect().top - dialog.offsetHeight - headerHeight - copyDownButton.offsetHeight;
                        var left = (buttonPosition.left - dialog.offsetWidth) + 'px'

                        var indicator = document.createElement('div')
                        var top
                        if (viewportOffsetTop >= 0) {
                            top = (buttonPosition.top - dialog.offsetHeight * 1.30 - copyDownButton.offsetHeight * 2) + 'px'
                            indicator.classList.add('indicator-bottom')
                            dialog.insertAdjacentElement('beforeend', indicator)
                            dialog.style['padding-top'] = '16px'
                            dialog.style['padding-bottom'] = '8px'
                        } else {
                            top = (buttonPosition.top - copyDownButton.offsetHeight * 2) + 'px'
                            indicator.classList.add('indicator-top')
                            dialog.insertAdjacentElement('afterbegin', indicator)
                            dialog.style['padding-bottom'] = '24px'
                        }
                        dialog.style.left = left
                        dialog.style.top = top

                        dialog.closest('.main-panel').addEventListener('scroll', function (event) {
                            var diff = getCoords(copyDownButton).left - dialog.offsetWidth
                            dialog.style.left = diff + 'px'
                        })
                    }
                }

                return processRows(currentRow.nextSibling, targetHeaderText, selectedInputs, copyables, index + 1, lastRowWithInput)
            }

            function lastRowWithInput (rowNumber, currentRow) {
                var currentRowTextInput = currentRow.querySelector('input[type="text"]')
                if (currentRow.nextSibling === null) {
                    return rowNumber
                } else if (currentRowTextInput) {
                    var newRowNumber = currentRowTextInput.getAttribute('id').match(/\d/)
                    return lastRowWithInput(parseInt(newRowNumber), currentRow.nextSibling)
                } else {
                    return lastRowWithInput(rowNumber, currentRow.nextSibling)
                }
            }

            function applyCopyDown (acctLinesTable, rowIndex, copyables, selectedInput, options) {
                var inputFields = Array.prototype.slice.call(acctLinesTable.querySelectorAll(getInputSelectorForRow(rowIndex)))
                var accountNumberPresent = acctLinesTable.querySelector('[id^="document.targetAccountingLine[' + rowIndex + '].accountNumber"')
                if (!accountNumberPresent) {
                    return
                } else if (inputFields.length > 0) {
                    var keys = Object.keys(selectedInput)
                    keys.forEach(function (key) {
                        if (key === 'Account') {
                            var chartElement = getChartElement(acctLinesTable, rowIndex)
                            setChartValue(chartElement, options.chartValue)
                        }
                        var fieldIndex = copyables.indexOf(key)
                        inputFields[fieldIndex].value = selectedInput[key]
                        if (inputFields[fieldIndex].hasAttribute('onblur') && typeof (inputFields[fieldIndex].onblur) === 'function') {
                            inputFields[fieldIndex].onblur()
                        }
                    })
                }
                applyCopyDown(acctLinesTable, rowIndex + 1, copyables, selectedInput, options)
            }

            function determineTotalAmount (acctLinesTable, copyables, rowIndex, totalAmount) {
                var inputFields = Array.prototype.slice.call(acctLinesTable.querySelectorAll(getInputSelectorForRow(rowIndex)))
                var accountNumberPresent = acctLinesTable.querySelector('[id^="document.targetAccountingLine[' + rowIndex + '].accountNumber"')
                var lineAmount;
                if (!accountNumberPresent) {
                    return totalAmount.toFixed(2).toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',')
                } else if (inputFields.length > 0) {
                    var fieldIndex = copyables.indexOf('Amount')
                    lineAmount = parseFloat(inputFields[fieldIndex].value)
                } else {
                    lineAmount = parseFloat(acctLinesTable.querySelector('[id^="document.targetAccountingLine[' + rowIndex + '].amount.div"]').textContent)
                }
                return determineTotalAmount(acctLinesTable, copyables, rowIndex + 1, totalAmount + lineAmount)
            }

            function createDialog (acctLinesTable, copyables, selectedInput, rowIndex) {
                var openDialog = acctLinesTable.querySelector('.copy-down-dialog')
                if (openDialog) {
                    removeElement(openDialog)
                }
                var dialog = document.createElement('div')
                dialog.classList.add('copy-down-dialog');

                var copyDownTitle = document.createElement('span')
                copyDownTitle.insertAdjacentText('beforeend', 'Copy Down')
                copyDownTitle.classList.add('copy-down-title')
                dialog.insertAdjacentElement('beforeend', copyDownTitle)

                var copyDownDescription = document.createElement('span')
                copyDownDescription.insertAdjacentText('beforeend', 'Select fields from this line to copy to all lines below it.')
                copyDownDescription.classList.add('copy-down-description')
                dialog.insertAdjacentElement('beforeend', copyDownDescription)

                var options = document.createElement('ul')
                var inputFields = acctLinesTable.querySelectorAll(getInputSelectorForRow(rowIndex))
                copyables.forEach(function (title, index) {
                    options.insertAdjacentElement('beforeend', createSelection(title, function (event) {
                        if (selectedInput.hasOwnProperty(title)) {
                            delete selectedInput[title]
                        } else {
                            selectedInput[title] = inputFields[index].value
                        }
                    }))
                })
                dialog.insertAdjacentElement('beforeend', options)

                var submitButton = createButton('Copy Down', 'copy-down-btn', function (event) {
                    event.preventDefault()
                    var chartElement = getChartElement(acctLinesTable, rowIndex)
                    var chartValue = chartElement.value || chartElement.textContent
                    applyCopyDown(acctLinesTable, rowIndex + 1, copyables, selectedInput, { chartValue: chartValue })
                    var selectedInputs = Object.keys(selectedInput)
                    if ('Amount' in selectedInput) {
                        var totalAmount = determineTotalAmount(acctLinesTable, copyables, 0, 0)
                        var totalLine = Array.prototype.slice.call(acctLinesTable.querySelectorAll('.total-line'))[1]
                        var totalAmountField = Array.prototype.slice.call(totalLine.querySelectorAll('.right'))[1]
                        totalAmountField.textContent = totalAmount
                    }
                    selectedInputs.forEach(function (prop) {
                        delete selectedInput[prop]
                    })
                    removeElement(dialog)
                })
                var cancelButton = createButton('Cancel', 'cancel-btn', function (event) {
                    var selectedInputs = Object.keys(selectedInput)
                    selectedInputs.forEach(function (prop) {
                        delete selectedInput[prop]
                    })
                    removeElement(dialog)
                })

                var buttonContainer = document.createElement('div')
                buttonContainer.classList.add('copy-down-buttons')
                buttonContainer.insertAdjacentElement('beforeend', submitButton)
                buttonContainer.insertAdjacentElement('beforeend', cancelButton)
                dialog.insertAdjacentElement('beforeend', buttonContainer)

                return dialog
            }

            var acctLinesTable = document.querySelector('.acct-lines')
            var acctLineHeaders = acctLinesTable.querySelectorAll('.header')
            var targetHeader = acctLineHeaders[1]

            // If target lines exist
            if (targetHeader) {
                var lastRowWithInput = lastRowWithInput(-1, targetHeader)
                var targetHeaderText = Array.prototype.slice.call(targetHeader.querySelectorAll('th'))
                processRows(targetHeader.nextSibling, targetHeaderText, {}, [], 0, lastRowWithInput)
            }
        </script>
    </kul:tab>

    <fp:capitalAccountingLines readOnly="${readOnly}"/>

    <c:if test="${KualiForm.capitalAccountingLine.canCreateAsset}">
        <fp:capitalAssetCreateTab readOnly="${readOnly}"/>
    </c:if>

    <fp:capitalAssetModifyTab readOnly="${readOnly}"/>

    <fp:lateAdjustment propertyName="document"
                       attributes="${DataDictionary.GeneralLedgerTransferDocument.attributes}"
                       defaultOpen="${KualiForm.showLateAdjustmentTab}"/>

    <gl:generalLedgerPendingEntries/>

    <kul:notes/>

    <kul:adHocRecipients/>

    <kul:routeLog/>

    <kul:superUserActions/>

    <sys:documentControls transactionalDocument="true" extraButtons="${KualiForm.extraButtons}"/>
    <kul:modernLookupSupport />

    <kul:modernLookupSupport/>

</kul:documentPage>
