<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2025 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<c:set var="balanceInquiryAttributes"
       value="${DataDictionary.LedgerBalanceForBenefitExpenseTransfer.attributes}"/>
<c:set var="benefitExpenseTransferDocumentAttributes"
       value="${DataDictionary.BenefitExpenseTransferDocument.attributes}"/>

<c:set var="readOnly"
       value="${!KualiForm.documentActions[KRADConstants.KUALI_ACTION_CAN_EDIT] || !KualiForm.editingMode['ledgerBalanceImporting']}"/>

<!-- accountsChartReadOnly is set to false even when account can cross indicator = Y because if it
read only then the javascript can not write value to the field. -->
<c:set var="accountsChartsReadOnly" value="${readOnly}"/>
<c:if test="${not readOnly}">
    <c:set var="accountsChartsReadOnly" value="false"/>
</c:if>

<c:set var="documentTypeName" value="BenefitExpenseTransferDocument"/>
<c:set var="htmlFormAction" value="laborBenefitExpenseTransfer"/>

<kul:documentPage showDocumentInfo="true"
                  documentTypeName="${documentTypeName}"
                  htmlFormAction="${htmlFormAction}" renderMultipart="true"
                  showTabButtons="true">

    <sys:documentOverview editingMode="${KualiForm.editingMode}"/>

    <kul:tab tabTitle="Ledger Balance Importing" defaultOpen="true" tabErrorKey="${KFSConstants.EMPLOYEE_LOOKUP_ERRORS}">
        <div class="tab-container">
            <table cellpadding="0" cellspacing="0" class="datatable" summary="Ledger Balance Importing">
                <tr>
                    <kul:htmlAttributeHeaderCell
                            attributeEntry="${balanceInquiryAttributes.universityFiscalYear}"
                            horizontal="true"
                            width="35%"
                            labelFor="universityFiscalYear"
                            forceRequired="true"
                            addClass="right"/>

                    <td class="datacell-nowrap">
                        <kul:htmlControlAttribute
                                attributeEntry="${balanceInquiryAttributes.universityFiscalYear}"
                                property="universityFiscalYear"
                                forceRequired="true"
                                readOnly="${readOnly}"/>
                    </td>
                </tr>
                <tr>
                    <kul:htmlAttributeHeaderCell
                            attributeEntry="${balanceInquiryAttributes.chartOfAccountsCode}"
                            horizontal="true"
                            labelFor="chartOfAccountsCode"
                            forceRequired="true"
                            addClass="right"/>

                    <td class="datacell-nowrap">
                        <kul:htmlControlAttribute
                                attributeEntry="${benefitExpenseTransferDocumentAttributes.chartOfAccountsCode}"
                                property="chartOfAccountsCode"
                                forceRequired="true"
                                readOnly="${accountsChartsReadOnly}"/>
                    </td>
                </tr>
                <tr>
                    <kul:htmlAttributeHeaderCell
                            attributeEntry="${balanceInquiryAttributes.accountNumber}"
                            horizontal="true"
                            labelFor="accountNumber"
                            forceRequired="true"
                            addClass="right"/>

                    <c:set var="accountNumberField" value="accountNumber"/>
                    <c:set var="coaCodePropertyName" value="chartOfAccountsCode"/>

                    <script language="JavaScript" type="text/javascript" src="dwr/interface/AccountService.js"></script>
                    <script language="JavaScript" type="text/javascript" src="scripts/coa/accountDocument.js"></script>

                    <td class="datacell-nowrap">
                        <kul:htmlControlAttribute
                                attributeEntry="${balanceInquiryAttributes.accountNumber}"
                                property="accountNumber"
                                forceRequired="true"
                                readOnly="${readOnly}"
                                onblur="loadChartCodeUsingAccountNumber('${accountNumberField}', '${coaCodePropertyName}');${onblur}"/>
                        <c:if test="${!readOnly}">
                            <kul:lookup
                                    boClassName="org.kuali.kfs.coa.businessobject.Account"
                                    fieldConversions="accountNumber:accountNumber,chartOfAccountsCode:chartOfAccountsCode"
                                    newLookup="true"
                            />
                        </c:if>
                    </td>
                </tr>
                <tr>
                    <kul:htmlAttributeHeaderCell
                            attributeEntry="${balanceInquiryAttributes.subAccountNumber}"
                            horizontal="true"
                            labelFor="subAccountNumber"
                            forceRequired="false"
                            hideRequiredAsterisk="true"
                            addClass="right"/>

                    <td class="datacell-nowrap">
                        <kul:htmlControlAttribute
                                attributeEntry="${balanceInquiryAttributes.subAccountNumber}"
                                property="subAccountNumber"
                                forceRequired="true"
                                readOnly="${readOnly}"/>
                        <c:if test="${!readOnly}">
                            <kul:lookup
                                    boClassName="org.kuali.kfs.coa.businessobject.SubAccount"
                                    lookupParameters="accountNumber:accountNumber,subAccountNumber:subAccountNumber,chartOfAccountsCode:chartOfAccountsCode"
                                    fieldConversions="accountNumber:accountNumber,subAccountNumber:subAccountNumber,chartOfAccountsCode:chartOfAccountsCode"
                                    fieldLabel="${balanceInquiryAttributes.subAccountNumber.label}"
                                    newLookup="true"
                            />
                        </c:if>
                    </td>
                </tr>
                <tr>
                    <td height="30" class="infoline">&nbsp;</td>
                    <td height="30" class="infoline">
                        <c:if test="${!readOnly}">
                            <gl:balanceInquiryLookup
                                    boClassName="org.kuali.kfs.module.ld.businessobject.LedgerBalanceForBenefitExpenseTransfer"
                                    actionPath="glBalanceInquiryLookup.do"
                                    lookupParameters="universityFiscalYear:universityFiscalYear,accountNumber:accountNumber,subAccountNumber:subAccountNumber,chartOfAccountsCode:chartOfAccountsCode,emplid:emplid"
                                    tabindexOverride="KualiForm.currentTabIndex"
                                    hideReturnLink="false"
                                    buttonText="Search"/>
                        </c:if>
                    </td>
                </tr>
            </table>
        </div>
    </kul:tab>

    <kul:tab tabTitle="Accounting Lines" defaultOpen="true"
             helpUrl="${KualiForm.accountingLineImportInstructionsUrl}" helpLabel="Import Templates">
        <sys-java:accountingLines>
            <sys-java:accountingLineGroup collectionPropertyName="document.sourceAccountingLines" collectionItemPropertyName="document.sourceAccountingLine" attributeGroupName="source"/>
            <sys-java:accountingLineGroup collectionPropertyName="document.targetAccountingLines" collectionItemPropertyName="document.targetAccountingLine" attributeGroupName="target"/>
        </sys-java:accountingLines>
    </kul:tab>

    <ld:laborLedgerPendingEntries/>
    <kul:notes/>
    <kul:adHocRecipients/>
    <kul:routeLog/>
    <kul:superUserActions/>
    <sys:documentControls transactionalDocument="true" extraButtons="${KualiForm.extraButtons}"/>
    <kul:modernLookupSupport/>
</kul:documentPage>
