/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import { defineConfig } from 'vitest/config';
import react from '@vitejs/plugin-react';
import { resolve } from 'path';

export default defineConfig({
  test: {
    environment: 'happy-dom',
    environmentOptions: {
      happyDOM: {
        url: 'https://dummy-kfs.kuali.cor/fin/'
      }
    },
    setupFiles: ['./test-utils/setupTests.ts'],
    alias: [
      {
        find: /.*\.css$/,
        replacement: 'identity-obj-proxy'
      }
    ],
    css: {
      modules: {
        classNameStrategy: 'non-scoped'
      }
    },
    server: {
      deps: {
        inline: ['@mui/x-data-grid']
      }
    },
    deps: {
      web: {
        transformCss: true
      }
    },
    globals: true,
    testTimeout: 30000,
    coverage: {
      enabled: true,
      provider: 'v8',
      include: ['app/**/*'],
      skipFull: true,
      exclude: ['app/__mocks__/**/*']
    }
  },
  esbuild: {
    loader: 'tsx',
    include: /src\/.*\.m?[tj]sx?$/,
    exclude: []
  },
  resolve: {
    alias: {
      '~': resolve(__dirname, 'app')
    }
  },
  plugins: [react()]
});
