/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2025 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import { fileURLToPath } from 'url';
import NodePolyfillPlugin from 'node-polyfill-webpack-plugin';
import path from 'path';
import postcssImportJson from '@daltontan/postcss-import-json';
import webpack from 'webpack';
import { WebpackAssetsManifest } from 'webpack-assets-manifest';

const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

const config = {
  target: ['web', 'es2023'],
  entry: {
    app: './app/legacy-app.tsx',
    index: './app/index.ts',
    institutionconfig: './app/institution-config/index.ts'
  },
  output: {
    path: path.resolve(__dirname, 'build'),
    filename: '[name].bundle.js'
  },
  resolve: {
    symlinks: false,
    alias: {
      lodash: path.resolve(__dirname, 'node_modules/lodash'),
      '~': path.resolve(__dirname, 'app'),
      buffer: import.meta.resolve('buffer/')
    },
    fallback: {
      path: false
    },
    extensions: ['.ts', '.tsx', '...'],
    conditionNames: ['mui-modern', '...']
  },
  module: {
    rules: [
      {
        test: /\.[jt]sx?$/,
        exclude: [/node_modules/],
        use: {
          loader: 'ts-loader',
          options: {
            transpileOnly: true
          }
        }
      },
      {
        test: /\.css$/,
        exclude: [/node_modules/],
        use: [
          'style-loader',
          {
            loader: 'css-loader',
            options: {
              modules: true,
              importLoaders: 1
            }
          },
          {
            loader: 'postcss-loader',
            options: {
              postcssOptions: {
                ident: 'postcss',
                plugins: [postcssImportJson()]
              }
            }
          }
        ]
      },
      {
        test: /\.css$/,
        include: [/node_modules/],
        use: ['style-loader', 'css-loader']
      },
      {
        test: /\.(png|jpg|gif|woff|eot|ttf|svg)$/,
        type: 'asset/inline'
      },
      { enforce: 'pre', test: /\.js$/, loader: 'source-map-loader' }
    ]
  },
  optimization: {
    splitChunks: {
      cacheGroups: {
        commons: {
          name: 'commons',
          chunks: 'initial'
        }
      }
    }
  },
  plugins: [
    new WebpackAssetsManifest({
      output: 'webpack.manifest.json'
    }),
    new webpack.ProvidePlugin({
      process: 'process/browser.js'
    }),
    new NodePolyfillPlugin()
  ]
};

export default config;
