<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2026 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<%@ attribute name="resultsList" required="true" type="java.util.List" description="The rows of fields that we'll iterate to display." %>

<c:set var="imageSelectAll" value="${empty image ? 'buttonsmall_selectall.gif' : image}"/>
<c:set var="imageUnselectAll" value="${empty image ? 'buttonsmall_unselall.gif' : image}"/>
<c:set var="imageSort" value="${empty image ? 'sort.gif' : image}"/>

<c:if test="${empty resultsList && KualiForm.methodToCall != 'start' && KualiForm.methodToCall != 'refresh'}">
	There were no results found.
</c:if>

<c:if test="${!empty resultsList}">
    <c:if test="${KualiForm.searchUsingOnlyPrimaryKeyValues}">
    	<bean-el:message key="lookup.using.primary.keys" arg0="${KualiForm.primaryKeyFieldLabels}"/>
    	<br/><br/>
    </c:if>
	<c:choose>
		<c:when test="${param['d-16544-e'] == null}">
			<kul:tableRenderPagingBanner pageNumber="${KualiForm.viewedPageNumber}" totalPages="${KualiForm.totalNumberOfPages}"
				firstDisplayedRow="${KualiForm.firstRowIndex}" lastDisplayedRow="${KualiForm.lastRowIndex}" resultsActualSize="${KualiForm.resultsActualSize}"
				resultsLimitedSize="${KualiForm.resultsLimitedSize}"
				buttonExtraParams=".${KRADConstants.METHOD_TO_CALL_PARM12_LEFT_DEL}${KualiForm.searchUsingOnlyPrimaryKeyValues}${KRADConstants.METHOD_TO_CALL_PARM12_RIGHT_DEL}"/>
			<input type="hidden" name="${KRADConstants.MULTIPLE_VALUE_LOOKUP_PREVIOUSLY_SELECTED_OBJ_IDS_PARAM}" value="${KualiForm.compositeSelectedObjectIds}"/>
			<input type="hidden" name="${KRADConstants.TableRenderConstants.PREVIOUSLY_SORTED_COLUMN_INDEX_PARAM}" value="${KualiForm.columnToSortIndex}"/>

			<p>
				<c:set var="balanceInquirySelectAllButtonName" value="methodToCall.selectAll.${KRADConstants.METHOD_TO_CALL_PARM12_LEFT_DEL}${KualiForm.searchUsingOnlyPrimaryKeyValues}${KRADConstants.METHOD_TO_CALL_PARM12_RIGHT_DEL}.x" />
					${kfunc:registerEditableProperty(KualiForm, balanceInquirySelectAllButtonName)}
					<input
							type="submit"
							tabindex="${tabindex}"
							name="${balanceInquirySelectAllButtonName}"
							alt="Select all rows"
							title="Select all rows"
							border="0" class="btn btn-default"
							valign="middle"
							value="Select All"/>
				<c:set var="balanceInquiryUnselectAllButtonName" value="methodToCall.unselectAll.${KRADConstants.METHOD_TO_CALL_PARM12_LEFT_DEL}${KualiForm.searchUsingOnlyPrimaryKeyValues}${KRADConstants.METHOD_TO_CALL_PARM12_RIGHT_DEL}.x" />
					${kfunc:registerEditableProperty(KualiForm, balanceInquiryUnselectAllButtonName)}
					<input
							type="submit"
							tabindex="${tabindex}"
							name="${balanceInquiryUnselectAllButtonName}"
							alt="Unselect all rows"
							title="Unselect all rows"
							border="0"
							class="btn btn-default"
							valign="middle"
							value="Unselect All"/>
			</p>

            <c:set var="numOfMonthField" value="14" scope="request" />
            <c:set var="numOfNonMonthField" value="${fn:length(resultsList[0].columns) - numOfMonthField}" scope="request" />

			<table class="fixed" width="100%" id="row">
				<thead>
					<tr>
			    		<c:forEach items="${resultsList[0].columns}" var="column" begin="0" end="${numOfNonMonthField}" varStatus="columnLoopStatus">
							<th class="sortable">
								${column.columnTitle}
								<c:set var="sortButtonName" value="methodToCall.sort.${columnLoopStatus.index}.${KRADConstants.METHOD_TO_CALL_PARM12_LEFT_DEL}${KualiForm.searchUsingOnlyPrimaryKeyValues}${KRADConstants.METHOD_TO_CALL_PARM12_RIGHT_DEL}.x" />
								${kfunc:registerEditableProperty(KualiForm, sortButtonName)}
								<input
										type="image"
										tabindex="${tabindex}"
										name="${sortButtonName}"
									   	src="${ConfigProperties.externalizable.images.url}sort_both_kns.png"
										alt="Sort column ${column.columnTitle}"
									   	title="Sort column ${column.columnTitle}"
										style="margin-bottom:-5px;"/>
							</th>
						</c:forEach>
					</tr>
				</thead>

		        <c:set var="rowCounter" value="0" scope="request" />
				<c:forEach items="${resultsList}" var="row" varStatus="rowLoopStatus" begin="${KualiForm.firstRowIndex}" end="${KualiForm.lastRowIndex}">
					<tr class="even">
						<c:forEach items="${row.columns}" var="column" begin="0" end="${numOfNonMonthField}">
							<td class="infocell" title="${column.propertyValue}">
								<c:if test="${!empty column.propertyURL}">
									<a href="<c:out value="${column.propertyURL}"/>" target="blank">
								</c:if>

								<c:out value="${fn:substring(column.propertyValue, 0, column.maxLength)}"/>
								<c:if test="${column.maxLength gt 0 && fn:length(column.propertyValue) gt column.maxLength}">...</c:if>

								<c:if test="${!empty column.propertyURL}"></a></c:if>
							</td>
						</c:forEach>
					</tr>
                    <%-- Skip the month table when none of the month values are present --%>
                    <c:set var="hasMonthValues" value="false"/>
                    <c:forEach var="column" items="${row.columns}" begin="${numOfNonMonthField + 1}">
                        <c:if test="${column.propertyValue != null and not empty column.propertyValue}">
                            <c:set var="hasMonthValues" value="true"/>
                        </c:if>
                    </c:forEach>
                    <tr>
                        <td colspan="${numOfNonMonthField + 1}"><br/>
                            <c:if test="${hasMonthValues}">
                            <center>
                            <table class="datatable-80 balanceInquiry" style="border-collapse: collapse" cellspacing="0"
                                   cellpadding="0" width="100%">
                                <c:forEach var="column" items="${row.columns}" begin="${numOfNonMonthField + 1}" varStatus="columnStatus">
                                    <c:if test="${(columnStatus.index - numOfNonMonthField) % 4 == 1}">
                                	<tr>
                                    </c:if>

                                    <c:if test="${(columnStatus.index - numOfNonMonthField + 1) eq numOfMonthField}">
                                        <td colspan="3" style="vertical-align: top; padding: 0"></td>
                                    </c:if>

                                    <td style="vertical-align: top" class="nested-table">
                                        <table class="datatable-80 balanceInquiry" style="width: 100%; border: 0"
                                               cellspacing="0" cellpadding="0"
                                               width="100%">
                                            <tr>
                                                <th class="infocell" style="text-align: left; width: 10%; white-space: nowrap; padding: 0; border: 0">
                                                    <c:set var="monthlyAmount" value="${fn:replace(column.propertyValue, ',', '')}"/>

                                                    <!-- restore the negtive number -->
                                                    <c:if test="${fn:contains(monthlyAmount, '(')}">
                                                        <c:set var="monthlyAmount" value="${fn:replace(monthlyAmount, '(', '-')}"/>
                                                        <c:set var="monthlyAmount" value="${fn:replace(monthlyAmount, ')', '')}"/>
                                                    </c:if>

                                                    <fmt:formatNumber var="amount" value="${monthlyAmount}" maxFractionDigits="2" minFractionDigits="2" groupingUsed="false"/>
                                                    <c:set var="monthlyAmount" value="${fn:replace(amount, '.', '')}"/>

                                                    <c:set var="objectIdPrefix" value="${row.objectId}.${column.propertyName}" />
                                                    <c:set var="objectId" value="${objectIdPrefix}.${monthlyAmount}" />

                                                    <c:set var="checked" value="${empty KualiForm.compositeObjectIdMap[objectId] ? '' : 'checked=checked'}" />
                                                    <c:set var="disabled" value="${(amount != null and amount != 0.0) ? '' : 'disabled=disabled'}" />

                                                    <c:set var="checkBoxObjectIdName" value="${KRADConstants.MULTIPLE_VALUE_LOOKUP_SELECTED_OBJ_ID_PARAM_PREFIX}${objectId}" />
                                                        ${kfunc:registerEditableProperty(KualiForm, checkBoxObjectIdName)}
                                                    <input type="checkbox" onchange="checkTableValues(this)"
                                                           name="${checkBoxObjectIdName}"
                                                           title="${column.columnTitle}" value="checked" ${disabled} ${checked}>
                                                            ${column.columnTitle}
                                                    </input>
                                                    <input type="hidden" name="${KRADConstants.MULTIPLE_VALUE_LOOKUP_DISPLAYED_OBJ_ID_PARAM_PREFIX}${objectId}" value="onscreen"/>
                                                </th>
                                                <th class="numbercell" width="10%" style="text-align: right; padding: 0; border: 0; white-space: nowrap">
                                                    <a href="${column.propertyURL}" target="blank">${column.propertyValue}</a>
                                                </th>
                                            </tr>
                                            <tr>
                                                <td colspan="2" style="vertical-align: top; text-align: right; border: 0; padding: 0">
                                                    <table class="datatable-80 balanceInquiry" style="width: 100%; margin: 0 auto; padding: 0; border: 0">
                                                        <c:forEach var="nestedCol" items="${column.nestedColumns}">
                                                            <tr>
                                                                <td class="numbercell" style="text-align: right; white-space: nowrap; border: 0; padding: 0">
                                                                    <c:set var="monthlyAmount" value="${fn:replace(nestedCol.propertyValue, ',', '')}"/>

                                                                    <!-- restore the negtive number -->
                                                                    <c:if test="${fn:contains(monthlyAmount, '(')}">
                                                                        <c:set var="monthlyAmount" value="${fn:replace(monthlyAmount, '(', '-')}"/>
                                                                        <c:set var="monthlyAmount" value="${fn:replace(monthlyAmount, ')', '')}"/>
                                                                    </c:if>

                                                                    <fmt:formatNumber var="amount" value="${monthlyAmount}" maxFractionDigits="2" minFractionDigits="2" groupingUsed="false"/>
                                                                    <c:set var="monthlyAmount" value="${fn:replace(amount, '.', '')}"/>

                                                                    <c:set var="objectIdPrefix" value="${row.objectId}.${nestedCol.propertyName}" />
                                                                    <c:set var="objectId" value="${objectIdPrefix}.${monthlyAmount}" />

                                                                    <c:set var="checked" value="${empty KualiForm.compositeObjectIdMap[objectId] ? '' : 'checked=checked'}" />
                                                                    <c:set var="disabled" value="${(amount != null and amount != 0.0) ? '' : 'disabled=disabled'}" />

                                                                    <c:set var="checkBoxObjectIdName" value="${KRADConstants.MULTIPLE_VALUE_LOOKUP_SELECTED_OBJ_ID_PARAM_PREFIX}${objectId}" />
                                                                        ${kfunc:registerEditableProperty(KualiForm, checkBoxObjectIdName)}
                                                                    <input type="checkbox"
                                                                           onchange="checkTableValues(this)"
                                                                           name="${checkBoxObjectIdName}"
                                                                           title="${nestedCol.columnTitle}" value="checked" ${disabled} ${checked}>
                                                                            ${nestedCol.columnTitle}
                                                                    </input>
                                                                </td>
                                                                <td class="numbercell" style="text-align: right; white-space: nowrap; border: 0; padding-top: 0; padding-bottom: 0; padding-right: 2px">
                                                                    <input type="hidden" name="${KRADConstants.MULTIPLE_VALUE_LOOKUP_DISPLAYED_OBJ_ID_PARAM_PREFIX}${objectId}" value="onscreen"/>
                                                                    <a href="${nestedCol.propertyURL}" target="blank">${nestedCol.propertyValue}</a>
                                                                </td>
                                                            </tr>
                                                        </c:forEach>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>

                                    <c:if test="${(columnStatus.index -numOfNonMonthField) % 4 == 0}">
                                		</tr>
                                    </c:if>
                                </c:forEach>
                            </table>
                            </center><br/>
                            </c:if>
                        </td>
                    </tr>
				</c:forEach>
			</table>

			<p>
				<c:set var="balanceInquirySelectAllButtonName" value="methodToCall.selectAll.${KRADConstants.METHOD_TO_CALL_PARM12_LEFT_DEL}${KualiForm.searchUsingOnlyPrimaryKeyValues}${KRADConstants.METHOD_TO_CALL_PARM12_RIGHT_DEL}.x" />
					${kfunc:registerEditableProperty(KualiForm, balanceInquirySelectAllButtonName)}
					<input
							type="submit"
							tabindex="${tabindex}"
							name="${balanceInquirySelectAllButtonName}"
							alt="Select all rows"
							title="Select all rows"
							border="0"
							class="btn btn-default"
							valign="middle"
							value="Select All"/>
				<c:set var="balanceInquiryUnselectAllButtonName" value="methodToCall.unselectAll.${KRADConstants.METHOD_TO_CALL_PARM12_LEFT_DEL}${KualiForm.searchUsingOnlyPrimaryKeyValues}${KRADConstants.METHOD_TO_CALL_PARM12_RIGHT_DEL}.x" />
					${kfunc:registerEditableProperty(KualiForm, balanceInquiryUnselectAllButtonName)}
					<input
							type="submit"
							tabindex="${tabindex}"
							name="${balanceInquiryUnselectAllButtonName}"
							alt="Unselect all rows"
							title="Unselect all rows"
							border="0"
							class="btn btn-default"
							valign="middle"
							value="Unselect All"/>

			</p>
			<kul:multipleValueLookupExportBanner/>
            <script>
                function checkTableValues(element) {
                  if (element.checked) {
                    const name = element.name;
                    const dotSplit = name.split('.');
                    const prefix = dotSplit[0] + '.';
                    if (!dotSplit[1].includes('-')) {
                      // Month checkbox
                        const checkboxName = prefix + dotSplit[1] + '-';
                        const checkboxes = document.querySelectorAll('input[name^="' + checkboxName + '"]');
                        checkboxes.forEach(checkbox => {
                          if (checkbox.checked) {
                            checkbox.checked = false;
                          }
                        });
                    } else {
                      // Nested checkbox
                      const dashSplit = dotSplit[1].split('-');
                      const checkboxName = prefix + dashSplit[0] + '.';
                      const monthCheckbox = document.querySelector('input[name^="' + checkboxName + '"]');
                      if (monthCheckbox && monthCheckbox.checked) {
                        monthCheckbox.checked = false;
                      }
                    }
                  }
                }
            </script>
		</c:when>
		<c:otherwise>
			<display:table class="datatable-100"
				requestURIcontext="false" name="${reqSearchResults}"
				id="row" export="true" pagesize="100">
				<c:forEach items="${row.columns}" var="column" varStatus="loopStatus">
					<display:column class="${colClass}" sortable="${column.sortable}"
								title="${column.columnTitle}" comparator="${column.comparator}"
								maxLength="${column.maxLength}"><c:out value="${column.propertyValue}" escapeXml="false" default="" /></display:column>
				</c:forEach>
			</display:table>
		</c:otherwise>
	</c:choose>
</c:if>
